/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.util;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.util.ScriptUtils;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class ScriptUtilsTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_evaluate_noVariables() throws Exception {
        ScriptUtilsTest.assertEquals((Object)5, (Object)ScriptUtils.evaluate((String)"2 + 3"));
        ScriptUtilsTest.assertEquals((Object)"abc", (Object)ScriptUtils.evaluate((String)"'a' + 'bc'"));
    }

    @Test
    public void test_evaluate_ReflectionUtils() throws Exception {
        String script = ScriptUtilsTest.getSource("return ReflectionUtils.invokeMethod2('abc', 'length')");
        ScriptUtilsTest.assertEquals((Object)3, (Object)ScriptUtils.evaluate((String)script));
    }

    @Test
    public void test_evaluate_withContext() throws Exception {
        ScriptUtilsTest.assertEquals((Object)3, (Object)ScriptUtils.evaluate((String)"size()", List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3))));
    }

    @Test
    public void test_evaluate_withVariables() throws Exception {
        Map<String, Integer> variables = Map.of("a", 2, "b", 3);
        ScriptUtilsTest.assertEquals((Object)6, (Object)ScriptUtils.evaluate((String)"a * b", variables));
        ScriptUtilsTest.assertEquals((Object)6, (Object)ScriptUtils.evaluate((String)"c = a * b; return c;", variables));
        Assertions.assertThat(variables).hasSize(2);
    }

    @Test
    public void test_evaluate_withOneVariable() throws Exception {
        ScriptUtilsTest.assertEquals((Object)10, (Object)ScriptUtils.evaluate((String)"a * 2", (String)"a", (Object)5));
    }

    @Test
    public void test_evaluate_withTwoVariables() throws Exception {
        ScriptUtilsTest.assertEquals((Object)15, (Object)ScriptUtils.evaluate((String)"a * b", (String)"a", (Object)5, (String)"b", (Object)3));
    }

    @Test
    public void test_evaluate_accessToSwingClasses() throws Exception {
        ScriptUtilsTest.assertEquals((Object)2, (Object)ScriptUtils.evaluate((String)"javax.swing.SwingConstants.LEFT"));
    }

    @Test
    public void test_evaluate_useDesignerClassLoader_noVariables() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        ClassLoader classLoader = JavaInfoUtils.getClassLoader((JavaInfo)panel);
        Object expected = classLoader.loadClass("com.jgoodies.forms.layout.Sizes").getField("DLUX1").get(null);
        Object actual = ScriptUtils.evaluate((ClassLoader)this.m_lastLoader, (String)"com.jgoodies.forms.layout.Sizes.DLUX1");
        ScriptUtilsTest.assertSame((Object)expected, (Object)actual);
        actual = ScriptUtils.evaluate((ClassLoader)this.m_lastLoader, (String)"com.jgoodies.forms.layout.Sizes.DLUX1");
        ScriptUtilsTest.assertSame((Object)expected, (Object)actual);
    }

    @Test
    public void test_evaluate_useDesignerClassLoader_createObject() throws Exception {
        ScriptUtilsTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "}"));
        ScriptUtilsTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        Object result = ScriptUtils.evaluate((ClassLoader)this.m_lastLoader, (String)"new test.MyButton()");
        ScriptUtilsTest.assertEquals((Object)"test.MyButton", (Object)result.getClass().getCanonicalName());
    }

    @Test
    public void test_evaluate_useDesignerClassLoader_withVariables() throws Exception {
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        Object actual = ScriptUtils.evaluate((ClassLoader)this.m_lastLoader, (String)"a + (com.jgoodies.forms.layout.Sizes.DLUX1).value", Map.of("a", 5.0));
        ScriptUtilsTest.assertEquals((double)6.0, (double)((Double)actual), (double)0.001);
    }

    @Test
    public void test_evaluate_useDesignerClassLoader_withOneVariable() throws Exception {
        ScriptUtilsTest.setFileContentSrc("test/Constants.java", ScriptUtilsTest.getSource("package test;", "public interface Constants {", "  int A = 2;", "}"));
        ScriptUtilsTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        Object actual = ScriptUtils.evaluate((ClassLoader)this.m_lastLoader, (String)"test.Constants.A * a", (String)"a", (Object)3);
        ScriptUtilsTest.assertEquals((Object)6, (Object)actual);
    }

    @Test
    public void test_evaluate_useDesignerClassLoader_withTwoVariables() throws Exception {
        ScriptUtilsTest.setFileContentSrc("test/Constants.java", ScriptUtilsTest.getSource("package test;", "public interface Constants {", "  int A = 2;", "  int B = 3;", "}"));
        ScriptUtilsTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        Object actual = ScriptUtils.evaluate((ClassLoader)this.m_lastLoader, (String)"test.Constants.A * a + test.Constants.B * b", (String)"a", (Object)2, (String)"b", (Object)3);
        ScriptUtilsTest.assertEquals((Object)13, (Object)actual);
    }
}

