/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.editor;

import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.DisplayExpressionPropertyEditor;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class DisplayExpressionPropertyEditorTest
extends SwingModelTest {
    @Test
    public void test_noExpression() throws Exception {
        this.createMyPanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        Property fooProperty = panel.getPropertyByTitle("myFoo");
        DisplayExpressionPropertyEditorTest.assertNotNull((Object)fooProperty);
        DisplayExpressionPropertyEditorTest.assertInstanceOf(DisplayExpressionPropertyEditor.class, (Object)fooProperty.getEditor());
        DisplayExpressionPropertyEditorTest.assertNull((Object)DisplayExpressionPropertyEditorTest.getPropertyText(fooProperty));
    }

    @Test
    public void test_hasExpression() throws Exception {
        this.createMyPanel();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    foo(1 + 2);", "  }", "}");
        panel.refresh();
        Property fooProperty = panel.getPropertyByTitle("myFoo");
        DisplayExpressionPropertyEditorTest.assertNotNull((Object)fooProperty);
        DisplayExpressionPropertyEditorTest.assertInstanceOf(DisplayExpressionPropertyEditor.class, (Object)fooProperty.getEditor());
        DisplayExpressionPropertyEditorTest.assertEquals((Object)"1 + 2", (Object)DisplayExpressionPropertyEditorTest.getPropertyText(fooProperty));
    }

    private void createMyPanel() throws Exception {
        DisplayExpressionPropertyEditorTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void foo(int value) {", "  }", "}"));
        DisplayExpressionPropertyEditorTest.setFileContentSrc("test/MyPanel.wbp-component.xml", DisplayExpressionPropertyEditorTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "      <method name='foo'>", "        <parameter type='int'>", "          <editor id='displayExpression'/>", "        </parameter>", "      </method>", "  </methods>", "  <method-single-property title='myFoo' method='foo(int)'/>", "</component>"));
        DisplayExpressionPropertyEditorTest.waitForAutoBuild();
    }
}

