/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.refactoring;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wb.internal.core.utils.Messages;

public class DeleteFileChange
extends Change {
    private final IFile m_file;

    public DeleteFileChange(IFile file) {
        this.m_file = file;
    }

    public Object getModifiedElement() {
        return this.m_file;
    }

    public String getName() {
        return MessageFormat.format(Messages.DeleteFileChange_name, this.m_file.getLocation().lastSegment());
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        RefactoringStatus status = new RefactoringStatus();
        if (!this.m_file.exists()) {
            status.addError(MessageFormat.format(Messages.DeleteFileChange_errNoFile, this.m_file.getLocation().lastSegment()));
        }
        return status;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        this.m_file.delete(false, pm);
        return null;
    }
}

