/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.nls.ui;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.wb.core.controls.CTableCombo;
import org.eclipse.wb.internal.core.nls.Messages;
import org.eclipse.wb.internal.core.nls.model.LocaleInfo;
import org.eclipse.wb.internal.core.nls.model.LocalePartInfo;
import org.eclipse.wb.internal.core.nls.model.LocalePartInfos;
import org.eclipse.wb.internal.core.nls.ui.FlagImagesRepository;

public class ChooseLocaleDialog
extends TitleAreaDialog {
    private CTableCombo m_languageCombo;
    private CTableCombo m_countryCombo;
    private TableViewer m_localesViewer;
    protected LocaleInfo m_selectedLocale;

    public ChooseLocaleDialog(Shell parentShell) {
        this(parentShell, null);
    }

    public ChooseLocaleDialog(Shell parentShell, Locale locale) {
        super(parentShell);
        this.m_selectedLocale = new LocaleInfo(locale);
    }

    protected Control createContents(Composite parent) {
        Locale locale;
        Control control = super.createContents(parent);
        if (this.m_selectedLocale != null && (locale = this.m_selectedLocale.getLocale()) != null) {
            ChooseLocaleDialog.updateLocalePartCombo(this.m_languageCombo, LocalePartInfos.getLanguages(), locale.getLanguage());
            ChooseLocaleDialog.updateLocalePartCombo(this.m_countryCombo, LocalePartInfos.getCountries(), locale.getCountry());
        }
        this.updateSelectedLocale();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.ChooseLocaleDialog_title);
        this.setMessage(Messages.ChooseLocaleDialog_message);
        Composite container = (Composite)super.createDialogArea(parent);
        this.createLocaleGroup(container);
        return container;
    }

    private void createLocaleGroup(Composite parent) {
        Group localeGroup = new Group(parent, 0);
        localeGroup.setLayoutData((Object)new GridData(768));
        localeGroup.setLayout((Layout)new GridLayout(2, false));
        localeGroup.setText(Messages.ChooseLocaleDialog_localeGroup);
        Label languageLabel = new Label((Composite)localeGroup, 0);
        languageLabel.setText(Messages.ChooseLocaleDialog_languageLabel);
        this.m_languageCombo = new CTableCombo((Composite)localeGroup, 2048);
        this.m_languageCombo.setLayoutData((Object)new GridData(768));
        LocalePartInfo[] localePartInfoArray = LocalePartInfos.getLanguages();
        int n = localePartInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            LocalePartInfo language = localePartInfoArray[n2];
            this.m_languageCombo.add(language.toString(), language.getFlagImage());
            ++n2;
        }
        this.m_languageCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseLocaleDialog.this.updateSelectedLocale();
            }
        });
        Label countryLabel = new Label((Composite)localeGroup, 0);
        countryLabel.setText(Messages.ChooseLocaleDialog_countryLabel);
        this.m_countryCombo = new CTableCombo((Composite)localeGroup, 2048);
        this.m_countryCombo.setLayoutData((Object)new GridData(768));
        localePartInfoArray = LocalePartInfos.getCountries();
        n = localePartInfoArray.length;
        n2 = 0;
        while (n2 < n) {
            LocalePartInfo country = localePartInfoArray[n2];
            this.m_countryCombo.add(country.toString(), country.getFlagImage());
            ++n2;
        }
        this.m_countryCombo.select(0);
        this.m_countryCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseLocaleDialog.this.updateSelectedLocale();
            }
        });
        this.createLocalesViewer(localeGroup);
    }

    private void createLocalesViewer(Group localeGroup) {
        Label countryLabel = new Label((Composite)localeGroup, 0);
        countryLabel.setText(Messages.ChooseLocaleDialog_allLocalesLabel);
        this.m_localesViewer = new TableViewer((Composite)localeGroup, 67584);
        Table table = this.m_localesViewer.getTable();
        GridData gridData = new GridData(1808);
        gridData.heightHint = this.convertHeightInCharsToPixels(12);
        table.setLayoutData((Object)gridData);
        table.setLinesVisible(true);
        this.m_localesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Object[] locales = Locale.getAvailableLocales();
                Arrays.sort(locales, new Comparator<Locale>(){

                    @Override
                    public int compare(Locale locale_1, Locale locale_2) {
                        return locale_1.toString().compareTo(locale_2.toString());
                    }
                });
                return locales;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        class LocalesLabelProvider
        extends LabelProvider
        implements ITableLabelProvider {
            LocalesLabelProvider() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                Locale locale = (Locale)element;
                return FlagImagesRepository.getFlagImage(locale);
            }

            public String getColumnText(Object element, int columnIndex) {
                Locale locale = (Locale)element;
                return locale.toString() + " - " + locale.getDisplayName();
            }
        }
        this.m_localesViewer.setLabelProvider((IBaseLabelProvider)new LocalesLabelProvider());
        this.m_localesViewer.setInput((Object)this);
        this.m_localesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ChooseLocaleDialog.this.m_localesViewer.getSelection();
                Locale locale = (Locale)selection.getFirstElement();
                if (locale != null) {
                    ChooseLocaleDialog.this.onLocaleSelected(locale);
                }
            }
        });
        this.m_localesViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ChooseLocaleDialog.this.okPressed();
            }
        });
    }

    private void onLocaleSelected(Locale locale) {
        boolean needLocaleUpdate = false;
        String localeLanguage = locale.getLanguage();
        needLocaleUpdate |= ChooseLocaleDialog.updateLocalePartCombo(this.m_languageCombo, LocalePartInfos.getLanguages(), localeLanguage);
        String localeCountry = locale.getCountry();
        if (needLocaleUpdate |= ChooseLocaleDialog.updateLocalePartCombo(this.m_countryCombo, LocalePartInfos.getCountries(), localeCountry)) {
            this.updateSelectedLocale();
        }
    }

    private static boolean updateLocalePartCombo(CTableCombo combo, LocalePartInfo[] parts, String name) {
        int index = LocalePartInfos.indexByName(parts, name);
        if (index != -1) {
            if (index != combo.getSelectionIndex()) {
                combo.select(index);
                return true;
            }
        } else {
            combo.select(0);
        }
        return false;
    }

    protected void updateSelectedLocale() {
        if (this.m_languageCombo.getSelectionIndex() == -1) {
            this.getButton(0).setEnabled(false);
            return;
        }
        LocalePartInfo language = LocalePartInfos.getLanguages()[this.m_languageCombo.getSelectionIndex()];
        LocalePartInfo country = LocalePartInfos.getCountries()[this.m_countryCombo.getSelectionIndex()];
        Locale locale = country.getName().length() == 0 ? Locale.of(language.getName()) : Locale.of(language.getName(), country.getName());
        this.m_selectedLocale = new LocaleInfo(locale);
        this.m_localesViewer.setSelection((ISelection)new StructuredSelection((Object)locale));
        this.setErrorMessage(null);
        this.getButton(0).setEnabled(true);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ChooseLocaleDialog_shellTitle);
    }

    public LocaleInfo getSelectedLocale() {
        return this.m_selectedLocale;
    }
}

