/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property;

import java.util.Objects;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;

public final class GenericPropertyComposite
extends GenericProperty {
    private final GenericProperty[] m_properties;
    private static final Object NO_VALUE = new Object();

    public static GenericPropertyComposite create(Property ... properties) {
        GenericProperty[] genericProperties = new GenericProperty[properties.length];
        int i = 0;
        while (i < properties.length) {
            Property property = properties[i];
            genericProperties[i] = (GenericProperty)property;
            ++i;
        }
        GenericPropertyComposite composite = new GenericPropertyComposite(genericProperties);
        composite.setCategory(genericProperties[0].getCategory());
        return composite;
    }

    public GenericPropertyComposite(GenericProperty[] properties) {
        super(properties[0].getJavaInfo(), properties[0].getTitle(), properties[0].getEditor());
        this.m_properties = properties;
    }

    public int hashCode() {
        return this.m_properties.length;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GenericPropertyComposite) {
            GenericPropertyComposite property = (GenericPropertyComposite)obj;
            return Objects.deepEquals(this.m_properties, property.m_properties);
        }
        return false;
    }

    public boolean isModified() throws Exception {
        GenericProperty[] genericPropertyArray = this.m_properties;
        int n = this.m_properties.length;
        int n2 = 0;
        while (n2 < n) {
            GenericProperty property = genericPropertyArray[n2];
            if (property.isModified()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Object getValue() throws Exception {
        Object value = NO_VALUE;
        GenericProperty[] genericPropertyArray = this.m_properties;
        int n = this.m_properties.length;
        int n2 = 0;
        while (n2 < n) {
            GenericProperty property = genericPropertyArray[n2];
            Object propertyValue = property.getValue();
            if (value == NO_VALUE) {
                value = propertyValue;
            } else if (!Objects.equals(value, propertyValue)) {
                return UNKNOWN_VALUE;
            }
            ++n2;
        }
        return value;
    }

    @Override
    public Object getDefaultValue() {
        Object value = NO_VALUE;
        GenericProperty[] genericPropertyArray = this.m_properties;
        int n = this.m_properties.length;
        int n2 = 0;
        while (n2 < n) {
            GenericProperty property = genericPropertyArray[n2];
            Object propertyValue = property.getDefaultValue();
            if (value == NO_VALUE) {
                value = propertyValue;
            } else if (!Objects.equals(value, propertyValue)) {
                return UNKNOWN_VALUE;
            }
            ++n2;
        }
        return value;
    }

    public void setValue(final Object value) throws Exception {
        ExecutionUtils.run((ObjectInfo)this.m_javaInfo, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GenericProperty[] genericPropertyArray = GenericPropertyComposite.this.m_properties;
                int n = GenericPropertyComposite.this.m_properties.length;
                int n2 = 0;
                while (n2 < n) {
                    GenericProperty property = genericPropertyArray[n2];
                    property.setValue(value);
                    ++n2;
                }
            }
        });
    }

    public Class<?> getType() {
        Class commonType = null;
        GenericProperty[] genericPropertyArray = this.m_properties;
        int n = this.m_properties.length;
        int n2 = 0;
        while (n2 < n) {
            GenericProperty property = genericPropertyArray[n2];
            Class type = property.getType();
            if (type == null) {
                return null;
            }
            if (commonType == null) {
                commonType = type;
            } else if (type != commonType) {
                return null;
            }
            ++n2;
        }
        return commonType;
    }

    @Override
    public Expression getExpression() {
        Expression commonExpression = null;
        String commonSource = null;
        GenericProperty[] genericPropertyArray = this.m_properties;
        int n = this.m_properties.length;
        int n2 = 0;
        while (n2 < n) {
            GenericProperty property = genericPropertyArray[n2];
            Expression expression = property.getExpression();
            if (expression == null) {
                return null;
            }
            String expresisonSource = this.m_javaInfo.getEditor().getSource((ASTNode)expression);
            if (commonSource == null) {
                commonExpression = expression;
                commonSource = expresisonSource;
            } else if (!commonSource.equals(expresisonSource)) {
                return null;
            }
            ++n2;
        }
        return commonExpression;
    }

    @Override
    public void setExpression(final String source, final Object value) throws Exception {
        ExecutionUtils.run((ObjectInfo)this.m_javaInfo, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GenericProperty[] genericPropertyArray = GenericPropertyComposite.this.m_properties;
                int n = GenericPropertyComposite.this.m_properties.length;
                int n2 = 0;
                while (n2 < n) {
                    GenericProperty property = genericPropertyArray[n2];
                    property.setExpression(source, value);
                    ++n2;
                }
            }
        });
    }
}

