/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.eval.evaluators;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.wb.core.eval.AstEvaluationEngine;
import org.eclipse.wb.core.eval.EvaluationContext;
import org.eclipse.wb.core.eval.IExpressionEvaluator;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;

public final class FloatEvaluator
implements IExpressionEvaluator {
    @Override
    public Object evaluate(EvaluationContext context, Expression expression, ITypeBinding typeBinding, String typeQualifiedName) throws Exception {
        if ("float".equals(typeQualifiedName)) {
            if (expression instanceof NumberLiteral) {
                NumberLiteral numberLiteral = (NumberLiteral)expression;
                String token = numberLiteral.getToken();
                token = StringUtils.stripEnd((String)token, (String)"Ff");
                return Float.valueOf(token);
            }
            if (expression instanceof PrefixExpression) {
                PrefixExpression prefixExpression = (PrefixExpression)expression;
                PrefixExpression.Operator operator = prefixExpression.getOperator();
                Expression operand = prefixExpression.getOperand();
                float operandValue = FloatEvaluator.getFloatValue(context, operand);
                if (operator == PrefixExpression.Operator.PLUS) {
                    return Float.valueOf(operandValue);
                }
                if (operator == PrefixExpression.Operator.MINUS) {
                    return Float.valueOf(-operandValue);
                }
            }
            if (expression instanceof InfixExpression) {
                InfixExpression infixExpression = (InfixExpression)expression;
                List<Expression> extendedOperands = DomGenerics.extendedOperands(infixExpression);
                float[] operands = new float[2 + extendedOperands.size()];
                operands[0] = FloatEvaluator.getFloatValue(context, infixExpression.getLeftOperand());
                operands[1] = FloatEvaluator.getFloatValue(context, infixExpression.getRightOperand());
                int i = 0;
                while (i < extendedOperands.size()) {
                    Expression operandExpression = extendedOperands.get(i);
                    operands[2 + i] = FloatEvaluator.getFloatValue(context, operandExpression);
                    ++i;
                }
                float value = operands[0];
                InfixExpression.Operator operator = infixExpression.getOperator();
                int i2 = 1;
                while (i2 < operands.length) {
                    float operand = operands[i2];
                    if (operator == InfixExpression.Operator.PLUS) {
                        value += operand;
                    } else if (operator == InfixExpression.Operator.MINUS) {
                        value -= operand;
                    } else if (operator == InfixExpression.Operator.TIMES) {
                        value *= operand;
                    } else if (operator == InfixExpression.Operator.DIVIDE) {
                        value /= operand;
                    } else if (operator == InfixExpression.Operator.REMAINDER) {
                        value %= operand;
                    }
                    ++i2;
                }
                return Float.valueOf(value);
            }
        }
        return AstEvaluationEngine.UNKNOWN;
    }

    private static float getFloatValue(EvaluationContext context, Expression expression) throws Exception {
        Object value = AstEvaluationEngine.evaluate(context, expression);
        if (value instanceof Character) {
            Character character = (Character)value;
            return character.charValue();
        }
        Number number = (Number)value;
        return number.floatValue();
    }
}

