/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout;

import java.awt.GridLayout;
import java.util.List;
import javax.swing.JButton;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildAddAfter;
import org.eclipse.wb.internal.core.editor.errors.ErrorEntryInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.generation.statement.StatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.generation.statement.block.BlockStatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.generation.statement.flat.FlatStatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.generation.statement.lazy.LazyStatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.property.ComplexProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.variable.description.FieldInitializerVariableDescription;
import org.eclipse.wb.internal.core.model.variable.description.FieldUniqueVariableDescription;
import org.eclipse.wb.internal.core.model.variable.description.LazyVariableDescription;
import org.eclipse.wb.internal.core.model.variable.description.LocalUniqueVariableDescription;
import org.eclipse.wb.internal.core.model.variable.description.VariableSupportDescription;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.swing.Activator;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.BorderLayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.GridLayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.LayoutInfo;
import org.eclipse.wb.tests.designer.swing.SwingTestUtils;
import org.eclipse.wb.tests.designer.swing.model.layout.AbstractLayoutTest;
import org.junit.jupiter.api.Test;

public class LayoutManagersTest
extends AbstractLayoutTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_parse_setLayout_single() throws Exception {
        this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridLayout());\n\t}\n}");
        LayoutManagersTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(new GridLayout())/}\n\t{new: java.awt.GridLayout} {empty} {/setLayout(new GridLayout())/}");
    }

    @Test
    public void test_parse_setLayout_double() throws Exception {
        Throwable t = LayoutManagersTest.assertThrows(Throwable.class, () -> {
            ContainerInfo containerInfo = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FlowLayout());\n\t\tsetLayout(new GridLayout());\n\t}\n}");
        });
        ErrorEntryInfo errorEntry = DesignerExceptionUtils.getErrorEntry((Throwable)t);
        LayoutManagersTest.assertEquals((int)1003, (int)errorEntry.getCode());
        LayoutManagersTest.assertEquals((Object)"line 8: You are attempting to set the\n\t\tlayout <b>java.awt.GridLayout</b> for the Container <b>(javax.swing.JPanel)</b>. However, the Container already has the layout <b>java.awt.FlowLayout</b>.\n\t\tPlease remove the invalid <i>setLayout()</i> invocation from your source.\n\t", (Object)errorEntry.getDescription().replaceAll("\r", ""));
    }

    @Test
    public void test_isActive() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t}\n}");
        LayoutInfo oldLayout = panel.getLayout();
        LayoutManagersTest.assertTrue((boolean)oldLayout.isActive());
        LayoutInfo newLayout = (LayoutInfo)LayoutManagersTest.createJavaInfo("java.awt.BorderLayout");
        panel.setLayout(newLayout);
        LayoutManagersTest.assertFalse((boolean)oldLayout.isActive());
        LayoutManagersTest.assertTrue((boolean)newLayout.isActive());
        newLayout.delete();
        LayoutManagersTest.assertTrue((boolean)oldLayout.isActive());
        LayoutManagersTest.assertFalse((boolean)newLayout.isActive());
    }

    @Test
    public void test_isActive_forDisconnected() throws Exception {
        this.parseContainer("// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t}\n}");
        LayoutInfo newLayout = (LayoutInfo)LayoutManagersTest.createJavaInfo("java.awt.FlowLayout");
        LayoutManagersTest.assertFalse((boolean)newLayout.isActive());
    }

    @Test
    public void test_getComponents() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        LayoutInfo layout = panel.getLayout();
        ComponentInfo button = (ComponentInfo)LayoutManagersTest.getJavaInfoByName("button");
        Assertions.assertThat((List)layout.getComponents()).containsExactly((Object[])new ComponentInfo[]{button});
    }

    @Test
    public void test_getComponents_ifNotActive() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        ComponentInfo button = (ComponentInfo)LayoutManagersTest.getJavaInfoByName("button");
        LayoutInfo oldLayout = panel.getLayout();
        LayoutInfo newLayout = (LayoutInfo)LayoutManagersTest.createJavaInfo("java.awt.BorderLayout");
        panel.setLayout(newLayout);
        LayoutManagersTest.assertFalse((boolean)oldLayout.isActive());
        LayoutManagersTest.assertTrue((boolean)newLayout.isActive());
        Assertions.assertThat((List)oldLayout.getComponents()).isEmpty();
        Assertions.assertThat((List)newLayout.getComponents()).containsExactly((Object[])new ComponentInfo[]{button});
    }

    @Test
    public void test_isManagedObject_simpleFalse() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t}\n}");
        LayoutInfo layout = panel.getLayout();
        Object newObject = LayoutManagersTest.createJavaInfo("java.lang.Object");
        LayoutManagersTest.assertFalse((boolean)layout.isManagedObject(newObject));
        newObject = LayoutManagersTest.createJButton();
        LayoutManagersTest.assertFalse((boolean)layout.isManagedObject(newObject));
    }

    @Test
    public void test_isManagedObject_simpleTrue() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        LayoutInfo layout = panel.getLayout();
        ComponentInfo button = (ComponentInfo)LayoutManagersTest.getJavaInfoByName("button");
        LayoutManagersTest.assertTrue((boolean)layout.isManagedObject((Object)button));
    }

    @Test
    public void test_isManagedObject_falseBecauseNotActive() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        ComponentInfo button = (ComponentInfo)LayoutManagersTest.getJavaInfoByName("button");
        LayoutInfo oldLayout = panel.getLayout();
        LayoutInfo newLayout = (LayoutInfo)LayoutManagersTest.createJavaInfo("java.awt.BorderLayout");
        panel.setLayout(newLayout);
        LayoutManagersTest.assertFalse((boolean)oldLayout.isActive());
        LayoutManagersTest.assertTrue((boolean)newLayout.isActive());
        LayoutManagersTest.assertFalse((boolean)oldLayout.isManagedObject((Object)button));
        LayoutManagersTest.assertTrue((boolean)newLayout.isManagedObject((Object)button));
    }

    @Test
    public void test_isManagedObject_falseBecauseIndirectlyExposed() throws Exception {
        LayoutManagersTest.setFileContentSrc("test/Super.java", this.getTestSource("public class Super extends JPanel {\n\tprivate JPanel panel = new JPanel();\n\tprivate JButton button = new JButton();\n\tpublic Super() {\n\t\tsetLayout(new GridBagLayout());\n\t\tadd(panel);\n\t\tpanel.add(button);\n\t}\n\tpublic JButton getButton() {\n\t\treturn button;\n\t}\n}"));
        LayoutManagersTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler\npublic class Test extends Super {\n\tpublic Test() {\n\t}\n}");
        ComponentInfo button = (ComponentInfo)LayoutManagersTest.getJavaInfoByName("getButton()");
        LayoutManagersTest.assertNotNull((Object)button);
        LayoutInfo layout = panel.getLayout();
        LayoutManagersTest.assertFalse((boolean)layout.isManagedObject((Object)button));
    }

    @Test
    public void test_3_BorderLayout_add_1_local_flat() throws Exception {
        String initialLines = "class Test {\n\tpublic static void main(String args[]) {\n\t\tJPanel panel = new JPanel();\n\t\tpanel.setLayout(new BorderLayout());\n\t}\n}";
        String expectedLines = "class Test {\n\tpublic static void main(String args[]) {\n\t\tJPanel panel = new JPanel();\n\t\tpanel.setLayout(new BorderLayout());\n\t\t\n\t\tJButton button = new JButton(\"New button\");\n\t\tpanel.add(button, BorderLayout.NORTH);\n\t}\n}";
        this.check_BorderLayout_add(initialLines, LocalUniqueVariableDescription.INSTANCE, FlatStatementGeneratorDescription.INSTANCE, expectedLines, new String[]{"new JButton(\"New button\")", "panel.add(button, BorderLayout.NORTH)"}, new String[]{"new JPanel()", "panel.setLayout(new BorderLayout())", "panel.add(button, BorderLayout.NORTH)"});
    }

    @Test
    public void test_2_BorderLayout() throws Exception {
        ContainerInfo panel = (ContainerInfo)this.parseSource("test", "Test.java", "package test;\nimport java.awt.*;\nimport javax.swing.*;\nclass Test {\n\tpublic static void main(String args[]) {\n\t\tJPanel panel = new JPanel();\n\t\tpanel.setLayout(new BorderLayout());\n\t}\n}");
        LayoutManagersTest.assertEquals((int)1, (int)panel.getChildren().size());
        LayoutManagersTest.assertSame(BorderLayoutInfo.class, ((ObjectInfo)panel.getChildren().get(0)).getClass());
        LayoutManagersTest.assertSame((Object)panel.getLayout(), panel.getChildren().get(0));
    }

    @Test
    public void test_3_BorderLayout_add_2_field_flat() throws Exception {
        String initialLines = "class Test {\n\tpublic static void main(String args[]) {\n\t\tJPanel panel = new JPanel();\n\t\tpanel.setLayout(new BorderLayout());\n\t}\n}";
        String expectedLines = "class Test {\n\tprivate static JButton button;\n\tpublic static void main(String args[]) {\n\t\tJPanel panel = new JPanel();\n\t\tpanel.setLayout(new BorderLayout());\n\t\t\n\t\tbutton = new JButton(\"New button\");\n\t\tpanel.add(button, BorderLayout.NORTH);\n\t}\n}";
        this.check_BorderLayout_add(initialLines, FieldUniqueVariableDescription.INSTANCE, FlatStatementGeneratorDescription.INSTANCE, expectedLines, new String[]{"new JButton(\"New button\")", "panel.add(button, BorderLayout.NORTH)"}, new String[]{"new JPanel()", "panel.setLayout(new BorderLayout())", "panel.add(button, BorderLayout.NORTH)"});
    }

    @Test
    public void test_3_BorderLayout_add_fieldInitializer_flat() throws Exception {
        String initialLines = "class Test {\n\tpublic static void main(String args[]) {\n\t\tJPanel panel = new JPanel();\n\t\tpanel.setLayout(new BorderLayout());\n\t}\n}";
        String expectedLines = "class Test {\n\tprivate static final JButton button = new JButton(\"New button\");\n\tpublic static void main(String args[]) {\n\t\tJPanel panel = new JPanel();\n\t\tpanel.setLayout(new BorderLayout());\n\t\t\n\t\tpanel.add(button, BorderLayout.NORTH);\n\t}\n}";
        this.check_BorderLayout_add(initialLines, FieldInitializerVariableDescription.INSTANCE, FlatStatementGeneratorDescription.INSTANCE, expectedLines, new String[]{"new JButton(\"New button\")", "panel.add(button, BorderLayout.NORTH)"}, new String[]{"new JPanel()", "panel.setLayout(new BorderLayout())", "panel.add(button, BorderLayout.NORTH)"});
    }

    @Test
    public void test_3_BorderLayout_add_4_local_block() throws Exception {
        String initialLines = "class Test {\n\tpublic static void main(String args[]) {\n\t\tJPanel panel = new JPanel();\n\t\tpanel.setLayout(new BorderLayout());\n\t}\n}";
        String expectedLines = "class Test {\n\tpublic static void main(String args[]) {\n\t\tJPanel panel = new JPanel();\n\t\tpanel.setLayout(new BorderLayout());\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tpanel.add(button, BorderLayout.NORTH);\n\t\t}\n\t}\n}";
        this.check_BorderLayout_add(initialLines, LocalUniqueVariableDescription.INSTANCE, BlockStatementGeneratorDescription.INSTANCE, expectedLines, new String[]{"new JButton(\"New button\")", "panel.add(button, BorderLayout.NORTH)"}, new String[]{"new JPanel()", "panel.setLayout(new BorderLayout())", "panel.add(button, BorderLayout.NORTH)"});
    }

    @Test
    public void test_3_BorderLayout_add_5_lazy() throws Exception {
        String initialLines = "class Test {\n\tpublic static void main(String args[]) {\n\t\tJPanel panel = new JPanel();\n\t\tpanel.setLayout(new BorderLayout());\n\t}\n}";
        String expectedLines = "class Test {\n\tprivate static JButton button;\n\tpublic static void main(String args[]) {\n\t\tJPanel panel = new JPanel();\n\t\tpanel.setLayout(new BorderLayout());\n\t\tpanel.add(getButton(), BorderLayout.NORTH);\n\t}\n\tprivate static JButton getButton() {\n\t\tif (button == null) {\n\t\t\tbutton = new JButton(\"New button\");\n\t\t}\n\t\treturn button;\n\t}\n}";
        ContainerInfo panel = this.check_BorderLayout_add(initialLines, LazyVariableDescription.INSTANCE, LazyStatementGeneratorDescription.INSTANCE, expectedLines, new String[]{"new JButton(\"New button\")", "panel.add(getButton(), BorderLayout.NORTH)"}, new String[]{"new JPanel()", "panel.setLayout(new BorderLayout())", "panel.add(getButton(), BorderLayout.NORTH)"});
        LayoutManagersTest.assert_creation((JavaInfo)panel);
    }

    private ContainerInfo check_BorderLayout_add(String initialLines, VariableSupportDescription variable, StatementGeneratorDescription statement, String expectedLines, String[] expectedChildNodes, String[] expectedParentNodes) throws Exception {
        ContainerInfo panel = this.parseContainer(initialLines);
        BorderLayoutInfo layout = (BorderLayoutInfo)panel.getChildren().get(0);
        LayoutManagersTest.assertEquals((int)0, (int)panel.getChildrenComponents().size());
        ComponentInfo newComponent = (ComponentInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, JButton.class, (CreationSupport)new ConstructorCreationSupport());
        SwingTestUtils.setGenerations(variable, statement);
        try {
            layout.command_CREATE(newComponent, "North");
        }
        finally {
            SwingTestUtils.setGenerationDefaults();
        }
        LayoutManagersTest.assertEquals((Object)this.getTestSource(expectedLines), (Object)this.m_lastEditor.getSource());
        LayoutManagersTest.assertAST(this.m_lastEditor);
        LayoutManagersTest.assertEquals((int)1, (int)panel.getChildrenComponents().size());
        LayoutManagersTest.assertSame((Object)newComponent, panel.getChildrenComponents().get(0));
        LayoutManagersTest.assertSame((Object)panel, (Object)newComponent.getParent());
        LayoutManagersTest.assertRelatedNodes((JavaInfo)newComponent, expectedChildNodes);
        LayoutManagersTest.assertRelatedNodes((JavaInfo)panel, expectedParentNodes);
        return panel;
    }

    @Test
    public void test_getPresentation() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t}\n}");
        LayoutInfo layout = panel.getLayout();
        LayoutManagersTest.assertVisible((ObjectInfo)layout, false);
    }

    @Test
    public void test_delete() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new java.awt.BorderLayout());\n\t}\n}");
        LayoutInfo layout = panel.getLayout();
        LayoutManagersTest.assertTrue((boolean)(layout instanceof BorderLayoutInfo));
        layout.delete();
        layout = panel.getLayout();
        LayoutManagersTest.assertTrue((boolean)(layout instanceof FlowLayoutInfo));
        this.assertEditor("// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t}\n}");
    }

    @Test
    public void test_delete2() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new java.awt.BorderLayout());\n\t}\n}");
        Property layoutProperty = panel.getPropertyByTitle("Layout");
        layoutProperty.setValue(Property.UNKNOWN_VALUE);
        this.assertEditor("// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t}\n}");
    }

    @Test
    public void test_replace() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t}\n}");
        LayoutManagersTest.assertInstanceOf(FlowLayoutInfo.class, (Object)panel.getLayout());
        LayoutInfo gridLayout = (LayoutInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, GridLayout.class, (CreationSupport)new ConstructorCreationSupport());
        panel.setLayout(gridLayout);
        LayoutManagersTest.assertInstanceOf(GridLayoutInfo.class, (Object)panel.getLayout());
        this.assertEditor("// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridLayout(1, 0, 0, 0));\n\t}\n}");
    }

    @Test
    public void test_replace2() throws Exception {
        final ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t}\n}");
        final StringBuffer buffer = new StringBuffer();
        panel.addBroadcastListener((Object)new ObjectInfoChildAddAfter(){

            public void invoke(ObjectInfo parent, ObjectInfo child) throws Exception {
                if (parent == panel && child instanceof LayoutInfo) {
                    LayoutInfo newLayout = (LayoutInfo)child;
                    buffer.append("layout added: " + newLayout.getDescription().getComponentClass().getName());
                }
            }
        });
        LayoutInfo gridLayout = (LayoutInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, GridLayout.class, (CreationSupport)new ConstructorCreationSupport());
        panel.setLayout(gridLayout);
        LayoutManagersTest.assertEquals((Object)"layout added: java.awt.GridLayout", (Object)buffer.toString());
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridLayout(1, 0, 0, 0));\n\t}\n}");
    }

    @Test
    public void test_layoutComplexProperty() throws Exception {
        ContainerInfo panel = (ContainerInfo)this.parseSource("test", "Test.java", "package test;\nimport javax.swing.*;\nclass Test {\n\tpublic static void main(String args[]) {\n\t\tJPanel panel = new JPanel();\n\t}\n}");
        Property layoutProperty = panel.getPropertyByTitle("Layout");
        LayoutManagersTest.assertTrue((boolean)(layoutProperty instanceof ComplexProperty));
        LayoutManagersTest.assertTrue((boolean)layoutProperty.isModified());
        LayoutManagersTest.assertEquals((Object)"(java.awt.FlowLayout)", (Object)LayoutManagersTest.getPropertyText(layoutProperty));
        Property[] subProperties = LayoutManagersTest.getSubProperties(layoutProperty);
        Property hgapProperty = LayoutManagersTest.getPropertyByTitle(subProperties, "hgap");
        LayoutManagersTest.assertNotNull((Object)hgapProperty);
        LayoutManagersTest.assertFalse((boolean)hgapProperty.isModified());
        LayoutManagersTest.assertEquals((Object)5, (Object)hgapProperty.getValue());
        Property vgapProperty = LayoutManagersTest.getPropertyByTitle(subProperties, "vgap");
        LayoutManagersTest.assertNotNull((Object)vgapProperty);
        LayoutManagersTest.assertFalse((boolean)vgapProperty.isModified());
        LayoutManagersTest.assertEquals((Object)5, (Object)vgapProperty.getValue());
    }

    @Test
    public void test_removeConstraints_whenReplaceLayout() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tButton button = new Button();\n\t\t\tadd(button, BorderLayout.WEST);\n\t\t}\n\t}\n}");
        this.refresh();
        panel.getLayout().delete();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tButton button = new Button();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_removeConstraints_whenReplaceLayout_addDeprecated() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new CardLayout());\n\t\t{\n\t\t\tButton button = new Button();\n\t\t\tadd(\"name\", button);\n\t\t}\n\t}\n}");
        this.refresh();
        panel.getLayout().delete();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tButton button = new Button();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_removeConstraints_whenReparent() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJPanel inner = new JPanel();\n\t\t\tinner.setLayout(null);\n\t\t\tadd(inner);\n\t\t\t{\n\t\t\t\tButton button = new Button();\n\t\t\t\tbutton.setBounds(10, 20, 100, 50);\n\t\t\t\tinner.add(button);\n\t\t\t}\n\t\t}\n\t}\n}");
        ContainerInfo inner = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)inner.getChildrenComponents().get(0);
        ((FlowLayoutInfo)panel.getLayout()).move(button, null);
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJPanel inner = new JPanel();\n\t\t\tinner.setLayout(null);\n\t\t\tadd(inner);\n\t\t}\n\t\t{\n\t\t\tButton button = new Button();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    private void check_nameTemplate(String template, String lines) throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJPanel panel = new JPanel();\n\t\t\tpanel.setLayout(new FlowLayout(FlowLayout.CENTER));\n\t\t\tadd(panel);\n\t\t}\n\t}\n}");
        panel.refresh();
        ContainerInfo innerPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        LayoutInfo layout = innerPanel.getLayout();
        Activator.getDefault().getPreferenceStore().setValue("templateLayoutName", template);
        layout.getPropertyByTitle("hgap").setValue((Object)7);
        this.assertEditor(lines);
    }

    @Test
    public void test_nameTemplate_useDefaultName() throws Exception {
        this.check_nameTemplate("${defaultName}", "class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJPanel panel = new JPanel();\n\t\t\tFlowLayout flowLayout = new FlowLayout(FlowLayout.CENTER);\n\t\t\tflowLayout.setHgap(7);\n\t\t\tpanel.setLayout(flowLayout);\n\t\t\tadd(panel);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_nameTemplate_alternativeTemplate_1() throws Exception {
        this.check_nameTemplate("${layoutAcronym}${containerName-cap}", "class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJPanel panel = new JPanel();\n\t\t\tFlowLayout flPanel = new FlowLayout(FlowLayout.CENTER);\n\t\t\tflPanel.setHgap(7);\n\t\t\tpanel.setLayout(flPanel);\n\t\t\tadd(panel);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_nameTemplate_alternativeTemplate_2() throws Exception {
        this.check_nameTemplate("${containerName}${layoutClassName}", "class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJPanel panel = new JPanel();\n\t\t\tFlowLayout panelFlowLayout = new FlowLayout(FlowLayout.CENTER);\n\t\t\tpanelFlowLayout.setHgap(7);\n\t\t\tpanel.setLayout(panelFlowLayout);\n\t\t\tadd(panel);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_nameTemplate_ignoreDuringParsing() throws Exception {
        LayoutManagersTest.setFileContentSrc("test/MyLayout.java", this.getTestSource("public class MyLayout extends FlowLayout {\n\tpublic MyLayout(Container container) {\n\t\tcontainer.setLayout(this);\n\t}\n}"));
        LayoutManagersTest.setFileContentSrc("test/MyLayout.wbp-component.xml", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<component xmlns=\"http://www.eclipse.org/wb/WBPComponent\">\n\t<constructors>\n\t\t<constructor>\n\t\t\t<parameter type=\"java.awt.Container\" parent=\"true\"/>\n\t\t</constructor>\n\t</constructors>\n</component>");
        LayoutManagersTest.waitForAutoBuild();
        Activator.getDefault().getPreferenceStore().setValue("templateLayoutName", "${containerName}${layoutClassName}");
        String lines = "class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJPanel panel = new JPanel();\n\t\t\tMyLayout layout = new MyLayout(panel);\n\t\t\tpanel.setLayout(layout);\n\t\t\tadd(panel);\n\t\t}\n\t}\n}";
        this.parseJavaInfo(lines);
        this.assertEditor(lines);
    }

    @Test
    public void test_customImplementationOf_LayoutManager() throws Exception {
        LayoutManagersTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {\n\tpublic MyPanel() {\n\t\tfinal LayoutManager layout = new FlowLayout();\n\t\tsetLayout(new LayoutManager() {\n\t\t\tpublic void addLayoutComponent(String name, Component comp) {\n\t\t\t\tlayout.addLayoutComponent(name, comp);\n\t\t\t}\n\t\t\tpublic void removeLayoutComponent(Component comp) {\n\t\t\t\tlayout.removeLayoutComponent(comp);\n\t\t\t}\n\t\t\tpublic Dimension preferredLayoutSize(Container parent) {\n\t\t\t\treturn layout.preferredLayoutSize(parent);\n\t\t\t}\n\t\t\tpublic Dimension minimumLayoutSize(Container parent) {\n\t\t\t\treturn layout.minimumLayoutSize(parent);\n\t\t\t}\n\t\t\tpublic void layoutContainer(Container parent) {\n\t\t\t\tlayout.layoutContainer(parent);\n\t\t\t}\n\t\t});\n\t}\n}"));
        LayoutManagersTest.waitForAutoBuild();
        this.parseJavaInfo("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class Test extends MyPanel {\n\tpublic Test() {\n\t}\n}");
        LayoutManagersTest.assertHierarchy("{this: test.MyPanel} {this} {}\n\t{implicit-layout: test.MyPanel$1} {implicit-layout} {}");
    }
}

