/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.forms.table;

import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.swt.model.layout.RowLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.model.forms.AbstractFormsTest;
import org.junit.jupiter.api.Test;

public class TableWrapLayoutClipboardTest
extends AbstractFormsTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_simpleSingleControl() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new RowLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      {", "        TableWrapLayout layout = new TableWrapLayout();", "        layout.topMargin = 20;", "        composite.setLayout(layout);", "      }", "      {", "        Button button = new Button(composite, SWT.NONE);", "      }", "    }", "  }", "}");
        shell.refresh();
        RowLayoutInfo rowLayout = (RowLayoutInfo)shell.getLayout();
        CompositeInfo composite = (CompositeInfo)shell.getChildrenControls().get(0);
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)composite);
        CompositeInfo newComposite = (CompositeInfo)memento.create((JavaInfo)shell);
        rowLayout.command_CREATE((ControlInfo)newComposite, null);
        memento.apply();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new RowLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      {", "        TableWrapLayout layout = new TableWrapLayout();", "        layout.topMargin = 20;", "        composite.setLayout(layout);", "      }", "      {", "        Button button = new Button(composite, SWT.NONE);", "      }", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      {", "        TableWrapLayout layout = new TableWrapLayout();", "        layout.topMargin = 20;", "        composite.setLayout(layout);", "      }", "      {", "        Button button = new Button(composite, SWT.NONE);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_grid2x2() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new RowLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      {", "        TableWrapLayout layout = new TableWrapLayout();", "        layout.numColumns = 2;", "        composite.setLayout(layout);", "      }", "      {", "        Button button = new Button(composite, SWT.NONE);", "        {", "          TableWrapData tableWrapData = new TableWrapData(TableWrapData.FILL_GRAB, TableWrapData.TOP);", "          button.setLayoutData(tableWrapData);", "        }", "      }", "      new Label(composite, SWT.NONE);", "      new Label(composite, SWT.NONE);", "      {", "        Button button = new Button(composite, SWT.NONE);", "      }", "    }", "  }", "}");
        shell.refresh();
        RowLayoutInfo rowLayout = (RowLayoutInfo)shell.getLayout();
        CompositeInfo composite = (CompositeInfo)shell.getChildrenControls().get(0);
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)composite);
        CompositeInfo newComposite = (CompositeInfo)memento.create((JavaInfo)shell);
        rowLayout.command_CREATE((ControlInfo)newComposite, null);
        memento.apply();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new RowLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      {", "        TableWrapLayout layout = new TableWrapLayout();", "        layout.numColumns = 2;", "        composite.setLayout(layout);", "      }", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB, TableWrapData.TOP));", "      }", "      new Label(composite, SWT.NONE);", "      new Label(composite, SWT.NONE);", "      {", "        Button button = new Button(composite, SWT.NONE);", "      }", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      {", "        TableWrapLayout layout = new TableWrapLayout();", "        layout.numColumns = 2;", "        composite.setLayout(layout);", "      }", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB, TableWrapData.TOP));", "      }", "      new Label(composite, SWT.NONE);", "      new Label(composite, SWT.NONE);", "      {", "        Button button = new Button(composite, SWT.NONE);", "      }", "    }", "  }", "}");
    }
}

