/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.palette;

import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.editor.palette.model.PaletteInfo;
import org.eclipse.wb.internal.core.editor.palette.PaletteManager;
import org.eclipse.wb.internal.core.editor.palette.command.CategoryAddCommand;
import org.eclipse.wb.internal.core.editor.palette.command.Command;
import org.eclipse.wb.internal.core.editor.palette.command.factory.FactoryAddCommand;
import org.eclipse.wb.internal.core.editor.palette.command.factory.FactoryEditCommand;
import org.eclipse.wb.internal.core.editor.palette.model.entry.InstanceFactoryEntryInfo;
import org.eclipse.wb.internal.core.editor.palette.model.entry.StaticFactoryEntryInfo;
import org.eclipse.wb.tests.designer.core.palette.AbstractPaletteTest;
import org.junit.jupiter.api.Test;

public class FactoryCommandsTest
extends AbstractPaletteTest {
    @Test
    public void test_add_static() throws Exception {
        PaletteManager manager = this.loadManager();
        PaletteInfo palette = manager.getPalette();
        CategoryInfo category = FactoryCommandsTest.addCategory(manager, "0");
        manager.commands_add((Command)new FactoryAddCommand("new id", "new name", "new description", true, "clazz", "signature", true, category));
        manager.commands_write();
        StaticFactoryEntryInfo entry = (StaticFactoryEntryInfo)palette.getEntry("new id");
        FactoryCommandsTest.assertEquals((Object)"new name", (Object)entry.getName());
        FactoryCommandsTest.assertEquals((Object)"new description", (Object)entry.getDescription());
        FactoryCommandsTest.assertTrue((boolean)entry.isVisible());
        FactoryCommandsTest.assertEquals((Object)"clazz", (Object)entry.getFactoryClassName());
        FactoryCommandsTest.assertEquals((Object)"signature", (Object)entry.getMethodSignature());
        manager.reloadPalette();
        palette = manager.getPalette();
        StaticFactoryEntryInfo entry2 = (StaticFactoryEntryInfo)palette.getEntry("new id");
        FactoryCommandsTest.assertEquals((Object)"new name", (Object)entry2.getName());
        FactoryCommandsTest.assertEquals((Object)"new description", (Object)entry2.getDescription());
        FactoryCommandsTest.assertTrue((boolean)entry2.isVisible());
        FactoryCommandsTest.assertEquals((Object)"clazz", (Object)entry2.getFactoryClassName());
        FactoryCommandsTest.assertEquals((Object)"signature", (Object)entry2.getMethodSignature());
    }

    @Test
    public void test_add_instance() throws Exception {
        PaletteManager manager = this.loadManager();
        PaletteInfo palette = manager.getPalette();
        CategoryInfo category = FactoryCommandsTest.addCategory(manager, "0");
        manager.commands_add((Command)new FactoryAddCommand("0", "0", "0", true, "0", "0", false, category));
        manager.commands_write();
        InstanceFactoryEntryInfo entry = (InstanceFactoryEntryInfo)palette.getEntry("0");
        FactoryCommandsTest.assertEquals((Object)"0", (Object)entry.getName());
        manager.reloadPalette();
        palette = manager.getPalette();
        InstanceFactoryEntryInfo entry2 = (InstanceFactoryEntryInfo)palette.getEntry("0");
        FactoryCommandsTest.assertEquals((Object)"0", (Object)entry2.getName());
    }

    @Test
    public void test_edit() throws Exception {
        PaletteManager manager = this.loadManager();
        PaletteInfo palette = manager.getPalette();
        CategoryInfo category = FactoryCommandsTest.addCategory(manager, "0");
        manager.commands_add((Command)new FactoryAddCommand("0", "0", "0", true, "0", "0", true, category));
        StaticFactoryEntryInfo entry = (StaticFactoryEntryInfo)palette.getEntry("0");
        FactoryCommandsTest.assertEquals((Object)"0", (Object)entry.getName());
        manager.commands_add((Command)new FactoryEditCommand("0", "1", "1", false, "1", "1", true));
        entry = (StaticFactoryEntryInfo)palette.getEntry("0");
        FactoryCommandsTest.assertEquals((Object)"1", (Object)entry.getName());
        FactoryCommandsTest.assertEquals((Object)"1", (Object)entry.getDescription());
        FactoryCommandsTest.assertFalse((boolean)entry.isVisible());
        FactoryCommandsTest.assertEquals((Object)"1", (Object)entry.getFactoryClassName());
        FactoryCommandsTest.assertEquals((Object)"1", (Object)entry.getMethodSignature());
        manager.commands_write();
        manager.reloadPalette();
        palette = manager.getPalette();
        StaticFactoryEntryInfo entry2 = (StaticFactoryEntryInfo)palette.getEntry("0");
        FactoryCommandsTest.assertEquals((Object)"1", (Object)entry2.getName());
        FactoryCommandsTest.assertEquals((Object)"1", (Object)entry2.getDescription());
        FactoryCommandsTest.assertFalse((boolean)entry2.isVisible());
        FactoryCommandsTest.assertEquals((Object)"1", (Object)entry2.getFactoryClassName());
        FactoryCommandsTest.assertEquals((Object)"1", (Object)entry2.getMethodSignature());
    }

    private static CategoryInfo addCategory(PaletteManager manager, String id) {
        PaletteInfo palette = manager.getPalette();
        manager.commands_add((Command)new CategoryAddCommand(id, "0", "0", true, true, null));
        return palette.getCategory(id);
    }
}

