/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.palette;

import java.util.Objects;
import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.editor.palette.model.EntryInfo;
import org.eclipse.wb.core.editor.palette.model.PaletteInfo;
import org.eclipse.wb.core.editor.palette.model.entry.ComponentEntryInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.editor.palette.PaletteManager;
import org.eclipse.wb.tests.designer.TestUtils;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.AfterEach;

public abstract class AbstractPaletteTest
extends SwingModelTest {
    private static final String POINT_ID = "org.eclipse.wb.core.toolkits";
    protected static final String PALETTE_EXTENSION_ID = "testPaletteId";
    protected static final String TOOLKIT_ID = "test.toolkit";
    private PaletteManager m_lastManager;

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        AbstractPaletteTest.removeToolkitExtension();
        if (this.m_lastManager != null) {
            this.m_lastManager.commands_clear();
            this.m_lastManager.commands_write();
            this.m_lastManager = null;
        }
        super.tearDown();
    }

    protected static void addPaletteExtension(String[] paletteLines) {
        AbstractPaletteTest.addPaletteExtension(PALETTE_EXTENSION_ID, paletteLines);
    }

    protected static void addPaletteExtension(String extensionId, String[] paletteLines) {
        String[] toolkitLines = new String[1 + paletteLines.length + 1];
        toolkitLines[0] = "    <palette>";
        System.arraycopy(paletteLines, 0, toolkitLines, 1, paletteLines.length);
        toolkitLines[toolkitLines.length - 1] = "    </palette>";
        AbstractPaletteTest.addToolkitExtension(extensionId, toolkitLines);
    }

    protected static void addToolkitExtension(String extensionId, String[] lines) {
        String contribution = AbstractPaletteTest.getSource3(new String[]{"  <toolkit id='test.toolkit'>"}, lines, new String[]{"  </toolkit>"});
        TestUtils.addDynamicExtension(POINT_ID, extensionId, contribution);
    }

    protected static void removeToolkitExtension() {
        AbstractPaletteTest.removeToolkitExtension(PALETTE_EXTENSION_ID);
    }

    protected static void removeToolkitExtension(String extensionId) {
        TestUtils.removeDynamicExtension(POINT_ID, extensionId);
    }

    protected final JavaInfo parseEmptyPanel() throws Exception {
        return this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
    }

    protected final PaletteInfo loadPalette() throws Exception {
        JavaInfo panel = this.parseEmptyPanel();
        return this.loadPalette(panel);
    }

    protected final PaletteManager loadManager() throws Exception {
        JavaInfo panel = this.parseEmptyPanel();
        this.m_lastManager = new PaletteManager(panel, TOOLKIT_ID);
        this.m_lastManager.reloadPalette();
        return this.m_lastManager;
    }

    protected final PaletteInfo loadPalette(JavaInfo javaInfo) {
        this.m_lastManager = new PaletteManager(javaInfo.getRootJava(), TOOLKIT_ID);
        this.m_lastManager.reloadPalette();
        return this.m_lastManager.getPalette();
    }

    protected final ComponentEntryInfo loadSingleComponent(String id) throws Exception {
        EntryInfo entry = this.loadSingleEntry(id);
        if (entry instanceof ComponentEntryInfo) {
            return (ComponentEntryInfo)entry;
        }
        throw new IllegalArgumentException("No component: " + id);
    }

    protected final EntryInfo loadSingleEntry(String id) throws Exception {
        PaletteInfo palette = this.loadPalette();
        for (CategoryInfo category : palette.getCategories()) {
            for (EntryInfo entry : category.getEntries()) {
                if (!Objects.equals(entry.getId(), id)) continue;
                return entry;
            }
        }
        throw new IllegalArgumentException("No entry: " + id);
    }
}

