/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.variables;

import java.util.Map;
import javax.swing.JButton;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.variable.NamesManager;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.ToolkitProvider;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.core.PreferencesRepairer;
import org.eclipse.wb.tests.designer.core.model.variables.AbstractVariableTest;
import org.junit.jupiter.api.Test;

public class TextPropertyRenameTest
extends AbstractVariableTest {
    private static final ToolkitDescription TOOLKIT = ToolkitProvider.DESCRIPTION;

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getNameForText() throws Exception {
        this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "}", "}");
        JavaInfo component = JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("javax.swing.JButton"), (CreationSupport)new ConstructorCreationSupport());
        TextPropertyRenameTest.assertEquals((Object)"firstButton", (Object)TextPropertyRenameTest.invoke_getNameForText(component, "First", 3, "${text}${class_name}"));
        TextPropertyRenameTest.assertEquals((Object)"btnFirst", (Object)TextPropertyRenameTest.invoke_getNameForText(component, "First", 3, "${class_acronym}${text}"));
        TextPropertyRenameTest.assertEquals((Object)"veryLongTextButton", (Object)TextPropertyRenameTest.invoke_getNameForText(component, "Very long text for my JButton", 3, "${text}${class_name}"));
        TextPropertyRenameTest.assertEquals((Object)"textCommaButton", (Object)TextPropertyRenameTest.invoke_getNameForText(component, "!!Text,  comma. \tdot... more~", 2, "${text}${class_name}"));
        TextPropertyRenameTest.assertNull((Object)TextPropertyRenameTest.invoke_getNameForText(component, "!..!", 3, "${text}${class_name}"));
    }

    private static String invoke_getNameForText(JavaInfo javaInfo, String text, int wordsLimit, String template) throws Exception {
        PreferencesRepairer preferencesRepairer = new PreferencesRepairer(TOOLKIT.getPreferences());
        try {
            preferencesRepairer.setValue("textVariable.wordsLimit", wordsLimit);
            preferencesRepairer.setValue("textVariable.template", template);
            String string = (String)ReflectionUtils.invokeMethod2(NamesManager.class, (String)"getNameForText", JavaInfo.class, String.class, (Object)javaInfo, (Object)text);
            return string;
        }
        finally {
            preferencesRepairer.restore();
        }
    }

    @Test
    public void test_textPropertyRename_never() throws Exception {
        String[] lines = new String[]{"public final class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}"};
        String[] expectedLines = new String[]{"public final class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    button.setText(\"first\");", "    add(button);", "  }", "}"};
        this.check_textPropertyRename(lines, expectedLines, "first", 2);
    }

    @Test
    public void test_textPropertyRename_alwaysBad_controlCharacters() throws Exception {
        String[] lines = new String[]{"public final class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}"};
        String[] expectedLines = new String[]{"public final class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    button.setText(\"...\");", "    add(button);", "  }", "}"};
        this.check_textPropertyRename(lines, expectedLines, "...", 0);
    }

    @Test
    public void test_textPropertyRename_alwaysBad_nonLatinCharacters() throws Exception {
        String[] lines = new String[]{"public final class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}"};
        String[] expectedLines = new String[]{"public final class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    button.setText(\"\u0410\u0411\");", "    add(button);", "  }", "}"};
        this.check_textPropertyRename(lines, expectedLines, "\u0410\u0411", 0);
    }

    @Test
    public void test_textPropertyRename_alwaysGood() throws Exception {
        String[] lines = new String[]{"public final class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}"};
        String[] expectedLines = new String[]{"public final class Test extends JPanel {", "  public Test() {", "    JButton firstButton = new JButton();", "    firstButton.setText(\"first\");", "    add(firstButton);", "  }", "}"};
        this.check_textPropertyRename(lines, expectedLines, "first", 0);
    }

    @Test
    public void test_textPropertyRename_defaultFalse() throws Exception {
        String[] lines = new String[]{"public final class Test extends JPanel {", "  public Test() {", "    JButton aButton = new JButton();", "    add(aButton);", "  }", "}"};
        String[] expectedLines = new String[]{"public final class Test extends JPanel {", "  public Test() {", "    JButton aButton = new JButton();", "    aButton.setText(\"first\");", "    add(aButton);", "  }", "}"};
        this.check_textPropertyRename(lines, expectedLines, "first", 1);
    }

    @Test
    public void test_textPropertyRename_defaultTrue() throws Exception {
        String[] lines = new String[]{"public final class Test extends JPanel {", "  public Test() {", "    JButton button_1 = new JButton();", "    add(button_1);", "  }", "}"};
        String[] expectedLines = new String[]{"public final class Test extends JPanel {", "  public Test() {", "    JButton firstButton = new JButton();", "    firstButton.setText(\"first\");", "    add(firstButton);", "  }", "}"};
        this.check_textPropertyRename(lines, expectedLines, "first", 1);
    }

    @Test
    public void test_textPropertyRename_field() throws Exception {
        IJavaProject javaProject = m_testProject.getJavaProject();
        String[] lines = new String[]{"public final class Test extends JPanel {", "  private JButton m_button_Q;", "  public Test() {", "    m_button_Q = new JButton();", "    add(m_button_Q);", "  }", "}"};
        String[] expectedLines = new String[]{"public final class Test extends JPanel {", "  private JButton m_firstButton_Q;", "  public Test() {", "    m_firstButton_Q = new JButton();", "    m_firstButton_Q.setText(\"first\");", "    add(m_firstButton_Q);", "  }", "}"};
        Map options = ProjectUtils.getOptions((IJavaProject)javaProject);
        javaProject.setOption("org.eclipse.jdt.core.codeComplete.fieldPrefixes", "m_");
        javaProject.setOption("org.eclipse.jdt.core.codeComplete.fieldSuffixes", "_Q");
        try {
            this.check_textPropertyRename(lines, expectedLines, "first", 0);
        }
        finally {
            javaProject.setOptions(options);
        }
    }

    @Test
    public void test_textPropertyRename_duplicate() throws Exception {
        String[] lines = new String[]{"public final class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "    //", "    JButton firstButton = new JButton();", "    add(firstButton);", "  }", "}"};
        String[] expectedLines = new String[]{"public final class Test extends JPanel {", "  public Test() {", "    JButton firstButton_1 = new JButton();", "    firstButton_1.setText(\"first\");", "    add(firstButton_1);", "    //", "    JButton firstButton = new JButton();", "    add(firstButton);", "  }", "}"};
        this.check_textPropertyRename(lines, expectedLines, "first", 0);
    }

    private void check_textPropertyRename(String[] lines, String[] expectedLines, String text, int mode) throws Exception {
        ContainerInfo panel = this.parseContainer(lines);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        PreferencesRepairer preferencesRepairer = new PreferencesRepairer(TOOLKIT.getPreferences());
        try {
            preferencesRepairer.setValue("textVariable.mode", mode);
            preferencesRepairer.setValue("textVariable.template", "${text}${class_name}");
            Property textProperty = button.getPropertyByTitle("text");
            textProperty.setValue((Object)text);
            this.assertEditor(expectedLines);
        }
        finally {
            preferencesRepairer.restore();
        }
    }

    @Test
    public void test_renameNewComponent() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo newButton = TextPropertyRenameTest.createComponent(JButton.class);
        flowLayout.add(newButton, null);
        PreferencesRepairer preferences = new PreferencesRepairer(TOOLKIT.getPreferences());
        try {
            preferences.setValue("textVariable.mode", 0);
            preferences.setValue("textVariable.template", "${text}${class_name}");
            newButton.getPropertyByTitle("text").setValue((Object)"first");
        }
        finally {
            preferences.restore();
        }
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      JButton firstButton = new JButton('first');", "      add(firstButton);", "    }", "  }", "}");
    }
}

