/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.generic;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.AssociationObjectFactories;
import org.eclipse.wb.core.model.association.AssociationObjectFactory;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.generic.ContainerObjectValidator;
import org.eclipse.wb.internal.core.model.generic.ContainerObjectValidators;
import org.eclipse.wb.internal.core.model.generic.SimpleContainer;
import org.eclipse.wb.internal.core.model.generic.SimpleContainerConfigurable;
import org.eclipse.wb.internal.core.model.generic.SimpleContainerConfiguration;
import org.eclipse.wb.internal.core.model.generic.SimpleContainerFactory;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.core.AbstractJavaProjectTest;
import org.eclipse.wb.tests.designer.core.model.TestObjectInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class SimpleContainerModelTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getConfigurations_noContainerAssociation() throws Exception {
        List<SimpleContainerConfiguration> configurations = this.getConfigurations(true, new String[][]{{"simpleContainer", "true"}, {"simpleContainer.component", "java.awt.Component"}});
        Assertions.assertThat(configurations).hasSize(1);
        SimpleContainerModelTest.assertConfiguration(configurations.get(0), "NO", "java.awt.Component");
    }

    @Test
    public void test_getConfigurations_forCanvas_common() throws Exception {
        List<SimpleContainerConfiguration> configurations = this.getConfigurations(true, new String[][]{{"simpleContainer", "true"}, {"simpleContainer.association", "%parent%.add(%child%)"}, {"simpleContainer.component", "java.awt.Component"}});
        Assertions.assertThat(configurations).hasSize(1);
        SimpleContainerModelTest.assertConfiguration(configurations.get(0), "%parent%.add(%child%)", "java.awt.Component");
    }

    @Test
    public void test_getConfigurations_forCanvas_explicit() throws Exception {
        List<SimpleContainerConfiguration> configurations = this.getConfigurations(true, new String[][]{{"simpleContainer.canvas", "true"}, {"simpleContainer.canvas.association", "%parent%.add(%child%)"}, {"simpleContainer.canvas.component", "java.awt.Component"}});
        Assertions.assertThat(configurations).hasSize(1);
        SimpleContainerModelTest.assertConfiguration(configurations.get(0), "%parent%.add(%child%)", "java.awt.Component");
    }

    @Test
    public void test_getConfigurations_forCanvas_onlyForTree() throws Exception {
        List<SimpleContainerConfiguration> configurations = this.getConfigurations(true, new String[][]{{"simpleContainer.tree", "true"}, {"simpleContainer.tree.association", "%parent%.add(%child%)"}, {"simpleContainer.tree.component", "java.awt.Component"}});
        Assertions.assertThat(configurations).isEmpty();
    }

    @Test
    public void test_getConfigurations_forTree_common() throws Exception {
        List<SimpleContainerConfiguration> configurations = this.getConfigurations(false, new String[][]{{"simpleContainer", "true"}, {"simpleContainer.association", "%parent%.add(%child%)"}, {"simpleContainer.component", "java.awt.Component"}});
        Assertions.assertThat(configurations).hasSize(1);
    }

    @Test
    public void test_getConfigurations_forTree_explicit() throws Exception {
        List<SimpleContainerConfiguration> configurations = this.getConfigurations(false, new String[][]{{"simpleContainer.tree", "true"}, {"simpleContainer.tree.association", "%parent%.add(%child%)"}, {"simpleContainer.tree.component", "java.awt.Component"}});
        Assertions.assertThat(configurations).hasSize(1);
    }

    @Test
    public void test_getConfigurations_3_count() throws Exception {
        List<SimpleContainerConfiguration> configurations = this.getConfigurations(true, new String[][]{{"simpleContainer", "true"}, {"simpleContainer.association", "%parent%.add(%child%)"}, {"simpleContainer.component", "java.awt.Component"}, {"simpleContainer.1", "true"}, {"simpleContainer.1.association", "%parent%.add(%child%)"}, {"simpleContainer.1.component", "javax.swing.JButton"}, {"simpleContainer.5", "true"}, {"simpleContainer.5.association", "%parent%.add(%child%)"}, {"simpleContainer.5.component", "javax.swing.JTextField"}});
        Assertions.assertThat(configurations).hasSize(3);
        SimpleContainerModelTest.assertConfiguration(configurations.get(0), "%parent%.add(%child%)", "java.awt.Component");
        SimpleContainerModelTest.assertConfiguration(configurations.get(1), "%parent%.add(%child%)", "javax.swing.JButton");
        SimpleContainerModelTest.assertConfiguration(configurations.get(2), "%parent%.add(%child%)", "javax.swing.JTextField");
    }

    @Test
    public void test_getConfigurations_ignoreFalse() throws Exception {
        List<SimpleContainerConfiguration> configurations = this.getConfigurations(true, new String[][]{{"simpleContainer", "false"}, {"simpleContainer.association", "%parent%.add(%child%)"}, {"simpleContainer.component", "java.awt.Component"}});
        Assertions.assertThat(configurations).hasSize(0);
    }

    @Test
    public void test_getConfigurations_defaultValidators() throws Exception {
        List<SimpleContainerConfiguration> configurations = this.getConfigurations(true, new String[][]{{"simpleContainer.defaultComponent", "java.awt.Component"}, {"simpleContainer", "true"}, {"simpleContainer.association", "%parent%.add(%child%)"}});
        Assertions.assertThat(configurations).hasSize(1);
        SimpleContainerModelTest.assertConfiguration(configurations.get(0), "%parent%.add(%child%)", "java.awt.Component");
    }

    @Test
    public void test_getConfigurations_validateContainer_isContainerType() throws Exception {
        List<SimpleContainerConfiguration> configurations = this.getConfigurations(true, new String[][]{{"simpleContainer.canvas", "isContainerType('java.awt.Component')"}, {"simpleContainer.canvas.association", "%parent%.add(%child%)"}, {"simpleContainer.canvas.component", "java.awt.Component"}});
        Assertions.assertThat(configurations).hasSize(1);
        SimpleContainerModelTest.assertConfiguration(configurations.get(0), "%parent%.add(%child%)", "java.awt.Component");
    }

    @Test
    public void test_getConfigurations_validateContainer_scriptToFalse() throws Exception {
        List<SimpleContainerConfiguration> configurations = this.getConfigurations(true, new String[][]{{"simpleContainer.canvas", "1 == 2"}, {"simpleContainer.canvas.association", "%parent%.add(%child%)"}, {"simpleContainer.canvas.component", "java.awt.Component"}});
        Assertions.assertThat(configurations).isEmpty();
    }

    @Test
    public void test_getConfigurations_noComponentValidator() throws Exception {
        try {
            this.getConfigurations(true, new String[][]{{"simpleContainer", "true"}, {"simpleContainer.association", "%parent%.add(%child%)"}});
            SimpleContainerModelTest.fail();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Test
    public void test_getConfigurations_explicitComponentTypes() throws Exception {
        List<SimpleContainerConfiguration> configurations = this.getConfigurations(true, new String[][]{{"simpleContainer", "true"}, {"simpleContainer.association", "%parent%.add(%child%)"}, {"simpleContainer.component", "javax.swing.JButton javax.swing.JTextField"}});
        Assertions.assertThat(configurations).hasSize(1);
        SimpleContainerModelTest.assertConfiguration(configurations.get(0), "%parent%.add(%child%)", "javax.swing.JButton javax.swing.JTextField");
    }

    @Test
    public void test_getConfigurations_defaultComponent() throws Exception {
        List<SimpleContainerConfiguration> configurations = this.getConfigurations(true, new String[][]{{"simpleContainer.defaultComponent", "java.awt.Component"}, {"simpleContainer", "true"}, {"simpleContainer.association", "%parent%.add(%child%)"}});
        Assertions.assertThat(configurations).hasSize(1);
        SimpleContainerModelTest.assertConfiguration(configurations.get(0), "%parent%.add(%child%)", "java.awt.Component");
    }

    @Test
    public void test_getConfigurations_componentValidatorExpression() throws Exception {
        List<SimpleContainerConfiguration> configurations = this.getConfigurations(true, new String[][]{{"simpleContainer", "true"}, {"simpleContainer.association", "%parent%.add(%child%)"}, {"simpleContainer.component-validator", "isComponentType(java.awt.Component)"}});
        Assertions.assertThat(configurations).hasSize(1);
        SimpleContainerModelTest.assertConfiguration(configurations.get(0), "%parent%.add(%child%)", "isComponentType(java.awt.Component)");
    }

    @Test
    public void test_getConfigurations_commandValidatorExpression() throws Exception {
        List<SimpleContainerConfiguration> configurations = this.getConfigurations(true, new String[][]{{"simpleContainer", "true"}, {"simpleContainer.association", "%parent%.add(%child%)"}, {"simpleContainer.component-validator", "isComponentType(java.awt.Component)"}, {"simpleContainer.command-validator", "isGoodCommand()"}});
        Assertions.assertThat(configurations).hasSize(1);
        SimpleContainerModelTest.assertConfiguration(configurations.get(0), "%parent%.add(%child%)", "isComponentType(java.awt.Component)");
    }

    private static void assertConfiguration(SimpleContainerConfiguration configuration, String association, String expectedComponentValidator) {
        SimpleContainerModelTest.assertEquals((Object)association, (Object)SimpleContainerModelTest.getAssociationObjectString(configuration));
        if (expectedComponentValidator != null) {
            SimpleContainerModelTest.assertEquals((Object)expectedComponentValidator, (Object)SimpleContainerModelTest.getValidatorString(configuration.getComponentValidator()));
        }
    }

    private static String getAssociationObjectString(SimpleContainerConfiguration configuration) {
        return configuration.getAssociationObjectFactory().toString();
    }

    private static String getValidatorString(Object validator) {
        return validator.toString();
    }

    private List<SimpleContainerConfiguration> getConfigurations(boolean forCanvas, String[][] parameters) throws Exception {
        String[] parameterLines = new String[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            String[] parameterPair = parameters[i];
            SimpleContainerModelTest.assertEquals((int)2, (int)parameterPair.length);
            parameterLines[i] = MessageFormat.format("    <parameter name=''{0}''>{1}</parameter>", parameterPair[0], parameterPair[1]);
            ++i;
        }
        SimpleContainerModelTest.setFileContentSrc("test/SimplePanel.java", this.getTestSource("public class SimplePanel extends Container {", "  public SimplePanel() {", "  }", "}"));
        SimpleContainerModelTest.setFileContentSrc("test/SimplePanel.wbp-component.xml", SimpleContainerModelTest.getSource3(new String[]{"<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='add'>", "      <parameter type='java.awt.Component' child='true'/>", "    </method>", "  </methods>", "  <parameters>"}, parameterLines, new String[]{"  </parameters>", "</component>"}));
        SimpleContainerModelTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends SimplePanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        return new SimpleContainerFactory((JavaInfo)panel, forCanvas).getConfigurations();
    }

    @Test
    public void test_duckTyping() throws Exception {
        JavaInfo component = (JavaInfo)Mockito.mock(JavaInfo.class);
        MySimpleContainer container = (MySimpleContainer)((Object)Mockito.mock(MySimpleContainer.class));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{component, container});
        ContainerObjectValidator validator = ContainerObjectValidators.alwaysTrue();
        SimpleContainerConfiguration configuration = new SimpleContainerConfiguration(validator, null);
        SimpleContainerConfigurable simpleContainer = new SimpleContainerConfigurable((JavaInfo)container, configuration);
        Mockito.when(container.getSimpleContainerChildren()).thenReturn(Collections.emptyList());
        SimpleContainerModelTest.assertTrue((boolean)simpleContainer.isEmpty());
        ((MySimpleContainer)((Object)inOrder.verify((Object)container))).getSimpleContainerChildren();
        inOrder.verifyNoMoreInteractions();
        Mockito.clearInvocations((Object[])new MySimpleContainer[]{container});
        TestObjectInfo existingChild = new TestObjectInfo();
        Mockito.when(container.getSimpleContainerChildren()).thenReturn(List.of(existingChild));
        SimpleContainerModelTest.assertFalse((boolean)simpleContainer.isEmpty());
        ((MySimpleContainer)((Object)inOrder.verify((Object)container))).getSimpleContainerChildren();
        inOrder.verifyNoMoreInteractions();
        Mockito.clearInvocations((Object[])new MySimpleContainer[]{container});
        Mockito.when(container.getSimpleContainerChildren()).thenReturn(Collections.emptyList());
        SimpleContainerModelTest.assertSame(null, (Object)simpleContainer.getChild());
        ((MySimpleContainer)((Object)inOrder.verify((Object)container))).getSimpleContainerChildren();
        inOrder.verifyNoMoreInteractions();
        Mockito.clearInvocations((Object[])new MySimpleContainer[]{container});
        existingChild = new TestObjectInfo();
        Mockito.when(container.getSimpleContainerChildren()).thenReturn(List.of(existingChild));
        SimpleContainerModelTest.assertSame((Object)((Object)existingChild), (Object)simpleContainer.getChild());
        ((MySimpleContainer)((Object)inOrder.verify((Object)container))).getSimpleContainerChildren();
        inOrder.verifyNoMoreInteractions();
        Mockito.clearInvocations((Object[])new MySimpleContainer[]{container});
        simpleContainer.command_CREATE((Object)component);
        ((MySimpleContainer)((Object)inOrder.verify((Object)container))).command_CREATE(component);
        inOrder.verifyNoMoreInteractions();
        Mockito.clearInvocations((Object[])new MySimpleContainer[]{container});
        simpleContainer.command_ADD((Object)component);
        ((MySimpleContainer)((Object)inOrder.verify((Object)container))).command_ADD(component);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void test_validateMethods() throws Exception {
        JavaInfo container = (JavaInfo)Mockito.mock(JavaInfo.class);
        JavaInfo component = (JavaInfo)Mockito.mock(JavaInfo.class);
        SimpleContainerConfiguration configuration = (SimpleContainerConfiguration)Mockito.mock(SimpleContainerConfiguration.class);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{component, container, configuration});
        SimpleContainerConfigurable simpleContainer = new SimpleContainerConfigurable(container, configuration);
        Mockito.when((Object)configuration.getComponentValidator()).thenReturn((Object)ContainerObjectValidators.alwaysTrue());
        SimpleContainerModelTest.assertTrue((boolean)simpleContainer.validateComponent((Object)component));
        ((SimpleContainerConfiguration)inOrder.verify((Object)configuration)).getComponentValidator();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void test_CREATE() throws Exception {
        SimpleContainerModelTest.prepareSimplePanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends SimplePanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        SimpleContainer simpleContainer = (SimpleContainer)new SimpleContainerFactory((JavaInfo)panel, true).get().get(0);
        SimpleContainerModelTest.assertTrue((boolean)simpleContainer.isEmpty());
        ComponentInfo newButton = SimpleContainerModelTest.createJButton();
        SimpleContainerModelTest.assertTrue((boolean)simpleContainer.validateComponent((Object)newButton));
        simpleContainer.command_CREATE((Object)newButton);
        this.assertEditor("// filler filler filler", "public class Test extends SimplePanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      setContent(button);", "    }", "  }", "}");
        SimpleContainerModelTest.assertFalse((boolean)simpleContainer.isEmpty());
    }

    @Test
    public void test_CREATE_twoTimes() throws Exception {
        SimpleContainerModelTest.prepareSimplePanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends SimplePanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        SimpleContainer simpleContainer = (SimpleContainer)new SimpleContainerFactory((JavaInfo)panel, true).get().get(0);
        SimpleContainerModelTest.assertTrue((boolean)simpleContainer.isEmpty());
        ComponentInfo newButton = SimpleContainerModelTest.createJButton();
        simpleContainer.command_CREATE((Object)newButton);
        newButton.delete();
        newButton = SimpleContainerModelTest.createJButton();
        simpleContainer.command_CREATE((Object)newButton);
        this.assertEditor("// filler filler filler", "public class Test extends SimplePanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      setContent(button);", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE() throws Exception {
        SimpleContainerModelTest.prepareSimplePanel();
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    {", "      SimplePanel SimplePanel = new SimplePanel();", "      add(SimplePanel);", "    }", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        ContainerInfo simplePanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(1);
        AssociationObjectFactory associationObjectFactory = AssociationObjectFactories.invocationChild((String)"%parent%.add(%child%)", (boolean)false);
        ContainerObjectValidator validator = ContainerObjectValidators.alwaysTrue();
        SimpleContainerConfiguration configuration = new SimpleContainerConfiguration(validator, associationObjectFactory);
        SimpleContainerConfigurable simpleContainer = new SimpleContainerConfigurable((JavaInfo)simplePanel, configuration);
        simpleContainer.command_ADD((Object)button);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    {", "      SimplePanel SimplePanel = new SimplePanel();", "      add(SimplePanel);", "      {", "        JButton button = new JButton();", "        SimplePanel.add(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_clipboard() throws Exception {
        SimpleContainerModelTest.prepareSimplePanel();
        ContainerInfo rootPanel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    {", "      SimplePanel panel = new SimplePanel();", "      add(panel);", "      {", "        JButton button = new JButton();", "        panel.setContent(button);", "      }", "    }", "  }", "}");
        rootPanel.refresh();
        ContainerInfo panel = (ContainerInfo)rootPanel.getChildrenComponents().get(0);
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)panel);
        ContainerInfo newPanel = (ContainerInfo)memento.create((JavaInfo)rootPanel);
        ((FlowLayoutInfo)rootPanel.getLayout()).add((ComponentInfo)newPanel, null);
        memento.apply();
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    {", "      SimplePanel panel = new SimplePanel();", "      add(panel);", "      {", "        JButton button = new JButton();", "        panel.setContent(button);", "      }", "    }", "    {", "      SimplePanel panel = new SimplePanel();", "      add(panel);", "      {", "        JButton button = new JButton();", "        panel.setContent(button);", "      }", "    }", "  }", "}");
    }

    static void prepareSimplePanel() throws Exception {
        SimpleContainerModelTest.prepareSimplePanel_classes();
        AbstractJavaProjectTest.setFileContentSrc("test/SimplePanel.wbp-component.xml", SimpleContainerModelTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='setContent'>", "      <parameter type='java.awt.Component' child='true'/>", "    </method>", "  </methods>", "  <parameters>", "    <parameter name='simpleContainer'>true</parameter>", "    <parameter name='simpleContainer.association'>%parent%.setContent(%child%)</parameter>", "    <parameter name='simpleContainer.component'>java.awt.Component</parameter>", "  </parameters>", "</component>"));
        SimpleContainerModelTest.waitForAutoBuild();
    }

    static void prepareSimplePanel_classes() throws Exception {
        SimpleContainerModelTest.setFileContentSrc("test/MyLayout.java", SimpleContainerModelTest.getSourceDQ("package test;", "import java.awt.*;", "public class MyLayout implements LayoutManager {", "  public void addLayoutComponent(String name, Component comp) {", "  }", "  public  void removeLayoutComponent(Component comp) {", "  }", "  public Dimension preferredLayoutSize(Container parent) {", "    return new Dimension(200, 100);", "  }", "  public Dimension minimumLayoutSize(Container parent) {", "    return new Dimension(200, 100);", "  }", "  public void layoutContainer(Container parent) {", "    int nmembers = parent.getComponentCount();", "    for (int i = 0 ; i < nmembers ; i++) {", "      Component m = parent.getComponent(i);", "      m.setBounds(10, 10, parent.getWidth() - 20, parent.getHeight() - 20);", "    }", "  }", "}"));
        SimpleContainerModelTest.setFileContentSrc("test/SimplePanel.java", SimpleContainerModelTest.getSourceDQ("package test;", "import java.awt.*;", "public class SimplePanel extends Container {", "  public SimplePanel() {", "    setLayout(new MyLayout());", "  }", "  public void setContent(Component component) {", "    add(component);", "  }", "}"));
    }

    public static class MySimpleContainer
    extends JavaInfo {
        public MySimpleContainer(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
            super(editor, description, creationSupport);
        }

        public List<ObjectInfo> getSimpleContainerChildren() {
            return Collections.emptyList();
        }

        public void command_CREATE(Object component) {
        }

        public void command_ADD(Object component) {
        }
    }
}

