/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.association;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.wb.core.model.association.CompoundAssociation;
import org.eclipse.wb.core.model.association.ConstructorParentAssociation;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class ConstructorParentAssociationTest
extends SwingModelTest {
    @Test
    public void test_parse() throws Exception {
        this.configureProject();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    new MyButton(this);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ConstructorParentAssociation association = (ConstructorParentAssociation)button.getAssociation();
        ConstructorParentAssociationTest.assertSame((Object)button, (Object)association.getJavaInfo());
        ConstructorParentAssociationTest.assertEquals((Object)"new MyButton(this)", (Object)association.getSource());
        ConstructorParentAssociationTest.assertEquals((Object)"new MyButton(this)", (Object)this.m_lastEditor.getSource((ASTNode)association.getCreation()));
        ConstructorParentAssociationTest.assertEquals((Object)"new MyButton(this);", (Object)this.m_lastEditor.getSource((ASTNode)association.getStatement()));
    }

    @Test
    public void test_delete() throws Exception {
        this.configureProject();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    new MyButton(this);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ConstructorParentAssociationTest.assertTrue((boolean)button.canDelete());
        button.delete();
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_morph() throws Exception {
        this.configureProject();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    new MyButton(this);", "  }", "}");
        ComponentInfo oldButton = (ComponentInfo)panel.getChildrenComponents().get(0);
        ConstructorParentAssociation oldAssociation = (ConstructorParentAssociation)oldButton.getAssociation();
        ConstructorParentAssociationTest.assertInstanceOf(ConstructorParentAssociation.class, (Object)oldAssociation.getCopy());
    }

    @Test
    public void test_add() throws Exception {
        this.configureProject();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("test.MyButton"), (CreationSupport)new ConstructorCreationSupport());
        flowLayout.add(button, null);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton myButton = new MyButton(this);", "    }", "  }", "}");
        ConstructorParentAssociation association = (ConstructorParentAssociation)button.getAssociation();
        ConstructorParentAssociationTest.assertSame((Object)button, (Object)association.getJavaInfo());
        ConstructorParentAssociationTest.assertEquals((Object)"new MyButton(this)", (Object)association.getSource());
    }

    @Test
    public void test_moveInner() throws Exception {
        this.configureProject();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton button = new MyButton(this);", "    }", "    {", "      JPanel container = new JPanel();", "      add(container);", "    }", "  }", "}");
        FlowLayoutInfo panelLayout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        panelLayout.move(button, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel container = new JPanel();", "      add(container);", "    }", "    {", "      MyButton button = new MyButton(this);", "    }", "  }", "}");
        ConstructorParentAssociation association = (ConstructorParentAssociation)button.getAssociation();
        ConstructorParentAssociationTest.assertSame((Object)button, (Object)association.getJavaInfo());
        ConstructorParentAssociationTest.assertEquals((Object)"new MyButton(this)", (Object)association.getSource());
    }

    @Test
    public void test_moveReparent() throws Exception {
        this.configureProject();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton button = new MyButton(this);", "    }", "    {", "      JPanel container = new JPanel();", "      add(container);", "    }", "  }", "}");
        ContainerInfo container = (ContainerInfo)panel.getChildrenComponents().get(1);
        FlowLayoutInfo containerLayout = (FlowLayoutInfo)container.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        containerLayout.move(button, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel container = new JPanel();", "      add(container);", "      {", "        MyButton button = new MyButton(container);", "        container.add(button);", "      }", "    }", "  }", "}");
        CompoundAssociation compoundAssociation = (CompoundAssociation)button.getAssociation();
        ConstructorParentAssociation association = (ConstructorParentAssociation)compoundAssociation.getAssociations().get(0);
        ConstructorParentAssociationTest.assertSame((Object)button, (Object)association.getJavaInfo());
        ConstructorParentAssociationTest.assertEquals((Object)"new MyButton(container)", (Object)association.getSource());
    }

    @Test
    public void test_moveReparent_differentConstructor() throws Exception {
        ConstructorParentAssociationTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton(JButton button) {", "  }", "  public MyButton(JPanel panel) {", "  }", "}"));
        ConstructorParentAssociationTest.setFileContentSrc("test/MyButton.wbp-component.xml", ConstructorParentAssociationTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <!-- CREATION -->", "  <creation>", "    <source><![CDATA[new test.MyButton(%parent%)]]></source>", "  </creation>", "  <!-- CONSTRUCTORS -->", "  <constructors>", "    <constructor>", "      <parameter type='javax.swing.JButton' parent='true'/>", "    </constructor>", "    <constructor>", "      <parameter type='javax.swing.JPanel' parent='true'/>", "    </constructor>", "  </constructors>", "</component>"));
        ConstructorParentAssociationTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "      {", "        MyButton myButton = new MyButton(button);", "      }", "    }", "    {", "      JPanel innerPanel = new JPanel();", "      add(innerPanel);", "    }", "  }", "}");
        ContainerInfo button = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo myButton = (ComponentInfo)button.getChildrenComponents().get(0);
        ContainerInfo innerPanel = (ContainerInfo)panel.getChildrenComponents().get(1);
        ConstructorParentAssociation association = (ConstructorParentAssociation)myButton.getAssociation();
        ConstructorParentAssociationTest.assertEquals((Object)"<init>(javax.swing.JButton)", (Object)AstNodeUtils.getCreationSignature((ClassInstanceCreation)association.getCreation()));
        FlowLayoutInfo containerLayout = (FlowLayoutInfo)innerPanel.getLayout();
        containerLayout.move(myButton, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "    {", "      JPanel innerPanel = new JPanel();", "      add(innerPanel);", "      {", "        MyButton myButton = new MyButton(innerPanel);", "        innerPanel.add(myButton);", "      }", "    }", "  }", "}");
        CompoundAssociation compoundAssociation = (CompoundAssociation)myButton.getAssociation();
        ConstructorParentAssociation association2 = (ConstructorParentAssociation)compoundAssociation.getAssociations().get(0);
        ConstructorParentAssociationTest.assertSame((Object)myButton, (Object)association2.getJavaInfo());
        ConstructorParentAssociationTest.assertEquals((Object)"new MyButton(innerPanel)", (Object)association2.getSource());
        ConstructorParentAssociationTest.assertEquals((Object)"<init>(javax.swing.JPanel)", (Object)AstNodeUtils.getCreationSignature((ClassInstanceCreation)association2.getCreation()));
    }

    private void configureProject() throws Exception {
        ConstructorParentAssociationTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton(Container container) {", "    container.add(this);", "  }", "}"));
        ConstructorParentAssociationTest.setFileContentSrc("test/MyButton.wbp-component.xml", ConstructorParentAssociationTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <!-- CREATION -->", "  <creation>", "    <source><![CDATA[new test.MyButton(%parent%)]]></source>", "  </creation>", "  <!-- CONSTRUCTORS -->", "  <constructors>", "    <constructor>", "      <parameter type='java.awt.Container' parent='true'/>", "    </constructor>", "  </constructors>", "</component>"));
        ConstructorParentAssociationTest.waitForAutoBuild();
    }
}

