/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid;

import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class GridDropTargetEffect
extends DropTargetEffect {
    static final int SCROLL_HYSTERESIS = 200;
    static final int EXPAND_HYSTERESIS = 1000;
    private Grid grid;
    private boolean ignoreCellSelection = false;
    private GridItem scrollItem;
    private long scrollBeginTime;
    private GridItem expandItem;
    private long expandBeginTime;
    private Point insertCell;
    private boolean insertBefore;
    private Point selectedCell;

    public GridDropTargetEffect(Grid grid) {
        super((Control)grid);
        this.grid = grid;
    }

    public void setIgnoreCellSelection(boolean ignore) {
        this.ignoreCellSelection = ignore;
    }

    public boolean getIgnoreCellSelection() {
        return this.ignoreCellSelection;
    }

    int checkEffect(int effect) {
        if ((effect & 1) != 0) {
            effect = effect & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((effect & 2) != 0) {
            effect &= 0xFFFFFFFB;
        }
        return effect;
    }

    public Widget getItem(int x, int y) {
        Point coordinates = new Point(x, y);
        coordinates = this.grid.toControl(coordinates);
        return this.grid.getItem(coordinates);
    }

    public void dragEnter(DropTargetEvent event) {
        this.expandBeginTime = 0L;
        this.expandItem = null;
        this.scrollBeginTime = 0L;
        this.scrollItem = null;
        this.insertCell = null;
        this.selectedCell = null;
    }

    public void dragLeave(DropTargetEvent event) {
        if (this.selectedCell != null) {
            this.deselect(this.selectedCell);
            this.selectedCell = null;
        }
        if (this.insertCell != null) {
            this.setInsertMark(null, false);
            this.insertCell = null;
        }
        this.expandBeginTime = 0L;
        this.expandItem = null;
        this.scrollBeginTime = 0L;
        this.scrollItem = null;
    }

    public void dragOver(DropTargetEvent event) {
        int effect = this.checkEffect(event.feedback);
        Point coordinates = new Point(event.x, event.y);
        coordinates = this.grid.toControl(coordinates);
        GridItem hoverItem = this.grid.getItem(coordinates);
        GridColumn hoverColumn = this.grid.getColumn(coordinates);
        Point hoverCell = this.grid.getCell(coordinates);
        if (hoverItem == null || hoverColumn == null || hoverCell == null) {
            hoverItem = null;
            hoverColumn = null;
            hoverCell = null;
        }
        if ((effect & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollItem = null;
        } else if (hoverItem != null && this.scrollItem == hoverItem && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                boolean scroll;
                GridItem topItem = this.grid.getItem(this.grid.getTopIndex());
                GridItem nextItem = hoverItem == topItem ? this.grid.getPreviousVisibleItem(hoverItem) : this.grid.getNextVisibleItem(hoverItem);
                boolean bl = scroll = nextItem != null && this.grid.isInDragScrollArea(coordinates);
                if (scroll) {
                    this.grid.showItem(nextItem);
                }
                this.scrollBeginTime = 0L;
                this.scrollItem = null;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 200L;
            this.scrollItem = hoverItem;
        }
        if ((effect & 0x10) == 0) {
            this.expandBeginTime = 0L;
            this.expandItem = null;
        } else if (hoverItem != null && this.expandItem == hoverItem && this.expandBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.expandBeginTime) {
                if (hoverColumn.isTree() && !hoverItem.isExpanded()) {
                    hoverItem.setExpanded(true);
                    if (hoverItem.hasChildren()) {
                        hoverItem.fireEvent(17);
                    }
                }
                this.expandBeginTime = 0L;
                this.expandItem = null;
            }
        } else {
            this.expandBeginTime = System.currentTimeMillis() + 1000L;
            this.expandItem = hoverItem;
        }
        if ((effect & 1) != 0 && hoverCell != null && !hoverCell.equals((Object)this.selectedCell)) {
            if (this.selectedCell != null) {
                this.deselect(this.selectedCell);
            }
            this.select(hoverCell);
            this.selectedCell = new Point(hoverCell.x, hoverCell.y);
        }
        if ((effect & 1) == 0 && this.selectedCell != null) {
            this.deselect(this.selectedCell);
            this.selectedCell = null;
        }
        if ((effect & 2) != 0 || (effect & 4) != 0) {
            boolean before;
            boolean bl = before = (effect & 2) != 0;
            if (hoverCell != null) {
                if (!hoverCell.equals((Object)this.insertCell) || before != this.insertBefore) {
                    this.setInsertMark(hoverCell, before);
                }
                this.insertCell = new Point(hoverCell.x, hoverCell.y);
                this.insertBefore = before;
            } else {
                if (this.insertCell != null) {
                    this.setInsertMark(null, false);
                }
                this.insertCell = null;
            }
        } else {
            if (this.insertCell != null) {
                this.setInsertMark(null, false);
            }
            this.insertCell = null;
        }
    }

    private void select(Point cell) {
        if (this.grid.getCellSelectionEnabled() && !this.ignoreCellSelection) {
            this.grid.selectCell(cell);
        } else {
            this.grid.select(cell.y);
        }
    }

    private void deselect(Point cell) {
        if (this.grid.getCellSelectionEnabled() && !this.ignoreCellSelection) {
            this.grid.deselectCell(cell);
        } else {
            this.grid.deselect(cell.y);
        }
    }

    private void setInsertMark(Point cell, boolean before) {
        if (cell != null) {
            if (this.grid.getCellSelectionEnabled() && !this.ignoreCellSelection) {
                this.grid.setInsertMark(this.grid.getItem(cell.y), this.grid.getColumn(cell.x), before);
            } else {
                this.grid.setInsertMark(this.grid.getItem(cell.y), null, before);
            }
        } else {
            this.grid.setInsertMark(null, null, false);
        }
    }
}

