/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.nls.commands;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.wb.internal.core.nls.commands.AbstractCommand;
import org.eclipse.wb.internal.core.nls.commands.SetValuesCommand;
import org.eclipse.wb.internal.core.nls.edit.IEditableSource;

public final class RenameKeyCommand
extends AbstractCommand {
    private final String m_oldKey;
    private final String m_newKey;
    private Map<String, String> m_oldToNewMap;
    private Map<String, String> m_newToOldMap;

    public RenameKeyCommand(IEditableSource editableSource, String oldKey, String newKey) {
        super(editableSource);
        this.m_oldKey = oldKey;
        this.m_newKey = newKey;
    }

    public Map<String, String> getOldToNewMap() {
        if (this.m_oldToNewMap == null) {
            this.m_oldToNewMap = new HashMap<String, String>();
            this.m_oldToNewMap.put(this.m_oldKey, this.m_newKey);
        }
        return this.m_oldToNewMap;
    }

    private Map<String, String> getNewToOldMap() {
        if (this.m_newToOldMap == null) {
            this.m_newToOldMap = new HashMap<String, String>();
            this.m_newToOldMap.put(this.m_newKey, this.m_oldKey);
        }
        return this.m_newToOldMap;
    }

    private void merge(RenameKeyCommand oldCommand) {
        this.m_oldToNewMap = oldCommand.getOldToNewMap();
        this.m_newToOldMap = oldCommand.getNewToOldMap();
        String oriKey = this.m_newToOldMap.remove(this.m_oldKey);
        if (oriKey == null) {
            oriKey = this.m_oldKey;
        }
        this.m_oldToNewMap.put(oriKey, this.m_newKey);
        this.m_newToOldMap.put(this.m_newKey, oriKey);
    }

    @Override
    public void addToCommandList(List<AbstractCommand> commands) {
        int index = commands.size() - 1;
        while (index >= 0) {
            AbstractCommand oldCommand = commands.get(index);
            if (!(oldCommand instanceof SetValuesCommand)) {
                if (!(oldCommand instanceof RenameKeyCommand)) break;
                RenameKeyCommand oldRenameKeyCommand = (RenameKeyCommand)oldCommand;
                if (oldRenameKeyCommand.getEditableSource() == this.getEditableSource()) {
                    this.merge(oldRenameKeyCommand);
                    commands.remove(index);
                }
            }
            --index;
        }
        super.addToCommandList(commands);
    }
}

