/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.vue.autoinsert;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.eclipse.core.runtime.ILog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wildwebdeveloper.vue.VueLanguageServerAPI;
import org.eclipse.wildwebdeveloper.vue.autoinsert.AutoInsertLastChange;
import org.eclipse.wildwebdeveloper.vue.autoinsert.AutoInsertParams;
import org.eclipse.wildwebdeveloper.vue.autoinsert.AutoInsertResponse;

public class VueAutoInsertReconciler
implements IReconciler {
    private IDocument document;
    private ITextViewer viewer;
    private Listener listener;

    private void autoInsert(DocumentEvent event) {
        if (event == null || this.viewer == null) {
            return;
        }
        IDocument document = event.getDocument();
        if (document == null || event == null || event.getLength() != 0) {
            return;
        }
        int offset = event.getOffset();
        URI uri = LSPEclipseUtils.toUri((IDocument)document);
        if (uri == null) {
            return;
        }
        TextDocumentIdentifier identifier = new TextDocumentIdentifier(uri.toString());
        LanguageServers.forDocument((IDocument)document).collectAll((w, ls) -> CompletableFuture.completedFuture(ls)).thenAccept(lss -> lss.stream().filter(VueLanguageServerAPI.class::isInstance).map(VueLanguageServerAPI.class::cast).findAny().ifPresent(info -> {
            Display display = this.viewer.getTextWidget().getDisplay();
            CompletableFuture.supplyAsync(() -> {
                try {
                    AutoInsertParams params = new AutoInsertParams();
                    params.setTextDocument(identifier);
                    params.setSelection(LSPEclipseUtils.toPosition((int)(offset + event.getText().length()), (IDocument)document));
                    AutoInsertLastChange changeEvent = new AutoInsertLastChange();
                    Range range = new Range(LSPEclipseUtils.toPosition((int)offset, (IDocument)document), LSPEclipseUtils.toPosition((int)(offset + documentEvent.fLength), (IDocument)document));
                    changeEvent.setRange(range);
                    changeEvent.setText(event.getText());
                    changeEvent.setRangeLength(documentEvent.fLength);
                    changeEvent.setRangeOffset(offset);
                    params.setChange(changeEvent);
                    info.autoInsert(params).thenAccept(response -> {
                        if (response != null) {
                            display.asyncExec(() -> {
                                try {
                                    String newText = (String)response.map(Function.identity(), AutoInsertResponse::getNewText);
                                    String text = newText.replace("$0", "").replace("$1", "");
                                    int index = newText.indexOf("$0");
                                    int replaceLength = 0;
                                    int replacePosition = offset + event.getText().length();
                                    if (response.isRight()) {
                                        replacePosition = LSPEclipseUtils.toOffset((Position)((AutoInsertResponse)response.getRight()).getRange().getStart(), (IDocument)document);
                                    }
                                    document.replace(replacePosition, replaceLength, text);
                                    if (index != -1) {
                                        this.viewer.setSelectedRange(replacePosition + index, 0);
                                    }
                                }
                                catch (BadLocationException e) {
                                    ILog.get().error(e.getMessage(), (Throwable)e);
                                }
                            });
                        }
                    });
                }
                catch (BadLocationException e) {
                    ILog.get().error(e.getMessage(), (Throwable)e);
                }
                return null;
            });
        }));
    }

    public void install(ITextViewer viewer) {
        this.viewer = viewer;
        this.listener = new Listener();
        viewer.addTextInputListener((ITextInputListener)this.listener);
    }

    public void uninstall() {
        if (this.listener != null) {
            this.viewer.removeTextInputListener((ITextInputListener)this.listener);
            if (this.document != null) {
                this.document.removeDocumentListener((IDocumentListener)this.listener);
            }
            this.listener = null;
        }
        this.viewer = null;
    }

    public IReconcilingStrategy getReconcilingStrategy(String contentType) {
        return null;
    }

    class Listener
    implements IDocumentListener,
    ITextInputListener {
        Listener() {
        }

        public void documentAboutToBeChanged(DocumentEvent e) {
        }

        public void documentChanged(DocumentEvent e) {
            System.out.println(e.toString());
            VueAutoInsertReconciler.this.autoInsert(e);
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput == VueAutoInsertReconciler.this.document) {
                if (VueAutoInsertReconciler.this.document != null) {
                    VueAutoInsertReconciler.this.document.removeDocumentListener((IDocumentListener)this);
                }
                VueAutoInsertReconciler.this.document = null;
            }
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            VueAutoInsertReconciler.this.document = newInput;
            if (VueAutoInsertReconciler.this.document == null) {
                return;
            }
            VueAutoInsertReconciler.this.document.addDocumentListener((IDocumentListener)this);
        }
    }
}

