import { CodeRangeKey, LinkedCodeMap, Mapping, SourceMap } from '@volar/language-core';
import type * as vscode from 'vscode-languageserver-protocol';
import type { TextDocument } from 'vscode-languageserver-textdocument';
export declare class SourceMapWithDocuments<Data = any> {
    sourceDocument: TextDocument;
    embeddedDocument: TextDocument;
    map: SourceMap<Data>;
    constructor(sourceDocument: TextDocument, embeddedDocument: TextDocument, map: SourceMap<Data>);
    getSourceRange(range: vscode.Range, filter?: (data: Data) => boolean): vscode.Range | undefined;
    getGeneratedRange(range: vscode.Range, filter?: (data: Data) => boolean): vscode.Range | undefined;
    getSourceRanges(range: vscode.Range, filter?: (data: Data) => boolean): Generator<vscode.Range, void, unknown>;
    getGeneratedRanges(range: vscode.Range, filter?: (data: Data) => boolean): Generator<vscode.Range, void, unknown>;
    protected findRanges(range: vscode.Range, filter: (data: Data) => boolean, api: 'getSourcePositionsBase' | 'getGeneratedPositionsBase', api2: 'matchSourcePosition' | 'matchGeneratedPosition'): Generator<vscode.Range, void, unknown>;
    getSourcePosition(position: vscode.Position, filter?: (data: Data) => boolean): import("vscode-languageserver-textdocument").Position | undefined;
    getGeneratedPosition(position: vscode.Position, filter?: (data: Data) => boolean): import("vscode-languageserver-textdocument").Position | undefined;
    getSourcePositions(position: vscode.Position, filter?: (data: Data) => boolean): Generator<import("vscode-languageserver-textdocument").Position, void, unknown>;
    getGeneratedPositions(position: vscode.Position, filter?: (data: Data) => boolean): Generator<import("vscode-languageserver-textdocument").Position, void, unknown>;
    getSourcePositionsBase(position: vscode.Position, filter?: (data: Data) => boolean): Generator<readonly [import("vscode-languageserver-textdocument").Position, Mapping<Data>], void, unknown>;
    getGeneratedPositionsBase(position: vscode.Position, filter?: (data: Data) => boolean): Generator<readonly [import("vscode-languageserver-textdocument").Position, Mapping<Data>], void, unknown>;
    protected findPositions(position: vscode.Position, filter: (data: Data) => boolean, fromDoc: TextDocument, toDoc: TextDocument, from: CodeRangeKey, to: CodeRangeKey): Generator<readonly [import("vscode-languageserver-textdocument").Position, Mapping<Data>], void, unknown>;
    protected matchSourcePosition(position: vscode.Position, mapping: Mapping): import("vscode-languageserver-textdocument").Position | undefined;
    protected matchGeneratedPosition(position: vscode.Position, mapping: Mapping): import("vscode-languageserver-textdocument").Position | undefined;
}
export declare class LinkedCodeMapWithDocument extends SourceMapWithDocuments {
    document: TextDocument;
    private linkedMap;
    constructor(document: TextDocument, linkedMap: LinkedCodeMap);
    getLinkedCodePositions(posotion: vscode.Position): Generator<import("vscode-languageserver-textdocument").Position, void, unknown>;
}
