/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.net.URL;
import java.util.Enumeration;
import java.util.ResourceBundle;
import org.eclipse.compare.ICompareFilter;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

public class CompareFilterDescriptor {
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String ID_ATTRIBUTE = "id";
    private static final String DEFINITION_ID_ATTRIBUTE = "definitionId";
    private static final String FILTER_IMAGE_ATTRIBUTE = "filter.image";
    private IConfigurationElement fConfiguration;
    private ResourceBundle fResourceBundle;
    private ImageDescriptor fImageDescriptor;

    public CompareFilterDescriptor(IConfigurationElement config) {
        String path;
        this.fConfiguration = config;
        this.fResourceBundle = new ResourceBundle(){

            @Override
            protected Object handleGetObject(String key) {
                return CompareFilterDescriptor.this.fConfiguration.getAttribute(key);
            }

            @Override
            public Enumeration<String> getKeys() {
                return new ConfigurationKeysEnumeration(CompareFilterDescriptor.this.fConfiguration);
            }
        };
        URL url = null;
        String pluginId = this.fConfiguration.getContributor().getName();
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle != null && (path = Utilities.getString(this.fResourceBundle, FILTER_IMAGE_ATTRIBUTE, FILTER_IMAGE_ATTRIBUTE)) != null) {
            url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
        }
        this.fImageDescriptor = url == null ? null : ImageDescriptor.createFromURL(url);
    }

    public ICompareFilter createCompareFilter() {
        try {
            return (ICompareFilter)this.fConfiguration.createExecutableExtension(CLASS_ATTRIBUTE);
        }
        catch (CoreException e) {
            CompareUIPlugin.log(e);
            return null;
        }
    }

    public String getFilterId() {
        return this.fConfiguration.getAttribute(ID_ATTRIBUTE);
    }

    public String getDefinitionId() {
        return this.fConfiguration.getAttribute(DEFINITION_ID_ATTRIBUTE);
    }

    public ResourceBundle getResourceBundle() {
        return this.fResourceBundle;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.fImageDescriptor;
    }

    private static class ConfigurationKeysEnumeration
    implements Enumeration<String> {
        private String[] keySet;
        private int cursor = 0;

        public ConfigurationKeysEnumeration(IConfigurationElement configuration) {
            this.keySet = configuration.getAttributeNames();
        }

        @Override
        public boolean hasMoreElements() {
            return this.cursor >= this.keySet.length;
        }

        @Override
        public String nextElement() {
            return this.keySet[this.cursor++];
        }
    }
}

