/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.ContentTypeToLSPLaunchConfigEntry;
import org.eclipse.lsp4e.ContentTypeToLanguageServerDefinition;
import org.eclipse.lsp4e.IMarkerAttributeComputer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageClientImpl;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LaunchConfigurationStreamProvider;
import org.eclipse.lsp4e.enablement.EnablementTester;
import org.eclipse.lsp4e.operations.diagnostics.LSPDiagnosticsToMarkers;
import org.eclipse.lsp4e.server.StreamConnectionProvider;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.Bundle;

public class LanguageServersRegistry {
    private static final String CONTENT_TYPE_TO_LSP_LAUNCH_PREF_KEY = "contentTypeToLSPLauch";
    private static final String EXTENSION_POINT_ID = "org.eclipse.lsp4e.languageServer";
    private static final String LS_ELEMENT = "server";
    private static final String MAPPING_ELEMENT = "contentTypeMapping";
    private static final String ID_ATTRIBUTE = "id";
    private static final String SINGLETON_ATTRIBUTE = "singleton";
    private static final boolean DEFAULT_SINGLETON = false;
    private static final String LAST_DOCUMENT_DISCONNECTED_TIMEOUT = "lastDocumentDisconnectedTimeout";
    private static final int DEFAULT_LAST_DOCUMENTED_DISCONNECTED_TIEMOUT = 0;
    private static final String CONTENT_TYPE_ATTRIBUTE = "contentType";
    private static final String LANGUAGE_ID_ATTRIBUTE = "languageId";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String CLIENT_IMPL_ATTRIBUTE = "clientImpl";
    private static final String MARKER_TYPE_ELEMENT = "makerType";
    private static final String MARKER_ATTR_COMPUTER_ELEMENT = "markerAttributeComputer";
    private static final String SERVER_INTERFACE_ATTRIBUTE = "serverInterface";
    private static final String LAUNCHER_BUILDER_ATTRIBUTE = "launcherBuilder";
    private static final String LABEL_ATTRIBUTE = "label";
    private static final String ENABLED_WHEN_ATTRIBUTE = "enabledWhen";
    private static final String ENABLED_WHEN_DESC = "description";
    private final List<ContentTypeToLanguageServerDefinition> connections = new ArrayList<ContentTypeToLanguageServerDefinition>();
    private final IPreferenceStore preferenceStore = LanguageServerPlugin.getDefault().getPreferenceStore();

    public static LanguageServersRegistry getInstance() {
        return LazyHolder.INSTANCE;
    }

    private LanguageServersRegistry() {
        this.initialize();
    }

    private void initialize() {
        int n;
        String prefs = this.preferenceStore.getString(CONTENT_TYPE_TO_LSP_LAUNCH_PREF_KEY);
        if (prefs != null && !prefs.isEmpty()) {
            String[] entries;
            String[] stringArray = entries = prefs.split(",");
            n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                ContentTypeToLSPLaunchConfigEntry mapping = ContentTypeToLSPLaunchConfigEntry.readFromPreference(entry);
                if (mapping != null) {
                    this.connections.add(mapping);
                }
                ++n2;
            }
        }
        HashMap<String, ExtensionLanguageServerDefinition> servers = new HashMap<String, ExtensionLanguageServerDefinition>();
        ArrayList<ContentTypeMapping> contentTypes = new ArrayList<ContentTypeMapping>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n3 = iConfigurationElementArray.length;
        n = 0;
        while (n < n3) {
            IConfigurationElement extension = iConfigurationElementArray[n];
            String id = extension.getAttribute(ID_ATTRIBUTE);
            if (id != null && !id.isEmpty()) {
                if (extension.getName().equals(LS_ELEMENT)) {
                    servers.put(id, new ExtensionLanguageServerDefinition(extension));
                } else if (extension.getName().equals(MAPPING_ELEMENT)) {
                    IConfigurationElement enabledWhen;
                    IConfigurationElement[] enabledWhenChildren;
                    IConfigurationElement[] enabledWhenElements;
                    IContentType contentType = Platform.getContentTypeManager().getContentType(extension.getAttribute(CONTENT_TYPE_ATTRIBUTE));
                    String languageId = extension.getAttribute(LANGUAGE_ID_ATTRIBUTE);
                    EnablementTester expression = null;
                    if (extension.getChildren(ENABLED_WHEN_ATTRIBUTE) != null && (enabledWhenElements = extension.getChildren(ENABLED_WHEN_ATTRIBUTE)).length == 1 && (enabledWhenChildren = (enabledWhen = enabledWhenElements[0]).getChildren()).length == 1) {
                        try {
                            String description = enabledWhen.getAttribute(ENABLED_WHEN_DESC);
                            expression = new EnablementTester(this::evaluationContext, ExpressionConverter.getDefault().perform(enabledWhenChildren[0]), description);
                        }
                        catch (CoreException e) {
                            LanguageServerPlugin.logWarning(e.getMessage(), e);
                        }
                    }
                    if (contentType != null) {
                        contentTypes.add(new ContentTypeMapping(contentType, id, languageId, expression));
                    }
                }
            }
            ++n;
        }
        for (ContentTypeMapping mapping : contentTypes) {
            LanguageServerDefinition lsDefinition = (LanguageServerDefinition)servers.get(mapping.id);
            if (lsDefinition != null) {
                this.registerAssociation(mapping.contentType, lsDefinition, mapping.languageId, mapping.enablement);
                continue;
            }
            LanguageServerPlugin.logWarning("server '" + mapping.id + "' not available", null);
        }
    }

    private IEvaluationContext evaluationContext() {
        return Optional.ofNullable((IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class)).map(IHandlerService::getCurrentState).orElse(null);
    }

    private void persistContentTypeToLaunchConfigurationMapping() {
        StringBuilder builder = new StringBuilder();
        for (ContentTypeToLSPLaunchConfigEntry entry : this.getContentTypeToLSPLaunches()) {
            entry.appendPreferenceTo(builder);
            builder.append(',');
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        this.preferenceStore.setValue(CONTENT_TYPE_TO_LSP_LAUNCH_PREF_KEY, builder.toString());
        if (this.preferenceStore instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)this.preferenceStore).save();
            }
            catch (IOException e) {
                LanguageServerPlugin.logError(e);
            }
        }
    }

    List<@NonNull ContentTypeToLanguageServerDefinition> findProviderFor(@NonNull IContentType contentType) {
        return this.connections.stream().filter(entry -> ((IContentType)entry.getKey()).equals(contentType)).sorted((mapping1, mapping2) -> {
            if (((IContentType)mapping1.getKey()).isKindOf((IContentType)mapping2.getKey())) {
                return -1;
            }
            if (((IContentType)mapping2.getKey()).isKindOf((IContentType)mapping1.getKey())) {
                return 1;
            }
            return ((IContentType)mapping1.getKey()).getId().compareTo(((IContentType)mapping2.getKey()).getId());
        }).collect(Collectors.toList());
    }

    public void registerAssociation(@NonNull IContentType contentType, @NonNull ILaunchConfiguration launchConfig, @NonNull Set<String> launchMode) {
        ContentTypeToLSPLaunchConfigEntry mapping = new ContentTypeToLSPLaunchConfigEntry(contentType, launchConfig, launchMode);
        this.connections.add(mapping);
        this.persistContentTypeToLaunchConfigurationMapping();
    }

    public void registerAssociation(@NonNull IContentType contentType, @NonNull LanguageServerDefinition serverDefinition, @Nullable String languageId, EnablementTester enablement) {
        if (languageId != null) {
            serverDefinition.registerAssociation(contentType, languageId);
        }
        this.connections.add(new ContentTypeToLanguageServerDefinition(contentType, serverDefinition, enablement));
    }

    public void setAssociations(List<ContentTypeToLSPLaunchConfigEntry> wc) {
        this.connections.removeIf(ContentTypeToLSPLaunchConfigEntry.class::isInstance);
        this.connections.addAll(wc);
        this.persistContentTypeToLaunchConfigurationMapping();
    }

    public List<ContentTypeToLSPLaunchConfigEntry> getContentTypeToLSPLaunches() {
        return this.connections.stream().filter(ContentTypeToLSPLaunchConfigEntry.class::isInstance).map(ContentTypeToLSPLaunchConfigEntry.class::cast).collect(Collectors.toList());
    }

    public List<ContentTypeToLanguageServerDefinition> getContentTypeToLSPExtensions() {
        return this.connections.stream().filter(mapping -> mapping.getValue() instanceof ExtensionLanguageServerDefinition).collect(Collectors.toList());
    }

    public @Nullable LanguageServerDefinition getDefinition(@NonNull String languageServerId) {
        for (ContentTypeToLanguageServerDefinition mapping : this.connections) {
            if (!((LanguageServerDefinition)mapping.getValue()).id.equals(languageServerId)) continue;
            return (LanguageServerDefinition)mapping.getValue();
        }
        return null;
    }

    public boolean matches(@NonNull IFile file, @NonNull LanguageServerDefinition serverDefinition) {
        return this.getAvailableLSFor(LSPEclipseUtils.getFileContentTypes(file)).contains(serverDefinition);
    }

    public boolean matches(@NonNull IDocument document, @NonNull LanguageServerDefinition serverDefinition) {
        return this.getAvailableLSFor(LSPEclipseUtils.getDocumentContentTypes(document)).contains(serverDefinition);
    }

    public boolean canUseLanguageServer(@NonNull IEditorInput editorInput) {
        return !this.getAvailableLSFor(Arrays.asList(Platform.getContentTypeManager().findContentTypesFor(editorInput.getName()))).isEmpty();
    }

    public boolean canUseLanguageServer(@NonNull IDocument document) {
        List<IContentType> contentTypes = LSPEclipseUtils.getDocumentContentTypes(document);
        if (contentTypes.isEmpty()) {
            return false;
        }
        return !this.getAvailableLSFor(contentTypes).isEmpty();
    }

    public boolean canUseLanguageServer(@NonNull IFile file) {
        return !this.getAvailableLSFor(LSPEclipseUtils.getFileContentTypes(file)).isEmpty();
    }

    private Set<LanguageServerDefinition> getAvailableLSFor(Collection<IContentType> contentTypes) {
        HashSet<LanguageServerDefinition> res = new HashSet<LanguageServerDefinition>();
        contentTypes = this.expandToSuperTypes(contentTypes);
        for (ContentTypeToLanguageServerDefinition mapping : this.connections) {
            if (!mapping.isEnabled() || !contentTypes.contains(mapping.getKey())) continue;
            res.add((LanguageServerDefinition)mapping.getValue());
        }
        return res;
    }

    private Collection<IContentType> expandToSuperTypes(Collection<IContentType> contentTypes) {
        ArrayList<IContentType> res = new ArrayList<IContentType>(contentTypes);
        int i = 0;
        while (i < res.size()) {
            IContentType current = res.get(i);
            IContentType base = current.getBaseType();
            if (base != null && !res.contains(base)) {
                res.add(base);
            }
            ++i;
        }
        return res;
    }

    private static class ContentTypeMapping {
        public final @NonNull String id;
        public final @NonNull IContentType contentType;
        public final @Nullable String languageId;
        public final @Nullable EnablementTester enablement;

        public ContentTypeMapping(@NonNull IContentType contentType, @NonNull String id, @Nullable String languageId, @Nullable EnablementTester enablement) {
            this.contentType = contentType;
            this.id = id;
            this.languageId = languageId;
            this.enablement = enablement;
        }
    }

    static class ExtensionLanguageServerDefinition
    extends LanguageServerDefinition {
        private final IConfigurationElement extension;

        private Consumer<PublishDiagnosticsParams> getDiagnosticHandler() {
            String serverId = this.extension.getAttribute(LanguageServersRegistry.ID_ATTRIBUTE);
            String markerType = this.extension.getAttribute(LanguageServersRegistry.MARKER_TYPE_ELEMENT);
            IMarkerAttributeComputer markerAttributeComputerElement = null;
            try {
                String markerAttributeComputer = this.extension.getAttribute(LanguageServersRegistry.MARKER_ATTR_COMPUTER_ELEMENT);
                if (markerAttributeComputer != null && !markerAttributeComputer.isEmpty()) {
                    markerAttributeComputerElement = (IMarkerAttributeComputer)this.extension.createExecutableExtension(LanguageServersRegistry.MARKER_ATTR_COMPUTER_ELEMENT);
                }
            }
            catch (CoreException e) {
                LanguageServerPlugin.logError(e);
            }
            return new LSPDiagnosticsToMarkers(serverId, markerType, markerAttributeComputerElement);
        }

        private static boolean getIsSingleton(IConfigurationElement element) {
            return Boolean.parseBoolean(element.getAttribute(LanguageServersRegistry.SINGLETON_ATTRIBUTE));
        }

        private static int getLastDocumentDisconnectedTimeout(IConfigurationElement element) {
            String lastDocumentisconnectedTiemoutAttribute = element.getAttribute(LanguageServersRegistry.LAST_DOCUMENT_DISCONNECTED_TIMEOUT);
            return lastDocumentisconnectedTiemoutAttribute == null ? 0 : Integer.parseInt(lastDocumentisconnectedTiemoutAttribute);
        }

        public ExtensionLanguageServerDefinition(@NonNull IConfigurationElement element) {
            super(element.getAttribute(LanguageServersRegistry.ID_ATTRIBUTE), element.getAttribute(LanguageServersRegistry.LABEL_ATTRIBUTE), ExtensionLanguageServerDefinition.getIsSingleton(element), ExtensionLanguageServerDefinition.getLastDocumentDisconnectedTimeout(element));
            this.extension = element;
        }

        @Override
        public StreamConnectionProvider createConnectionProvider() {
            try {
                return (StreamConnectionProvider)this.extension.createExecutableExtension(LanguageServersRegistry.CLASS_ATTRIBUTE);
            }
            catch (CoreException e) {
                StatusManager.getManager().handle(e, "org.eclipse.lsp4e");
                throw new RuntimeException("Exception occurred while creating an instance of the stream connection provider", e);
            }
        }

        @Override
        public LanguageClientImpl createLanguageClient() {
            LanguageClientImpl languageClient = null;
            String clientImpl = this.extension.getAttribute(LanguageServersRegistry.CLIENT_IMPL_ATTRIBUTE);
            if (clientImpl != null && !clientImpl.isEmpty()) {
                try {
                    languageClient = (LanguageClientImpl)this.extension.createExecutableExtension(LanguageServersRegistry.CLIENT_IMPL_ATTRIBUTE);
                }
                catch (CoreException e) {
                    StatusManager.getManager().handle(e, "org.eclipse.lsp4e");
                }
            }
            if (languageClient == null) {
                languageClient = super.createLanguageClient();
            }
            languageClient.setDiagnosticsConsumer(this.getDiagnosticHandler());
            return languageClient;
        }

        @Override
        public Class<? extends LanguageServer> getServerInterface() {
            Bundle bundle;
            String serverInterface = this.extension.getAttribute(LanguageServersRegistry.SERVER_INTERFACE_ATTRIBUTE);
            if (serverInterface != null && !serverInterface.isEmpty() && (bundle = Platform.getBundle((String)this.extension.getContributor().getName())) != null) {
                try {
                    return bundle.loadClass(serverInterface);
                }
                catch (ClassNotFoundException exception) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.lsp4e", exception.getMessage(), (Throwable)exception));
                }
            }
            return super.getServerInterface();
        }

        @Override
        public <S extends LanguageServer> Launcher.Builder<S> createLauncherBuilder() {
            String launcherSupplier = this.extension.getAttribute(LanguageServersRegistry.LAUNCHER_BUILDER_ATTRIBUTE);
            if (launcherSupplier != null && !launcherSupplier.isEmpty()) {
                try {
                    return (Launcher.Builder)this.extension.createExecutableExtension(LanguageServersRegistry.LAUNCHER_BUILDER_ATTRIBUTE);
                }
                catch (CoreException e) {
                    StatusManager.getManager().handle(e, "org.eclipse.lsp4e");
                }
            }
            return super.createLauncherBuilder();
        }
    }

    public static abstract class LanguageServerDefinition {
        public final @NonNull String id;
        public final @NonNull String label;
        public final boolean isSingleton;
        public final int lastDocumentDisconnectedTimeout;
        public final @NonNull Map<IContentType, String> languageIdMappings;

        LanguageServerDefinition(@NonNull String id, @NonNull String label, boolean isSingleton, int lastDocumentDisconnectedTimeout) {
            this.id = id;
            this.label = label;
            this.isSingleton = isSingleton;
            this.lastDocumentDisconnectedTimeout = lastDocumentDisconnectedTimeout;
            this.languageIdMappings = new ConcurrentHashMap<IContentType, String>();
        }

        public void registerAssociation(@NonNull IContentType contentType, @NonNull String languageId) {
            this.languageIdMappings.put(contentType, languageId);
        }

        public abstract StreamConnectionProvider createConnectionProvider();

        public LanguageClientImpl createLanguageClient() {
            return new LanguageClientImpl();
        }

        public Class<? extends LanguageServer> getServerInterface() {
            return LanguageServer.class;
        }

        public <S extends LanguageServer> Launcher.Builder<S> createLauncherBuilder() {
            return new Launcher.Builder();
        }
    }

    static class LaunchConfigurationLanguageServerDefinition
    extends LanguageServerDefinition {
        final ILaunchConfiguration launchConfiguration;
        final Set<String> launchModes;

        public LaunchConfigurationLanguageServerDefinition(ILaunchConfiguration launchConfiguration, Set<String> launchModes) {
            super(launchConfiguration.getName(), launchConfiguration.getName(), false, 0);
            this.launchConfiguration = launchConfiguration;
            this.launchModes = launchModes;
        }

        @Override
        public StreamConnectionProvider createConnectionProvider() {
            return new LaunchConfigurationStreamProvider(this.launchConfiguration, this.launchModes);
        }
    }

    private static final class LazyHolder {
        static final LanguageServersRegistry INSTANCE = new LanguageServersRegistry();

        private LazyHolder() {
        }
    }
}

