/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ru extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_gu = "\u0433\u0443\u0434\u0436\u0430\u0440\u0430\u0442\u0438";
        final String metaValue_kn = "\u043a\u0430\u043d\u043d\u0430\u0434\u0430";
        final String metaValue_ml = "\u043c\u0430\u043b\u0430\u044f\u043b\u0430\u043c";
        final String metaValue_or = "\u043e\u0440\u0438\u044f";
        final String metaValue_te = "\u0442\u0435\u043b\u0443\u0433\u0443";
        final String metaValue_tl = "\u0442\u0430\u0433\u0430\u043b\u043e\u0433";
        final String metaValue_bax = "\u0431\u0430\u043c\u0443\u043c";
        final String metaValue_chr = "\u0447\u0435\u0440\u043e\u043a\u0438";
        final String metaValue_kpe = "\u043a\u043f\u0435\u043b\u043b\u0435";
        final String metaValue_men = "\u043c\u0435\u043d\u0434\u0435";
        final String metaValue_nqo = "\u043d\u043a\u043e";
        final String metaValue_zbl = "\u0431\u043b\u0438\u0441\u0441\u0438\u043c\u0432\u043e\u043b\u0438\u043a\u0430";
        final String metaValue_Zsye = "\u044d\u043c\u043e\u0434\u0437\u0438";
        final Object[][] data = new Object[][] {
            { "ksh", "\u043a\u0451\u043b\u044c\u043d\u0441\u043a\u0438\u0439" },
            { "Ogam", "\u043e\u0433\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0430\u044f" },
            { "mwl", "\u043c\u0438\u0440\u0430\u043d\u0434\u0441\u043a\u0438\u0439" },
            { "Zsym", "\u0441\u0438\u043c\u0432\u043e\u043b\u044b" },
            { "cch", "\u0430\u0442\u0441\u0430\u043c" },
            { "mwr", "\u043c\u0430\u0440\u0432\u0430\u0440\u0438" },
            { "type.nu.lanatham", "\u0446\u0438\u0444\u0440\u044b \u0442\u0430\u0439 \u0442\u0430\u043c \u0442\u0430\u043c" },
            { "Zsye", metaValue_Zsye },
            { "Tagb", "\u0442\u0430\u0433\u0431\u0430\u043d\u0432\u0430" },
            { "ccp", "\u0447\u0430\u043a\u043c\u0430" },
            { "egy", "\u0434\u0440\u0435\u0432\u043d\u0435\u0435\u0433\u0438\u043f\u0435\u0442\u0441\u043a\u0438\u0439" },
            { "raj", "\u0440\u0430\u0434\u0436\u0430\u0441\u0442\u0445\u0430\u043d\u0438" },
            { "Phag", "\u043f\u0430\u0433\u0441\u043f\u0430" },
            { "tem", "\u0442\u0435\u043c\u043d\u0435" },
            { "teo", "\u0442\u0435\u0441\u043e" },
            { "rap", "\u0440\u0430\u043f\u0430\u043d\u0443\u0439\u0441\u043a\u0438\u0439" },
            { "ter", "\u0442\u0435\u0440\u0435\u043d\u043e" },
            { "AC", "\u043e-\u0432 \u0412\u043e\u0437\u043d\u0435\u0441\u0435\u043d\u0438\u044f" },
            { "rar", "\u0440\u0430\u0440\u043e\u0442\u043e\u043d\u0433\u0430" },
            { "tet", "\u0442\u0435\u0442\u0443\u043c" },
            { "AD", "\u0410\u043d\u0434\u043e\u0440\u0440\u0430" },
            { "AE", "\u041e\u0410\u042d" },
            { "nl_BE", "\u0444\u043b\u0430\u043c\u0430\u043d\u0434\u0441\u043a\u0438\u0439" },
            { "AF", "\u0410\u0444\u0433\u0430\u043d\u0438\u0441\u0442\u0430\u043d" },
            { "AG", "\u0410\u043d\u0442\u0438\u0433\u0443\u0430 \u0438 \u0411\u0430\u0440\u0431\u0443\u0434\u0430" },
            { "type.ca.ethiopic", "\u044d\u0444\u0438\u043e\u043f\u0441\u043a\u0438\u0439 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c" },
            { "AI", "\u0410\u043d\u0433\u0438\u043b\u044c\u044f" },
            { "key.tz", "\u0447\u0430\u0441\u043e\u0432\u043e\u0439 \u043f\u043e\u044f\u0441" },
            { "AL", "\u0410\u043b\u0431\u0430\u043d\u0438\u044f" },
            { "AM", "\u0410\u0440\u043c\u0435\u043d\u0438\u044f" },
            { "Teng", "\u0442\u0435\u043d\u0433\u0432\u0430\u0440\u0441\u043a\u0430\u044f" },
            { "AO", "\u0410\u043d\u0433\u043e\u043b\u0430" },
            { "AQ", "\u0410\u043d\u0442\u0430\u0440\u043a\u0442\u0438\u0434\u0430" },
            { "AR", "\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430" },
            { "Prti", "\u043f\u0430\u0440\u0444\u044f\u043d\u0441\u043a\u0430\u044f" },
            { "AS", "\u0410\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u043e\u0435 \u0421\u0430\u043c\u043e\u0430" },
            { "AT", "\u0410\u0432\u0441\u0442\u0440\u0438\u044f" },
            { "AU", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f" },
            { "AW", "\u0410\u0440\u0443\u0431\u0430" },
            { "en_US", "\u0430\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0438\u0439 \u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439" },
            { "AX", "\u0410\u043b\u0430\u043d\u0434\u0441\u043a\u0438\u0435 \u043e-\u0432\u0430" },
            { "mye", "\u043c\u0438\u0435\u043d\u0435" },
            { "AZ", "\u0410\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d" },
            { "%%AREVELA", "\u0412\u043e\u0441\u0442\u043e\u0447\u043d\u043e-\u0430\u0440\u043c\u044f\u043d\u0441\u043a\u0438\u0439" },
            { "BA", "\u0411\u043e\u0441\u043d\u0438\u044f \u0438 \u0413\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d\u0430" },
            { "BB", "\u0411\u0430\u0440\u0431\u0430\u0434\u043e\u0441" },
            { "ceb", "\u0441\u0435\u0431\u0443\u0430\u043d\u043e" },
            { "BD", "\u0411\u0430\u043d\u0433\u043b\u0430\u0434\u0435\u0448" },
            { "kum", "\u043a\u0443\u043c\u044b\u043a\u0441\u043a\u0438\u0439" },
            { "BE", "\u0411\u0435\u043b\u044c\u0433\u0438\u044f" },
            { "gmh", "\u0441\u0440\u0435\u0434\u043d\u0435\u0432\u0435\u0440\u0445\u043d\u0435\u043d\u0435\u043c\u0435\u0446\u043a\u0438\u0439" },
            { "BF", "\u0411\u0443\u0440\u043a\u0438\u043d\u0430-\u0424\u0430\u0441\u043e" },
            { "BG", "\u0411\u043e\u043b\u0433\u0430\u0440\u0438\u044f" },
            { "BH", "\u0411\u0430\u0445\u0440\u0435\u0439\u043d" },
            { "BI", "\u0411\u0443\u0440\u0443\u043d\u0434\u0438" },
            { "BJ", "\u0411\u0435\u043d\u0438\u043d" },
            { "BL", "\u0421\u0435\u043d-\u0411\u0430\u0440\u0442\u0435\u043b\u0435\u043c\u0438" },
            { "BM", "\u0411\u0435\u0440\u043c\u0443\u0434\u0441\u043a\u0438\u0435 \u043e-\u0432\u0430" },
            { "kut", "\u043a\u0443\u0442\u0435\u043d\u0430\u0438" },
            { "myv", "\u044d\u0440\u0437\u044f\u043d\u0441\u043a\u0438\u0439" },
            { "BN", "\u0411\u0440\u0443\u043d\u0435\u0439-\u0414\u0430\u0440\u0443\u0441\u0441\u0430\u043b\u0430\u043c" },
            { "BO", "\u0411\u043e\u043b\u0438\u0432\u0438\u044f" },
            { "BQ", "\u0411\u043e\u043d\u044d\u0439\u0440, \u0421\u0438\u043d\u0442-\u042d\u0441\u0442\u0430\u0442\u0438\u0443\u0441 \u0438 \u0421\u0430\u0431\u0430" },
            { "BR", "\u0411\u0440\u0430\u0437\u0438\u043b\u0438\u044f" },
            { "BS", "\u0411\u0430\u0433\u0430\u043c\u044b" },
            { "xog", "\u0441\u043e\u0433\u0430" },
            { "BT", "\u0411\u0443\u0442\u0430\u043d" },
            { "BV", "\u043e-\u0432 \u0411\u0443\u0432\u0435" },
            { "BW", "\u0411\u043e\u0442\u0441\u0432\u0430\u043d\u0430" },
            { "BY", "\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u044c" },
            { "BZ", "\u0411\u0435\u043b\u0438\u0437" },
            { "Visp", "\u0432\u0438\u0434\u0438\u043c\u0430\u044f \u0440\u0435\u0447\u044c" },
            { "type.ca.persian", "\u043f\u0435\u0440\u0441\u0438\u0434\u0441\u043a\u0438\u0439 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c" },
            { "type.nu.hebr", "\u0446\u0438\u0444\u0440\u044b \u043d\u0430 \u0438\u0432\u0440\u0438\u0442\u0435" },
            { "CA", "\u041a\u0430\u043d\u0430\u0434\u0430" },
            { "CC", "\u041a\u043e\u043a\u043e\u0441\u043e\u0432\u044b\u0435 \u043e-\u0432\u0430" },
            { "mzn", "\u043c\u0430\u0437\u0430\u043d\u0434\u0435\u0440\u0430\u043d\u0441\u043a\u0438\u0439" },
            { "CD", "\u041a\u043e\u043d\u0433\u043e - \u041a\u0438\u043d\u0448\u0430\u0441\u0430" },
            { "CF", "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u043e-\u0410\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0430\u044f \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430" },
            { "CG", "\u041a\u043e\u043d\u0433\u043e - \u0411\u0440\u0430\u0437\u0437\u0430\u0432\u0438\u043b\u044c" },
            { "CH", "\u0428\u0432\u0435\u0439\u0446\u0430\u0440\u0438\u044f" },
            { "CI", "\u041a\u043e\u0442-\u0434\u2019\u0418\u0432\u0443\u0430\u0440" },
            { "CK", "\u041e\u0441\u0442\u0440\u043e\u0432\u0430 \u041a\u0443\u043a\u0430" },
            { "CL", "\u0427\u0438\u043b\u0438" },
            { "Kthi", "\u043a\u0430\u0439\u0442\u0445\u0438" },
            { "CM", "\u041a\u0430\u043c\u0435\u0440\u0443\u043d" },
            { "CN", "\u041a\u0438\u0442\u0430\u0439" },
            { "CO", "\u041a\u043e\u043b\u0443\u043c\u0431\u0438\u044f" },
            { "CP", "\u043e-\u0432 \u041a\u043b\u0438\u043f\u043f\u0435\u0440\u0442\u043e\u043d" },
            { "CR", "\u041a\u043e\u0441\u0442\u0430-\u0420\u0438\u043a\u0430" },
            { "CU", "\u041a\u0443\u0431\u0430" },
            { "CV", "\u041a\u0430\u0431\u043e-\u0412\u0435\u0440\u0434\u0435" },
            { "CW", "\u041a\u044e\u0440\u0430\u0441\u0430\u043e" },
            { "CX", "\u043e-\u0432 \u0420\u043e\u0436\u0434\u0435\u0441\u0442\u0432\u0430" },
            { "CY", "\u041a\u0438\u043f\u0440" },
            { "type.nu.bali", "\u0431\u0430\u043b\u0438\u0439\u0441\u043a\u0438\u0435 \u0446\u0438\u0444\u0440\u044b" },
            { "CZ", "\u0427\u0435\u0445\u0438\u044f" },
            { "eka", "\u044d\u043a\u0430\u0434\u0436\u0443\u043a" },
            { "DE", "\u0413\u0435\u0440\u043c\u0430\u043d\u0438\u044f" },
            { "goh", "\u0434\u0440\u0435\u0432\u043d\u0435\u0432\u0435\u0440\u0445\u043d\u0435\u043d\u0435\u043c\u0435\u0446\u043a\u0438\u0439" },
            { "ace", "\u0430\u0447\u0435\u0445\u0441\u043a\u0438\u0439" },
            { "cgg", "\u043a\u0438\u0433\u0430" },
            { "DG", "\u0414\u0438\u0435\u0433\u043e-\u0413\u0430\u0440\u0441\u0438\u044f" },
            { "type.nu.deva", "\u0446\u0438\u0444\u0440\u044b \u0434\u0435\u0432\u0430\u043d\u0430\u0433\u0430\u0440\u0438" },
            { "DJ", "\u0414\u0436\u0438\u0431\u0443\u0442\u0438" },
            { "DK", "\u0414\u0430\u043d\u0438\u044f" },
            { "ach", "\u0430\u0447\u043e\u043b\u0438" },
            { "gon", "\u0433\u043e\u043d\u0434\u0438" },
            { "Brai", "\u0448\u0440\u0438\u0444\u0442 \u0411\u0440\u0430\u0439\u043b\u044f" },
            { "Brah", "\u0431\u0440\u0430\u0445\u043c\u0438" },
            { "DM", "\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430" },
            { "type.nu.armnlow", "\u0430\u0440\u043c\u044f\u043d\u0441\u043a\u0438\u0435 \u0446\u0438\u0444\u0440\u044b \u0432 \u043d\u0438\u0436\u043d\u0435\u043c \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0435" },
            { "DO", "\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d\u0441\u043a\u0430\u044f \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430" },
            { "gor", "\u0433\u043e\u0440\u043e\u043d\u0442\u0430\u043b\u043e" },
            { "got", "\u0433\u043e\u0442\u0441\u043a\u0438\u0439" },
            { "Mtei", "\u043c\u0430\u043d\u0438\u043f\u0443\u0440\u0438" },
            { "zun", "\u0437\u0443\u043d\u044c\u0438" },
            { "tig", "\u0442\u0438\u0433\u0440\u0435" },
            { "Takr", "\u0442\u0430\u043a\u0440\u0438" },
            { "DZ", "\u0410\u043b\u0436\u0438\u0440" },
            { "pag", "\u043f\u0430\u043d\u0433\u0430\u0441\u0438\u043d\u0430\u043d" },
            { "type.d0.hwidth", "\u043f\u043e\u043b\u0443\u0448\u0438\u0440\u0438\u043d\u043d\u044b\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u044b" },
            { "pal", "\u043f\u0435\u0445\u043b\u0435\u0432\u0438\u0439\u0441\u043a\u0438\u0439" },
            { "EA", "\u0421\u0435\u0443\u0442\u0430 \u0438 \u041c\u0435\u043b\u0438\u043b\u044c\u044f" },
            { "chb", "\u0447\u0438\u0431\u0447\u0430" },
            { "pam", "\u043f\u0430\u043c\u043f\u0430\u043d\u0433\u0430" },
            { "EC", "\u042d\u043a\u0432\u0430\u0434\u043e\u0440" },
            { "pap", "\u043f\u0430\u043f\u044c\u044f\u043c\u0435\u043d\u0442\u043e" },
            { "ada", "\u0430\u0434\u0430\u043d\u0433\u043c\u0435" },
            { "EE", "\u042d\u0441\u0442\u043e\u043d\u0438\u044f" },
            { "tiv", "\u0442\u0438\u0432\u0438" },
            { "EG", "\u0415\u0433\u0438\u043f\u0435\u0442" },
            { "EH", "\u0417\u0430\u043f\u0430\u0434\u043d\u0430\u044f \u0421\u0430\u0445\u0430\u0440\u0430" },
            { "chg", "\u0447\u0430\u0433\u0430\u0442\u0430\u0439\u0441\u043a\u0438\u0439" },
            { "pau", "\u043f\u0430\u043b\u0430\u0443" },
            { "chk", "\u0447\u0443\u043a\u043e\u0442\u0441\u043a\u0438\u0439" },
            { "chn", "\u0447\u0438\u043d\u0443\u043a \u0436\u0430\u0440\u0433\u043e\u043d" },
            { "chm", "\u043c\u0430\u0440\u0438\u0439\u0441\u043a\u0438\u0439" },
            { "chp", "\u0447\u0438\u043f\u0435\u0432\u044c\u044f\u043d" },
            { "cho", "\u0447\u043e\u043a\u0442\u0430\u0432\u0441\u043a\u0438\u0439" },
            { "chr", metaValue_chr },
            { "ER", "\u042d\u0440\u0438\u0442\u0440\u0435\u044f" },
            { "ES", "\u0418\u0441\u043f\u0430\u043d\u0438\u044f" },
            { "ET", "\u042d\u0444\u0438\u043e\u043f\u0438\u044f" },
            { "EU", "\u0415\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u043a\u0438\u0439 \u0441\u043e\u044e\u0437" },
            { "elx", "\u044d\u043b\u0430\u043c\u0441\u043a\u0438\u0439" },
            { "type.ca.gregorian", "\u0433\u0440\u0438\u0433\u043e\u0440\u0438\u0430\u043d\u0441\u043a\u0438\u0439 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c" },
            { "EZ", "\u0435\u0432\u0440\u043e\u0437\u043e\u043d\u0430" },
            { "chy", "\u0448\u0430\u0439\u0435\u043d\u0441\u043a\u0438\u0439" },
            { "type.nu.gujr", "\u0446\u0438\u0444\u0440\u044b \u0433\u0443\u0434\u0436\u0430\u0440\u0430\u0442\u0438" },
            { "Inds", "\u0445\u0430\u0440\u0430\u043f\u043f\u0441\u043a\u0430\u044f (\u043f\u0438\u0441\u044c\u043c\u0435\u043d\u043d\u043e\u0441\u0442\u044c \u0434\u043e\u043b\u0438\u043d\u044b \u0418\u043d\u0434\u0430)" },
            { "ady", "\u0430\u0434\u044b\u0433\u0435\u0439\u0441\u043a\u0438\u0439" },
            { "FI", "\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438\u044f" },
            { "FJ", "\u0424\u0438\u0434\u0436\u0438" },
            { "FK", "\u0424\u043e\u043b\u043a\u043b\u0435\u043d\u0434\u0441\u043a\u0438\u0435 \u043e-\u0432\u0430" },
            { "FM", "\u0424\u0435\u0434\u0435\u0440\u0430\u0442\u0438\u0432\u043d\u044b\u0435 \u0428\u0442\u0430\u0442\u044b \u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438\u0438" },
            { "key.va", "\u0432\u0430\u0440\u0438\u0430\u043d\u0442 \u0440\u0435\u0433\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a" },
            { "FO", "\u0424\u0430\u0440\u0435\u0440\u0441\u043a\u0438\u0435 \u043e-\u0432\u0430" },
            { "Taml", "\u0442\u0430\u043c\u0438\u043b\u044c\u0441\u043a\u0430\u044f" },
            { "FR", "\u0424\u0440\u0430\u043d\u0446\u0438\u044f" },
            { "Kpel", metaValue_kpe },
            { "tkl", "\u0442\u043e\u043a\u0435\u043b\u0430\u0439\u0441\u043a\u0438\u0439" },
            { "grb", "\u0433\u0440\u0435\u0431\u043e" },
            { "root", "\u043f\u0440\u0430\u044f\u0437\u044b\u043a" },
            { "type.ca.indian", "\u041d\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0439 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c \u0418\u043d\u0434\u0438\u0438" },
            { "grc", "\u0434\u0440\u0435\u0432\u043d\u0435\u0433\u0440\u0435\u0447\u0435\u0441\u043a\u0438\u0439" },
            { "GA", "\u0413\u0430\u0431\u043e\u043d" },
            { "vot", "\u0432\u043e\u0434\u0441\u043a\u0438\u0439" },
            { "GB", "\u0412\u0435\u043b\u0438\u043a\u043e\u0431\u0440\u0438\u0442\u0430\u043d\u0438\u044f" },
            { "pcm", "\u043d\u0438\u0433\u0435\u0440\u0438\u0439\u0441\u043a\u043e-\u043a\u0440\u0435\u043e\u043b\u044c\u0441\u043a\u0438\u0439" },
            { "GD", "\u0413\u0440\u0435\u043d\u0430\u0434\u0430" },
            { "GE", "\u0413\u0440\u0443\u0437\u0438\u044f" },
            { "GF", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0430\u044f \u0413\u0432\u0438\u0430\u043d\u0430" },
            { "GG", "\u0413\u0435\u0440\u043d\u0441\u0438" },
            { "GH", "\u0413\u0430\u043d\u0430" },
            { "Tale", "\u0442\u0430\u0439\u0441\u043a\u0438\u0439 \u043b\u0435" },
            { "GI", "\u0413\u0438\u0431\u0440\u0430\u043b\u0442\u0430\u0440" },
            { "afh", "\u0430\u0444\u0440\u0438\u0445\u0438\u043b\u0438" },
            { "GL", "\u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434\u0438\u044f" },
            { "enm", "\u0441\u0440\u0435\u0434\u043d\u0435\u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439" },
            { "GM", "\u0413\u0430\u043c\u0431\u0438\u044f" },
            { "GN", "\u0413\u0432\u0438\u043d\u0435\u044f" },
            { "GP", "\u0413\u0432\u0430\u0434\u0435\u043b\u0443\u043f\u0430" },
            { "GQ", "\u042d\u043a\u0432\u0430\u0442\u043e\u0440\u0438\u0430\u043b\u044c\u043d\u0430\u044f \u0413\u0432\u0438\u043d\u0435\u044f" },
            { "GR", "\u0413\u0440\u0435\u0446\u0438\u044f" },
            { "GS", "\u042e\u0436\u043d\u0430\u044f \u0413\u0435\u043e\u0440\u0433\u0438\u044f \u0438 \u042e\u0436\u043d\u044b\u0435 \u0421\u0430\u043d\u0434\u0432\u0438\u0447\u0435\u0432\u044b \u043e-\u0432\u0430" },
            { "GT", "\u0413\u0432\u0430\u0442\u0435\u043c\u0430\u043b\u0430" },
            { "GU", "\u0413\u0443\u0430\u043c" },
            { "GW", "\u0413\u0432\u0438\u043d\u0435\u044f-\u0411\u0438\u0441\u0430\u0443" },
            { "tli", "\u0442\u043b\u0438\u043d\u0433\u0438\u0442" },
            { "tlh", "\u043a\u043b\u0438\u043d\u0433\u043e\u043d\u0441\u043a\u0438\u0439" },
            { "Talu", "\u043d\u043e\u0432\u044b\u0439 \u0442\u0430\u0439\u0441\u043a\u0438\u0439 \u043b\u0435" },
            { "GY", "\u0413\u0430\u0439\u0430\u043d\u0430" },
            { "ckb", "\u0441\u043e\u0440\u0430\u043d\u0438" },
            { "zxx", "\u043d\u0435\u0442 \u044f\u0437\u044b\u043a\u043e\u0432\u043e\u0433\u043e \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u0430" },
            { "Jurc", "\u0447\u0436\u0443\u0440\u0447\u0436\u044d\u043d\u044c\u0441\u043a\u0430\u044f" },
            { "de_AT", "\u0430\u0432\u0441\u0442\u0440\u0438\u0439\u0441\u043a\u0438\u0439 \u043d\u0435\u043c\u0435\u0446\u043a\u0438\u0439" },
            { "HK", "\u0413\u043e\u043d\u043a\u043e\u043d\u0433 (\u0421\u0410\u0420)" },
            { "Vaii", "\u0432\u0430\u0439\u0441\u043a\u0430\u044f" },
            { "HM", "\u043e-\u0432\u0430 \u0425\u0435\u0440\u0434 \u0438 \u041c\u0430\u043a\u0434\u043e\u043d\u0430\u043b\u044c\u0434" },
            { "HN", "\u0413\u043e\u043d\u0434\u0443\u0440\u0430\u0441" },
            { "HR", "\u0425\u043e\u0440\u0432\u0430\u0442\u0438\u044f" },
            { "agq", "\u0430\u0433\u0435\u043c" },
            { "gsw", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0441\u043a\u0438\u0439 \u043d\u0435\u043c\u0435\u0446\u043a\u0438\u0439" },
            { "type.ca.islamic-umalqura", "\u0438\u0441\u043b\u0430\u043c\u0441\u043a\u0438\u0439 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c (\u0423\u043c\u043c \u0430\u043b\u044c-\u041a\u0443\u0440\u0430)" },
            { "HT", "\u0413\u0430\u0438\u0442\u0438" },
            { "HU", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f" },
            { "tmh", "\u0442\u0430\u043c\u0430\u0448\u0435\u043a" },
            { "IC", "\u041a\u0430\u043d\u0430\u0440\u0441\u043a\u0438\u0435 \u043e-\u0432\u0430" },
            { "nan", "\u043c\u0438\u043d\u044c\u043d\u0430\u043d\u044c" },
            { "ID", "\u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u044f" },
            { "peo", "\u0441\u0442\u0430\u0440\u043e\u043f\u0435\u0440\u0441\u0438\u0434\u0441\u043a\u0438\u0439" },
            { "type.nu.kali", "\u0446\u0438\u0444\u0440\u044b \u043a\u0430\u0439\u044f \u043b\u0438" },
            { "IE", "\u0418\u0440\u043b\u0430\u043d\u0434\u0438\u044f" },
            { "nap", "\u043d\u0435\u0430\u043f\u043e\u043b\u0438\u0442\u0430\u043d\u0441\u043a\u0438\u0439" },
            { "naq", "\u043d\u0430\u043c\u0430" },
            { "type.nu.sora", "\u0446\u0438\u0444\u0440\u044b \u0441\u043e\u0440\u0430-\u0441\u043e\u043c\u043f\u0435\u043d\u0433" },
            { "zza", "\u0437\u0430\u0437\u0430" },
            { "Tang", "\u0442\u0430\u043d\u0433\u0443\u0442\u0441\u043a\u043e\u0435 \u043c\u0435\u043d\u044f" },
            { "IL", "\u0418\u0437\u0440\u0430\u0438\u043b\u044c" },
            { "Nbat", "\u043d\u0430\u0431\u0430\u0442\u0435\u0439\u0441\u043a\u0430\u044f" },
            { "IM", "\u043e-\u0432 \u041c\u044d\u043d" },
            { "IN", "\u0418\u043d\u0434\u0438\u044f" },
            { "type.co.eor", "\u0435\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u043a\u0438\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u0430 \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438" },
            { "IO", "\u0411\u0440\u0438\u0442\u0430\u043d\u0441\u043a\u0430\u044f \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u044f \u0432 \u0418\u043d\u0434\u0438\u0439\u0441\u043a\u043e\u043c \u043e\u043a\u0435\u0430\u043d\u0435" },
            { "IQ", "\u0418\u0440\u0430\u043a" },
            { "IR", "\u0418\u0440\u0430\u043d" },
            { "IS", "\u0418\u0441\u043b\u0430\u043d\u0434\u0438\u044f" },
            { "IT", "\u0418\u0442\u0430\u043b\u0438\u044f" },
            { "Zmth", "\u043c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043e\u0431\u043e\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f" },
            { "type.nu.thai", "\u0442\u0430\u0439\u0441\u043a\u0438\u0435 \u0446\u0438\u0444\u0440\u044b" },
            { "%%POSIX", "\u041a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440\u043d\u044b\u0439" },
            { "type.nu.beng", "\u0431\u0435\u043d\u0433\u0430\u043b\u044c\u0441\u043a\u0438\u0435 \u0446\u0438\u0444\u0440\u044b" },
            { "JE", "\u0414\u0436\u0435\u0440\u0441\u0438" },
            { "type.ca.islamic", "\u0438\u0441\u043b\u0430\u043c\u0441\u043a\u0438\u0439 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c" },
            { "JM", "\u042f\u043c\u0430\u0439\u043a\u0430" },
            { "Beng", "\u0431\u0435\u043d\u0433\u0430\u043b\u044c\u0441\u043a\u0430\u044f" },
            { "JO", "\u0418\u043e\u0440\u0434\u0430\u043d\u0438\u044f" },
            { "JP", "\u042f\u043f\u043e\u043d\u0438\u044f" },
            { "%%1606NICT", "\u041f\u043e\u0437\u0434\u043d\u0435-\u0441\u0440\u0435\u0434\u043d\u0435\u0432\u0435\u043a\u043e\u0432\u044b\u0439 \u0444\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0438\u0439 \u0434\u043e 1606 \u0433." },
            { "ain", "\u0430\u0439\u043d\u0441\u043a\u0438\u0439" },
            { "Mend", metaValue_men },
            { "guz", "\u0433\u0443\u0441\u0438\u0438" },
            { "tog", "\u0442\u043e\u043d\u0433\u0430" },
            { "type.nu.knda", "\u0446\u0438\u0444\u0440\u044b \u043a\u0430\u043d\u043d\u0430\u0434\u0430" },
            { "Kali", "\u043a\u0430\u0439\u0430" },
            { "de_CH", "\u043b\u0438\u0442\u0435\u0440\u0430\u0442\u0443\u0440\u043d\u044b\u0439 \u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0441\u043a\u0438\u0439 \u043d\u0435\u043c\u0435\u0446\u043a\u0438\u0439" },
            { "type.co.phonetic", "\u0424\u043e\u043d\u0435\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u043f\u043e\u0440\u044f\u0434\u043e\u043a \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438" },
            { "type.ca.buddhist", "\u0431\u0443\u0434\u0434\u0438\u0439\u0441\u043a\u0438\u0439 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c" },
            { "KE", "\u041a\u0435\u043d\u0438\u044f" },
            { "419", "\u041b\u0430\u0442\u0438\u043d\u0441\u043a\u0430\u044f \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "KG", "\u041a\u0438\u0440\u0433\u0438\u0437\u0438\u044f" },
            { "KH", "\u041a\u0430\u043c\u0431\u043e\u0434\u0436\u0430" },
            { "KI", "\u041a\u0438\u0440\u0438\u0431\u0430\u0442\u0438" },
            { "KM", "\u041a\u043e\u043c\u043e\u0440\u044b" },
            { "Knda", metaValue_kn },
            { "KN", "\u0421\u0435\u043d\u0442-\u041a\u0438\u0442\u0441 \u0438 \u041d\u0435\u0432\u0438\u0441" },
            { "Zinh", "\u0443\u043d\u0430\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u043d\u0430\u044f" },
            { "fr_CA", "\u043a\u0430\u043d\u0430\u0434\u0441\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0438\u0439" },
            { "KP", "\u041a\u041d\u0414\u0420" },
            { "KR", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u041a\u043e\u0440\u0435\u044f" },
            { "Plrd", "\u043f\u043e\u043b\u043b\u0430\u0440\u0434\u043e\u0432\u0441\u043a\u0430\u044f \u0444\u043e\u043d\u0435\u0442\u0438\u043a\u0430" },
            { "fr_CH", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0441\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0438\u0439" },
            { "KW", "\u041a\u0443\u0432\u0435\u0439\u0442" },
            { "tpi", "\u0442\u043e\u043a-\u043f\u0438\u0441\u0438\u043d" },
            { "KY", "\u041e\u0441\u0442\u0440\u043e\u0432\u0430 \u041a\u0430\u0439\u043c\u0430\u043d" },
            { "KZ", "\u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d" },
            { "Cyrl", "\u043a\u0438\u0440\u0438\u043b\u043b\u0438\u0446\u0430" },
            { "LA", "\u041b\u0430\u043e\u0441" },
            { "LB", "\u041b\u0438\u0432\u0430\u043d" },
            { "LC", "\u0421\u0435\u043d\u0442-\u041b\u044e\u0441\u0438\u044f" },
            { "phn", "\u0444\u0438\u043d\u0438\u043a\u0438\u0439\u0441\u043a\u0438\u0439" },
            { "Cyrs", "\u0441\u0442\u0430\u0440\u043e\u0441\u043b\u0430\u0432\u044f\u043d\u0441\u043a\u0430\u044f" },
            { "gwi", "\u0433\u0432\u0438\u0447\u0438\u043d" },
            { "nds", "\u043d\u0438\u0436\u043d\u0435\u043d\u0435\u043c\u0435\u0446\u043a\u0438\u0439" },
            { "LI", "\u041b\u0438\u0445\u0442\u0435\u043d\u0448\u0442\u0435\u0439\u043d" },
            { "LK", "\u0428\u0440\u0438-\u041b\u0430\u043d\u043a\u0430" },
            { "akk", "\u0430\u043a\u043a\u0430\u0434\u0441\u043a\u0438\u0439" },
            { "cop", "\u043a\u043e\u043f\u0442\u0441\u043a\u0438\u0439" },
            { "LR", "\u041b\u0438\u0431\u0435\u0440\u0438\u044f" },
            { "LS", "\u041b\u0435\u0441\u043e\u0442\u043e" },
            { "Phlv", "\u043f\u0430\u0445\u043b\u0430\u0432\u0438 \u043a\u043d\u0438\u0436\u043d\u0430\u044f" },
            { "LT", "\u041b\u0438\u0442\u0432\u0430" },
            { "LU", "\u041b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433" },
            { "LV", "\u041b\u0430\u0442\u0432\u0438\u044f" },
            { "Kana", "\u043a\u0430\u0442\u0430\u043a\u0430\u043d\u0430" },
            { "Sora", "\u0441\u043e\u0440\u0430-\u0441\u043e\u043d\u043f\u0435\u043d\u0433" },
            { "LY", "\u041b\u0438\u0432\u0438\u044f" },
            { "lad", "\u043b\u0430\u0434\u0438\u043d\u043e" },
            { "vun", "\u0432\u0443\u043d\u0434\u0436\u043e" },
            { "lah", "\u043b\u0430\u0445\u043d\u0434\u0430" },
            { "lag", "\u043b\u0430\u043d\u0433\u043e" },
            { "Thaa", "\u0442\u0430\u043d\u0430" },
            { "MA", "\u041c\u0430\u0440\u043e\u043a\u043a\u043e" },
            { "MC", "\u041c\u043e\u043d\u0430\u043a\u043e" },
            { "MD", "\u041c\u043e\u043b\u0434\u043e\u0432\u0430" },
            { "Nshu", "\u043d\u044e\u0439-\u0448\u0443" },
            { "ME", "\u0427\u0435\u0440\u043d\u043e\u0433\u043e\u0440\u0438\u044f" },
            { "MF", "\u0421\u0435\u043d-\u041c\u0430\u0440\u0442\u0435\u043d" },
            { "lam", "\u043b\u0430\u043c\u0431\u0430" },
            { "MG", "\u041c\u0430\u0434\u0430\u0433\u0430\u0441\u043a\u0430\u0440" },
            { "MH", "\u041c\u0430\u0440\u0448\u0430\u043b\u043b\u043e\u0432\u044b \u041e\u0441\u0442\u0440\u043e\u0432\u0430" },
            { "ale", "\u0430\u043b\u0435\u0443\u0442\u0441\u043a\u0438\u0439" },
            { "Thai", "\u0442\u0430\u0439\u0441\u043a\u0430\u044f" },
            { "type.nu.vaii", "\u0426\u0438\u0444\u0440\u044b \u044f\u0437\u044b\u043a\u0430 \u0432\u0430\u0439" },
            { "MK", "\u0421\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0438\u044f" },
            { "ML", "\u041c\u0430\u043b\u0438" },
            { "MM", "\u041c\u044c\u044f\u043d\u043c\u0430 (\u0411\u0438\u0440\u043c\u0430)" },
            { "MN", "\u041c\u043e\u043d\u0433\u043e\u043b\u0438\u044f" },
            { "new", "\u043d\u0435\u0432\u0430\u0440\u0441\u043a\u0438\u0439" },
            { "MO", "\u041c\u0430\u043a\u0430\u043e (\u0421\u0410\u0420)" },
            { "MP", "\u0421\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u041c\u0430\u0440\u0438\u0430\u043d\u0441\u043a\u0438\u0435 \u043e-\u0432\u0430" },
            { "MQ", "\u041c\u0430\u0440\u0442\u0438\u043d\u0438\u043a\u0430" },
            { "MR", "\u041c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0438\u044f" },
            { "MS", "\u041c\u043e\u043d\u0442\u0441\u0435\u0440\u0440\u0430\u0442" },
            { "MT", "\u041c\u0430\u043b\u044c\u0442\u0430" },
            { "type.m0.ungegn", "\u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u0442\u0440\u0430\u043d\u0441\u043b\u0438\u0442\u0435\u0440\u0430\u0446\u0438\u0438 \u041e\u041e\u041d" },
            { "MU", "\u041c\u0430\u0432\u0440\u0438\u043a\u0438\u0439" },
            { "alt", "\u044e\u0436\u043d\u043e\u0430\u043b\u0442\u0430\u0439\u0441\u043a\u0438\u0439" },
            { "MV", "\u041c\u0430\u043b\u044c\u0434\u0438\u0432\u044b" },
            { "MW", "\u041c\u0430\u043b\u0430\u0432\u0438" },
            { "MX", "\u041c\u0435\u043a\u0441\u0438\u043a\u0430" },
            { "type.ca.japanese", "\u044f\u043f\u043e\u043d\u0441\u043a\u0438\u0439 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c" },
            { "MY", "\u041c\u0430\u043b\u0430\u0439\u0437\u0438\u044f" },
            { "MZ", "\u041c\u043e\u0437\u0430\u043c\u0431\u0438\u043a" },
            { "Phli", "\u043f\u0435\u0445\u043b\u0435\u0432\u0438\u0439\u0441\u043a\u0430\u044f" },
            { "NA", "\u041d\u0430\u043c\u0438\u0431\u0438\u044f" },
            { "202", "\u0422\u0440\u043e\u043f\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "type.ca.hebrew", "\u0435\u0432\u0440\u0435\u0439\u0441\u043a\u0438\u0439 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c" },
            { "type.co.dictionary", "\u0441\u043b\u043e\u0432\u0430\u0440\u043d\u044b\u0439 \u043f\u043e\u0440\u044f\u0434\u043e\u043a \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438" },
            { "NC", "\u041d\u043e\u0432\u0430\u044f \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0438\u044f" },
            { "%%WADEGILE", "\u0421\u0438\u0441\u0442\u0435\u043c\u0430 \u0423\u044d\u0439\u0434\u0430 \u2013 \u0414\u0436\u0430\u0439\u043b\u0437\u0430" },
            { "tru", "\u0442\u0443\u0440\u043e\u0439\u043e" },
            { "NE", "\u041d\u0438\u0433\u0435\u0440" },
            { "NF", "\u043e-\u0432 \u041d\u043e\u0440\u0444\u043e\u043b\u043a" },
            { "NG", "\u041d\u0438\u0433\u0435\u0440\u0438\u044f" },
            { "trv", "\u0441\u0435\u0434\u0435\u043a\u0441\u043a\u0438\u0439" },
            { "Phlp", "\u043f\u0430\u0445\u043b\u0430\u0432\u0438 \u043f\u0441\u0430\u043b\u0442\u0438\u0440\u043d\u0430\u044f" },
            { "NI", "\u041d\u0438\u043a\u0430\u0440\u0430\u0433\u0443\u0430" },
            { "Hmng", "\u043f\u0430\u0445\u0430\u0443 \u0445\u043c\u043e\u043d\u0433" },
            { "NL", "\u041d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u044b" },
            { "NO", "\u041d\u043e\u0440\u0432\u0435\u0433\u0438\u044f" },
            { "NP", "\u041d\u0435\u043f\u0430\u043b" },
            { "NR", "\u041d\u0430\u0443\u0440\u0443" },
            { "NU", "\u041d\u0438\u0443\u044d" },
            { "Phnx", "\u0444\u0438\u043d\u0438\u043a\u0438\u0439\u0441\u043a\u0430\u044f" },
            { "rof", "\u0440\u043e\u043c\u0431\u043e" },
            { "tsi", "\u0446\u0438\u043c\u0448\u0438\u0430\u043d" },
            { "NZ", "\u041d\u043e\u0432\u0430\u044f \u0417\u0435\u043b\u0430\u043d\u0434\u0438\u044f" },
            { "Merc", "\u043c\u0435\u0440\u043e\u0438\u0442\u0441\u043a\u0430\u044f \u043a\u0443\u0440\u0441\u0438\u0432\u043d\u0430\u044f" },
            { "rom", "\u0446\u044b\u0433\u0430\u043d\u0441\u043a\u0438\u0439" },
            { "Mero", "\u043c\u0435\u0440\u043e\u0438\u0442\u0441\u043a\u0430\u044f" },
            { "crh", "\u043a\u0440\u044b\u043c\u0441\u043a\u043e-\u0442\u0430\u0442\u0430\u0440\u0441\u043a\u0438\u0439" },
            { "ang", "\u0441\u0442\u0430\u0440\u043e\u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439" },
            { "OM", "\u041e\u043c\u0430\u043d" },
            { "anp", "\u0430\u043d\u0433\u0438\u043a\u0430" },
            { "crs", "\u0441\u0435\u0439\u0448\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u043a\u0440\u0435\u043e\u043b\u044c\u0441\u043a\u0438\u0439" },
            { "Xpeo", "\u0441\u0442\u0430\u0440\u043e\u043f\u0435\u0440\u0441\u0438\u0434\u0441\u043a\u0430\u044f" },
            { "PA", "\u041f\u0430\u043d\u0430\u043c\u0430" },
            { "type.ca.islamic-civil", "\u0418\u0441\u043b\u0430\u043c\u0441\u043a\u0438\u0439 \u0433\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u0438\u0439 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c" },
            { "csb", "\u043a\u0430\u0448\u0443\u0431\u0441\u043a\u0438\u0439" },
            { "en_GB", "\u0431\u0440\u0438\u0442\u0430\u043d\u0441\u043a\u0438\u0439 \u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439" },
            { "PE", "\u041f\u0435\u0440\u0443" },
            { "PF", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0430\u044f \u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438\u044f" },
            { "PG", "\u041f\u0430\u043f\u0443\u0430 \u2014 \u041d\u043e\u0432\u0430\u044f \u0413\u0432\u0438\u043d\u0435\u044f" },
            { "PH", "\u0424\u0438\u043b\u0438\u043f\u043f\u0438\u043d\u044b" },
            { "PK", "\u041f\u0430\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "PL", "\u041f\u043e\u043b\u044c\u0448\u0430" },
            { "ewo", "\u044d\u0432\u043e\u043d\u0434\u043e" },
            { "PM", "\u0421\u0435\u043d-\u041f\u044c\u0435\u0440 \u0438 \u041c\u0438\u043a\u0435\u043b\u043e\u043d" },
            { "PN", "\u043e-\u0432\u0430 \u041f\u0438\u0442\u043a\u044d\u0440\u043d" },
            { "PR", "\u041f\u0443\u044d\u0440\u0442\u043e-\u0420\u0438\u043a\u043e" },
            { "PS", "\u041f\u0430\u043b\u0435\u0441\u0442\u0438\u043d\u0441\u043a\u0438\u0435 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438" },
            { "Bali", "\u0431\u0430\u043b\u0438\u0439\u0441\u043a\u0430\u044f" },
            { "PT", "\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0438\u044f" },
            { "PW", "\u041f\u0430\u043b\u0430\u0443" },
            { "nia", "\u043d\u0438\u0430\u0441" },
            { "type.nu.greklow", "\u0433\u0440\u0435\u0447\u0435\u0441\u043a\u0438\u0435 \u0446\u0438\u0444\u0440\u044b \u0432 \u043d\u0438\u0436\u043d\u0435\u043c \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0435" },
            { "PY", "\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0439" },
            { "tum", "\u0442\u0443\u043c\u0431\u0443\u043a\u0430" },
            { "Hebr", "\u0435\u0432\u0440\u0435\u0439\u0441\u043a\u0430\u044f" },
            { "QA", "\u041a\u0430\u0442\u0430\u0440" },
            { "%%SCOTLAND", "\u0410\u043d\u0433\u043b\u043e-\u0448\u043e\u0442\u043b\u0430\u043d\u0434\u0441\u043a\u0438\u0439" },
            { "niu", "\u043d\u0438\u0443\u044d" },
            { "QO", "\u0412\u043d\u0435\u0448\u043d\u044f\u044f \u041e\u043a\u0435\u0430\u043d\u0438\u044f" },
            { "lez", "\u043b\u0435\u0437\u0433\u0438\u043d\u0441\u043a\u0438\u0439" },
            { "type.nu.takr", "\u0446\u0438\u0444\u0440\u044b \u0442\u0430\u043a\u0440\u0438" },
            { "tvl", "\u0442\u0443\u0432\u0430\u043b\u0443" },
            { "Tavt", "\u0442\u0430\u0439-\u0432\u044c\u0435\u0442" },
            { "001", "\u0432\u0435\u0441\u044c \u043c\u0438\u0440" },
            { "002", "\u0410\u0444\u0440\u0438\u043a\u0430" },
            { "003", "\u0421\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "RE", "\u0420\u0435\u044e\u043d\u044c\u043e\u043d" },
            { "005", "\u042e\u0436\u043d\u0430\u044f \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "jbo", "\u043b\u043e\u0436\u0431\u0430\u043d" },
            { "Rjng", "\u0440\u0435\u0434\u0436\u0430\u043d\u0433\u0441\u043a\u0430\u044f" },
            { "009", "\u041e\u043a\u0435\u0430\u043d\u0438\u044f" },
            { "RO", "\u0420\u0443\u043c\u044b\u043d\u0438\u044f" },
            { "RS", "\u0421\u0435\u0440\u0431\u0438\u044f" },
            { "Mroo", "\u043c\u0440\u043e" },
            { "RU", "\u0420\u043e\u0441\u0441\u0438\u044f" },
            { "RW", "\u0420\u0443\u0430\u043d\u0434\u0430" },
            { "type.nu.talu", "\u0446\u0438\u0444\u0440\u044b \u043d\u043e\u0432\u043e\u0439 \u0442\u0430\u0439-\u043b\u044e" },
            { "Mani", "\u043c\u0430\u043d\u0438\u0445\u0435\u0439\u0441\u043a\u0430\u044f" },
            { "Ugar", "\u0443\u0433\u0430\u0440\u0438\u0442\u0441\u043a\u0430\u044f" },
            { "Khar", "\u043a\u0445\u0430\u0440\u043e\u0448\u0442\u0445\u0438" },
            { "SA", "\u0421\u0430\u0443\u0434\u043e\u0432\u0441\u043a\u0430\u044f \u0410\u0440\u0430\u0432\u0438\u044f" },
            { "pon", "\u043f\u043e\u043d\u0430\u043f\u0435" },
            { "Mand", "\u043c\u0430\u043d\u0434\u0435\u0439\u0441\u043a\u0430\u044f" },
            { "SB", "\u0421\u043e\u043b\u043e\u043c\u043e\u043d\u043e\u0432\u044b \u041e\u0441\u0442\u0440\u043e\u0432\u0430" },
            { "twq", "\u0442\u0430\u0441\u0430\u0432\u0430\u043a" },
            { "011", "\u0417\u0430\u043f\u0430\u0434\u043d\u0430\u044f \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "SC", "\u0421\u0435\u0439\u0448\u0435\u043b\u044c\u0441\u043a\u0438\u0435 \u041e\u0441\u0442\u0440\u043e\u0432\u0430" },
            { "SD", "\u0421\u0443\u0434\u0430\u043d" },
            { "013", "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "SE", "\u0428\u0432\u0435\u0446\u0438\u044f" },
            { "014", "\u0412\u043e\u0441\u0442\u043e\u0447\u043d\u0430\u044f \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "arc", "\u0430\u0440\u0430\u043c\u0435\u0439\u0441\u043a\u0438\u0439" },
            { "Loma", "\u043b\u043e\u043c\u0430" },
            { "015", "\u0421\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "SG", "\u0421\u0438\u043d\u0433\u0430\u043f\u0443\u0440" },
            { "SH", "\u043e-\u0432 \u0421\u0432. \u0415\u043b\u0435\u043d\u044b" },
            { "type.lb.strict", "\u0436\u0435\u0441\u0442\u043a\u0438\u0439 \u043f\u0435\u0440\u0435\u0432\u043e\u0434 \u0441\u0442\u0440\u043e\u043a\u0438" },
            { "017", "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "SI", "\u0421\u043b\u043e\u0432\u0435\u043d\u0438\u044f" },
            { "018", "\u042e\u0436\u043d\u0430\u044f \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "SJ", "\u0428\u043f\u0438\u0446\u0431\u0435\u0440\u0433\u0435\u043d \u0438 \u042f\u043d-\u041c\u0430\u0439\u0435\u043d" },
            { "Bamu", metaValue_bax },
            { "019", "\u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "SK", "\u0421\u043b\u043e\u0432\u0430\u043a\u0438\u044f" },
            { "Wole", "\u0432\u043e\u043b\u0435\u0430\u0438" },
            { "SL", "\u0421\u044c\u0435\u0440\u0440\u0430-\u041b\u0435\u043e\u043d\u0435" },
            { "SM", "\u0421\u0430\u043d-\u041c\u0430\u0440\u0438\u043d\u043e" },
            { "SN", "\u0421\u0435\u043d\u0435\u0433\u0430\u043b" },
            { "SO", "\u0421\u043e\u043c\u0430\u043b\u0438" },
            { "arn", "\u043c\u0430\u043f\u0443\u0447\u0435" },
            { "arp", "\u0430\u0440\u0430\u043f\u0430\u0445\u043e" },
            { "type.nu.taml", "\u0442\u0430\u043c\u0438\u043b\u044c\u0441\u043a\u0438\u0435 \u0442\u0440\u0430\u0434\u0438\u0446\u0438\u043e\u043d\u043d\u044b\u0435 \u0446\u0438\u0444\u0440\u044b" },
            { "SR", "\u0421\u0443\u0440\u0438\u043d\u0430\u043c" },
            { "SS", "\u042e\u0436\u043d\u044b\u0439 \u0421\u0443\u0434\u0430\u043d" },
            { "ST", "\u0421\u0430\u043d-\u0422\u043e\u043c\u0435 \u0438 \u041f\u0440\u0438\u043d\u0441\u0438\u043f\u0438" },
            { "SV", "\u0421\u0430\u043b\u044c\u0432\u0430\u0434\u043e\u0440" },
            { "ars", "\u043d\u0435\u0434\u0436\u0434\u0438\u0439\u0441\u043a\u0438\u0439 \u0430\u0440\u0430\u0431\u0441\u043a\u0438\u0439" },
            { "SX", "\u0421\u0438\u043d\u0442-\u041c\u0430\u0440\u0442\u0435\u043d" },
            { "SY", "\u0421\u0438\u0440\u0438\u044f" },
            { "yao", "\u044f\u043e" },
            { "SZ", "\u042d\u0441\u0432\u0430\u0442\u0438\u043d\u0438" },
            { "arw", "\u0430\u0440\u0430\u0432\u0430\u043a\u0441\u043a\u0438\u0439" },
            { "yap", "\u044f\u043f" },
            { "TA", "\u0422\u0440\u0438\u0441\u0442\u0430\u043d-\u0434\u0430-\u041a\u0443\u043d\u044c\u044f" },
            { "asa", "\u0430\u0441\u0443" },
            { "type.ms.ussystem", "\u0430\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0430\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u043c\u0435\u0440" },
            { "021", "\u0421\u0435\u0432\u0435\u0440\u043e\u0430\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0438\u0439 \u0440\u0435\u0433\u0438\u043e\u043d" },
            { "TC", "\u043e-\u0432\u0430 \u0422\u0451\u0440\u043a\u0441 \u0438 \u041a\u0430\u0439\u043a\u043e\u0441" },
            { "yav", "\u044f\u043d\u0433\u0431\u0435\u043d" },
            { "TD", "\u0427\u0430\u0434" },
            { "Qaag", "\u0437\u043e\u0434\u0436\u0438" },
            { "TF", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0438\u0435 \u042e\u0436\u043d\u044b\u0435 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438" },
            { "TG", "\u0422\u043e\u0433\u043e" },
            { "TH", "\u0422\u0430\u0438\u043b\u0430\u043d\u0434" },
            { "TJ", "\u0422\u0430\u0434\u0436\u0438\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "029", "\u041a\u0430\u0440\u0438\u0431\u044b" },
            { "TK", "\u0422\u043e\u043a\u0435\u043b\u0430\u0443" },
            { "TL", "\u0412\u043e\u0441\u0442\u043e\u0447\u043d\u044b\u0439 \u0422\u0438\u043c\u043e\u0440" },
            { "ybb", "\u0439\u0435\u043c\u0431\u0430" },
            { "type.co.searchjl", "\u041f\u043e\u0438\u0441\u043a \u043f\u043e \u043f\u0435\u0440\u0432\u043e\u0439 \u0441\u043e\u0433\u043b\u0430\u0441\u043d\u043e\u0439 \u0445\u0430\u043d\u0433\u044b\u043b\u044c" },
            { "TM", "\u0422\u0443\u0440\u043a\u043c\u0435\u043d\u0438\u0441\u0442\u0430\u043d" },
            { "TN", "\u0422\u0443\u043d\u0438\u0441" },
            { "TO", "\u0422\u043e\u043d\u0433\u0430" },
            { "TR", "\u0422\u0443\u0440\u0446\u0438\u044f" },
            { "TT", "\u0422\u0440\u0438\u043d\u0438\u0434\u0430\u0434 \u0438 \u0422\u043e\u0431\u0430\u0433\u043e" },
            { "TV", "\u0422\u0443\u0432\u0430\u043b\u0443" },
            { "TW", "\u0422\u0430\u0439\u0432\u0430\u043d\u044c" },
            { "ast", "\u0430\u0441\u0442\u0443\u0440\u0438\u0439\u0441\u043a\u0438\u0439" },
            { "Orkh", "\u043e\u0440\u0445\u043e\u043d\u043e-\u0435\u043d\u0438\u0441\u0435\u0439\u0441\u043a\u0430\u044f" },
            { "TZ", "\u0422\u0430\u043d\u0437\u0430\u043d\u0438\u044f" },
            { "nmg", "\u043a\u0432\u0430\u0441\u0438\u043e" },
            { "Zzzz", "\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043f\u0438\u0441\u044c\u043c\u0435\u043d\u043d\u043e\u0441\u0442\u044c" },
            { "Sind", "\u043a\u0445\u0443\u0434\u0430\u0432\u0430\u0434\u0438" },
            { "UA", "\u0423\u043a\u0440\u0430\u0438\u043d\u0430" },
            { "rup", "\u0430\u0440\u0443\u043c\u044b\u043d\u0441\u043a\u0438\u0439" },
            { "030", "\u0412\u043e\u0441\u0442\u043e\u0447\u043d\u0430\u044f \u0410\u0437\u0438\u044f" },
            { "tyv", "\u0442\u0443\u0432\u0438\u043d\u0441\u043a\u0438\u0439" },
            { "sw_CD", "\u043a\u043e\u043d\u0433\u043e\u043b\u0435\u0437\u0441\u043a\u0438\u0439 \u0441\u0443\u0430\u0445\u0438\u043b\u0438" },
            { "034", "\u042e\u0436\u043d\u0430\u044f \u0410\u0437\u0438\u044f" },
            { "hai", "\u0445\u0430\u0439\u0434\u0430" },
            { "035", "\u042e\u0433\u043e-\u0412\u043e\u0441\u0442\u043e\u0447\u043d\u0430\u044f \u0410\u0437\u0438\u044f" },
            { "UG", "\u0423\u0433\u0430\u043d\u0434\u0430" },
            { "hak", "\u0445\u0430\u043a\u043a\u0430" },
            { "type.co.pinyin", "\u043f\u0438\u043d\u044c\u0438\u043d\u044c" },
            { "039", "\u042e\u0436\u043d\u0430\u044f \u0415\u0432\u0440\u043e\u043f\u0430" },
            { "Sinh", "\u0441\u0438\u043d\u0433\u0430\u043b\u044c\u0441\u043a\u0430\u044f" },
            { "UM", "\u0412\u043d\u0435\u0448\u043d\u0438\u0435 \u043c\u0430\u043b\u044b\u0435 \u043e-\u0432\u0430 (\u0421\u0428\u0410)" },
            { "UN", "\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u041e\u0431\u044a\u0435\u0434\u0438\u043d\u0435\u043d\u043d\u044b\u0445 \u041d\u0430\u0446\u0438\u0439" },
            { "US", "\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u043d\u044b\u0435 \u0428\u0442\u0430\u0442\u044b" },
            { "haw", "\u0433\u0430\u0432\u0430\u0439\u0441\u043a\u0438\u0439" },
            { "type.co.gb2312han", "\u0443\u043f\u0440\u043e\u0449\u0435\u043d\u043d\u044b\u0439 \u043a\u0438\u0442\u0430\u0439\u0441\u043a\u0438\u0439 - GB2312" },
            { "UY", "\u0423\u0440\u0443\u0433\u0432\u0430\u0439" },
            { "prg", "\u043f\u0440\u0443\u0441\u0441\u043a\u0438\u0439" },
            { "UZ", "\u0423\u0437\u0431\u0435\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "tzm", "\u0441\u0440\u0435\u0434\u043d\u0435\u0430\u0442\u043b\u0430\u0441\u0441\u043a\u0438\u0439 \u0442\u0430\u043c\u0430\u0437\u0438\u0433\u0445\u0442\u0441\u043a\u0438\u0439" },
            { "type.co.stroke", "\u043f\u043e \u0447\u0435\u0440\u0442\u0430\u043c" },
            { "nnh", "\u043d\u0433\u0438\u0435\u043c\u0431\u0443\u043d\u0434" },
            { "VA", "\u0412\u0430\u0442\u0438\u043a\u0430\u043d" },
            { "pro", "\u0441\u0442\u0430\u0440\u043e\u043f\u0440\u043e\u0432\u0430\u043d\u0441\u0430\u043b\u044c\u0441\u043a\u0438\u0439" },
            { "VC", "\u0421\u0435\u043d\u0442-\u0412\u0438\u043d\u0441\u0435\u043d\u0442 \u0438 \u0413\u0440\u0435\u043d\u0430\u0434\u0438\u043d\u044b" },
            { "VE", "\u0412\u0435\u043d\u0435\u0441\u0443\u044d\u043b\u0430" },
            { "VG", "\u0412\u0438\u0440\u0433\u0438\u043d\u0441\u043a\u0438\u0435 \u043e-\u0432\u0430 (\u0412\u0435\u043b\u0438\u043a\u043e\u0431\u0440\u0438\u0442\u0430\u043d\u0438\u044f)" },
            { "VI", "\u0412\u0438\u0440\u0433\u0438\u043d\u0441\u043a\u0438\u0435 \u043e-\u0432\u0430 (\u0421\u0428\u0410)" },
            { "VN", "\u0412\u044c\u0435\u0442\u043d\u0430\u043c" },
            { "VU", "\u0412\u0430\u043d\u0443\u0430\u0442\u0443" },
            { "nog", "\u043d\u043e\u0433\u0430\u0439\u0441\u043a\u0438\u0439" },
            { "rwk", "\u0440\u0443\u0430\u043d\u0434\u0430" },
            { "non", "\u0441\u0442\u0430\u0440\u043e\u043d\u043e\u0440\u0432\u0435\u0436\u0441\u043a\u0438\u0439" },
            { "053", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0430\u0437\u0438\u044f" },
            { "%%AREVMDA", "\u0417\u0430\u043f\u0430\u0434\u043d\u043e-\u0430\u0440\u043c\u044f\u043d\u0441\u043a\u0438\u0439" },
            { "054", "\u041c\u0435\u043b\u0430\u043d\u0435\u0437\u0438\u044f" },
            { "WF", "\u0423\u043e\u043b\u043b\u0438\u0441 \u0438 \u0424\u0443\u0442\u0443\u043d\u0430" },
            { "type.co.traditional", "\u0442\u0440\u0430\u0434\u0438\u0446\u0438\u043e\u043d\u043d\u044b\u0439 \u043f\u043e\u0440\u044f\u0434\u043e\u043a" },
            { "057", "\u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438\u044f" },
            { "jgo", "\u043d\u0433\u043e\u043c\u0431\u0430" },
            { "lkt", "\u043b\u0430\u043a\u043e\u0442\u0430" },
            { "type.nu.finance", "\u0421\u0438\u043c\u0432\u043e\u043b\u044b \u043e\u0431\u043e\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u043f\u043e\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u0435\u0439" },
            { "type.co.compat", "\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b\u0439 \u043f\u043e\u0440\u044f\u0434\u043e\u043a \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438" },
            { "wae", "\u0432\u0430\u043b\u043b\u0438\u0441\u0441\u043a\u0438\u0439" },
            { "WS", "\u0421\u0430\u043c\u043e\u0430" },
            { "Bass", "\u0431\u0430\u0441\u0441\u0430 (\u0432\u0430\u0445)" },
            { "type.nu.mtei", "\u0446\u0438\u0444\u0440\u044b \u043c\u0430\u043d\u0438\u043f\u0443\u0440\u0438" },
            { "wal", "\u0432\u043e\u043b\u0430\u043c\u043e" },
            { "was", "\u0432\u0430\u0448\u043e" },
            { "XA", "\u043f\u0441\u0435\u0432\u0434\u043e\u0430\u043a\u0446\u0435\u043d\u0442\u044b" },
            { "war", "\u0432\u0430\u0440\u0430\u0439" },
            { "XB", "\u043f\u0441\u0435\u0432\u0434\u043e-Bidi" },
            { "awa", "\u0430\u0432\u0430\u0434\u0445\u0438" },
            { "061", "\u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438\u044f" },
            { "XK", "\u041a\u043e\u0441\u043e\u0432\u043e" },
            { "type.nu.brah", "\u0446\u0438\u0444\u0440\u044b \u0431\u0440\u0430\u0445\u043c\u0438" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u043d\u0435\u0442 \u043f\u0438\u0441\u044c\u043c\u0435\u043d\u043d\u043e\u0441\u0442\u0438" },
            { "Olck", "\u043e\u043b \u0447\u0438\u043a\u0438" },
            { "wbp", "\u0432\u0430\u043b\u044c\u0431\u0438\u0440\u0438" },
            { "Batk", "\u0431\u0430\u0442\u0430\u043a\u0441\u043a\u0430\u044f" },
            { "Blis", metaValue_zbl },
            { "YE", "\u0419\u0435\u043c\u0435\u043d" },
            { "nqo", metaValue_nqo },
            { "type.co.standard", "\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u0430\u044f \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430" },
            { "fan", "\u0444\u0430\u043d\u0433" },
            { "%%ROZAJ", "\u0420\u0435\u0437\u044c\u044f\u043d\u0441\u043a\u0438\u0439" },
            { "fat", "\u0444\u0430\u043d\u0442\u0438" },
            { "Sgnw", "\u044f\u0437\u044b\u043a \u0437\u043d\u0430\u043a\u043e\u0432" },
            { "YT", "\u041c\u0430\u0439\u043e\u0442\u0442\u0430" },
            { "type.nu.cham", "\u0447\u0430\u043c\u0441\u043a\u0438\u0435 \u0446\u0438\u0444\u0440\u044b" },
            { "ZA", "\u042e\u0436\u043d\u043e-\u0410\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0430\u044f \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430" },
            { "type.nu.sund", "\u0441\u0443\u0434\u0430\u043d\u0441\u043a\u0438\u0435 \u0446\u0438\u0444\u0440\u044b" },
            { "type.lb.loose", "\u043c\u044f\u0433\u043a\u0438\u0439 \u043f\u0435\u0440\u0435\u0432\u043e\u0434 \u0441\u0442\u0440\u043e\u043a\u0438" },
            { "Deva", "\u0434\u0435\u0432\u0430\u043d\u0430\u0433\u0430\u0440\u0438" },
            { "type.nu.geor", "\u0433\u0440\u0443\u0437\u0438\u043d\u0441\u043a\u0438\u0435 \u0446\u0438\u0444\u0440\u044b" },
            { "type.co.zhuyin", "\u0447\u0436\u0443\u0438\u043d\u044c" },
            { "Hira", "\u0445\u0438\u0440\u0430\u0433\u0430\u043d\u0430" },
            { "ZM", "\u0417\u0430\u043c\u0431\u0438\u044f" },
            { "%%PINYIN", "\u041f\u0438\u043d\u044c\u0438\u043d\u044c" },
            { "ZW", "\u0417\u0438\u043c\u0431\u0430\u0431\u0432\u0435" },
            { "ZZ", "\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0440\u0435\u0433\u0438\u043e\u043d" },
            { "Runr", "\u0440\u0443\u043d\u0438\u0447\u0435\u0441\u043a\u0430\u044f" },
            { "type.ms.metric", "\u043c\u0435\u0442\u0440\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u0430" },
            { "type.ca.iso8601", "\u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c ISO-8601" },
            { "lol", "\u043c\u043e\u043d\u0433\u043e" },
            { "nso", "\u0441\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0441\u043e\u0442\u043e" },
            { "type.nu.telu", "\u0446\u0438\u0444\u0440\u044b \u0442\u0435\u043b\u0443\u0433\u0443" },
            { "lou", "\u043b\u0443\u0438\u0437\u0438\u0430\u043d\u0441\u043a\u0438\u0439 \u043a\u0440\u0435\u043e\u043b\u044c\u0441\u043a\u0438\u0439" },
            { "loz", "\u043b\u043e\u0437\u0438" },
            { "Nkgb", "\u043d\u0430\u0441\u0438 \u0433\u0435\u0431\u0430" },
            { "jmc", "\u043c\u0430\u0447\u0430\u043c\u0435" },
            { "type.nu.hansfin", "\u043a\u0438\u0442\u0430\u0439\u0441\u043a\u0438\u0435 \u0443\u043f\u0440\u043e\u0449\u0435\u043d\u043d\u044b\u0435 \u0446\u0438\u0444\u0440\u044b (\u0444\u0438\u043d\u0430\u043d\u0441\u044b)" },
            { "hil", "\u0445\u0438\u043b\u0438\u0433\u0430\u0439\u043d\u043e\u043d" },
            { "type.nu.arabext", "\u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u043d\u0430\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u0430\u0440\u0430\u0431\u0441\u043a\u043e-\u0438\u043d\u0434\u0438\u0439\u0441\u043a\u0438\u0445 \u0446\u0438\u0444\u0440" },
            { "nus", "\u043d\u0443\u044d\u0440" },
            { "dak", "\u0434\u0430\u043a\u043e\u0442\u0430" },
            { "type.nu.fullwide", "\u043f\u043e\u043b\u043d\u043e\u0448\u0438\u0440\u0438\u043d\u043d\u044b\u0435 \u0446\u0438\u0444\u0440\u044b" },
            { "hit", "\u0445\u0435\u0442\u0442\u0441\u043a\u0438\u0439" },
            { "dar", "\u0434\u0430\u0440\u0433\u0438\u043d\u0441\u043a\u0438\u0439" },
            { "dav", "\u0442\u0430\u0438\u0442\u0430" },
            { "Maya", "\u043c\u0430\u0439\u044f" },
            { "lrc", "\u0441\u0435\u0432\u0435\u0440\u043d\u043e\u043b\u0443\u0440\u0441\u043a\u0438\u0439" },
            { "type.co.emoji", metaValue_Zsye },
            { "Copt", "\u043a\u043e\u043f\u0442\u0441\u043a\u0430\u044f" },
            { "nwc", "\u043a\u043b\u0430\u0441\u0441\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u043d\u0435\u0432\u0430\u0440\u0438" },
            { "udm", "\u0443\u0434\u043c\u0443\u0440\u0442\u0441\u043a\u0438\u0439" },
            { "Khmr", "\u043a\u0445\u043c\u0435\u0440\u0441\u043a\u0430\u044f" },
            { "type.ca.islamic-rgsa", "\u0438\u0441\u043b\u0430\u043c\u0441\u043a\u0438\u0439 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c (\u0421\u0430\u0443\u0434\u043e\u0432\u0441\u043a\u0430\u044f \u0410\u0440\u0430\u0432\u0438\u044f)" },
            { "Limb", "\u043b\u0438\u043c\u0431\u0443" },
            { "sad", "\u0441\u0430\u043d\u0434\u0430\u0432\u0435" },
            { "type.nu.roman", "\u0440\u0438\u043c\u0441\u043a\u0438\u0435 \u0446\u0438\u0444\u0440\u044b" },
            { "sah", "\u0441\u0430\u0445\u0430" },
            { "type.nu.shrd", "\u0446\u0438\u0444\u0440\u044b \u0448\u0430\u0440\u0430\u0434\u0430" },
            { "sam", "\u0441\u0430\u043c\u0430\u0440\u0438\u0442\u044f\u043d\u0441\u043a\u0438\u0439 \u0430\u0440\u0430\u043c\u0435\u0439\u0441\u043a\u0438\u0439" },
            { "saq", "\u0441\u0430\u043c\u0431\u0443\u0440\u0443" },
            { "sas", "\u0441\u0430\u0441\u0430\u043a\u0441\u043a\u0438\u0439" },
            { "sat", "\u0441\u0430\u043d\u0442\u0430\u043b\u0438" },
            { "Tfng", "\u0434\u0440\u0435\u0432\u043d\u0435\u043b\u0438\u0432\u0438\u0439\u0441\u043a\u0430\u044f" },
            { "jpr", "\u0435\u0432\u0440\u0435\u0439\u0441\u043a\u043e-\u043f\u0435\u0440\u0441\u0438\u0434\u0441\u043a\u0438\u0439" },
            { "type.d0.npinyin", "\u0427\u0438\u0441\u043b\u043e\u0432\u0430\u044f" },
            { "type.nu.native", "\u041e\u0431\u043e\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0446\u0438\u0444\u0440 \u043a\u043e\u0440\u0435\u043d\u043d\u043e\u0433\u043e \u043d\u0430\u0441\u0435\u043b\u0435\u043d\u0438\u044f" },
            { "sba", "\u043d\u0433\u0430\u043c\u0431\u0430\u0439\u0441\u043a\u0438\u0439" },
            { "Guru", "\u0433\u0443\u0440\u043c\u0443\u043a\u0445\u0438" },
            { "lua", "\u043b\u0443\u0431\u0430-\u043b\u0443\u043b\u0443\u0430" },
            { "type.d0.fwidth", "\u043f\u043e\u043b\u043d\u043e\u0448\u0438\u0440\u0438\u043d\u043d\u044b\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u044b" },
            { "sbp", "\u0441\u0430\u043d\u0433\u0443" },
            { "lui", "\u043b\u0443\u0438\u0441\u0435\u043d\u044c\u043e" },
            { "nyn", "\u043d\u044c\u044f\u043d\u043a\u043e\u043b\u0435" },
            { "nym", "\u043d\u044c\u044f\u043c\u0432\u0435\u0437\u0438" },
            { "lun", "\u043b\u0443\u043d\u0434\u0430" },
            { "nyo", "\u043d\u044c\u043e\u0440\u043e" },
            { "luo", "\u043b\u0443\u043e" },
            { "fil", "\u0444\u0438\u043b\u0438\u043f\u043f\u0438\u043d\u0441\u043a\u0438\u0439" },
            { "hmn", "\u0445\u043c\u043e\u043d\u0433" },
            { "del", "\u0434\u0435\u043b\u0430\u0432\u0430\u0440\u0441\u043a\u0438\u0439" },
            { "lus", "\u043c\u0438\u0437\u043e" },
            { "bal", "\u0431\u0435\u043b\u0443\u0434\u0436\u0441\u043a\u0438\u0439" },
            { "den", "\u0441\u043b\u0435\u0439\u0432\u0438" },
            { "ban", "\u0431\u0430\u043b\u0438\u0439\u0441\u043a\u0438\u0439" },
            { "uga", "\u0443\u0433\u0430\u0440\u0438\u0442\u0441\u043a\u0438\u0439" },
            { "luy", "\u043b\u0443\u0445\u044c\u044f" },
            { "bas", "\u0431\u0430\u0441\u0430" },
            { "bax", metaValue_bax },
            { "jrb", "\u0435\u0432\u0440\u0435\u0439\u0441\u043a\u043e-\u0430\u0440\u0430\u0431\u0441\u043a\u0438\u0439" },
            { "es_ES", "\u0435\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u043a\u0438\u0439 \u0438\u0441\u043f\u0430\u043d\u0441\u043a\u0438\u0439" },
            { "nzi", "\u043d\u0437\u0438\u043c\u0430" },
            { "sco", "\u0448\u043e\u0442\u043b\u0430\u043d\u0434\u0441\u043a\u0438\u0439" },
            { "scn", "\u0441\u0438\u0446\u0438\u043b\u0438\u0439\u0441\u043a\u0438\u0439" },
            { "aa", "\u0430\u0444\u0430\u0440\u0441\u043a\u0438\u0439" },
            { "ab", "\u0430\u0431\u0445\u0430\u0437\u0441\u043a\u0438\u0439" },
            { "Aran", "\u043d\u0430\u0441\u0442\u0430\u043b\u0438\u043a" },
            { "ae", "\u0430\u0432\u0435\u0441\u0442\u0438\u0439\u0441\u043a\u0438\u0439" },
            { "af", "\u0430\u0444\u0440\u0438\u043a\u0430\u0430\u043d\u0441" },
            { "ak", "\u0430\u043a\u0430\u043d" },
            { "type.nu.cakm", "\u0446\u0438\u0444\u0440\u044b \u0447\u0430\u043a\u043c\u0430" },
            { "bbj", "\u0433\u043e\u043c\u0430\u043b\u0430" },
            { "am", "\u0430\u043c\u0445\u0430\u0440\u0441\u043a\u0438\u0439" },
            { "an", "\u0430\u0440\u0430\u0433\u043e\u043d\u0441\u043a\u0438\u0439" },
            { "Arab", "\u0430\u0440\u0430\u0431\u0438\u0446\u0430" },
            { "Jpan", "\u044f\u043f\u043e\u043d\u0441\u043a\u0430\u044f" },
            { "ar", "\u0430\u0440\u0430\u0431\u0441\u043a\u0438\u0439" },
            { "Hrkt", "\u043a\u0430\u0442\u0430\u043a\u0430\u043d\u0430 \u0438 \u0445\u0438\u0440\u0430\u0433\u0430\u043d\u0430" },
            { "as", "\u0430\u0441\u0441\u0430\u043c\u0441\u043a\u0438\u0439" },
            { "Lina", "\u043b\u0438\u043d\u0435\u0439\u043d\u043e\u0435 \u043f\u0438\u0441\u044c\u043c\u043e \u0410" },
            { "av", "\u0430\u0432\u0430\u0440\u0441\u043a\u0438\u0439" },
            { "Linb", "\u043b\u0438\u043d\u0435\u0439\u043d\u043e\u0435 \u043f\u0438\u0441\u044c\u043c\u043e \u0411" },
            { "sdh", "\u044e\u0436\u043d\u043e\u043a\u0443\u0440\u0434\u0441\u043a\u0438\u0439" },
            { "ay", "\u0430\u0439\u043c\u0430\u0440\u0430" },
            { "az", "\u0430\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d\u0441\u043a\u0438\u0439" },
            { "Khoj", "\u0445\u043e\u0434\u0436\u0438\u043a\u0438" },
            { "ba", "\u0431\u0430\u0448\u043a\u0438\u0440\u0441\u043a\u0438\u0439" },
            { "type.co.unihan", "\u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u043f\u043e \u043a\u043b\u044e\u0447\u0430\u043c, \u0437\u0430\u0442\u0435\u043c \u043f\u043e \u0447\u0435\u0440\u0442\u0430\u043c" },
            { "be", "\u0431\u0435\u043b\u043e\u0440\u0443\u0441\u0441\u043a\u0438\u0439" },
            { "bg", "\u0431\u043e\u043b\u0433\u0430\u0440\u0441\u043a\u0438\u0439" },
            { "bi", "\u0431\u0438\u0441\u043b\u0430\u043c\u0430" },
            { "type.nu.java", "\u044f\u0432\u0430\u043d\u0441\u043a\u0438\u0435 \u0446\u0438\u0444\u0440\u044b" },
            { "bm", "\u0431\u0430\u043c\u0431\u0430\u0440\u0430" },
            { "bn", "\u0431\u0435\u043d\u0433\u0430\u043b\u044c\u0441\u043a\u0438\u0439" },
            { "bo", "\u0442\u0438\u0431\u0435\u0442\u0441\u043a\u0438\u0439" },
            { "dgr", "\u0434\u043e\u0433\u0440\u0438\u0431" },
            { "br", "\u0431\u0440\u0435\u0442\u043e\u043d\u0441\u043a\u0438\u0439" },
            { "bs", "\u0431\u043e\u0441\u043d\u0438\u0439\u0441\u043a\u0438\u0439" },
            { "see", "\u0441\u0435\u043d\u0435\u043a\u0430" },
            { "Mymr", "\u043c\u044c\u044f\u043d\u043c\u0430\u043d\u0441\u043a\u0430\u044f" },
            { "type.nu.laoo", "\u043b\u0430\u043e\u0441\u0441\u043a\u0438\u0435 \u0446\u0438\u0444\u0440\u044b" },
            { "seh", "\u0441\u0435\u043d\u0430" },
            { "Nkoo", metaValue_nqo },
            { "sel", "\u0441\u0435\u043b\u044c\u043a\u0443\u043f\u0441\u043a\u0438\u0439" },
            { "ca", "\u043a\u0430\u0442\u0430\u043b\u0430\u043d\u0441\u043a\u0438\u0439" },
            { "ses", "\u043a\u043e\u0439\u0440\u0430\u0431\u043e\u0440\u043e \u0441\u0435\u043d\u043d\u0438" },
            { "ce", "\u0447\u0435\u0447\u0435\u043d\u0441\u043a\u0438\u0439" },
            { "ch", "\u0447\u0430\u043c\u043e\u0440\u0440\u043e" },
            { "co", "\u043a\u043e\u0440\u0441\u0438\u043a\u0430\u043d\u0441\u043a\u0438\u0439" },
            { "Orya", metaValue_or },
            { "cr", "\u043a\u0440\u0438" },
            { "cs", "\u0447\u0435\u0448\u0441\u043a\u0438\u0439" },
            { "cu", "\u0446\u0435\u0440\u043a\u043e\u0432\u043d\u043e\u0441\u043b\u0430\u0432\u044f\u043d\u0441\u043a\u0438\u0439" },
            { "cv", "\u0447\u0443\u0432\u0430\u0448\u0441\u043a\u0438\u0439" },
            { "cy", "\u0432\u0430\u043b\u043b\u0438\u0439\u0441\u043a\u0438\u0439" },
            { "type.nu.ethi", "\u044d\u0444\u0438\u043e\u043f\u0441\u043a\u0438\u0435 \u0446\u0438\u0444\u0440\u044b" },
            { "Yiii", "\u0438" },
            { "da", "\u0434\u0430\u0442\u0441\u043a\u0438\u0439" },
            { "pt_PT", "\u0435\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u043a\u0438\u0439 \u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u044c\u0441\u043a\u0438\u0439" },
            { "de", "\u043d\u0435\u043c\u0435\u0446\u043a\u0438\u0439" },
            { "type.cf.standard", "\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442" },
            { "bej", "\u0431\u0435\u0434\u0436\u0430" },
            { "din", "\u0434\u0438\u043d\u043a\u0430" },
            { "Bugi", "\u0431\u0443\u0433\u0438\u043d\u0438\u0437\u0438\u0439\u0441\u043a\u0430\u044f" },
            { "bem", "\u0431\u0435\u043c\u0431\u0430" },
            { "sga", "\u0441\u0442\u0430\u0440\u043e\u0438\u0440\u043b\u0430\u043d\u0434\u0441\u043a\u0438\u0439" },
            { "type.nu.mong", "\u041c\u043e\u043d\u0433\u043e\u043b\u044c\u0441\u043a\u0438\u0435 \u0446\u0438\u0444\u0440\u044b" },
            { "dv", "\u043c\u0430\u043b\u044c\u0434\u0438\u0432\u0441\u043a\u0438\u0439" },
            { "es_419", "\u043b\u0430\u0442\u0438\u043d\u043e\u0430\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0438\u0439 \u0438\u0441\u043f\u0430\u043d\u0441\u043a\u0438\u0439" },
            { "dz", "\u0434\u0437\u043e\u043d\u0433-\u043a\u044d" },
            { "bez", "\u0431\u0435\u043d\u0430" },
            { "type.ca.chinese", "\u043a\u0438\u0442\u0430\u0439\u0441\u043a\u0438\u0439 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c" },
            { "Lisu", "\u043b\u0438\u0441\u0443" },
            { "dje", "\u0434\u0436\u0435\u0440\u043c\u0430" },
            { "type.nu.grek", "\u0433\u0440\u0435\u0447\u0435\u0441\u043a\u0438\u0435 \u0446\u0438\u0444\u0440\u044b" },
            { "ee", "\u044d\u0432\u0435" },
            { "bfd", "\u0431\u0430\u0444\u0443\u0442" },
            { "type.lb.normal", "\u043e\u0431\u044b\u0447\u043d\u044b\u0439 \u043f\u0435\u0440\u0435\u0432\u043e\u0434 \u0441\u0442\u0440\u043e\u043a\u0438" },
            { "ro_MD", "\u043c\u043e\u043b\u0434\u0430\u0432\u0441\u043a\u0438\u0439" },
            { "el", "\u0433\u0440\u0435\u0447\u0435\u0441\u043a\u0438\u0439" },
            { "en", "\u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439" },
            { "eo", "\u044d\u0441\u043f\u0435\u0440\u0430\u043d\u0442\u043e" },
            { "type.co.big5han", "\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u0442\u0440\u0430\u0434\u0438\u0446\u0438\u043e\u043d\u043d\u043e\u0433\u043e \u043a\u0438\u0442\u0430\u0439\u0441\u043a\u043e\u0433\u043e \u044f\u0437\u044b\u043a\u0430 \u2013 Big5" },
            { "es", "\u0438\u0441\u043f\u0430\u043d\u0441\u043a\u0438\u0439" },
            { "et", "\u044d\u0441\u0442\u043e\u043d\u0441\u043a\u0438\u0439" },
            { "Hanb", "\u0445\u0430\u043d\u044c\u0431" },
            { "eu", "\u0431\u0430\u0441\u043a\u0441\u043a\u0438\u0439" },
            { "Buhd", "\u0431\u0443\u0445\u0438\u0434" },
            { "Hang", "\u0445\u0430\u043d\u0433\u044b\u043b\u044c" },
            { "Samr", "\u0441\u0430\u043c\u0430\u0440\u0438\u0442\u044f\u043d\u0441\u043a\u0430\u044f" },
            { "shi", "\u0442\u0430\u0448\u0435\u043b\u044c\u0445\u0438\u0442" },
            { "hsb", "\u0432\u0435\u0440\u0445\u043d\u0435\u043b\u0443\u0436\u0438\u0446\u043a\u0438\u0439" },
            { "Hani", "\u043a\u0438\u0442\u0430\u0439\u0441\u043a\u0430\u044f" },
            { "shn", "\u0448\u0430\u043d\u0441\u043a\u0438\u0439" },
            { "Hano", "\u0445\u0430\u043d\u0443\u043d\u0443" },
            { "fa", "\u043f\u0435\u0440\u0441\u0438\u0434\u0441\u043a\u0438\u0439" },
            { "Hans", "\u0443\u043f\u0440\u043e\u0449\u0435\u043d\u043d\u0430\u044f \u043a\u0438\u0442\u0430\u0439\u0441\u043a\u0430\u044f" },
            { "type.nu.latn", "\u0441\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0435 \u0430\u0440\u0430\u0431\u0441\u043a\u0438\u0435 \u0446\u0438\u0444\u0440\u044b" },
            { "Hant", "\u0442\u0440\u0430\u0434\u0438\u0446\u0438\u043e\u043d\u043d\u0430\u044f \u043a\u0438\u0442\u0430\u0439\u0441\u043a\u0430\u044f" },
            { "ff", "\u0444\u0443\u043b\u0430\u0445" },
            { "shu", "\u0447\u0430\u0434\u0441\u043a\u0438\u0439 \u0430\u0440\u0430\u0431\u0441\u043a\u0438\u0439" },
            { "hsn", "\u0441\u044f\u043d" },
            { "fi", "\u0444\u0438\u043d\u0441\u043a\u0438\u0439" },
            { "fj", "\u0444\u0438\u0434\u0436\u0438" },
            { "fon", "\u0444\u043e\u043d" },
            { "bgn", "\u0437\u0430\u043f\u0430\u0434\u043d\u044b\u0439 \u0431\u0435\u043b\u0443\u0434\u0436\u0441\u043a\u0438\u0439" },
            { "yue", "\u043a\u0430\u043d\u0442\u043e\u043d\u0441\u043a\u0438\u0439" },
            { "fo", "\u0444\u0430\u0440\u0435\u0440\u0441\u043a\u0438\u0439" },
            { "type.m0.bgn", "\u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u0442\u0440\u0430\u043d\u0441\u043b\u0438\u0442\u0435\u0440\u0430\u0446\u0438\u0438 BGN" },
            { "umb", "\u0443\u043c\u0431\u0443\u043d\u0434\u0443" },
            { "fr", "\u0444\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0438\u0439" },
            { "sid", "\u0441\u0438\u0434\u0430\u043c\u0430" },
            { "fy", "\u0437\u0430\u043f\u0430\u0434\u043d\u043e\u0444\u0440\u0438\u0437\u0441\u043a\u0438\u0439" },
            { "ga", "\u0438\u0440\u043b\u0430\u043d\u0434\u0441\u043a\u0438\u0439" },
            { "gd", "\u0433\u044d\u043b\u044c\u0441\u043a\u0438\u0439" },
            { "gl", "\u0433\u0430\u043b\u0438\u0441\u0438\u0439\u0441\u043a\u0438\u0439" },
            { "gn", "\u0433\u0443\u0430\u0440\u0430\u043d\u0438" },
            { "bho", "\u0431\u0445\u043e\u0434\u0436\u043f\u0443\u0440\u0438" },
            { "und", "\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u044f\u0437\u044b\u043a" },
            { "type.ca.ethiopic-amete-alem", "\u042d\u0444\u0438\u043e\u043f\u0441\u043a\u0438\u0439 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c \"\u0410\u043c\u0435\u0442\u0435 \u0410\u043b\u0435\u043c\"" },
            { "gu", metaValue_gu },
            { "type.ca.islamic-tbla", "\u0438\u0441\u043b\u0430\u043c\u0441\u043a\u0438\u0439 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c (\u0442\u0430\u0431\u043b\u0438\u0447\u043d\u044b\u0439, \u0430\u0441\u0442\u0440\u043e\u043d\u043e\u043c\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u044d\u043f\u043e\u0445\u0430)" },
            { "gv", "\u043c\u044d\u043d\u0441\u043a\u0438\u0439" },
            { "type.nu.osma", "\u0446\u0438\u0444\u0440\u044b \u043e\u0441\u043c\u0430\u043d\u044c\u044f" },
            { "ha", "\u0445\u0430\u0443\u0441\u0430" },
            { "he", "\u0438\u0432\u0440\u0438\u0442" },
            { "hi", "\u0445\u0438\u043d\u0434\u0438" },
            { "hup", "\u0445\u0443\u043f\u0430" },
            { "bik", "\u0431\u0438\u043a\u043e\u043b\u044c\u0441\u043a\u0438\u0439" },
            { "bin", "\u0431\u0438\u043d\u0438" },
            { "ho", "\u0445\u0438\u0440\u0438\u043c\u043e\u0442\u0443" },
            { "hr", "\u0445\u043e\u0440\u0432\u0430\u0442\u0441\u043a\u0438\u0439" },
            { "ht", "\u0433\u0430\u0438\u0442\u044f\u043d\u0441\u043a\u0438\u0439" },
            { "hu", "\u0432\u0435\u043d\u0433\u0435\u0440\u0441\u043a\u0438\u0439" },
            { "hy", "\u0430\u0440\u043c\u044f\u043d\u0441\u043a\u0438\u0439" },
            { "hz", "\u0433\u0435\u0440\u0435\u0440\u043e" },
            { "frc", "\u043a\u0430\u0434\u0436\u0443\u043d\u0441\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0438\u0439" },
            { "%%FONIPA", "\u041c\u0435\u0436\u0434\u0443\u043d\u0430\u0440\u043e\u0434\u043d\u044b\u0439 \u0444\u043e\u043d\u0435\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0430\u043b\u0444\u0430\u0432\u0438\u0442" },
            { "ia", "\u0438\u043d\u0442\u0435\u0440\u043b\u0438\u043d\u0433\u0432\u0430" },
            { "Jamo", "\u0434\u0436\u0430\u043c\u043e" },
            { "id", "\u0438\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u0439\u0441\u043a\u0438\u0439" },
            { "type.nu.tibt", "\u0442\u0438\u0431\u0435\u0442\u0441\u043a\u0438\u0435 \u0446\u0438\u0444\u0440\u044b" },
            { "ie", "\u0438\u043d\u0442\u0435\u0440\u043b\u0438\u043d\u0433\u0432\u0435" },
            { "ig", "\u0438\u0433\u0431\u043e" },
            { "ii", "\u043d\u043e\u0441\u0443" },
            { "frm", "\u0441\u0440\u0435\u0434\u043d\u0435\u0444\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0438\u0439" },
            { "ik", "\u0438\u043d\u0443\u043f\u0438\u0430\u043a" },
            { "fro", "\u0441\u0442\u0430\u0440\u043e\u0444\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0438\u0439" },
            { "io", "\u0438\u0434\u043e" },
            { "frs", "\u0432\u043e\u0441\u0442\u043e\u0447\u043d\u044b\u0439 \u0444\u0440\u0438\u0437\u0441\u043a\u0438\u0439" },
            { "frr", "\u0441\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u0440\u0438\u0437\u0441\u043a\u0438\u0439" },
            { "is", "\u0438\u0441\u043b\u0430\u043d\u0434\u0441\u043a\u0438\u0439" },
            { "it", "\u0438\u0442\u0430\u043b\u044c\u044f\u043d\u0441\u043a\u0438\u0439" },
            { "iu", "\u0438\u043d\u0443\u043a\u0442\u0438\u0442\u0443\u0442" },
            { "Mlym", metaValue_ml },
            { "ja", "\u044f\u043f\u043e\u043d\u0441\u043a\u0438\u0439" },
            { "Sarb", "\u0441\u0442\u0430\u0440\u043e\u044e\u0436\u043d\u043e\u0430\u0440\u0430\u0431\u0441\u043a\u0430\u044f" },
            { "Sara", "\u0441\u0430\u0440\u0430\u0442\u0438" },
            { "doi", "\u0434\u043e\u0433\u0440\u0438" },
            { "type.nu.lepc", "\u0446\u0438\u0444\u0440\u044b \u043b\u0435\u043f\u0447\u0430" },
            { "bkm", "\u043a\u043e\u043c" },
            { "sma", "\u044e\u0436\u043d\u043e\u0441\u0430\u0430\u043c\u0441\u043a\u0438\u0439" },
            { "jv", "\u044f\u0432\u0430\u043d\u0441\u043a\u0438\u0439" },
            { "Shaw", "\u0430\u043b\u0444\u0430\u0432\u0438\u0442 \u0428\u043e\u0443" },
            { "mad", "\u043c\u0430\u0434\u0443\u0440\u0441\u043a\u0438\u0439" },
            { "smj", "\u043b\u0443\u043b\u0435-\u0441\u0430\u0430\u043c\u0441\u043a\u0438\u0439" },
            { "mag", "\u043c\u0430\u0433\u0430\u0445\u0438" },
            { "maf", "\u043c\u0430\u0444\u0430" },
            { "mai", "\u043c\u0430\u0439\u0442\u0445\u0438\u043b\u0438" },
            { "smn", "\u0438\u043d\u0430\u0440\u0438-\u0441\u0430\u0430\u043c\u0441\u043a\u0438\u0439" },
            { "ka", "\u0433\u0440\u0443\u0437\u0438\u043d\u0441\u043a\u0438\u0439" },
            { "bla", "\u0441\u0438\u043a\u0441\u0438\u043a\u0430" },
            { "mak", "\u043c\u0430\u043a\u0430\u0441\u0441\u0430\u0440\u0441\u043a\u0438\u0439" },
            { "wuu", "\u0432\u0443" },
            { "sms", "\u043a\u043e\u043b\u0442\u0442\u0430-\u0441\u0430\u0430\u043c\u0441\u043a\u0438\u0439" },
            { "man", "\u043c\u0430\u043d\u0434\u0438\u043d\u0433\u043e" },
            { "kg", "\u043a\u043e\u043d\u0433\u043e" },
            { "Goth", "\u0433\u043e\u0442\u0441\u043a\u0430\u044f" },
            { "ki", "\u043a\u0438\u043a\u0443\u0439\u044e" },
            { "mas", "\u043c\u0430\u0441\u0430\u0438" },
            { "kj", "\u043a\u0443\u043d\u0430\u043c\u0430" },
            { "kk", "\u043a\u0430\u0437\u0430\u0445\u0441\u043a\u0438\u0439" },
            { "kl", "\u0433\u0440\u0435\u043d\u043b\u0430\u043d\u0434\u0441\u043a\u0438\u0439" },
            { "km", "\u043a\u0445\u043c\u0435\u0440\u0441\u043a\u0438\u0439" },
            { "kn", metaValue_kn },
            { "ko", "\u043a\u043e\u0440\u0435\u0439\u0441\u043a\u0438\u0439" },
            { "kr", "\u043a\u0430\u043d\u0443\u0440\u0438" },
            { "ks", "\u043a\u0430\u0448\u043c\u0438\u0440\u0438" },
            { "Cirt", "\u043a\u0438\u0440\u0442" },
            { "Lepc", "\u043b\u0435\u043f\u0445\u0430" },
            { "Avst", "\u0430\u0432\u0435\u0441\u0442\u0438\u0439\u0441\u043a\u0430\u044f" },
            { "ku", "\u043a\u0443\u0440\u0434\u0441\u043a\u0438\u0439" },
            { "kv", "\u043a\u043e\u043c\u0438" },
            { "kw", "\u043a\u043e\u0440\u043d\u0441\u043a\u0438\u0439" },
            { "ky", "\u043a\u0438\u0440\u0433\u0438\u0437\u0441\u043a\u0438\u0439" },
            { "snk", "\u0441\u043e\u043d\u0438\u043d\u043a\u0435" },
            { "la", "\u043b\u0430\u0442\u0438\u043d\u0441\u043a\u0438\u0439" },
            { "lb", "\u043b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433\u0441\u043a\u0438\u0439" },
            { "type.nu.mlym", "\u0446\u0438\u0444\u0440\u044b \u043c\u0430\u043b\u0430\u044f\u043b\u0430\u043c" },
            { "lg", "\u0433\u0430\u043d\u0434\u0430" },
            { "Roro", "\u0440\u043e\u043d\u0433\u043e-\u0440\u043e\u043d\u0433\u043e" },
            { "li", "\u043b\u0438\u043c\u0431\u0443\u0440\u0433\u0441\u043a\u0438\u0439" },
            { "Tibt", "\u0442\u0438\u0431\u0435\u0442\u0441\u043a\u0430\u044f" },
            { "ln", "\u043b\u0438\u043d\u0433\u0430\u043b\u0430" },
            { "fur", "\u0444\u0440\u0438\u0443\u043b\u044c\u0441\u043a\u0438\u0439" },
            { "lo", "\u043b\u0430\u043e\u0441\u0441\u043a\u0438\u0439" },
            { "type.ms.uksystem", "\u0431\u0440\u0438\u0442\u0430\u043d\u0441\u043a\u0430\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u043c\u0435\u0440" },
            { "type.nu.lana", "\u0446\u0438\u0444\u0440\u044b \u0442\u0430\u0439 \u0442\u0430\u043c \u0445\u043e\u0440\u0430" },
            { "lt", "\u043b\u0438\u0442\u043e\u0432\u0441\u043a\u0438\u0439" },
            { "lu", "\u043b\u0443\u0431\u0430-\u043a\u0430\u0442\u0430\u043d\u0433\u0430" },
            { "lv", "\u043b\u0430\u0442\u044b\u0448\u0441\u043a\u0438\u0439" },
            { "sog", "\u0441\u043e\u0433\u0434\u0438\u0439\u0441\u043a\u0438\u0439" },
            { "mg", "\u043c\u0430\u043b\u0430\u0433\u0430\u0441\u0438\u0439\u0441\u043a\u0438\u0439" },
            { "mh", "\u043c\u0430\u0440\u0448\u0430\u043b\u043b\u044c\u0441\u043a\u0438\u0439" },
            { "type.co.ducet", "c\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u0430\u044f \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 Unicode" },
            { "mi", "\u043c\u0430\u043e\u0440\u0438" },
            { "mk", "\u043c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u043a\u0438\u0439" },
            { "ml", metaValue_ml },
            { "mn", "\u043c\u043e\u043d\u0433\u043e\u043b\u044c\u0441\u043a\u0438\u0439" },
            { "mr", "\u043c\u0430\u0440\u0430\u0442\u0445\u0438" },
            { "ms", "\u043c\u0430\u043b\u0430\u0439\u0441\u043a\u0438\u0439" },
            { "mt", "\u043c\u0430\u043b\u044c\u0442\u0438\u0439\u0441\u043a\u0438\u0439" },
            { "my", "\u0431\u0438\u0440\u043c\u0430\u043d\u0441\u043a\u0438\u0439" },
            { "Saur", "\u0441\u0430\u0443\u0440\u0430\u0448\u0442\u0440\u0430" },
            { "Armn", "\u0430\u0440\u043c\u044f\u043d\u0441\u043a\u0430\u044f" },
            { "mdf", "\u043c\u043e\u043a\u0448\u0430\u043d\u0441\u043a\u0438\u0439" },
            { "mde", "\u043c\u0430\u0431\u0430" },
            { "dsb", "\u043d\u0438\u0436\u043d\u0435\u043b\u0443\u0436\u0438\u0446\u043a\u0438\u0439" },
            { "Armi", "\u0430\u0440\u0430\u043c\u0435\u0439\u0441\u043a\u0430\u044f" },
            { "na", "\u043d\u0430\u0443\u0440\u0443" },
            { "type.co.search", "\u043f\u043e\u0438\u0441\u043a" },
            { "nb", "\u043d\u043e\u0440\u0432\u0435\u0436\u0441\u043a\u0438\u0439 \u0431\u0443\u043a\u043c\u043e\u043b" },
            { "nd", "\u0441\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043d\u0434\u0435\u0431\u0435\u043b\u0435" },
            { "ne", "\u043d\u0435\u043f\u0430\u043b\u044c\u0441\u043a\u0438\u0439" },
            { "ng", "\u043d\u0434\u043e\u043d\u0433\u0430" },
            { "mdr", "\u043c\u0430\u043d\u0434\u0430\u0440\u0441\u043a\u0438\u0439" },
            { "nl", "\u043d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u0441\u043a\u0438\u0439" },
            { "nn", "\u043d\u044e\u043d\u043e\u0440\u0441\u043a" },
            { "no", "\u043d\u043e\u0440\u0432\u0435\u0436\u0441\u043a\u0438\u0439" },
            { "nr", "\u044e\u0436\u043d\u044b\u0439 \u043d\u0434\u0435\u0431\u0435\u043b\u0435" },
            { "nv", "\u043d\u0430\u0432\u0430\u0445\u043e" },
            { "kaa", "\u043a\u0430\u0440\u0430\u043a\u0430\u043b\u043f\u0430\u043a\u0441\u043a\u0438\u0439" },
            { "ny", "\u043d\u044c\u044f\u043d\u0434\u0436\u0430" },
            { "kac", "\u043a\u0430\u0447\u0438\u043d\u0441\u043a\u0438\u0439" },
            { "kab", "\u043a\u0430\u0431\u0438\u043b\u044c\u0441\u043a\u0438\u0439" },
            { "%%POLYTON", "\u041c\u043d\u043e\u0433\u043e\u0442\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0439" },
            { "oc", "\u043e\u043a\u0441\u0438\u0442\u0430\u043d\u0441\u043a\u0438\u0439" },
            { "kaj", "\u043a\u0430\u0434\u0436\u0438" },
            { "kam", "\u043a\u0430\u043c\u0431\u0430" },
            { "men", metaValue_men },
            { "oj", "\u043e\u0434\u0436\u0438\u0431\u0432\u0430" },
            { "mer", "\u043c\u0435\u0440\u0443" },
            { "type.nu.armn", "\u0430\u0440\u043c\u044f\u043d\u0441\u043a\u0438\u0435 \u0446\u0438\u0444\u0440\u044b" },
            { "om", "\u043e\u0440\u043e\u043c\u043e" },
            { "kaw", "\u043a\u0430\u0432\u0438" },
            { "or", metaValue_or },
            { "os", "\u043e\u0441\u0435\u0442\u0438\u043d\u0441\u043a\u0438\u0439" },
            { "kbd", "\u043a\u0430\u0431\u0430\u0440\u0434\u0438\u043d\u0441\u043a\u0438\u0439" },
            { "mfe", "\u043c\u0430\u0432\u0440\u0438\u043a\u0438\u0439\u0441\u043a\u0438\u0439 \u043a\u0440\u0435\u043e\u043b\u044c\u0441\u043a\u0438\u0439" },
            { "srn", "\u0441\u0440\u0430\u043d\u0430\u043d-\u0442\u043e\u043d\u0433\u043e" },
            { "pa", "\u043f\u0430\u043d\u0434\u0436\u0430\u0431\u0438" },
            { "dua", "\u0434\u0443\u0430\u043b\u0430" },
            { "srr", "\u0441\u0435\u0440\u0435\u0440" },
            { "kbl", "\u043a\u0430\u043d\u0435\u043c\u0431\u0443" },
            { "pi", "\u043f\u0430\u043b\u0438" },
            { "pl", "\u043f\u043e\u043b\u044c\u0441\u043a\u0438\u0439" },
            { "dum", "\u0441\u0440\u0435\u0434\u043d\u0435\u043d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u0441\u043a\u0438\u0439" },
            { "type.nu.saur", "\u0446\u0438\u0444\u0440\u044b \u0441\u0430\u0443\u0440\u0430\u0448\u0442\u0440\u0430" },
            { "type.ca.dangi", "\u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c \u0434\u0430\u043d\u0433\u0438" },
            { "ps", "\u043f\u0443\u0448\u0442\u0443" },
            { "pt", "\u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u044c\u0441\u043a\u0438\u0439" },
            { "mga", "\u0441\u0440\u0435\u0434\u043d\u0435\u0438\u0440\u043b\u0430\u043d\u0434\u0441\u043a\u0438\u0439" },
            { "key.co", "\u043f\u043e\u0440\u044f\u0434\u043e\u043a \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438" },
            { "pt_BR", "\u0431\u0440\u0430\u0437\u0438\u043b\u044c\u0441\u043a\u0438\u0439 \u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u044c\u0441\u043a\u0438\u0439" },
            { "kcg", "\u0442\u044c\u044f\u043f" },
            { "mgh", "\u043c\u0430\u043a\u0443\u0430-\u043c\u0435\u0435\u0442\u0442\u043e" },
            { "key.cf", "\u0444\u043e\u0440\u043c\u0430\u0442 \u0432\u0430\u043b\u044e\u0442\u044b" },
            { "type.nu.nkoo", "\u0446\u0438\u0444\u0440\u044b \u043d\u043a\u043e" },
            { "bra", "\u0431\u0440\u0430\u0443\u0438" },
            { "key.ca", "\u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c" },
            { "Laoo", "\u043b\u0430\u043e\u0441\u0441\u043a\u0430\u044f" },
            { "mgo", "\u043c\u0435\u0442\u0430" },
            { "type.hc.h23", "24-\u0447\u0430\u0441\u043e\u0432\u043e\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 (0\u201323)" },
            { "type.hc.h24", "24-\u0447\u0430\u0441\u043e\u0432\u043e\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 (1\u201324)" },
            { "ssy", "\u0441\u0430\u0445\u043e" },
            { "type.nu.mymr", "\u0431\u0438\u0440\u043c\u0430\u043d\u0441\u043a\u0438\u0435 \u0446\u0438\u0444\u0440\u044b" },
            { "qu", "\u043a\u0435\u0447\u0443\u0430" },
            { "zap", "\u0441\u0430\u043f\u043e\u0442\u0435\u043a\u0441\u043a\u0438\u0439" },
            { "brx", "\u0431\u043e\u0434\u043e" },
            { "Lana", "\u043b\u0430\u043d\u043d\u0430" },
            { "kde", "\u043c\u0430\u043a\u043e\u043d\u0434\u0435" },
            { "Ethi", "\u044d\u0444\u0438\u043e\u043f\u0441\u043a\u0430\u044f" },
            { "type.hc.h12", "12-\u0447\u0430\u0441\u043e\u0432\u043e\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 (1\u201312)" },
            { "type.hc.h11", "12-\u0447\u0430\u0441\u043e\u0432\u043e\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 (0\u201311)" },
            { "rm", "\u0440\u043e\u043c\u0430\u043d\u0448\u0441\u043a\u0438\u0439" },
            { "rn", "\u0440\u0443\u043d\u0434\u0438" },
            { "key.cu", "\u0432\u0430\u043b\u044e\u0442\u0430" },
            { "ro", "\u0440\u0443\u043c\u044b\u043d\u0441\u043a\u0438\u0439" },
            { "%%SAAHO", "\u0421\u0430\u0445\u043e" },
            { "type.nu.orya", "\u0446\u0438\u0444\u0440\u044b \u043e\u0440\u0438\u044f" },
            { "type.nu.hanidec", "\u043a\u0438\u0442\u0430\u0439\u0441\u043a\u0438\u0435 \u0434\u0435\u0441\u044f\u0442\u0438\u0447\u043d\u044b\u0435 \u0446\u0438\u0444\u0440\u044b" },
            { "ru", "\u0440\u0443\u0441\u0441\u043a\u0438\u0439" },
            { "bss", "\u0430\u043a\u043e\u043e\u0441\u0435" },
            { "zbl", metaValue_zbl },
            { "rw", "\u043a\u0438\u043d\u044c\u044f\u0440\u0443\u0430\u043d\u0434\u0430" },
            { "kea", "\u043a\u0430\u0431\u0443\u0432\u0435\u0440\u0434\u044c\u044f\u043d\u0443" },
            { "mic", "\u043c\u0438\u043a\u043c\u0430\u043a" },
            { "suk", "\u0441\u0443\u043a\u0443\u043c\u0430" },
            { "en_AU", "\u0430\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u0439\u0441\u043a\u0438\u0439 \u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439" },
            { "Dupl", "\u0434\u0443\u043f\u043b\u043e\u044f\u043d\u0441\u043a\u0430\u044f \u0441\u043a\u043e\u0440\u043e\u043f\u0438\u0441\u044c" },
            { "sa", "\u0441\u0430\u043d\u0441\u043a\u0440\u0438\u0442" },
            { "sc", "\u0441\u0430\u0440\u0434\u0438\u043d\u0441\u043a\u0438\u0439" },
            { "sus", "\u0441\u0443\u0441\u0443" },
            { "sd", "\u0441\u0438\u043d\u0434\u0445\u0438" },
            { "se", "\u0441\u0435\u0432\u0435\u0440\u043d\u043e\u0441\u0430\u0430\u043c\u0441\u043a\u0438\u0439" },
            { "min", "\u043c\u0438\u043d\u0430\u043d\u0433\u043a\u0430\u0431\u0430\u0443" },
            { "sg", "\u0441\u0430\u043d\u0433\u043e" },
            { "sh", "\u0441\u0435\u0440\u0431\u0441\u043a\u043e\u0445\u043e\u0440\u0432\u0430\u0442\u0441\u043a\u0438\u0439" },
            { "si", "\u0441\u0438\u043d\u0433\u0430\u043b\u044c\u0441\u043a\u0438\u0439" },
            { "sux", "\u0448\u0443\u043c\u0435\u0440\u0441\u043a\u0438\u0439" },
            { "sk", "\u0441\u043b\u043e\u0432\u0430\u0446\u043a\u0438\u0439" },
            { "sl", "\u0441\u043b\u043e\u0432\u0435\u043d\u0441\u043a\u0438\u0439" },
            { "Gran", "\u0433\u0440\u0430\u043d\u0442\u0445\u0430" },
            { "sm", "\u0441\u0430\u043c\u043e\u0430\u043d\u0441\u043a\u0438\u0439" },
            { "sn", "\u0448\u043e\u043d\u0430" },
            { "so", "\u0441\u043e\u043c\u0430\u043b\u0438" },
            { "type.nu.arab", "\u0430\u0440\u0430\u0431\u0441\u043a\u043e-\u0438\u043d\u0434\u0438\u0439\u0441\u043a\u0438\u0435 \u0446\u0438\u0444\u0440\u044b" },
            { "sq", "\u0430\u043b\u0431\u0430\u043d\u0441\u043a\u0438\u0439" },
            { "sr", "\u0441\u0435\u0440\u0431\u0441\u043a\u0438\u0439" },
            { "ss", "\u0441\u0432\u0430\u0437\u0438" },
            { "type.cf.account", "\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442" },
            { "st", "\u044e\u0436\u043d\u044b\u0439 \u0441\u043e\u0442\u043e" },
            { "Java", "\u044f\u0432\u0430\u043d\u0441\u043a\u0430\u044f" },
            { "su", "\u0441\u0443\u043d\u0434\u0430\u043d\u0441\u043a\u0438\u0439" },
            { "sv", "\u0448\u0432\u0435\u0434\u0441\u043a\u0438\u0439" },
            { "sw", "\u0441\u0443\u0430\u0445\u0438\u043b\u0438" },
            { "type.nu.hantfin", "\u043a\u0438\u0442\u0430\u0439\u0441\u043a\u0438\u0435 \u0442\u0440\u0430\u0434\u0438\u0446\u0438\u043e\u043d\u043d\u044b\u0435 \u0446\u0438\u0444\u0440\u044b (\u0444\u0438\u043d\u0430\u043d\u0441\u044b)" },
            { "ibb", "\u0438\u0431\u0438\u0431\u0438\u043e" },
            { "iba", "\u0438\u0431\u0430\u043d\u0441\u043a\u0438\u0439" },
            { "ta", "\u0442\u0430\u043c\u0438\u043b\u044c\u0441\u043a\u0438\u0439" },
            { "142", "\u0410\u0437\u0438\u044f" },
            { "bua", "\u0431\u0443\u0440\u044f\u0442\u0441\u043a\u0438\u0439" },
            { "143", "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u0410\u0437\u0438\u044f" },
            { "te", metaValue_te },
            { "145", "\u0417\u0430\u043f\u0430\u0434\u043d\u0430\u044f \u0410\u0437\u0438\u044f" },
            { "tg", "\u0442\u0430\u0434\u0436\u0438\u043a\u0441\u043a\u0438\u0439" },
            { "th", "\u0442\u0430\u0439\u0441\u043a\u0438\u0439" },
            { "ti", "\u0442\u0438\u0433\u0440\u0438\u043d\u044c\u044f" },
            { "bug", "\u0431\u0443\u0433\u0438\u0439\u0441\u043a\u0438\u0439" },
            { "kfo", "\u043a\u043e\u0440\u043e" },
            { "en_CA", "\u043a\u0430\u043d\u0430\u0434\u0441\u043a\u0438\u0439 \u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439" },
            { "tk", "\u0442\u0443\u0440\u043a\u043c\u0435\u043d\u0441\u043a\u0438\u0439" },
            { "tl", metaValue_tl },
            { "tn", "\u0442\u0441\u0432\u0430\u043d\u0430" },
            { "to", "\u0442\u043e\u043d\u0433\u0430\u043d\u0441\u043a\u0438\u0439" },
            { "bum", "\u0431\u0443\u043b\u0443" },
            { "dyo", "\u0434\u0438\u043e\u043b\u0430-\u0444\u043e\u043d\u044c\u0438" },
            { "type.nu.jpan", "\u044f\u043f\u043e\u043d\u0441\u043a\u0438\u0435 \u0446\u0438\u0444\u0440\u044b" },
            { "tr", "\u0442\u0443\u0440\u0435\u0446\u043a\u0438\u0439" },
            { "ts", "\u0442\u0441\u043e\u043d\u0433\u0430" },
            { "swb", "\u043a\u043e\u043c\u043e\u0440\u0441\u043a\u0438\u0439" },
            { "Cakm", "\u0447\u0430\u043a\u043c\u0438\u0439\u0441\u043a\u0430\u044f" },
            { "tt", "\u0442\u0430\u0442\u0430\u0440\u0441\u043a\u0438\u0439" },
            { "dyu", "\u0434\u0438\u0443\u043b\u0430" },
            { "tw", "\u0442\u0432\u0438" },
            { "ty", "\u0442\u0430\u0438\u0442\u044f\u043d\u0441\u043a\u0438\u0439" },
            { "150", "\u0415\u0432\u0440\u043e\u043f\u0430" },
            { "151", "\u0412\u043e\u0441\u0442\u043e\u0447\u043d\u0430\u044f \u0415\u0432\u0440\u043e\u043f\u0430" },
            { "154", "\u0421\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u0415\u0432\u0440\u043e\u043f\u0430" },
            { "dzg", "\u0434\u0430\u0437\u0430" },
            { "155", "\u0417\u0430\u043f\u0430\u0434\u043d\u0430\u044f \u0415\u0432\u0440\u043e\u043f\u0430" },
            { "ug", "\u0443\u0439\u0433\u0443\u0440\u0441\u043a\u0438\u0439" },
            { "Ital", "\u0441\u0442\u0430\u0440\u043e\u0438\u0442\u0430\u043b\u044c\u044f\u043d\u0441\u043a\u0430\u044f" },
            { "Kore", "\u043a\u043e\u0440\u0435\u0439\u0441\u043a\u0430\u044f" },
            { "Zyyy", "\u043e\u0431\u0449\u0435\u043f\u0440\u0438\u043d\u044f\u0442\u0430\u044f" },
            { "uk", "\u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u0438\u0439" },
            { "type.ca.coptic", "\u041a\u043e\u043f\u0442\u0441\u043a\u0438\u0439 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c" },
            { "ur", "\u0443\u0440\u0434\u0443" },
            { "%%1994", "\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u0430\u044f \u0440\u0435\u0437\u044c\u044f\u043d\u0441\u043a\u0430\u044f \u043e\u0440\u0444\u043e\u0433\u0440\u0430\u0444\u0438\u044f" },
            { "xal", "\u043a\u0430\u043b\u043c\u044b\u0446\u043a\u0438\u0439" },
            { "zen", "\u0437\u0435\u043d\u0430\u0433\u0441\u043a\u0438\u0439" },
            { "uz", "\u0443\u0437\u0431\u0435\u043a\u0441\u043a\u0438\u0439" },
            { "kha", "\u043a\u0445\u0430\u0441\u0438" },
            { "%%1996", "\u041f\u0440\u0430\u0432\u0438\u043b\u0430 \u043d\u0435\u043c\u0435\u0446\u043a\u043e\u0439 \u043e\u0440\u0444\u043e\u0433\u0440\u0430\u0444\u0438\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u0441 1996 \u0433\u043e\u0434\u0430" },
            { "nds_NL", "\u043d\u0438\u0436\u043d\u0435\u0441\u0430\u043a\u0441\u043e\u043d\u0441\u043a\u0438\u0439" },
            { "Sylo", "\u0441\u0438\u043b\u043e\u0442\u0438 \u043d\u0430\u0433\u0440\u0438" },
            { "ve", "\u0432\u0435\u043d\u0434\u0430" },
            { "Wara", "\u0432\u0430\u0440\u0430\u043d\u0433-\u043a\u0448\u0438\u0442\u0438" },
            { "type.ca.roc", "\u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c \u041c\u0438\u043d\u044c\u0433\u043e" },
            { "vi", "\u0432\u044c\u0435\u0442\u043d\u0430\u043c\u0441\u043a\u0438\u0439" },
            { "kho", "\u0445\u043e\u0442\u0430\u043d\u0441\u043a\u0438\u0439" },
            { "khq", "\u043a\u043e\u0439\u0440\u0430 \u0447\u0438\u0438\u043d\u0438" },
            { "key.hc", "\u0444\u043e\u0440\u043c\u0430\u0442 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 (12- \u0438\u043b\u0438 24-\u0447\u0430\u0441\u043e\u0432\u043e\u0439)" },
            { "%%TARASK", "\u0422\u0430\u0440\u0430\u0448\u043a\u0435\u0432\u0438\u0446\u0430" },
            { "vo", "\u0432\u043e\u043b\u0430\u043f\u044e\u043a" },
            { "syc", "\u043a\u043b\u0430\u0441\u0441\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0441\u0438\u0440\u0438\u0439\u0441\u043a\u0438\u0439" },
            { "Osma", "\u043e\u0441\u043c\u0430\u043d\u0441\u043a\u0430\u044f" },
            { "quc", "\u043a\u0438\u0447\u0435" },
            { "gaa", "\u0433\u0430" },
            { "wa", "\u0432\u0430\u043b\u043b\u043e\u043d\u0441\u043a\u0438\u0439" },
            { "gag", "\u0433\u0430\u0433\u0430\u0443\u0437\u0441\u043a\u0438\u0439" },
            { "syr", "\u0441\u0438\u0440\u0438\u0439\u0441\u043a\u0438\u0439" },
            { "Grek", "\u0433\u0440\u0435\u0447\u0435\u0441\u043a\u0430\u044f" },
            { "gan", "\u0433\u0430\u043d\u044c" },
            { "Lydi", "\u043b\u0438\u0434\u0438\u0439\u0441\u043a\u0430\u044f" },
            { "Xsux", "\u0448\u0443\u043c\u0435\u0440\u043e-\u0430\u043a\u043a\u0430\u0434\u0441\u043a\u0430\u044f \u043a\u043b\u0438\u043d\u043e\u043f\u0438\u0441\u044c" },
            { "wo", "\u0432\u043e\u043b\u043e\u0444" },
            { "zgh", "\u0442\u0430\u043c\u0430\u0437\u0438\u0433\u0445\u0442\u0441\u043a\u0438\u0439" },
            { "ar_001", "\u0430\u0440\u0430\u0431\u0441\u043a\u0438\u0439 \u043b\u0438\u0442\u0435\u0440\u0430\u0442\u0443\u0440\u043d\u044b\u0439" },
            { "Cans", "\u043a\u0430\u043d\u0430\u0434\u0441\u043a\u043e\u0435 \u0441\u043b\u043e\u0433\u043e\u0432\u043e\u0435 \u043f\u0438\u0441\u044c\u043c\u043e" },
            { "gay", "\u0433\u0430\u0439\u043e" },
            { "Mong", "\u043c\u043e\u043d\u0433\u043e\u043b\u044c\u0441\u043a\u0430\u044f" },
            { "mnc", "\u043c\u0430\u043d\u044c\u0447\u0436\u0443\u0440\u0441\u043a\u0438\u0439" },
            { "Latf", "\u043b\u0430\u0442\u0438\u043d\u0441\u043a\u0430\u044f \u0444\u0440\u0430\u043a\u0442\u0443\u0440\u0430" },
            { "Hluw", "\u043b\u0443\u0432\u0438\u0439\u0441\u043a\u0438\u0435 \u0438\u0435\u0440\u043e\u0433\u043b\u0438\u0444\u044b" },
            { "gba", "\u0433\u0431\u0430\u044f" },
            { "mni", "\u043c\u0430\u043d\u0438\u043f\u0443\u0440\u0441\u043a\u0438\u0439" },
            { "Latn", "\u043b\u0430\u0442\u0438\u043d\u0438\u0446\u0430" },
            { "Latg", "\u0433\u044d\u043b\u044c\u0441\u043a\u0430\u044f \u043b\u0430\u0442\u0438\u043d\u0441\u043a\u0430\u044f" },
            { "type.nu.hans", "\u043a\u0438\u0442\u0430\u0439\u0441\u043a\u0438\u0435 \u0443\u043f\u0440\u043e\u0449\u0435\u043d\u043d\u044b\u0435 \u0446\u0438\u0444\u0440\u044b" },
            { "type.nu.hant", "\u043a\u0438\u0442\u0430\u0439\u0441\u043a\u0438\u0435 \u0442\u0440\u0430\u0434\u0438\u0446\u0438\u043e\u043d\u043d\u044b\u0435 \u0446\u0438\u0444\u0440\u044b" },
            { "xh", "\u043a\u043e\u0441\u0430" },
            { "type.nu.romanlow", "\u0440\u0438\u043c\u0441\u043a\u0438\u0435 \u0446\u0438\u0444\u0440\u044b \u0432 \u043d\u0438\u0436\u043d\u0435\u043c \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0435" },
            { "byn", "\u0431\u0438\u043b\u0438\u043d" },
            { "Lyci", "\u043b\u0438\u0446\u0438\u0430\u043d" },
            { "osa", "\u043e\u0441\u0435\u0434\u0436\u0438" },
            { "byv", "\u043c\u0435\u0434\u0443\u043c\u0431\u0430" },
            { "Moon", "\u0430\u0437\u0431\u0443\u043a\u0430 \u043c\u0443\u043d\u0430" },
            { "moh", "\u043c\u043e\u0445\u0430\u0443\u043a" },
            { "kkj", "\u043a\u0430\u043a\u043e" },
            { "yi", "\u0438\u0434\u0438\u0448" },
            { "mos", "\u043c\u043e\u0441\u0438" },
            { "Syrc", "\u0441\u0438\u0440\u0438\u0439\u0441\u043a\u0430\u044f" },
            { "Dsrt", "\u0434\u0435\u0437\u0435\u0440\u0435\u0442" },
            { "yo", "\u0439\u043e\u0440\u0443\u0431\u0430" },
            { "type.nu.traditional", "\u0422\u0440\u0430\u0434\u0438\u0446\u0438\u043e\u043d\u043d\u0430\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u043d\u0443\u043c\u0435\u0440\u0430\u0446\u0438\u0438" },
            { "es_MX", "\u043c\u0435\u043a\u0441\u0438\u043a\u0430\u043d\u0441\u043a\u0438\u0439 \u0438\u0441\u043f\u0430\u043d\u0441\u043a\u0438\u0439" },
            { "Syrj", "\u0437\u0430\u043f\u0430\u0434\u043d\u043e\u0441\u0438\u0440\u0438\u0439\u0441\u043a\u0430\u044f" },
            { "ota", "\u0441\u0442\u0430\u0440\u043e\u0442\u0443\u0440\u0435\u0446\u043a\u0438\u0439" },
            { "Syre", "\u0441\u0438\u0440\u0438\u0439\u0441\u043a\u0430\u044f \u044d\u0441\u0442\u0440\u0430\u043d\u0433\u0435\u043b\u043e" },
            { "vai", "\u0432\u0430\u0438" },
            { "za", "\u0447\u0436\u0443\u0430\u043d\u044c" },
            { "Cari", "\u043a\u0430\u0440\u0438\u0439\u0441\u043a\u0430\u044f" },
            { "kln", "\u043a\u0430\u043b\u0435\u043d\u0434\u0436\u0438\u043d" },
            { "zh", "\u043a\u0438\u0442\u0430\u0439\u0441\u043a\u0438\u0439" },
            { "Afak", "\u0430\u0444\u0430\u043a\u0430" },
            { "Bopo", "\u0431\u043e\u043f\u043e\u043c\u043e\u0444\u043e" },
            { "Perm", "\u0434\u0440\u0435\u0432\u043d\u0435\u043f\u0435\u0440\u043c\u0441\u043a\u0430\u044f" },
            { "key.lb", "\u0441\u0442\u0438\u043b\u044c \u043f\u0435\u0440\u0435\u0432\u043e\u0434\u0430 \u0441\u0442\u0440\u043e\u043a\u0438" },
            { "zu", "\u0437\u0443\u043b\u0443" },
            { "type.co.phonebook", "\u043f\u043e\u0440\u044f\u0434\u043e\u043a \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u043d\u043e\u0439 \u043a\u043d\u0438\u0433\u0438" },
            { "%%MONOTON", "\u041c\u043e\u043d\u043e\u0442\u043e\u043d\u043d\u044b\u0439" },
            { "Geor", "\u0433\u0440\u0443\u0437\u0438\u043d\u0441\u043a\u0430\u044f" },
            { "Shrd", "\u0448\u0430\u0440\u0430\u0434\u0430" },
            { "kmb", "\u043a\u0438\u043c\u0431\u0443\u043d\u0434\u0443" },
            { "type.nu.jpanfin", "\u044f\u043f\u043e\u043d\u0441\u043a\u0438\u0435 \u0446\u0438\u0444\u0440\u044b (\u0444\u0438\u043d\u0430\u043d\u0441\u044b)" },
            { "Cham", "\u0447\u0430\u043c\u0441\u043a\u0430\u044f" },
            { "gez", "\u0433\u0435\u044d\u0437" },
            { "Syrn", "\u0432\u043e\u0441\u0442\u043e\u0447\u043d\u043e-\u0441\u0438\u0440\u0438\u0439\u0441\u043a\u0430\u044f" },
            { "type.nu.mymrshan", "\u0431\u0438\u0440\u043c\u0430\u043d\u0441\u043a\u0438\u0435 \u0448\u0430\u043d\u0441\u043a\u0438\u0435 \u0446\u0438\u0444\u0440\u044b" },
            { "Narb", "\u0441\u0435\u0432\u0435\u0440\u043d\u043e\u0430\u0440\u0430\u0432\u0438\u0439\u0441\u043a\u043e\u0435" },
            { "type.nu.olck", "\u0446\u0438\u0444\u0440\u044b \u043e\u043b-\u0447\u0438\u043a\u0438" },
            { "type.co.reformed", "\u0440\u0435\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u043f\u043e\u0440\u044f\u0434\u043e\u043a \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438" },
            { "Tglg", metaValue_tl },
            { "Egyd", "\u0435\u0433\u0438\u043f\u0435\u0442\u0441\u043a\u0430\u044f \u0434\u0435\u043c\u043e\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f" },
            { "Egyh", "\u0435\u0433\u0438\u043f\u0435\u0442\u0441\u043a\u0430\u044f \u0438\u0435\u0440\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f" },
            { "Palm", "\u043f\u0430\u043b\u044c\u043c\u0438\u0440\u044b" },
            { "ebu", "\u044d\u043c\u0431\u0443" },
            { "Egyp", "\u0435\u0433\u0438\u043f\u0435\u0442\u0441\u043a\u0430\u044f \u0438\u0435\u0440\u043e\u0433\u043b\u0438\u0444\u0438\u0447\u0435\u0441\u043a\u0430\u044f" },
            { "Geok", "\u0433\u0440\u0443\u0437\u0438\u043d\u0441\u043a\u0430\u044f \u0445\u0443\u0446\u0443\u0440\u0438" },
            { "zh_Hans", "\u043a\u0438\u0442\u0430\u0439\u0441\u043a\u0438\u0439, \u0443\u043f\u0440\u043e\u0449\u0435\u043d\u043d\u043e\u0435 \u043f\u0438\u0441\u044c\u043c\u043e" },
            { "koi", "\u043a\u043e\u043c\u0438-\u043f\u0435\u0440\u043c\u044f\u0446\u043a\u0438\u0439" },
            { "Hung", "\u0441\u0442\u0430\u0440\u043e\u0432\u0435\u043d\u0433\u0435\u0440\u0441\u043a\u0430\u044f" },
            { "kok", "\u043a\u043e\u043d\u043a\u0430\u043d\u0438" },
            { "%%1901", "\u0422\u0440\u0430\u0434\u0438\u0446\u0438\u043e\u043d\u043d\u0430\u044f \u043d\u0435\u043c\u0435\u0446\u043a\u0430\u044f \u043e\u0440\u0444\u043e\u0433\u0440\u0430\u0444\u0438\u044f" },
            { "kos", "\u043a\u043e\u0441\u0440\u0430\u0435\u043d\u0441\u043a\u0438\u0439" },
            { "type.nu.limb", "\u0446\u0438\u0444\u0440\u044b \u043b\u0438\u043c\u0431\u0443" },
            { "zh_Hant", "\u043a\u0438\u0442\u0430\u0439\u0441\u043a\u0438\u0439, \u0442\u0440\u0430\u0434\u0438\u0446\u0438\u043e\u043d\u043d\u043e\u0435 \u043f\u0438\u0441\u044c\u043c\u043e" },
            { "Sund", "\u0441\u0443\u043d\u0434\u0430\u043d\u0441\u043a\u0430\u044f" },
            { "kpe", metaValue_kpe },
            { "type.nu.khmr", "\u043a\u0445\u043c\u0435\u0440\u0441\u043a\u0438\u0435 \u0446\u0438\u0444\u0440\u044b" },
            { "Tirh", "\u0442\u0438\u0440\u0445\u0443\u0442\u0430" },
            { "ilo", "\u0438\u043b\u043e\u043a\u043e" },
            { "%%VALENCIA", "\u0412\u0430\u043b\u0435\u043d\u0441\u0438\u0439\u0441\u043a\u0438\u0439" },
            { "Cprt", "\u043a\u0438\u043f\u0440\u0441\u043a\u0430\u044f" },
            { "%%BAKU1926", "\u0423\u043d\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0442\u044e\u0440\u0441\u043a\u043e-\u043b\u0430\u0442\u0438\u043d\u0441\u043a\u0438\u0439 \u0430\u043b\u0444\u0430\u0432\u0438\u0442" },
            { "mua", "\u043c\u0443\u043d\u0434\u0430\u043d\u0433" },
            { "type.nu.guru", "\u0446\u0438\u0444\u0440\u044b \u0433\u0443\u0440\u043c\u0443\u043a\u0445\u0438" },
            { "mul", "\u044f\u0437\u044b\u043a\u0438 \u0440\u0430\u0437\u043d\u044b\u0445 \u0441\u0435\u043c\u0435\u0439" },
            { "cad", "\u043a\u0430\u0434\u0434\u043e" },
            { "key.ms", "\u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u043c\u0435\u0440" },
            { "mus", "\u043a\u0440\u0438\u043a" },
            { "Glag", "\u0433\u043b\u0430\u0433\u043e\u043b\u0438\u0446\u0430" },
            { "gil", "\u0433\u0438\u043b\u0431\u0435\u0440\u0442\u0441\u043a\u0438\u0439" },
            { "%%KKCOR", "\u041e\u0431\u0449\u0430\u044f \u043e\u0440\u0444\u043e\u0433\u0440\u0430\u0444\u0438\u044f" },
            { "Cher", metaValue_chr },
            { "car", "\u043a\u0430\u0440\u0438\u0431" },
            { "cay", "\u043a\u0430\u0439\u044e\u0433\u0430" },
            { "type.nu.tamldec", "\u0442\u0430\u043c\u0438\u043b\u044c\u0441\u043a\u0438\u0435 \u0446\u0438\u0444\u0440\u044b" },
            { "krc", "\u043a\u0430\u0440\u0430\u0447\u0430\u0435\u0432\u043e-\u0431\u0430\u043b\u043a\u0430\u0440\u0441\u043a\u0438\u0439" },
            { "inh", "\u0438\u043d\u0433\u0443\u0448\u0441\u043a\u0438\u0439" },
            { "fa_AF", "\u0434\u0430\u0440\u0438" },
            { "krl", "\u043a\u0430\u0440\u0435\u043b\u044c\u0441\u043a\u0438\u0439" },
            { "efi", "\u044d\u0444\u0438\u043a" },
            { "key.nu", "\u0446\u0438\u0444\u0440\u044b" },
            { "kru", "\u043a\u0443\u0440\u0443\u0445" },
            { "ksb", "\u0448\u0430\u043c\u0431\u0430\u043b\u0430" },
            { "Telu", metaValue_te },
            { "ksf", "\u0431\u0430\u0444\u0438\u044f" },
        };
        return data;
    }
}
