/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epp.internal.mpc.ui.wizards.AbstractTagFilter;
import org.eclipse.equinox.internal.p2.discovery.model.Tag;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ComboTagFilter
extends AbstractTagFilter {
    private ComboWrapper combo;
    private String noSelectionLabel;
    private SelectionListener listener;

    @Override
    public void createControl(Composite parent) {
        if (this.getChoices() == null) {
            throw new IllegalStateException();
        }
        this.combo = ComboTagFilter.useCCombo() ? new CComboComboWrapper(parent, 12) : new ComboComboWrapper(parent, 12);
        this.combo.setData((Object)this);
        this.listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = ComboTagFilter.this.combo.getSelectionIndex();
                if (selectionIndex > 0) {
                    Tag tag = ComboTagFilter.this.getChoices().get(selectionIndex - 1);
                    ComboTagFilter.this.setSelected(Collections.singleton(tag));
                } else {
                    ComboTagFilter.this.setSelected(Collections.emptySet());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.combo.addSelectionListener(this.listener);
        this.rebuildChoicesUi();
    }

    private static boolean useCCombo() {
        return "gtk".equals(Platform.getWS());
    }

    protected void rebuildChoicesUi() {
        if (this.combo != null) {
            this.combo.removeSelectionListener(this.listener);
            this.combo.removeAll();
            this.combo.add(this.noSelectionLabel == null ? "" : this.noSelectionLabel);
            if (this.getChoices() != null) {
                for (Tag tag : this.getChoices()) {
                    this.combo.add(tag.getLabel());
                }
            }
            this.combo.select(0);
            this.combo.addSelectionListener(this.listener);
        }
    }

    @Override
    protected void choicesChanged(List<Tag> choices, List<Tag> previousChoices) {
        this.rebuildChoicesUi();
        super.choicesChanged(choices, previousChoices);
    }

    public String getNoSelectionLabel() {
        return this.noSelectionLabel;
    }

    public void setNoSelectionLabel(String noSelectionLabel) {
        this.noSelectionLabel = noSelectionLabel;
    }

    @Override
    protected void updateUi() {
        if (this.combo.isDisposed()) {
            return;
        }
        int index = -1;
        if (!this.getSelected().isEmpty()) {
            Tag selected = this.getSelected().iterator().next();
            index = this.getChoices().indexOf(selected);
        }
        this.combo.select(index + 1);
        super.updateUi();
    }

    private static class CComboComboWrapper
    extends ComboWrapper {
        public CComboComboWrapper(Composite parent, int style) {
            super(parent, style);
        }

        @Override
        Control createCombo(Composite parent, int style) {
            return new CCombo(parent, style);
        }

        public CCombo getCombo() {
            return (CCombo)super.getCombo();
        }

        @Override
        public void select(int i) {
            this.getCombo().select(i);
        }

        @Override
        public void add(String element) {
            this.getCombo().add(element);
        }

        @Override
        public void removeAll() {
            this.getCombo().removeAll();
        }

        @Override
        public void removeSelectionListener(SelectionListener listener) {
            this.getCombo().removeSelectionListener(listener);
        }

        @Override
        public void addSelectionListener(SelectionListener listener) {
            this.getCombo().addSelectionListener(listener);
        }

        @Override
        public int getSelectionIndex() {
            return this.getCombo().getSelectionIndex();
        }
    }

    private static class ComboComboWrapper
    extends ComboWrapper {
        public ComboComboWrapper(Composite parent, int style) {
            super(parent, style);
        }

        @Override
        Control createCombo(Composite parent, int style) {
            return new Combo(parent, style);
        }

        public Combo getCombo() {
            return (Combo)super.getCombo();
        }

        @Override
        public void select(int i) {
            this.getCombo().select(i);
        }

        @Override
        public void add(String element) {
            this.getCombo().add(element);
        }

        @Override
        public void removeAll() {
            this.getCombo().removeAll();
        }

        @Override
        public void removeSelectionListener(SelectionListener listener) {
            this.getCombo().removeSelectionListener(listener);
        }

        @Override
        public void addSelectionListener(SelectionListener listener) {
            this.getCombo().addSelectionListener(listener);
        }

        @Override
        public int getSelectionIndex() {
            return this.getCombo().getSelectionIndex();
        }
    }

    private static abstract class ComboWrapper {
        private final Control combo;

        public ComboWrapper(Composite parent, int style) {
            this.combo = this.createCombo(parent, style);
        }

        abstract Control createCombo(Composite var1, int var2);

        public Control getCombo() {
            return this.combo;
        }

        public void setData(Object data) {
            this.combo.setData(data);
        }

        public boolean isDisposed() {
            return this.combo.isDisposed();
        }

        public abstract void select(int var1);

        public abstract void add(String var1);

        public abstract void removeAll();

        public abstract void removeSelectionListener(SelectionListener var1);

        public abstract void addSelectionListener(SelectionListener var1);

        public abstract int getSelectionIndex();
    }
}

