/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.internal.storage.CommitFileRevision;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.op.DiscardChangesOperation;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.ActionUtils;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.blame.BlameOperation;
import org.eclipse.egit.ui.internal.commit.DiffViewer;
import org.eclipse.egit.ui.internal.dialogs.CommandConfirmation;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.egit.ui.internal.history.FileDiffInput;
import org.eclipse.egit.ui.internal.history.FileDiffLabelProvider;
import org.eclipse.egit.ui.internal.history.HistoryPageInput;
import org.eclipse.egit.ui.internal.merge.GitCompareEditorInput;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.themes.ColorUtil;

public class CommitFileDiffViewer
extends TableViewer {
    static final int INTERESTING_MARK_TREE_FILTER_INDEX = 0;
    private static final String LINESEP = System.lineSeparator();
    private Clipboard clipboard;
    private IAction selectAll;
    private IAction copy;
    private IAction copyAll;
    private IAction checkOutThisVersion;
    private IAction openThisVersion;
    private IAction openPreviousVersion;
    private IAction blame;
    private IAction openWorkingTreeVersion;
    private IAction compareWithPrevious;
    private IAction compareWorkingTreeVersion;
    private IAction showInHistory;
    private FileDiffInput realInput;
    private FileDiffLoader loader;
    private final IWorkbenchSite site;

    private static int preventBug499850(int style) {
        if ((style & 0x10000002) == 0x10000002 && "gtk".equals(SWT.getPlatform()) && SWT.getVersion() < 4919) {
            return style & 0xFFFFFFFD;
        }
        return style;
    }

    public CommitFileDiffViewer(Composite parent, IWorkbenchSite site) {
        this(parent, site, 268503810);
    }

    public CommitFileDiffViewer(Composite parent, IWorkbenchSite site, int style) {
        super(parent, CommitFileDiffViewer.preventBug499850(style));
        this.setUseHashlookup(true);
        this.site = site;
        Table rawTable = this.getTable();
        Color fg = rawTable.getForeground();
        Color bg = rawTable.getBackground();
        RGB dimmedForegroundRgb = ColorUtil.blend((RGB)fg.getRGB(), (RGB)bg.getRGB(), (int)60);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this);
        this.setLabelProvider((IBaseLabelProvider)new FileDiffLabelProvider(dimmedForegroundRgb));
        this.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object left, Object right) {
                if (left instanceof FileDiff && right instanceof FileDiff) {
                    return FileDiff.PATH_COMPARATOR.compare((FileDiff)left, (FileDiff)right);
                }
                return super.compare(viewer, left, right);
            }
        });
        this.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ISelection s = event.getSelection();
                if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection iss = (IStructuredSelection)s;
                FileDiff d = (FileDiff)iss.getFirstElement();
                if (Activator.getDefault().getPreferenceStore().getBoolean("resourcehistory_compare_mode")) {
                    CommitFileDiffViewer.this.showTwoWayFileDiff(d);
                } else if (d.getChange() == DiffEntry.ChangeType.DELETE) {
                    CommitFileDiffViewer.this.openPreviousVersionInEditor(d);
                } else {
                    CommitFileDiffViewer.this.openThisVersionInEditor(d);
                }
            }
        });
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CommitFileDiffViewer.this.updateActionEnablement(event.getSelection());
            }
        });
        this.clipboard = new Clipboard(rawTable.getDisplay());
        rawTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CommitFileDiffViewer.this.clipboard.dispose();
            }
        });
        MenuManager mgr = new MenuManager();
        rawTable.setMenu(mgr.createContextMenu((Control)rawTable));
        this.checkOutThisVersion = new CheckoutAction(() -> ((CommitFileDiffViewer)this).getStructuredSelection());
        this.openThisVersion = new Action(UIText.CommitFileDiffViewer_OpenInEditorMenuLabel){

            public void run() {
                CommitFileDiffViewer.this.withSelection(arg_0 -> CommitFileDiffViewer.access$2(CommitFileDiffViewer.this, arg_0));
            }
        };
        this.openPreviousVersion = new Action(UIText.CommitFileDiffViewer_OpenPreviousInEditorMenuLabel){

            public void run() {
                CommitFileDiffViewer.this.withSelection(arg_0 -> CommitFileDiffViewer.access$1(CommitFileDiffViewer.this, arg_0));
            }
        };
        this.blame = new Action(UIText.CommitFileDiffViewer_ShowAnnotationsMenuLabel, UIIcons.ANNOTATE){

            public void run() {
                CommitFileDiffViewer.this.withSelection(arg_0 -> CommitFileDiffViewer.access$6(CommitFileDiffViewer.this, arg_0));
            }
        };
        this.openWorkingTreeVersion = new Action(UIText.CommitFileDiffViewer_OpenWorkingTreeVersionInEditorMenuLabel){

            public void run() {
                CommitFileDiffViewer.this.withSelection(d -> {
                    String relativePath = d.getPath();
                    File file = new Path(d.getRepository().getWorkTree().getAbsolutePath()).append(relativePath).toFile();
                    DiffViewer.openFileInEditor(file, -1);
                });
            }
        };
        this.compareWithPrevious = new Action(UIText.CommitFileDiffViewer_CompareMenuLabel){

            public void run() {
                CommitFileDiffViewer.this.withFirstSelected(CommitFileDiffViewer.this::showTwoWayFileDiff);
            }
        };
        this.compareWorkingTreeVersion = new Action(UIText.CommitFileDiffViewer_CompareWorkingDirectoryMenuLabel){

            public void run() {
                IStructuredSelection selection = CommitFileDiffViewer.this.getStructuredSelection();
                if (selection == null || selection.isEmpty()) {
                    return;
                }
                ArrayList<FileDiff> diffs = new ArrayList<FileDiff>();
                Iterator items = selection.iterator();
                while (items.hasNext()) {
                    diffs.add((FileDiff)items.next());
                }
                if (diffs.size() == 1) {
                    CommitFileDiffViewer.this.showWorkingDirectoryFileDiff((FileDiff)diffs.get(0));
                } else if (!diffs.isEmpty()) {
                    FileDiff first = (FileDiff)diffs.get(0);
                    Repository repository = first.getRepository();
                    IPath workingTree = Path.fromOSString((String)repository.getWorkTree().getAbsolutePath());
                    List<IPath> paths = diffs.stream().map(FileDiff::getPath).map(arg_0 -> ((IPath)workingTree).append(arg_0)).collect(Collectors.toList());
                    GitCompareEditorInput comparison = new GitCompareEditorInput(null, first.getCommit().name(), repository, paths.toArray(new IPath[0]));
                    CompareUtils.openInCompare(CommitFileDiffViewer.this.site.getPage(), comparison);
                }
            }
        };
        this.showInHistory = new Action(UIText.CommitFileDiffViewer_ShowInHistoryLabel, UIIcons.HISTORY){

            public void run() {
                ShowInContext context = CommitFileDiffViewer.this.getShowInContext();
                if (context == null) {
                    return;
                }
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                IWorkbenchPart part = page.getActivePart();
                if (part instanceof IHistoryView) {
                    ((IShowInTarget)part).show(context);
                }
            }
        };
        mgr.add(this.openWorkingTreeVersion);
        mgr.add(this.openThisVersion);
        mgr.add(this.openPreviousVersion);
        mgr.add((IContributionItem)new Separator());
        mgr.add(this.checkOutThisVersion);
        mgr.add((IContributionItem)new Separator());
        mgr.add(this.compareWithPrevious);
        mgr.add(this.compareWorkingTreeVersion);
        mgr.add(this.blame);
        mgr.add((IContributionItem)new Separator());
        mgr.add(this.showInHistory);
        MenuManager showInSubMenu = UIUtils.createShowInMenu(site.getWorkbenchWindow());
        mgr.add((IContributionItem)showInSubMenu);
        mgr.add((IContributionItem)new Separator());
        this.copy = ActionUtils.createGlobalAction(ActionFactory.COPY, () -> {
            IStructuredSelection selection = this.getStructuredSelection();
            if (selection != null && !selection.isEmpty()) {
                this.doCopy(selection.iterator());
            }
        });
        this.copy.setText(UIText.CommitFileDiffViewer_CopyFilePathMenuLabel);
        this.copy.setEnabled(true);
        if ((rawTable.getStyle() & 2) != 0) {
            this.selectAll = ActionUtils.createGlobalAction(ActionFactory.SELECT_ALL, this::doSelectAll);
            this.selectAll.setEnabled(true);
            ActionUtils.setGlobalActions((Control)rawTable, this.copy, this.selectAll);
            mgr.add(this.selectAll);
        } else {
            ActionUtils.setGlobalActions((Control)rawTable, this.copy);
        }
        mgr.add(this.copy);
        this.copyAll = new Action(UIText.CommitFileDiffViewer_CopyAllFilePathsMenuLabel){

            public void run() {
                CommitFileDiffViewer.this.doCopy(Arrays.asList(((IStructuredContentProvider)CommitFileDiffViewer.this.getContentProvider()).getElements(CommitFileDiffViewer.this.getInput())).iterator());
            }
        };
        mgr.add(this.copyAll);
        mgr.addMenuListener(manager -> {
            boolean bl = this.getControl().setFocus();
        });
    }

    private void withSelection(Consumer<FileDiff> consumer) {
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        Iterator items = selection.iterator();
        items.forEachRemaining(o -> {
            if (o instanceof FileDiff) {
                consumer.accept((FileDiff)o);
            }
        });
    }

    private void withFirstSelected(Consumer<FileDiff> consumer) {
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        Object o = selection.getFirstElement();
        if (o instanceof FileDiff) {
            consumer.accept((FileDiff)o);
        }
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        this.copyAll.setEnabled(this.getContentProvider() instanceof IStructuredContentProvider && this.doGetItemCount() > 0);
    }

    private void updateActionEnablement(ISelection selection) {
        boolean isBare;
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)selection;
        boolean allSelected = !sel.isEmpty() && sel.size() == this.getTable().getItemCount();
        boolean submoduleSelected = false;
        boolean addSelected = false;
        boolean deleteSelected = false;
        Repository repository = null;
        for (Object item : sel.toList()) {
            FileDiff fileDiff = (FileDiff)item;
            if (repository == null) {
                repository = fileDiff.getRepository();
            }
            if (fileDiff.isSubmodule()) {
                submoduleSelected = true;
            }
            if (fileDiff.getChange() == DiffEntry.ChangeType.ADD) {
                addSelected = true;
                continue;
            }
            if (fileDiff.getChange() != DiffEntry.ChangeType.DELETE) continue;
            deleteSelected = true;
        }
        boolean bl = isBare = repository == null || repository.isBare();
        if (this.selectAll != null) {
            this.selectAll.setEnabled(!allSelected);
        }
        this.copy.setEnabled(!sel.isEmpty());
        this.showInHistory.setEnabled(!sel.isEmpty());
        if (!submoduleSelected) {
            boolean oneOrMoreSelected = !sel.isEmpty();
            this.checkOutThisVersion.setEnabled(oneOrMoreSelected && repository != null && repository.getRepositoryState().equals((Object)RepositoryState.SAFE));
            this.openThisVersion.setEnabled(oneOrMoreSelected && !deleteSelected);
            this.openPreviousVersion.setEnabled(oneOrMoreSelected && !addSelected);
            this.compareWithPrevious.setEnabled(sel.size() == 1 && !addSelected && !deleteSelected);
            this.blame.setEnabled(oneOrMoreSelected);
            if (sel.size() == 1) {
                FileDiff diff = (FileDiff)sel.getFirstElement();
                boolean workTreeFileExists = false;
                if (!isBare && repository != null) {
                    String path = new Path(repository.getWorkTree().getAbsolutePath()).append(diff.getPath()).toOSString();
                    workTreeFileExists = new File(path).exists();
                }
                this.compareWorkingTreeVersion.setEnabled(workTreeFileExists);
                this.openWorkingTreeVersion.setEnabled(workTreeFileExists);
            } else {
                this.compareWorkingTreeVersion.setEnabled(oneOrMoreSelected && !isBare);
                this.openWorkingTreeVersion.setEnabled(oneOrMoreSelected && !isBare);
            }
        } else {
            this.checkOutThisVersion.setEnabled(false);
            this.openThisVersion.setEnabled(false);
            this.openPreviousVersion.setEnabled(false);
            this.openWorkingTreeVersion.setEnabled(false);
            this.compareWithPrevious.setEnabled(false);
            this.blame.setEnabled(false);
            this.compareWorkingTreeVersion.setEnabled(false);
        }
    }

    protected void handleDispose(DisposeEvent event) {
        this.cancelJob();
        this.realInput = null;
        super.handleDispose(event);
    }

    public void newInput(Object input) {
        this.cancelJob();
        if (input == null) {
            this.setSelection((ISelection)StructuredSelection.EMPTY);
            this.setInput(new Object());
        } else if (this.realInput != null && input instanceof FileDiffInput) {
            FileDiffInput newInput = (FileDiffInput)input;
            if (!Objects.equals(this.realInput.getRepository(), newInput.getRepository()) || this.realInput.isFirstParentOnly() != newInput.isFirstParentOnly() || !this.realInput.getCommit().equals((AnyObjectId)newInput.getCommit())) {
                this.setSelection((ISelection)StructuredSelection.EMPTY);
                this.setInput(new Object());
            }
        }
        if (input instanceof FileDiffInput) {
            this.realInput = (FileDiffInput)input;
            this.startJob((FileDiffInput)input);
        } else {
            this.realInput = null;
            this.setInput(input);
        }
    }

    protected void setSelectionToWidget(List list, boolean reveal) {
        if (list != null && list.isEmpty()) {
            list = null;
        }
        super.setSelectionToWidget(list, reveal);
    }

    public ShowInContext getShowInContext() {
        IStructuredSelection selection = this.getStructuredSelection();
        ArrayList<Object> elements = new ArrayList<Object>();
        ArrayList<File> files = new ArrayList<File>();
        Repository repo = null;
        Path workTreePath = null;
        boolean isBare = false;
        for (Object selectedElement : selection.toList()) {
            IPath path;
            FileDiff fileDiff = (FileDiff)selectedElement;
            if (repo == null) {
                repo = fileDiff.getRepository();
                if (repo == null) {
                    return null;
                }
                isBare = repo.isBare();
                if (!isBare) {
                    workTreePath = new Path(repo.getWorkTree().getAbsolutePath());
                }
            }
            IFile file = null;
            if (!isBare && workTreePath != null) {
                path = workTreePath.append(fileDiff.getPath());
                file = ResourceUtil.getFileForLocation((IPath)path, (boolean)false);
                if (file != null) {
                    elements.add(file);
                } else {
                    elements.add(path);
                }
                files.add(path.toFile());
                continue;
            }
            path = Path.fromPortableString((String)fileDiff.getGitPath());
            files.add(path.toFile());
            elements.add(fileDiff);
        }
        HistoryPageInput historyPageInput = null;
        if (!files.isEmpty()) {
            historyPageInput = new HistoryPageInput(repo, files.toArray(new File[0]));
        }
        return new ShowInContext(historyPageInput, (ISelection)new StructuredSelection(elements));
    }

    private void openThisVersionInEditor(FileDiff d) {
        DiffViewer.openInEditor(d, DiffEntry.Side.NEW, -1);
    }

    private void openPreviousVersionInEditor(FileDiff d) {
        DiffViewer.openInEditor(d, DiffEntry.Side.OLD, -1);
    }

    private void showAnnotations(FileDiff d) {
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            RevCommit commit = d.getChange().equals((Object)DiffEntry.ChangeType.DELETE) ? d.getCommit().getParent(0) : d.getCommit();
            String path = d.getPath();
            IFileRevision rev = CompareUtils.getFileRevision(path, commit, d.getRepository(), d.getChange().equals((Object)DiffEntry.ChangeType.DELETE) ? d.getBlobs()[0] : d.getBlobs()[d.getBlobs().length - 1]);
            if (rev instanceof CommitFileRevision) {
                BlameOperation op = new BlameOperation((CommitFileRevision)rev, window.getShell(), page);
                JobUtil.scheduleUserJob((IEGitOperation)op, (String)UIText.ShowBlameHandler_JobName, (Object)JobFamilies.BLAME);
            } else {
                String message = NLS.bind((String)UIText.DiffViewer_notContainedInCommit, (Object)path, (Object)d.getCommit().getId().getName());
                Activator.showError(message, null);
            }
        }
        catch (IOException e) {
            Activator.logError(UIText.GitHistoryPage_openFailed, e);
            Activator.showError(UIText.GitHistoryPage_openFailed, null);
        }
    }

    void showTwoWayFileDiff(FileDiff d) {
        DiffViewer.showTwoWayFileDiff(d);
    }

    void showWorkingDirectoryFileDiff(FileDiff d) {
        String p = d.getPath();
        RevCommit commit = d.getCommit();
        Repository repo = d.getRepository();
        if (commit == null || repo == null) {
            Activator.showError(UIText.GitHistoryPage_openFailed, null);
            return;
        }
        IWorkbenchPage activePage = this.site.getWorkbenchWindow().getActivePage();
        IFile file = ResourceUtil.getFileForLocation((Repository)repo, (String)p, (boolean)false);
        try {
            if (file != null) {
                IResource[] resources = new IResource[]{file};
                CompareUtils.compare(resources, repo, "HEAD", commit.getName(), true, activePage);
            } else {
                IPath path = new Path(repo.getWorkTree().getAbsolutePath()).append(p);
                File ioFile = path.toFile();
                if (ioFile.exists()) {
                    CompareUtils.compare(path, repo, "HEAD", commit.getName(), true, activePage);
                }
            }
        }
        catch (IOException e) {
            Activator.handleError(UIText.GitHistoryPage_openFailed, e, true);
        }
    }

    private void doSelectAll() {
        Table table;
        if (this.getInput() != null && (table = this.getTable()) != null) {
            table.selectAll();
            this.setSelection(this.getSelection());
        }
    }

    private void doCopy(Iterator<?> items) {
        StringBuilder r = new StringBuilder();
        while (items.hasNext()) {
            Object obj = items.next();
            if (!(obj instanceof FileDiff)) continue;
            if (r.length() > 0) {
                r.append(LINESEP);
            }
            r.append(((FileDiff)obj).getPath());
        }
        this.clipboard.setContents(new Object[]{r.toString()}, new Transfer[]{TextTransfer.getInstance()}, 1);
    }

    void setInterestingPaths(Collection<String> interestingPaths) {
        if (this.realInput != null) {
            this.cancelJob();
            this.realInput.setInterestingPaths(interestingPaths);
            this.startJob(this.realInput);
        }
    }

    private TreeFilter toFilter(Collection<String> paths) {
        if (paths != null && !paths.isEmpty()) {
            return PathFilterGroup.createFromStrings(paths);
        }
        return TreeFilter.ALL;
    }

    private void startJob(final FileDiffInput input) {
        final FileDiffLoader job = new FileDiffLoader(input, this.toFilter(input.getInterestingPaths()));
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!event.getResult().isOK()) {
                    return;
                }
                UpdateJob updater = new UpdateJob(MessageFormat.format(UIText.CommitFileDiffViewer_updatingFileDiffs, input.getCommit().getName()), job);
                updater.schedule();
            }
        });
        job.setUser(false);
        job.setSystem(true);
        this.loader = job;
        this.loader.schedule();
    }

    private void cancelJob() {
        if (this.loader != null) {
            this.loader.cancel();
            this.loader = null;
        }
        Job.getJobManager().cancel(JobFamilies.HISTORY_FILE_DIFF);
    }

    static /* synthetic */ void access$6(CommitFileDiffViewer commitFileDiffViewer, FileDiff fileDiff) {
        commitFileDiffViewer.showAnnotations(fileDiff);
    }

    public static class CheckoutAction
    extends Action {
        private final Supplier<IStructuredSelection> selectionProvider;

        public CheckoutAction(Supplier<IStructuredSelection> selectionProvider) {
            super(UIText.CommitFileDiffViewer_CheckoutThisVersionMenuLabel);
            this.selectionProvider = selectionProvider;
        }

        public void run() {
            DiscardChangesOperation operation = this.createOperation();
            if (operation == null) {
                return;
            }
            Map paths = operation.getPathsPerRepository();
            if (!CommandConfirmation.confirmCheckout(null, paths, true)) {
                return;
            }
            JobUtil.scheduleUserWorkspaceJob((IEGitOperation)operation, (String)UIText.DiscardChangesAction_discardChanges, (Object)JobFamilies.DISCARD_CHANGES);
        }

        private DiscardChangesOperation createOperation() {
            Collection<FileDiff> diffs = this.getFileDiffs(this.selectionProvider.get());
            if (diffs.isEmpty()) {
                return null;
            }
            FileDiff first = diffs.iterator().next();
            Repository repository = first.getRepository();
            String revision = first.getCommit().getName();
            List paths = diffs.stream().map(FileDiff::getNewPath).collect(Collectors.toList());
            DiscardChangesOperation operation = new DiscardChangesOperation(repository, paths);
            operation.setRevision(revision);
            return operation;
        }

        private Collection<FileDiff> getFileDiffs(IStructuredSelection selection) {
            ArrayList<FileDiff> result = new ArrayList<FileDiff>();
            for (Object obj : selection.toList()) {
                FileDiff diff = (FileDiff)Adapters.adapt(obj, FileDiff.class);
                if (diff == null || diff.getChange() == DiffEntry.ChangeType.DELETE || diff.isSubmodule()) continue;
                result.add(diff);
            }
            return result;
        }
    }

    private static class FileDiffLoader
    extends Job {
        private FileDiff[] diffs;
        private final FileDiffInput input;
        private final TreeFilter filter;

        public FileDiffLoader(FileDiffInput input, TreeFilter filter) {
            super(MessageFormat.format(UIText.CommitFileDiffViewer_computingFileDiffs, input.getCommit().getName()));
            this.input = input;
            this.filter = filter;
            this.setRule(new TreeWalkSchedulingRule(input.getTreeWalk()));
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (this.input.isFirstParentOnly() && this.input.getCommit().getParentCount() > 1) {
                    RevCommit[] parents = new RevCommit[]{this.input.getCommit().getParent(0)};
                    this.diffs = FileDiff.compute(this.input.getRepository(), this.input.getTreeWalk(), this.input.getCommit(), parents, monitor, this.filter);
                } else {
                    this.diffs = FileDiff.compute(this.input.getRepository(), this.input.getTreeWalk(), this.input.getCommit(), monitor, this.filter);
                }
            }
            catch (IOException err) {
                Activator.handleError(MessageFormat.format(UIText.CommitFileDiffViewer_errorGettingDifference, this.input.getCommit().getId()), err, false);
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }

        public FileDiff[] getDiffs() {
            return this.diffs;
        }

        public FileDiffInput getInput() {
            return this.input;
        }

        public boolean belongsTo(Object family) {
            return family == JobFamilies.HISTORY_FILE_DIFF || super.belongsTo(family);
        }
    }

    private static class TreeWalkSchedulingRule
    implements ISchedulingRule {
        private final TreeWalk treeWalk;

        public TreeWalkSchedulingRule(TreeWalk treeWalk) {
            this.treeWalk = treeWalk;
        }

        public boolean contains(ISchedulingRule rule) {
            if (rule instanceof TreeWalkSchedulingRule) {
                return Objects.equals(this.treeWalk, ((TreeWalkSchedulingRule)rule).treeWalk);
            }
            return false;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return this.contains(rule);
        }
    }

    private class UpdateJob
    extends UIJob {
        private final FileDiffLoader loadJob;

        public UpdateJob(String name, FileDiffLoader loadJob) {
            super(name);
            this.loadJob = loadJob;
            this.setUser(false);
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            Control control = CommitFileDiffViewer.this.getControl();
            if (control == null || control.isDisposed() || CommitFileDiffViewer.this.loader != this.loadJob || monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            FileDiff[] diffs = this.loadJob.getDiffs();
            try {
                control.setRedraw(false);
                CommitFileDiffViewer.this.setInput(diffs);
                FileDiff interesting = this.getFirstInterestingElement(diffs);
                if (interesting != null) {
                    if (this.loadJob.getInput().isSelectMarked()) {
                        CommitFileDiffViewer.this.setSelection((ISelection)new StructuredSelection((Object)interesting), true);
                    } else {
                        CommitFileDiffViewer.this.reveal(interesting);
                    }
                }
            }
            finally {
                control.setRedraw(true);
            }
            return Status.OK_STATUS;
        }

        private FileDiff getFirstInterestingElement(FileDiff[] diffs) {
            if (diffs != null) {
                FileDiff[] fileDiffArray = diffs;
                int n = diffs.length;
                int n2 = 0;
                while (n2 < n) {
                    FileDiff d = fileDiffArray[n2];
                    if (d.isMarked(0)) {
                        return d;
                    }
                    ++n2;
                }
            }
            return null;
        }

        public boolean belongsTo(Object family) {
            return family == JobFamilies.HISTORY_FILE_DIFF || super.belongsTo(family);
        }
    }
}

