/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.theme;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ThemeTrieElementRule {
    public int scopeDepth;
    public final List<String> parentScopes;
    public int fontStyle;
    public int foreground;
    public int background;

    public ThemeTrieElementRule(int scopeDepth, List<String> parentScopes, int fontStyle, int foreground, int background) {
        this.scopeDepth = scopeDepth;
        this.parentScopes = parentScopes;
        this.fontStyle = fontStyle;
        this.foreground = foreground;
        this.background = background;
    }

    public ThemeTrieElementRule clone() {
        return new ThemeTrieElementRule(this.scopeDepth, this.parentScopes, this.fontStyle, this.foreground, this.background);
    }

    public static List<ThemeTrieElementRule> cloneArr(List<ThemeTrieElementRule> arr) {
        ArrayList<ThemeTrieElementRule> r = new ArrayList<ThemeTrieElementRule>();
        int i = 0;
        int len = arr.size();
        while (i < len) {
            r.add(arr.get(i).clone());
            ++i;
        }
        return r;
    }

    public void acceptOverwrite(int scopeDepth, int fontStyle, int foreground, int background) {
        if (this.scopeDepth <= scopeDepth) {
            this.scopeDepth = scopeDepth;
        }
        if (fontStyle != -1) {
            this.fontStyle = fontStyle;
        }
        if (foreground != 0) {
            this.foreground = foreground;
        }
        if (background != 0) {
            this.background = background;
        }
    }

    public int hashCode() {
        return Objects.hash(this.background, this.fontStyle, this.foreground, this.parentScopes, this.scopeDepth);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThemeTrieElementRule other = (ThemeTrieElementRule)obj;
        return this.background == other.background && this.fontStyle == other.fontStyle && this.foreground == other.foreground && Objects.equals(this.parentScopes, other.parentScopes) && this.scopeDepth == other.scopeDepth;
    }
}

