/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.ui.internal.job;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.internal.ComponentXML;
import org.eclipse.wtp.releng.tools.component.internal.Plugin;
import org.eclipse.wtp.releng.tools.component.ui.ComponentManager;
import org.eclipse.wtp.releng.tools.component.ui.internal.WorkspaceFileLocation;

public class AddComponent
extends Job {
    private IFile file;

    public AddComponent(IFile file) {
        super(ComponentManager.getManager().getMessage("JOB_ADD_COMPONENT", new String[]{file.getFullPath().toString()}));
        this.file = file;
    }

    public IStatus run(IProgressMonitor monitor) {
        ComponentManager manager = ComponentManager.getManager();
        WorkspaceFileLocation location = new WorkspaceFileLocation(this.file);
        String absolutePath = location.getAbsolutePath();
        if (!manager.getScannableComponents().containsKey(absolutePath) && !manager.getCompRefs().containsKey(absolutePath)) {
            ComponentXML compXML = new ComponentXML();
            compXML.setLocation((ILocation)location);
            try {
                compXML.load();
                manager.addCompRef(compXML);
                Collection plugins = compXML.getPlugins();
                Iterator it = plugins.iterator();
                while (it.hasNext()) {
                    if (!manager.isWorkspacePlugin(((Plugin)it.next()).getId())) continue;
                    manager.addScannableComponent(compXML);
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new Status(0, "org.eclipse.wtp.releng.tools.component.ui", 0, "", null);
    }
}

