/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.ui.internal.adopter.view;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.wtp.releng.tools.component.adopters.ClassRef;
import org.eclipse.wtp.releng.tools.component.adopters.FieldRef;
import org.eclipse.wtp.releng.tools.component.adopters.MethodRef;
import org.eclipse.wtp.releng.tools.component.ui.internal.adopter.view.BreakageReportContentProvider;
import org.eclipse.wtp.releng.tools.component.ui.internal.adopter.view.BreakageReportLabelProvider;

public class BreakageReportView
extends ViewPart {
    protected Tree tree;
    protected TreeViewer treeViewer;

    public void createPartControl(Composite superparent) {
        Composite parent = new Composite(superparent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(768));
        GridData gd = new GridData(1808);
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        parent.setLayoutData((Object)gd);
        this.tree = new Tree(parent, 2818);
        gd = new GridData(1808);
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        this.tree.setLayoutData((Object)gd);
        this.treeViewer = new TreeViewer(this.tree);
        this.treeViewer.setContentProvider((IContentProvider)new BreakageReportContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new BreakageReportLabelProvider());
        this.treeViewer.setInput((Object)Boolean.TRUE);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection structuredSel;
                Object obj;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && ((obj = (structuredSel = (IStructuredSelection)selection).getFirstElement()) instanceof ClassRef || obj instanceof MethodRef || obj instanceof FieldRef)) {
                    TreeItem[] items;
                    String className = null;
                    if (obj instanceof ClassRef) {
                        className = ((ClassRef)obj).getName();
                    } else {
                        items = BreakageReportView.this.tree.getSelection();
                        if (items.length > 0) {
                            className = items[0].getParentItem().getText();
                        }
                    }
                    if (className != null && (items = BreakageReportView.this.tree.getSelection()).length > 0) {
                        TreeItem currItem = items[0];
                        TreeItem parentItem = items[0].getParentItem();
                        while (parentItem != null) {
                            currItem = parentItem;
                            parentItem = currItem.getParentItem();
                        }
                        BreakageReportView.this.openJava(currItem.getText(), className);
                    }
                }
            }
        });
    }

    private void openJava(String projectName, String className) {
        try {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project.exists()) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IClasspathEntry[] cps = javaProject.getRawClasspath();
                int i = 0;
                while (i < cps.length) {
                    if (cps[i].getEntryKind() == 3) {
                        StringBuffer sb = new StringBuffer();
                        sb.append(cps[i].getPath().toString());
                        sb.append(className.replace('.', '/'));
                        sb.append(".java");
                        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(sb.toString());
                        if (res != null && res.exists()) {
                            JavaUI.openInEditor((IJavaElement)JavaCore.create((IResource)res));
                        }
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException jme) {
            jme.printStackTrace();
        }
        catch (PartInitException pie) {
            pie.printStackTrace();
        }
    }

    public void setFocus() {
        if (this.tree != null) {
            this.tree.setFocus();
        }
    }

    public void refresh() {
        this.treeViewer.setInput((Object)Boolean.TRUE);
    }

    public void clear() {
        this.treeViewer.setInput(null);
    }
}

