/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.jaxp.debug.debugger;

import java.util.ArrayList;
import java.util.List;

public abstract class StyleFrame {
    private static int nextId;
    private final StyleFrame parent;
    private final List children = new ArrayList();
    private final int id = nextId++;

    public StyleFrame(StyleFrame parent) {
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public int getId() {
        return this.id;
    }

    public abstract String getName();

    public abstract String getFilename();

    public abstract int getCurrentLine();

    public abstract List getVariableStack();

    public StyleFrame getParent() {
        return this.parent;
    }

    public void addChild(StyleFrame child) {
        this.children.add(child);
    }

    public void removeChild(StyleFrame child) {
        this.children.remove(child);
    }

    public List getChildren() {
        return this.children;
    }

    public String toString() {
        String safename = this.getName().replaceAll("\\|", "%@_PIPE_@%");
        return String.valueOf(this.getFilename()) + "|" + this.getId() + "|" + this.getCurrentLine() + "|" + safename;
    }
}

