/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.jaxp.debug.debugger;

import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.wst.xsl.jaxp.debug.debugger.BreakPoint;
import org.eclipse.wst.xsl.jaxp.debug.debugger.IXSLDebugger;
import org.eclipse.wst.xsl.jaxp.debug.debugger.StyleFrame;
import org.eclipse.wst.xsl.jaxp.debug.debugger.Variable;
import org.eclipse.wst.xsl.jaxp.debug.invoker.IProcessorInvoker;
import org.eclipse.wst.xsl.jaxp.debug.invoker.TransformationException;

public abstract class AbstractDebugger
implements IXSLDebugger {
    private static final Log log;
    private static final int ACTION_DO_NOTHING = 0;
    private static final int ACTION_STOP = 1;
    private static final int ACTION_QUIT = 2;
    private static final int ACTION_SUSPEND = 3;
    private static final int ACTION_RESUME = 4;
    private static final int ACTION_STEP_INTO = 5;
    private static final int ACTION_STEP_OVER = 6;
    private static final int ACTION_STEP_RETURN = 7;
    private static final String EVENT_STARTED = "started";
    private static final String EVENT_STOPPED = "stopped";
    private static final String EVENT_SUSPENDED = "suspended client";
    private static final String EVENT_SUSPENDED_STEP = "suspended step";
    private static final String EVENT_RESUMED = "resumed client";
    private static final String EVENT_RESUMED_STEP = "resumed step";
    private IProcessorInvoker invoker;
    private int action;
    private Writer eventWriter;
    private Writer generatedWriter;
    private final Set breakpoints = Collections.synchronizedSet(new HashSet());
    private final Stack stack = new Stack();
    private StyleFrame stepOverFrame;
    private BreakPoint breakpoint;
    private URL sourceURL;
    private Result result;
    private int stepOverStackSize;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xsl.jaxp.debug.debugger.AbstractDebugger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public void setInvoker(IProcessorInvoker invoker) {
        this.invoker = invoker;
    }

    public void setEventWriter(Writer writer) {
        this.eventWriter = writer;
    }

    public void setGeneratedWriter(Writer writer) {
        this.generatedWriter = writer;
    }

    public void setSource(URL sourceURL) {
        this.sourceURL = sourceURL;
    }

    public void setTarget(final Writer writer) {
        this.result = new StreamResult(new Writer(){

            public void write(char[] cbuf, int off, int len) throws IOException {
                writer.write(cbuf, off, len);
                AbstractDebugger.this.generatedWriter.write(cbuf, off, len);
            }

            public void close() throws IOException {
                writer.close();
                AbstractDebugger.this.generatedWriter.close();
            }

            public void flush() throws IOException {
                writer.flush();
                AbstractDebugger.this.generatedWriter.flush();
            }
        });
    }

    public void run() {
        if (this.action != 2) {
            this.debuggerStarted();
            try {
                this.invoker.transform(this.sourceURL, this.result);
            }
            catch (TransformationException e) {
                log.error((Object)"Transform failed", (Throwable)e);
            }
            this.debuggerStopped();
        }
    }

    public synchronized void suspend() {
        this.action = 3;
        this.notify();
    }

    public synchronized void resume() {
        this.action = 4;
        this.notify();
    }

    public synchronized void stepInto() {
        this.action = 5;
        this.notify();
    }

    public synchronized void stepOver() {
        this.action = 6;
        this.stepOverFrame = this.peekStyleFrame();
        this.stepOverStackSize = this.stack.size();
        this.notify();
    }

    public synchronized void stepReturn() {
        this.action = 7;
        this.stepOverStackSize = this.stack.size();
        this.notify();
    }

    public synchronized void quit() {
        this.action = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String stack() {
        StringBuffer sb = new StringBuffer();
        Stack stack = this.stack;
        synchronized (stack) {
            Iterator iter = this.stack.iterator();
            while (iter.hasNext()) {
                StyleFrame frame = (StyleFrame)iter.next();
                sb.append(frame.toString());
                Iterator iter2 = frame.getVariableStack().iterator();
                while (iter2.hasNext()) {
                    sb.append("|");
                    Variable v = (Variable)iter2.next();
                    sb.append(v.getId());
                }
                if (!iter.hasNext()) continue;
                sb.append("$$$");
            }
        }
        return sb.toString();
    }

    public synchronized void checkStopped() {
        if (this.action == 2) {
            this.debuggerQuit();
        } else if (this.action == 1) {
            this.debuggerStopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkSuspended(StyleFrame styleFrame, BreakPoint breakpoint) {
        int stackSize;
        if (breakpoint.equals(this.breakpoint)) {
            return;
        }
        Stack stack = this.stack;
        synchronized (stack) {
            stackSize = this.stack.size();
        }
        if (stackSize == 0) {
            return;
        }
        switch (this.action) {
            case 3: {
                this.debuggerSuspendedClient(breakpoint);
                break;
            }
            case 6: {
                if (!styleFrame.equals(this.stepOverFrame) && stackSize >= this.stepOverStackSize) break;
                this.debuggerSuspendedStep(breakpoint);
                break;
            }
            case 5: {
                this.debuggerSuspendedStep(breakpoint);
                break;
            }
            case 7: {
                if (stackSize >= this.stepOverStackSize) break;
                this.debuggerSuspendedStep(breakpoint);
                break;
            }
            default: {
                this.checkBreakpoint(breakpoint);
            }
        }
    }

    private synchronized void checkBreakpoint(BreakPoint breakpoint) {
        if (this.isBreakpoint(breakpoint)) {
            this.debuggerSuspendedBreakpoint(breakpoint);
        }
    }

    public synchronized void debuggerTransformStarted() {
        this.stack.clear();
    }

    protected synchronized void debuggerStarted() {
        this.action = 0;
        this.sendEvent(EVENT_STARTED);
    }

    protected synchronized void debuggerStopped() {
        this.action = 0;
        this.sendEvent(EVENT_STOPPED);
    }

    private synchronized void debuggerQuit() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {}
    }

    private synchronized void debuggerSuspendedBreakpoint(BreakPoint breakpoint) {
        this.sendEvent("suspended breakpoint " + breakpoint);
        this.debuggerSuspended(breakpoint);
    }

    private synchronized void debuggerSuspendedStep(BreakPoint breakpoint) {
        this.sendEvent(EVENT_SUSPENDED_STEP);
        this.debuggerSuspended(breakpoint);
    }

    private synchronized void debuggerSuspendedClient(BreakPoint breakpoint) {
        this.sendEvent(EVENT_SUSPENDED);
        this.debuggerSuspended(breakpoint);
    }

    public synchronized void debuggerSuspended(BreakPoint breakpoint) {
        this.breakpoint = breakpoint;
        do {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        } while (this.action != 4 && this.action != 5 && this.action != 6 && this.action != 7 && this.action != 1);
        this.debuggerResumed();
    }

    private synchronized void debuggerResumed() {
        if (this.action == 5 || this.action == 6 || this.action == 7) {
            this.sendEvent(EVENT_RESUMED_STEP);
        } else {
            this.sendEvent(EVENT_RESUMED);
        }
    }

    private synchronized void sendEvent(String event) {
        try {
            log.info((Object)("Sending event: " + event + " eventWriter=" + this.eventWriter));
            this.eventWriter.write(String.valueOf(event) + "\n");
            this.eventWriter.flush();
        }
        catch (IOException e) {
            log.error((Object)"Error sending event", (Throwable)e);
        }
    }

    public void addBreakpoint(BreakPoint breakpoint) {
        log.info((Object)("Adding breakpoint: " + breakpoint));
        this.breakpoints.add(breakpoint);
    }

    public void removeBreakpoint(BreakPoint breakpoint) {
        log.info((Object)("Removing breakpoint: " + breakpoint));
        this.breakpoints.remove(breakpoint);
    }

    private boolean isBreakpoint(BreakPoint breakpoint) {
        if (breakpoint.equals(this.breakpoint)) {
            return false;
        }
        this.breakpoint = null;
        return this.breakpoints.contains(breakpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyleFrame popStyleFrame() {
        Stack stack = this.stack;
        synchronized (stack) {
            StyleFrame styleFrame = (StyleFrame)this.stack.pop();
            if (styleFrame.getParent() != null) {
                styleFrame.getParent().removeChild(styleFrame);
            }
            log.trace((Object)("Popped frame: " + styleFrame + " (size after pop=" + this.stack.size() + ")"));
            return styleFrame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushStyleFrame(StyleFrame styleFrame) {
        Stack stack = this.stack;
        synchronized (stack) {
            this.stack.push(styleFrame);
            log.trace((Object)("Pushed frame: " + styleFrame + " (size after push=" + this.stack.size() + ")"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyleFrame peekStyleFrame() {
        Stack stack = this.stack;
        synchronized (stack) {
            if (this.stack.size() > 0) {
                return (StyleFrame)this.stack.peek();
            }
            return null;
        }
    }
}

