/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSInteger;

public class XSDecimal
extends NumericType {
    private double _value;

    public XSDecimal() {
        this(0.0);
    }

    public XSDecimal(double x) {
        this._value = x;
    }

    public String string_type() {
        return "xs:decimal";
    }

    public String type_name() {
        return "decimal";
    }

    public String string_value() {
        return "" + this._value;
    }

    public boolean zero() {
        return this._value == 0.0;
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg.empty()) {
            return rs;
        }
        AnyAtomicType aat = (AnyAtomicType)arg.first();
        try {
            Double d = new Double(aat.string_value());
            rs.add(new XSDecimal(d));
            return rs;
        }
        catch (NumberFormatException numberFormatException) {
            throw DynamicError.cant_cast(null);
        }
    }

    public double double_value() {
        return this._value;
    }

    public void set_double(double x) {
        this._value = x;
    }

    public boolean eq(AnyType at) throws DynamicError {
        if (!(at instanceof XSDecimal)) {
            DynamicError.throw_type_error();
        }
        XSDecimal dt = (XSDecimal)at;
        return this.double_value() == dt.double_value();
    }

    public boolean gt(AnyType arg) throws DynamicError {
        XSDecimal val = (XSDecimal)XSDecimal.get_single_type(arg, XSDecimal.class);
        return this.double_value() > val.double_value();
    }

    public boolean lt(AnyType arg) throws DynamicError {
        XSDecimal val = (XSDecimal)XSDecimal.get_single_type(arg, XSDecimal.class);
        return this.double_value() < val.double_value();
    }

    public ResultSequence plus(ResultSequence arg) throws DynamicError {
        AnyType at = this.get_single_arg(arg);
        if (!(at instanceof XSDecimal)) {
            DynamicError.throw_type_error();
        }
        XSDecimal dt = (XSDecimal)at;
        return ResultSequenceFactory.create_new(new XSDecimal(this.double_value() + dt.double_value()));
    }

    public ResultSequence minus(ResultSequence arg) throws DynamicError {
        AnyType at = this.get_single_arg(arg);
        if (!(at instanceof XSDecimal)) {
            DynamicError.throw_type_error();
        }
        XSDecimal dt = (XSDecimal)at;
        return ResultSequenceFactory.create_new(new XSDecimal(this.double_value() - dt.double_value()));
    }

    public ResultSequence times(ResultSequence arg) throws DynamicError {
        XSDecimal val = (XSDecimal)XSDecimal.get_single_type(arg, XSDecimal.class);
        return ResultSequenceFactory.create_new(new XSDecimal(this.double_value() * val.double_value()));
    }

    public ResultSequence div(ResultSequence arg) throws DynamicError {
        XSDecimal val = (XSDecimal)XSDecimal.get_single_type(arg, XSDecimal.class);
        if (val.zero()) {
            throw DynamicError.div_zero(null);
        }
        return ResultSequenceFactory.create_new(new XSDecimal(this.double_value() / val.double_value()));
    }

    public ResultSequence idiv(ResultSequence arg) throws DynamicError {
        XSDecimal val = (XSDecimal)XSDecimal.get_single_type(arg, XSDecimal.class);
        if (val.zero()) {
            throw DynamicError.div_zero(null);
        }
        return ResultSequenceFactory.create_new(new XSInteger((int)(this.double_value() / val.double_value())));
    }

    public ResultSequence mod(ResultSequence arg) throws DynamicError {
        XSDecimal val = (XSDecimal)XSDecimal.get_single_type(arg, XSDecimal.class);
        return ResultSequenceFactory.create_new(new XSDecimal(this.double_value() % val.double_value()));
    }

    public ResultSequence unary_minus() {
        return ResultSequenceFactory.create_new(new XSDecimal(-1.0 * this.double_value()));
    }

    public NumericType abs() {
        return new XSDecimal(Math.abs(this.double_value()));
    }

    public NumericType ceiling() {
        return new XSDecimal(Math.ceil(this.double_value()));
    }

    public NumericType floor() {
        return new XSDecimal(Math.floor(this.double_value()));
    }

    public NumericType round() {
        return new XSDecimal(Math.round(this.double_value()));
    }

    public NumericType round_half_to_even() {
        return new XSDecimal(Math.rint(this.double_value()));
    }
}

