/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;

public class FnEscapeUri
extends Function {
    private static Collection _expected_args = null;

    public FnEscapeUri() {
        super(new QName("escape-uri"), 2);
    }

    public ResultSequence evaluate(Collection args) throws DynamicError {
        return FnEscapeUri.escape_uri(args);
    }

    public static ResultSequence escape_uri(Collection args) throws DynamicError {
        Collection cargs = Function.convert_arguments(args, FnEscapeUri.expected_args());
        Iterator argi = cargs.iterator();
        ResultSequence arg1 = (ResultSequence)argi.next();
        ResultSequence arg2 = (ResultSequence)argi.next();
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg1.empty()) {
            rs.add(new XSString(""));
            return rs;
        }
        String str = ((XSString)arg1.first()).value();
        boolean escape_reserved = ((XSBoolean)arg2.first()).value();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char x = str.charAt(i);
            if (FnEscapeUri.needs_escape(x, escape_reserved)) {
                sb.append("%");
                sb.append(Integer.toHexString(x));
            } else {
                sb.append(x);
            }
            ++i;
        }
        rs.add(new XSString(sb.toString()));
        return rs;
    }

    private static boolean needs_escape(char x, boolean er) {
        if ('A' <= x && x <= 'Z') {
            return false;
        }
        if ('a' <= x && x <= 'z') {
            return false;
        }
        if ('0' <= x && x <= '9') {
            return false;
        }
        switch (x) {
            case '!': 
            case '#': 
            case '%': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '-': 
            case '.': 
            case '_': 
            case '~': {
                return false;
            }
            case '$': 
            case '&': 
            case '+': 
            case ',': 
            case '/': 
            case ':': 
            case ';': 
            case '=': 
            case '?': 
            case '@': 
            case '[': 
            case ']': {
                if (er) break;
                return false;
            }
        }
        return true;
    }

    public static Collection expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            _expected_args.add(new SeqType(new XSString(), 3));
            _expected_args.add(new SeqType(new XSBoolean(), 0));
        }
        return _expected_args;
    }
}

