/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import javax.wsdl.Definition;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.xml.namespace.QName;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcessVisitor;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.ErrorList;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversal;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversalContext;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BP2103
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private ErrorList errors = new ErrorList();

    public BP2103(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public void visit(ExtensibilityElement el, Object parent, WSDLTraversalContext ctx) {
        if (el instanceof Schema) {
            this.searchForImport(((Schema)el).getElement());
        }
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "failed";
        WSDLTraversal traversal = new WSDLTraversal();
        traversal.setVisitor(this);
        traversal.ignoreImport();
        traversal.visitExtensibilityElement(true);
        traversal.ignoreReferences();
        traversal.traverse((Definition)entryContext.getEntry().getEntryDetail());
        if (!this.errors.isEmpty()) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext);
        } else {
            this.result = "passed";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private void searchForImport(Node n) {
        while (n != null) {
            if (1 == n.getNodeType()) {
                if (XMLUtils.equals(n, ELEM_XSD_IMPORT)) {
                    Attr a = XMLUtils.getAttribute((Element)n, ATTR_XSD_SCHEMALOCATION);
                    String schemaLocation = a != null ? a.getValue() : "";
                    a = XMLUtils.getAttribute((Element)n, ATTR_XSD_NAMESPACE);
                    String namespace = a != null ? a.getValue() : "";
                    this.errors.add(new QName(namespace, schemaLocation));
                } else if (!XMLUtils.equals(n, ELEM_XSD_SCHEMA)) {
                    this.searchForImport(n.getFirstChild());
                }
            }
            n = n.getNextSibling();
        }
    }
}

