/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core;

import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;

public class ServerEvent {
    private IServer server;
    private int kind;
    private IModule[] moduleTree;
    private int state;
    private int publishState;
    private boolean restartState;
    public static final int STATE_CHANGE = 1;
    public static final int PUBLISH_STATE_CHANGE = 2;
    public static final int RESTART_STATE_CHANGE = 4;
    public static final int SERVER_CHANGE = 16;
    public static final int MODULE_CHANGE = 32;

    public ServerEvent(int kind, IServer server, int state, int publishingState, boolean restartState) {
        this.kind = kind |= 0x10;
        this.server = server;
        this.state = state;
        this.publishState = publishingState;
        this.restartState = restartState;
        if (server == null) {
            throw new IllegalArgumentException("Server parameter must not be null");
        }
        if ((kind & 0x20) != 0) {
            throw new IllegalArgumentException("Kind parameter invalid");
        }
        this.checkKind();
    }

    public ServerEvent(int kind, IServer server, IModule[] module, int state, int publishingState, boolean restartState) {
        this.kind = kind |= 0x20;
        this.server = server;
        this.moduleTree = module;
        this.state = state;
        this.publishState = publishingState;
        this.restartState = restartState;
        if (this.moduleTree == null || this.moduleTree.length == 0) {
            throw new IllegalArgumentException("Module parameter invalid");
        }
        if ((kind & 0x10) != 0) {
            throw new IllegalArgumentException("Kind parameter invalid");
        }
        this.checkKind();
    }

    private void checkKind() {
        int i = 0;
        if ((this.kind & 1) != 0) {
            ++i;
        }
        if ((this.kind & 4) != 0) {
            ++i;
        }
        if ((this.kind & 2) != 0) {
            ++i;
        }
        if (i != 0 && i != 1) {
            throw new IllegalArgumentException("Kind parameter invalid");
        }
    }

    public int getKind() {
        return this.kind;
    }

    public IModule[] getModule() {
        return this.moduleTree;
    }

    public int getPublishState() {
        return this.publishState;
    }

    public boolean getRestartState() {
        return this.restartState;
    }

    public int getState() {
        return this.state;
    }

    public IServer getServer() {
        return this.server;
    }

    public String toString() {
        return "<Server-Event id=" + this.hashCode() + " kind=" + this.getKind() + " server=" + this.getServer() + " module=" + this.getModule() + " state=" + this.getState() + " publishState=" + this.getPublishState() + " restartState=" + this.getRestartState() + ">";
    }
}

