/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavadocCompletionModelTest;

public class JavadocBugsCompletionModelTest
extends AbstractJavadocCompletionModelTest {
    static /* synthetic */ Class class$0;

    public JavadocBugsCompletionModelTest(String name) {
        super(name);
        this.tabs = 2;
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.JavadocBugsCompletionModelTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return JavadocBugsCompletionModelTest.buildModelTestSuite(clazz);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.setUpProjectOptions("1.4");
    }

    public void testBug3270() throws JavaScriptModelException {
        String source = "package javadoc.bugs;\npublic class BasicTestBugs {\n\t/**\n\t * @throws \n\t */\n\tvoid foo() throws InterruptedException {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/bugs/BasicTestBugs.js", source, true, "@throws ", 0);
        this.assertSortedResults("InterruptedException[TYPE_REF]{InterruptedException, java.lang, Ljava.lang.InterruptedException;, null, null, " + this.positions + 71 + "}\n" + "BasicTestBugs[TYPE_REF]{BasicTestBugs, javadoc.bugs, Ljavadoc.bugs.BasicTestBugs;, null, null, " + this.positions + 21 + "}");
    }

    public void testBug3270a() throws JavaScriptModelException {
        String source = "package javadoc.bugs;\npublic class BasicTestBugs {\n\t/**\n\t * @throws I\n\t */\n\tvoid foo() throws InterruptedException {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/bugs/BasicTestBugs.js", source, true, "I");
        this.assertSortedResults("InterruptedException[TYPE_REF]{InterruptedException, java.lang, Ljava.lang.InterruptedException;, null, null, " + this.positions + 71 + "}\n" + "IllegalMonitorStateException[TYPE_REF]{IllegalMonitorStateException, java.lang, Ljava.lang.IllegalMonitorStateException;, null, null, " + this.positions + 41 + "}");
    }

    public void testBug3270b() throws JavaScriptModelException {
        String source = "package javadoc.bugs;\npublic class BasicTestBugs {\n\t/**\n\t * @throws Cl\n\t */\n\tvoid foo() throws InterruptedException {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/bugs/BasicTestBugs.js", source, true, "Cl");
        this.assertSortedResults("CloneNotSupportedException[TYPE_REF]{CloneNotSupportedException, java.lang, Ljava.lang.CloneNotSupportedException;, null, null, " + this.positions + 41 + "}\n" + "Class[TYPE_REF]{Class, java.lang, Ljava.lang.Class;, null, null, " + this.positions + 21 + "}");
    }

    public void testBug22043() throws JavaScriptModelException {
        String source = "package javadoc.bugs;\n/**\n * Complete after (S:\n * \t@see #thisIsAMethod(S\n */\npublic class BasicTestBugs {\n\tpublic void thisIsAMethod(String param) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/bugs/BasicTestBugs.js", source, true, "S", 2);
        this.assertSortedResults("String[TYPE_REF]{String, java.lang, Ljava.lang.String;, null, null, " + this.positions + 21 + "}\n" + "Serializable[TYPE_REF]{java.io.Serializable, java.io, Ljava.io.Serializable;, null, null, " + this.positions + 18 + "}\n" + "short[KEYWORD]{short, null, null, short, null, " + this.positions + 8 + "}");
    }

    public void testBug22043a() throws JavaScriptModelException {
        String source = "package javadoc.bugs;\n/**\n * Complete after 'thisIsAMethod':\n * \t@see #thisIsAMethod(S\n */\npublic class BasicTestBugs {\n\tpublic void thisIsAMethod(String param) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/bugs/BasicTestBugs.js", source, true, "thisIsAMethod", 2);
        this.assertResults("thisIsAMethod[FUNCTION_REF]{thisIsAMethod(String), Ljavadoc.bugs.BasicTestBugs;, (Ljava.lang.String;)V, thisIsAMethod, (param), " + this.positions + 33 + "}");
    }

    public void testBug22043b() throws JavaScriptModelException {
        String source = "package javadoc.bugs;\n/**\n * Complete after 'thisIsAMethod(':\n * \t@see #thisIsAMethod(S\n */\npublic class BasicTestBugs {\n\tpublic void thisIsAMethod(String param) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/bugs/BasicTestBugs.js", source, true, "thisIsAMethod(", 2);
        this.assertResults("thisIsAMethod[FUNCTION_REF]{thisIsAMethod(String), Ljavadoc.bugs.BasicTestBugs;, (Ljava.lang.String;)V, thisIsAMethod, (param), " + this.positions + 25 + "}");
    }

    public void testBug22043c() throws JavaScriptModelException {
        String source = "package javadoc.bugs;\n/**\n * Complete after thisIsAMethod(:\n * \t@see #thisIsAMethod(Object\n */\npublic class BasicTestBugs {\n\tpublic void thisIsAMethod(String param) {}\n\tpublic void thisIsAMethod(Object str) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/bugs/BasicTestBugs.js", source, true, "thisIsAMethod(", 2);
        this.assertResults("thisIsAMethod[FUNCTION_REF]{thisIsAMethod(Object), Ljavadoc.bugs.BasicTestBugs;, (Ljava.lang.Object;)V, thisIsAMethod, (str), " + this.positions + 25 + "}\n" + "thisIsAMethod[FUNCTION_REF]{thisIsAMethod(String), Ljavadoc.bugs.BasicTestBugs;, (Ljava.lang.String;)V, thisIsAMethod, (param), " + this.positions + 25 + "}");
    }

    public void testBug67732() throws JavaScriptModelException {
        String source = "package javadoc.bugs;\n/**\n * This line approaches the print margin {@link \n * Object#to\n */\npublic class T67732 {\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/bugs/BasicTestBugs.js", source, true, "to");
        this.assertSortedResults("toString[FUNCTION_REF]{toString(), Ljava.lang.Object;, ()Ljava.lang.String;, toString, null, " + this.positions + 29 + "}");
    }

    public void testBug68757() throws JavaScriptModelException {
        String[] sources = new String[]{"/Completion/src/javadoc/bugs/BasicTestBugs.js", "package javadoc.bugs;\nimport javadoc.tests.OtherType;\npublic class BasicTestBugs {\n\t/**\n\t * @see Other\n\t */\n\tpublic void foo(OtherType type) {}\n}\n", "/Completion/src/javadoc/tests/OtherType.js", "package javadoc.tests;\npublic class OtherType {\n}\n"};
        this.completeInJavadoc(sources, true, "Other", 2);
        this.assertSortedResults("OtherType[TYPE_REF]{OtherType, javadoc.tests, Ljavadoc.tests.OtherType;, null, null, " + this.positions + 21 + "}");
    }

    public void testBug68757a() throws JavaScriptModelException {
        String[] sources = new String[]{"/Completion/src/javadoc/bugs/BasicTestBugs.js", "package javadoc.bugs;\npublic class BasicTestBugs {\n\t/**\n\t * @see Other\n\t */\n\tpublic void foo(javadoc.tests.OtherType type) {}\n}\n", "/Completion/src/javadoc/tests/OtherType.js", "package javadoc.tests;\npublic class OtherType {\n}\n"};
        this.completeInJavadoc(sources, true, "Other");
        this.assertSortedResults("OtherType[TYPE_REF]{javadoc.tests.OtherType, javadoc.tests, Ljavadoc.tests.OtherType;, null, null, " + this.positions + 18 + "}");
    }

    public void testBug68757b() throws JavaScriptModelException {
        String[] sources = new String[]{"/Completion/src/javadoc/bugs/BasicTestBugs.js", "package javadoc.bugs;\npublic class BasicTestBugs {\n\t/**\n\t * @see Other\n\t */\n\tpublic void foo() {}\n}\n", "/Completion/src/javadoc/tests/OtherType.js", "package javadoc.tests;\npublic class OtherType {\n}\n"};
        this.completeInJavadoc(sources, true, "Other");
        this.assertSortedResults("OtherType[TYPE_REF]{javadoc.tests.OtherType, javadoc.tests, Ljavadoc.tests.OtherType;, null, null, " + this.positions + 18 + "}");
    }

    public void _testBug75551() throws JavaScriptModelException {
        String[] sources = new String[]{"/Completion/src/javadoc/bugs/BasicTestBugs.js", "package javadoc.bugs;\npublic class BasicTestBugs extends SuperClass {\n  /**\n   * {@link #kick(Inner\n   */\n  public BasicTestBugs() {\n  }\n  public void kick(InnerClass innerClass) {}\n}", "/Completion/src/javadoc/bugs/SuperClass.js", "package javadoc.bugs;\npublic class SuperClass {\n  protected static class InnerClass {\n  }\n}"};
        this.completeInJavadoc(sources, true, "Inner");
        this.assertSortedResults("SuperClass.InnerClass[TYPE_REF]{SuperClass.InnerClass, javadoc.bugs, Ljavadoc.bugs.SuperClass$InnerClass;, null, null, " + this.positions + 21 + "}");
    }

    public void testBug86112() throws JavaScriptModelException {
        String[] sources = new String[]{"/Completion/src/javadoc/bugs/BasicTestBugs.js", "package javadoc.bugs;\npublic class BasicTestBugs {\n  /**\n   * @see Terminator#\n   */\n  public BasicTestBugs() {\n  }\n}", "/Completion/src/javadoc/bugs/Terminator.js", "package javadoc.bugs;\npublic class Terminator {\n  static {\n  }\n}"};
        this.completeInJavadoc(sources, true, "#", 0);
        this.assertSortedResults("clone[FUNCTION_REF]{clone(), Ljava.lang.Object;, ()Ljava.lang.Object;, clone, null, " + this.positions + 29 + "}\n" + "equals[FUNCTION_REF]{equals(Object), Ljava.lang.Object;, (Ljava.lang.Object;)Z, equals, (obj), " + this.positions + 29 + "}\n" + "finalize[FUNCTION_REF]{finalize(), Ljava.lang.Object;, ()V, finalize, null, " + this.positions + 29 + "}\n" + "getClass[FUNCTION_REF]{getClass(), Ljava.lang.Object;, ()Ljava.lang.Class;, getClass, null, " + this.positions + 29 + "}\n" + "hashCode[FUNCTION_REF]{hashCode(), Ljava.lang.Object;, ()I, hashCode, null, " + this.positions + 29 + "}\n" + "notify[FUNCTION_REF]{notify(), Ljava.lang.Object;, ()V, notify, null, " + this.positions + 29 + "}\n" + "notifyAll[FUNCTION_REF]{notifyAll(), Ljava.lang.Object;, ()V, notifyAll, null, " + this.positions + 29 + "}\n" + "toString[FUNCTION_REF]{toString(), Ljava.lang.Object;, ()Ljava.lang.String;, toString, null, " + this.positions + 29 + "}\n" + "wait[FUNCTION_REF]{wait(long, int), Ljava.lang.Object;, (JI)V, wait, (millis, nanos), " + this.positions + 29 + "}\n" + "wait[FUNCTION_REF]{wait(long), Ljava.lang.Object;, (J)V, wait, (millis), " + this.positions + 29 + "}\n" + "wait[FUNCTION_REF]{wait(), Ljava.lang.Object;, ()V, wait, null, " + this.positions + 29 + "}\n" + "Terminator[FUNCTION_REF<CONSTRUCTOR>]{Terminator(), Ljavadoc.bugs.Terminator;, ()V, Terminator, null, " + this.positions + 8 + "}");
    }

    public void testBug87868() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.bugs;\npublic class BasicTestBugs<S> {\n\t/** \n\t * Calls {@link #meth\n\t */\n\tpublic void method(S s) {}\n}";
        this.completeInJavadoc("/Completion/src/javadoc/bugs/BasicTestBugs.js", source, true, "meth");
        this.assertSortedResults("method[FUNCTION_REF]{method(Object), Ljavadoc.bugs.BasicTestBugs<TS;>;, (TS;)V, method, (s), " + this.positions + 29 + "}");
    }

    public void testBug113374a() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.bugs;\n/** \n * <co\n */\npublic class BasicTestBugs {\n}";
        this.completeInJavadoc("/Completion/src/javadoc/bugs/BasicTestBugs.js", source, true, "co");
        this.assertSortedResults("");
    }

    public void testBug113374b() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.bugs;\n/** \n * &un\n */\npublic class BasicTestBugs {\n}";
        this.completeInJavadoc("/Completion/src/javadoc/bugs/BasicTestBugs.js", source, true, "un");
        this.assertSortedResults("");
    }

    public void testBug113376a() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String[] sources = new String[]{"/Completion/src/javadoc/bugs/BasicTestFields.js", "package javadoc.bugs;\n/**\n * @see javadoc.util.Collection\n * @see javadoc.util.List#add(Object)\n */public class BasicTestBugs<A> {\n}", "/Completion/src/javadoc/util/Collection.js", "package javadoc.util;\npublic interface Collection<E> {}\npublic interface List<E> {}\n\tpublic void add(E e);\n}"};
        this.completeInJavadoc(sources, true, "javadoc.util.Collection");
        this.assertSortedResults("Collection[TYPE_REF]{javadoc.util.Collection, javadoc.util, Ljavadoc.util.Collection;, null, null, " + this.positions + 24 + "}");
    }

    public void testBug113376b() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String[] sources = new String[]{"/Completion/src/javadoc/bugs/BasicTestFields.js", "package javadoc.bugs;\n/**\n * {@link String.}\n * \n * @see javadoc.util.Collection\n * @see javadoc.util.List#add(Object)\n */public class BasicTestBugs<A> {\n}", "/Completion/src/javadoc/util/Collection.js", "package javadoc.util;\npublic interface Collection<E> {}\npublic interface List<E> {}\n\tpublic void add(E e);\n}"};
        this.completeInJavadoc(sources, true, "String.", 0);
        this.assertSortedResults("");
    }

    public void testBug114341a() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n  /**\n   * Secondary.Mem\n   */\n  void foo() {}\n}\nclass Secondary {\n  class Member {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "Secondary.Mem");
        this.assertSortedResults("Secondary.Member[JSDOC_TYPE_REF]{{@link Member}, javadoc.text, Ljavadoc.text.Secondary$Member;, null, null, " + this.positions + 49 + "}\n" + "Secondary.Member[TYPE_REF]{Member, javadoc.text, Ljavadoc.text.Secondary$Member;, null, null, " + this.positions + 18 + "}");
    }

    public void testBug114341b() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n  /**\n   * @see Secondary.Mem\n   */\n  void foo() {}\n}\nclass Secondary {\n  class Member {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "Mem");
        this.assertSortedResults("Secondary.Member[TYPE_REF]{Member, javadoc.text, Ljavadoc.text.Secondary$Member;, null, null, " + this.positions + 18 + "}");
    }

    public void testBug114341c() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n  /**\n   * {@link Secondary.Mem }\n   */\n  void foo() {}\n}\nclass Secondary {\n  class Member {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "Mem");
        this.assertSortedResults("Secondary.Member[TYPE_REF]{Member, javadoc.text, Ljavadoc.text.Secondary$Member;, null, null, " + this.positions + 18 + "}");
    }

    public void testBug114341d() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n  /**\n   * javadoc.text.Secondary.Mem\n   */\n  void foo() {}\n}\nclass Secondary {\n  class Member {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "javadoc.text.Secondary.Mem");
        this.assertSortedResults("Secondary.Member[JSDOC_TYPE_REF]{{@link Member}, javadoc.text, Ljavadoc.text.Secondary$Member;, null, null, " + this.positions + 49 + "}\n" + "Secondary.Member[TYPE_REF]{Member, javadoc.text, Ljavadoc.text.Secondary$Member;, null, null, " + this.positions + 18 + "}");
    }

    public void testBug114341e() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n  /**\n   * @see javadoc.text.Secondary.Mem\n   */\n  void foo() {}\n}\nclass Secondary {\n  class Member {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "Mem");
        this.assertSortedResults("Secondary.Member[TYPE_REF]{Member, javadoc.text, Ljavadoc.text.Secondary$Member;, null, null, " + this.positions + 18 + "}");
    }

    public void testBug114341f() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n  /**\n   * {@link javadoc.text.Secondary.Mem }\n   */\n  void foo() {}\n}\nclass Secondary {\n  class Member {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "Mem");
        this.assertSortedResults("Secondary.Member[TYPE_REF]{Member, javadoc.text, Ljavadoc.text.Secondary$Member;, null, null, " + this.positions + 18 + "}");
    }

    public void testBug115662a() throws JavaScriptModelException {
        String source = "package bugs.b115662;\n/**\n * {@link #to\n */\npublic class Tests {\n\tint toto;\n}\n";
        this.completeInJavadoc("/Completion/src/bugs/b115662/Test.js", source, true, "to");
        this.assertSortedResults("toString[FUNCTION_REF]{toString(), Ljava.lang.Object;, ()Ljava.lang.String;, toString, null, " + this.positions + 29 + "}\n" + "toto[FIELD_REF]{toto, Lbugs.b115662.Tests;, I, toto, null, " + this.positions + 29 + "}");
    }

    public void testBug115662b() throws JavaScriptModelException {
        String source = "package bugs.b115662;\n/**\n * {@link #toString()\n */\npublic class Tests {\n\tint toto;\n}\n";
        this.completeInJavadoc("/Completion/src/bugs/b115662/Test.js", source, true, "to");
        this.assertSortedResults("toString[FUNCTION_REF]{toString(), Ljava.lang.Object;, ()Ljava.lang.String;, toString, null, " + this.positions + 29 + "}\n" + "toto[FIELD_REF]{toto, Lbugs.b115662.Tests;, I, toto, null, " + this.positions + 29 + "}");
    }

    public void testBug115662c() throws JavaScriptModelException {
        String source = "package bugs.b115662;\n/**\n * {@link #toString()\n */\npublic class Test {\n\tint toto;\n}\n";
        this.completeInJavadoc("/Completion/src/bugs/b115662/Test.js", source, true, "toString");
        this.assertSortedResults("toString[FUNCTION_REF]{toString(), Ljava.lang.Object;, ()Ljava.lang.String;, toString, null, " + this.positions + 33 + "}");
    }

    public void testBug117183a() throws JavaScriptModelException {
        String[] sources = new String[]{"/Completion/src/javadoc/bugs/BasicTestBugs.js", "package javadoc.bugs;\n/**\n * Completion inside reference Reference#A_STATIC_FIELD.\n * Try to complete wherever inside A_STATIC_FIELD gives no proposal!\n */\npublic class BasicTestBugs {\n}\n", "/Completion/src/javadoc/bugs/Reference.js", "package javadoc.bugs;\npublic class Reference {\n\tpublic static int A_STATIC_FIELD = 0;\n}\n"};
        this.completeInJavadoc(sources, true, "Reference#A_");
        this.assertSortedResults("A_STATIC_FIELD[JSDOC_FIELD_REF]{{@link Reference#A_STATIC_FIELD}, Ljavadoc.bugs.Reference;, I, A_STATIC_FIELD, null, " + this.positions + 49 + "}\n" + "A_STATIC_FIELD[JSDOC_VALUE_REF]{{@value Reference#A_STATIC_FIELD}, Ljavadoc.bugs.Reference;, I, A_STATIC_FIELD, null, " + this.positions + 49 + "}");
    }

    public void testBug117183b() throws JavaScriptModelException {
        String[] sources = new String[]{"/Completion/src/javadoc/bugs/BasicTestBugs.js", "package javadoc.bugs;\n/**\n * Completion inside reference Reference#A_STATIC_FIELD.\n * Try to complete wherever inside A_STATIC_FIELD gives no proposal!\n */\npublic class BasicTestBugs {\n}\n", "/Completion/src/javadoc/bugs/Reference.js", "package javadoc.bugs;\npublic class Reference {\n\tpublic static int A_STATIC_FIELD = 0;\n}\n"};
        this.completeInJavadoc(sources, true, "Reference#A_STATIC_FIELD");
        this.assertSortedResults("A_STATIC_FIELD[JSDOC_FIELD_REF]{{@link Reference#A_STATIC_FIELD}, Ljavadoc.bugs.Reference;, I, A_STATIC_FIELD, null, " + this.positions + 53 + "}\n" + "A_STATIC_FIELD[JSDOC_VALUE_REF]{{@value Reference#A_STATIC_FIELD}, Ljavadoc.bugs.Reference;, I, A_STATIC_FIELD, null, " + this.positions + 53 + "}");
    }

    public void testBug117183c() throws JavaScriptModelException {
        String[] sources = new String[]{"/Completion/src/javadoc/bugs/BasicTestBugs.js", "package javadoc.bugs;\n/**\n * Completion after Obj|\n */\nclass BasicTestBugs {\n}\n"};
        this.completeInJavadoc(sources, true, "Obj");
        this.assertSortedResults("Object[JSDOC_TYPE_REF]{{@link Object}, java.lang, Ljava.lang.Object;, null, null, " + this.positions + 52 + "}\n" + "Object[TYPE_REF]{Object, java.lang, Ljava.lang.Object;, null, null, " + this.positions + 21 + "}");
    }

    public void testBug117183d() throws JavaScriptModelException {
        String[] sources = new String[]{"/Completion/src/javadoc/bugs/BasicTestBugs.js", "package javadoc.bugs;\n/**\n * Completion after Str.\n */\nclass BasicTestBugs {\n}\n"};
        this.completeInJavadoc(sources, true, "Str");
        this.assertSortedResults("String[JSDOC_TYPE_REF]{{@link String}, java.lang, Ljava.lang.String;, null, null, " + this.positions + 52 + "}\n" + "String[TYPE_REF]{String, java.lang, Ljava.lang.String;, null, null, " + this.positions + 21 + "}");
    }

    public void testBug118105() throws JavaScriptModelException {
        String source = "package bugs.b118105;\n/**\n * Some words here {@link Str.\n */\npublic class BasicTestBugs {\n}\n";
        this.completeInJavadoc("/Completion/src/bugs/b118105/BasicTestBugs.js", source, true, "Str");
        this.assertSortedResults("String[TYPE_REF]{String, java.lang, Ljava.lang.String;, null, null, " + this.positions + 21 + "}");
    }

    public void testBug118092() throws JavaScriptModelException {
        String source = "package bugs.b118092;\npublic class BasicTestBugs {\n   /**\n    * \u00b8<c\n    */\n   public void method() {}\n}\n";
        this.completeInJavadoc("/Completion/src/bugs/b118092/BasicTestBugs.js", source, true, "<c");
        this.assertSortedResults("");
    }

    public void testBug118311() throws JavaScriptModelException {
        String source = "package bugs.b118311;\n/**\n * Text \\@\n */\npublic class BasicTestBugs {\n\n}\n";
        this.completeInJavadoc("/Completion/src/bugs/b118311/BasicTestBugs.js", source, true, "@");
        this.assertSortedResults("docRoot[JSDOC_INLINE_TAG]{{@docRoot}, null, null, docRoot, null, " + this.positions + 8 + "}\n" + "link[JSDOC_INLINE_TAG]{{@link}, null, null, link, null, " + this.positions + 8 + "}\n" + "linkplain[JSDOC_INLINE_TAG]{{@linkplain}, null, null, linkplain, null, " + this.positions + 8 + "}\n" + "value[JSDOC_INLINE_TAG]{{@value}, null, null, value, null, " + this.positions + 8 + "}");
    }

    public void testBug118397a() throws JavaScriptModelException {
        String source = "package bugs.b118397;\n/**\n * @see bugs.b118.BasicTestBugs\n */\npublic class BasicTestBugs {\n}\n";
        this.completeInJavadoc("/Completion/src/bugs/b118397/BasicTestBugs.js", source, true, "bugs.b118", 2);
        this.assertSortedResults("bugs.b118397[PACKAGE_REF]{bugs.b118397, bugs.b118397, null, null, null, " + this.positions + 20 + "}");
    }

    public void testBug118397b() throws JavaScriptModelException {
        String source = "package bugs.b118397;\n/**\n * @see Basic.Inner\n */\npublic class BasicTestBugs {\n\tclass Inner {\n\t}\n}\n";
        this.completeInJavadoc("/Completion/src/bugs/b118397/BasicTestBugs.js", source, true, "Basic");
        this.assertSortedResults("BasicTestBugs[TYPE_REF]{BasicTestBugs, bugs.b118397, Lbugs.b118397.BasicTestBugs;, null, null, " + this.positions + 21 + "}\n" + "BasicTestReferences[TYPE_REF]{org.eclipse.wst.jsdt.core.tests.BasicTestReferences, org.eclipse.wst.jsdt.core.tests, Lorg.eclipse.wst.jsdt.core.tests.BasicTestReferences;, null, null, " + this.positions + 18 + "}");
    }

    public void testBug118397c() throws JavaScriptModelException {
        String source = "package bugs.b118397;\n/**\n * @see BasicTestBugs.In.Level2\n */\npublic class BasicTestBugs {\n\tclass Inner {\n\t\tclass Level2 {\n\t\t\tclass Level3 {\n\t\t\t}\n\t\t}\n\t}\n}\n";
        this.completeInJavadoc("/Completion/src/bugs/b118397/BasicTestBugs.js", source, true, "In");
        this.assertSortedResults("BasicTestBugs.Inner[TYPE_REF]{Inner, bugs.b118397, Lbugs.b118397.BasicTestBugs$Inner;, null, null, " + this.positions + 18 + "}");
    }

    public void testBug118397d() throws JavaScriptModelException {
        String source = "package bugs.b118397;\n/**\n * @see BasicTestBugs.Inner.Lev.Level3\n */\npublic class BasicTestBugs {\n\tclass Inner {\n\t\tclass Level2 {\n\t\t\tclass Level3 {\n\t\t\t}\n\t\t}\n\t}\n}\n";
        this.completeInJavadoc("/Completion/src/bugs/b118397/BasicTestBugs.js", source, true, "Lev");
        this.assertSortedResults("BasicTestBugs.Inner.Level2[TYPE_REF]{Level2, bugs.b118397, Lbugs.b118397.BasicTestBugs$Inner$Level2;, null, null, " + this.positions + 18 + "}");
    }

    public void testBug139621a() throws JavaScriptModelException {
        String source = "package bugs.b139621;\npublic class BasicTestBugs {\n\t/**\n\t * Test with only an orphan comment in type declaration\n\t * @see Obj\n\t */\n}\n";
        this.completeInJavadoc("/Completion/src/bugs/b139621/BasicTestBugs.js", source, true, "Obj");
        this.assertSortedResults("Object[TYPE_REF]{Object, java.lang, Ljava.lang.Object;, null, null, " + this.positions + 21 + "}");
    }

    public void testBug139621b() throws JavaScriptModelException {
        String source = "package bugs.b139621;\n/**\n * Test with an existing javadoc type declaration\n * @see Test\n */\npublic class BasicTestBugs {\n\t/**\n\t * Test with only an orphan comment in type declaration\n\t * @see Obj\n\t */\n}\n";
        this.completeInJavadoc("/Completion/src/bugs/b139621/BasicTestBugs.js", source, true, "Obj");
        this.assertSortedResults("Object[TYPE_REF]{Object, java.lang, Ljava.lang.Object;, null, null, " + this.positions + 21 + "}");
    }

    public void testBug139621c() throws JavaScriptModelException {
        String source = "package bugs.b139621;\npublic class BasicTestBugs {\n\t/**\n\t * Test with only an orphan comment in type declaration\n\t * (completion for tags)\n\t * @\n\t */\n}\n";
        this.completeInJavadoc("/Completion/src/bugs/b139621/BasicTestBugs.js", source, true, "@");
        this.assertSortedResults("author[JSDOC_BLOCK_TAG]{@author, null, null, author, null, " + this.positions + 8 + "}\n" + "category[JSDOC_BLOCK_TAG]{@category, null, null, category, null, " + this.positions + 8 + "}\n" + "deprecated[JSDOC_BLOCK_TAG]{@deprecated, null, null, deprecated, null, " + this.positions + 8 + "}\n" + "docRoot[JSDOC_INLINE_TAG]{{@docRoot}, null, null, docRoot, null, " + this.positions + 8 + "}\n" + "exception[JSDOC_BLOCK_TAG]{@exception, null, null, exception, null, " + this.positions + 8 + "}\n" + "inheritDoc[JSDOC_INLINE_TAG]{{@inheritDoc}, null, null, inheritDoc, null, " + this.positions + 8 + "}\n" + "link[JSDOC_INLINE_TAG]{{@link}, null, null, link, null, " + this.positions + 8 + "}\n" + "linkplain[JSDOC_INLINE_TAG]{{@linkplain}, null, null, linkplain, null, " + this.positions + 8 + "}\n" + "param[JSDOC_BLOCK_TAG]{@param, null, null, param, null, " + this.positions + 8 + "}\n" + "return[JSDOC_BLOCK_TAG]{@return, null, null, return, null, " + this.positions + 8 + "}\n" + "see[JSDOC_BLOCK_TAG]{@see, null, null, see, null, " + this.positions + 8 + "}\n" + "serial[JSDOC_BLOCK_TAG]{@serial, null, null, serial, null, " + this.positions + 8 + "}\n" + "serialData[JSDOC_BLOCK_TAG]{@serialData, null, null, serialData, null, " + this.positions + 8 + "}\n" + "serialField[JSDOC_BLOCK_TAG]{@serialField, null, null, serialField, null, " + this.positions + 8 + "}\n" + "since[JSDOC_BLOCK_TAG]{@since, null, null, since, null, " + this.positions + 8 + "}\n" + "throws[JSDOC_BLOCK_TAG]{@throws, null, null, throws, null, " + this.positions + 8 + "}\n" + "value[JSDOC_INLINE_TAG]{{@value}, null, null, value, null, " + this.positions + 8 + "}\n" + "version[JSDOC_BLOCK_TAG]{@version, null, null, version, null, " + this.positions + 8 + "}");
    }

    public void testBug139621d() throws JavaScriptModelException {
        String source = "package bugs.b139621;\npublic class BasicTestBugs {\n\t/**\n\t * Test with only an orphan comment in type declaration\n\t * (variation of completion for tags but considered in text as it's in fact tag start character is after a reference )\n\t * @see Object\t * @\n\t */\n}\n";
        this.completeInJavadoc("/Completion/src/bugs/b139621/BasicTestBugs.js", source, true, "@", 2);
        this.assertSortedResults("docRoot[JSDOC_INLINE_TAG]{{@docRoot}, null, null, docRoot, null, " + this.positions + 8 + "}\n" + "inheritDoc[JSDOC_INLINE_TAG]{{@inheritDoc}, null, null, inheritDoc, null, " + this.positions + 8 + "}\n" + "link[JSDOC_INLINE_TAG]{{@link}, null, null, link, null, " + this.positions + 8 + "}\n" + "linkplain[JSDOC_INLINE_TAG]{{@linkplain}, null, null, linkplain, null, " + this.positions + 8 + "}\n" + "value[JSDOC_INLINE_TAG]{{@value}, null, null, value, null, " + this.positions + 8 + "}");
    }

    public void testBug139621e() throws JavaScriptModelException {
        String source = "package bugs.b139621;\n/**\n * Test with orphan comment after a method declaration\n * @see Test\n */\npublic class BasicTestBugs {\n\tpublic void foo() {}\n\t/**\n\t * This method returns an object\n\t * @see Obj\n\t */\n}\n";
        this.completeInJavadoc("/Completion/src/bugs/b139621/BasicTestBugs.js", source, true, "Obj");
        this.assertSortedResults("Object[TYPE_REF]{Object, java.lang, Ljava.lang.Object;, null, null, " + this.positions + 21 + "}");
    }

    public void testBug139621f() throws JavaScriptModelException {
        String source = "package bugs.b139621;\n/**\n * Test with orphan comment after a field declaration\n * @see Test\n */\npublic class BasicTestBugs {\n\tpublic int x;\n\t/**\n\t * This method returns an object\n\t * @see Obj\n\t */\n}\n";
        this.completeInJavadoc("/Completion/src/bugs/b139621/BasicTestBugs.js", source, true, "Obj");
        this.assertSortedResults("Object[TYPE_REF]{Object, java.lang, Ljava.lang.Object;, null, null, " + this.positions + 21 + "}");
    }

    public void testBug139621g() throws JavaScriptModelException {
        String source = "package bugs.b139621;\n/**\n * Compilation unit without any type\n * @see Obj\n */\n";
        this.completeInJavadoc("/Completion/src/bugs/b139621/BasicTestBugs.js", source, true, "Obj");
        this.assertSortedResults("Object[TYPE_REF]{Object, java.lang, Ljava.lang.Object;, null, null, " + this.positions + 21 + "}");
    }

    public void testBug139621h() throws JavaScriptModelException {
        String source = "package bugs.b139621;\n/**\n * Compilation unit without any type\n * (completion for tags)\n * @\n */\n";
        this.completeInJavadoc("/Completion/src/bugs/b139621/BasicTestBugs.js", source, true, "@");
        this.assertSortedResults("author[JSDOC_BLOCK_TAG]{@author, null, null, author, null, " + this.positions + 8 + "}\n" + "category[JSDOC_BLOCK_TAG]{@category, null, null, category, null, " + this.positions + 8 + "}\n" + "deprecated[JSDOC_BLOCK_TAG]{@deprecated, null, null, deprecated, null, " + this.positions + 8 + "}\n" + "docRoot[JSDOC_INLINE_TAG]{{@docRoot}, null, null, docRoot, null, " + this.positions + 8 + "}\n" + "link[JSDOC_INLINE_TAG]{{@link}, null, null, link, null, " + this.positions + 8 + "}\n" + "linkplain[JSDOC_INLINE_TAG]{{@linkplain}, null, null, linkplain, null, " + this.positions + 8 + "}\n" + "see[JSDOC_BLOCK_TAG]{@see, null, null, see, null, " + this.positions + 8 + "}\n" + "serial[JSDOC_BLOCK_TAG]{@serial, null, null, serial, null, " + this.positions + 8 + "}\n" + "since[JSDOC_BLOCK_TAG]{@since, null, null, since, null, " + this.positions + 8 + "}\n" + "value[JSDOC_INLINE_TAG]{{@value}, null, null, value, null, " + this.positions + 8 + "}\n" + "version[JSDOC_BLOCK_TAG]{@version, null, null, version, null, " + this.positions + 8 + "}");
    }

    public void testBug139621i() throws JavaScriptModelException {
        String source = "package bugs.b139621;\n/**\n * Compilation unit without any type\n * (variation of completion for tags but considered in text as it's in fact tag start character is after a reference )\n * @see Object The root class * @\n */\n";
        this.completeInJavadoc("/Completion/src/bugs/b139621/BasicTestBugs.js", source, true, "@", 2);
        this.assertSortedResults("docRoot[JSDOC_INLINE_TAG]{{@docRoot}, null, null, docRoot, null, " + this.positions + 8 + "}\n" + "link[JSDOC_INLINE_TAG]{{@link}, null, null, link, null, " + this.positions + 8 + "}\n" + "linkplain[JSDOC_INLINE_TAG]{{@linkplain}, null, null, linkplain, null, " + this.positions + 8 + "}\n" + "value[JSDOC_INLINE_TAG]{{@value}, null, null, value, null, " + this.positions + 8 + "}");
    }

    public void testBug144866() throws JavaScriptModelException {
        String source = "package bugs.b144866;\npublic class BasicTestBugs {\n\tpublic static int EXAMPLE = 0;\n\t/**\n\t * This method returns an object\n\t * @see Object\n\t * \tThis method will use {@value #EX } constant value...\n\t */\n\tpublic void foo() {\n\t}\n}\n";
        this.completeInJavadoc("/Completion/src/bugs/b144866/BasicTestBugs.js", source, true, "EX", 2);
        this.assertSortedResults("EXAMPLE[FIELD_REF]{EXAMPLE, Lbugs.b144866.BasicTestBugs;, I, EXAMPLE, null, " + this.positions + 18 + "}");
    }

    public void testBug171016() throws JavaScriptModelException {
        String source = "package bugs.b171016;\npublic class BasicTestBugs {\n\tpublic void foo() {}}\nclass X extends BasicTestBugs {\n\t/**\n\t * {@In\n\t */\n\tpublic void foo() {}}\n";
        this.completeInJavadoc("/Completion/src/bugs/b171016/BasicTestBugs.js", source, true, "{@In", 1);
        this.assertSortedResults("inheritDoc[JSDOC_INLINE_TAG]{{@inheritDoc}, null, null, inheritDoc, null, " + this.positions + 8 + "}");
    }

    public void testBug171016b() throws JavaScriptModelException {
        String source = "package bugs.b171016;\npublic class BasicTestBugs {\n\tpublic void foo() {}}\nclass X extends BasicTestBugs {\n\t/**\n\t * @In\n\t */\n\tpublic void foo() {}}\n";
        this.completeInJavadoc("/Completion/src/bugs/b171016/BasicTestBugs.js", source, true, "@In", 1);
        this.assertSortedResults("inheritDoc[JSDOC_INLINE_TAG]{{@inheritDoc}, null, null, inheritDoc, null, " + this.positions + 8 + "}");
    }

    public void _testBug171031() throws JavaScriptModelException {
        String source = "package bugs.b171031;\npublic class BasicTestBugs {\n\t/**\n\t * @In+\n\t */\n\tpublic void foo() {}}\n";
        this.completeInJavadoc("/Completion/src/bugs/b171031/BasicTestBugs.js", source, true, "@In", 1);
        this.assertSortedResults("");
    }
}

