/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.runtime;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;

public class TargetInterface {
    static final boolean DEBUG = false;
    String codeSnippetClassName;
    static final boolean TIMING = false;
    long sentTime;
    Socket socket;

    public void connect(String targetAddress, int portNumber, int timeout) {
        if (this.isConnected()) {
            return;
        }
        if (portNumber > 0) {
            long startTime = System.currentTimeMillis();
            do {
                try {
                    this.socket = new Socket(targetAddress, portNumber);
                    this.socket.setTcpNoDelay(true);
                    break;
                }
                catch (UnknownHostException unknownHostException) {
                }
                catch (IOException iOException) {}
                if (this.socket != null) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            } while (!this.isConnected() && System.currentTimeMillis() - startTime < (long)timeout);
        }
    }

    public void disconnect() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
            this.socket = null;
        }
    }

    public Result getResult() {
        String toString;
        String typeName;
        block5: {
            boolean hasValue = false;
            typeName = null;
            toString = null;
            if (this.isConnected()) {
                try {
                    DataInputStream in = new DataInputStream(this.socket.getInputStream());
                    hasValue = in.readBoolean();
                    if (hasValue) {
                        typeName = in.readUTF();
                        toString = in.readUTF();
                        break block5;
                    }
                    typeName = null;
                    toString = null;
                }
                catch (IOException e) {
                    hasValue = true;
                    typeName = e.getMessage();
                    toString = "";
                    this.disconnect();
                }
            } else {
                hasValue = true;
                typeName = "Connection has been lost";
                toString = "";
            }
        }
        Result result = new Result();
        result.displayString = toString == null ? null : toString.toCharArray();
        result.typeName = typeName == null ? null : typeName.toCharArray();
        return result;
    }

    boolean isConnected() {
        return this.socket != null;
    }

    public class Result {
        public char[] displayString;
        public char[] typeName;
    }
}

