/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.runtime;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.eclipse.wst.jsdt.core.tests.runtime.J9VirtualMachine;
import org.eclipse.wst.jsdt.core.tests.runtime.LocalVMLauncher;
import org.eclipse.wst.jsdt.core.tests.runtime.LocalVirtualMachine;
import org.eclipse.wst.jsdt.core.tests.runtime.RuntimeConstants;
import org.eclipse.wst.jsdt.core.tests.runtime.TargetException;
import org.eclipse.wst.jsdt.core.tests.util.Util;

public class J9VMLauncher
extends LocalVMLauncher
implements RuntimeConstants {
    int internalDebugPort = -1;
    String proxyOutFile;
    String symbolPath;

    protected String buildBootClassPath() {
        StringBuffer bootPathString = new StringBuffer();
        char pathSeparator = File.pathSeparatorChar;
        if (this.bootPath != null) {
            int length = this.bootPath.length;
            int i = 0;
            while (i < length) {
                bootPathString.append(this.bootPath[i]);
                bootPathString.append(pathSeparator);
                ++i;
            }
        } else {
            bootPathString.append(this.vmPath);
            bootPathString.append(File.separator);
            bootPathString.append("lib");
            bootPathString.append(File.separator);
            bootPathString.append("jclMax");
            bootPathString.append(File.separator);
            bootPathString.append("classes.zip");
            bootPathString.append(pathSeparator);
        }
        if (this.evalTargetPath != null) {
            bootPathString.append(this.evalTargetPath);
            bootPathString.append(File.separatorChar);
            bootPathString.append("bootPath");
        }
        return bootPathString.toString();
    }

    protected Process execCommandLine() throws TargetException {
        if (this.debugPort != -1 && this.internalDebugPort == -1) {
            throw new TargetException("Internal debug port has not been specified");
        }
        return super.execCommandLine();
    }

    public String[] getCommandLine() {
        int i;
        Vector<String> commandLine = new Vector<String>();
        commandLine.addElement(String.valueOf(this.vmPath) + (this.vmPath.endsWith(File.separator) ? "" : File.separator) + "bin" + File.separator + "j9");
        if (this.vmArguments != null) {
            i = 0;
            while (i < this.vmArguments.length) {
                commandLine.addElement(this.vmArguments[i]);
                ++i;
            }
        }
        if (this.debugPort != -1 && this.internalDebugPort != -1) {
            commandLine.addElement("-debug:" + this.internalDebugPort);
        }
        commandLine.addElement("-Xbootclasspath:" + this.buildBootClassPath());
        commandLine.addElement("-classpath");
        commandLine.addElement(this.buildClassPath());
        if (this.evalPort != -1) {
            commandLine.addElement("org.eclipse.wst.jsdt.core.tests.eval.target.CodeSnippetRunner");
        }
        if (this.evalPort != -1) {
            commandLine.addElement("-evalport");
            commandLine.addElement(Integer.toString(this.evalPort));
            commandLine.addElement("-cscp");
            commandLine.addElement(String.valueOf(this.evalTargetPath) + File.separator + "regularPath");
            commandLine.addElement("-csbp");
            commandLine.addElement(String.valueOf(this.evalTargetPath) + File.separator + "bootPath");
        }
        if (this.programClass != null) {
            commandLine.addElement(this.programClass);
        }
        if (this.programArguments != null) {
            i = 0;
            while (i < this.programArguments.length) {
                commandLine.addElement(this.programArguments[i]);
                ++i;
            }
        }
        Object[] result = new String[commandLine.size()];
        commandLine.copyInto(result);
        int i2 = 0;
        while (i2 < result.length) {
            Object argument = result[i2];
            if (((String)argument).indexOf(32) != -1) {
                result[i2] = "\"" + (String)argument + "\"";
            }
            ++i2;
        }
        return result;
    }

    public int getInternalDebugPort() {
        return this.internalDebugPort;
    }

    public String[] getProxyCommandLine() {
        Vector<String> commandLine = new Vector<String>();
        commandLine.addElement(String.valueOf(this.vmPath) + (this.vmPath.endsWith(File.separator) ? "" : File.separator) + "bin" + File.separator + "j9proxy");
        commandLine.addElement(String.valueOf(this.getTargetAddress()) + ":" + this.internalDebugPort);
        commandLine.addElement(Integer.toString(this.debugPort));
        if (this.symbolPath != null && this.symbolPath != "") {
            commandLine.addElement(this.symbolPath);
        }
        Object[] result = new String[commandLine.size()];
        commandLine.copyInto(result);
        return result;
    }

    public String getProxyOutFile() {
        return this.proxyOutFile;
    }

    public String getSymbolPath() {
        return this.symbolPath;
    }

    public LocalVirtualMachine launch() throws TargetException {
        LocalVirtualMachine localVM = super.launch();
        Process proxyProcess = null;
        if (this.debugPort != -1) {
            try {
                String[] commandLine = this.getProxyCommandLine();
                proxyProcess = Runtime.getRuntime().exec(commandLine);
            }
            catch (IOException iOException) {
                localVM.shutDown();
                throw new TargetException("Error launching J9 Proxy at " + this.vmPath);
            }
        }
        Process vmProcess = localVM.process;
        this.runningVMs.removeElement(localVM);
        J9VirtualMachine vm = new J9VirtualMachine(vmProcess, this.debugPort, this.evalTargetPath, proxyProcess, this.proxyOutFile);
        this.runningVMs.addElement(vm);
        return vm;
    }

    public void setDebugPort(int debugPort) {
        super.setDebugPort(debugPort);
        this.setInternalDebugPort(Util.getFreePort());
    }

    public void setInternalDebugPort(int internalDebugPort) {
        this.internalDebugPort = internalDebugPort;
    }

    public void setProxyOutFile(String proxyOutFile) {
        this.proxyOutFile = proxyOutFile;
    }

    public void setSymbolPath(String symbolPath) {
        this.symbolPath = symbolPath;
    }
}

