/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.future.compiler.regression;

import junit.framework.Test;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractRegressionTest;

public class ArrayTest
extends AbstractRegressionTest {
    static /* synthetic */ Class class$0;

    public ArrayTest(String name) {
        super(name);
    }

    public static Test suite() {
        return ArrayTest.buildAllCompliancesTestSuite(ArrayTest.testClass());
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.future.compiler.regression.ArrayTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void test001() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n  int[] x= new int[] {,};\n}\n"});
    }

    public void test002() {
        this.runConformTest(new String[]{"A.java", "public class A {\n    public static void main(String[] args) {\n        float[] tab = new float[] {-0.0f};\n        System.out.print(tab[0]);\n    }\n}"}, "-0.0");
    }

    public void test003() {
        this.runConformTest(new String[]{"A.java", "public class A {\n    public static void main(String[] args) {\n        float[] tab = new float[] {0.0f};\n        System.out.print(tab[0]);\n    }\n}"}, "0.0");
    }

    public void test004() {
        this.runConformTest(new String[]{"A.java", "public class A {\n    public static void main(String[] args) {\n        int[] tab = new int[] {-0};\n        System.out.print(tab[0]);\n    }\n}"}, "0");
    }

    public void test006() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo() {\n\t\tchar[][][] array = new char[][][10];\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tchar[][][] array = new char[][][10];\n\t                                ^^\nCannot specify an array dimension after an empty dimension\n----------\n");
    }

    public void test007() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic long lfield;\n\t\n\tpublic static void main(String[] args) {\n\t\tlfield = args.length;\n\t\tlfield = args(args).length;\n\t\t\n\t}\n\tstatic String[] args(String[] args) {\n\t\treturn args;\n\t}\n}\n"}, "");
    }

    public void test008() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic String getTexts(int i) [] {\n\t\tString[] texts = new String[1];\n\t\treturn texts; \n\t}\n    public static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
    }

    public void test009() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo() {\n\t\tX x = { 10, zork() };\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tX x = { 10, zork() };\n\t      ^^^^^^^^^^^^^^\nType mismatch: cannot convert from int[] to X\n----------\n2. ERROR in X.java (at line 3)\n\tX x = { 10, zork() };\n\t            ^^^^\nThe method zork() is undefined for the type X\n----------\n");
    }

    public void test010() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\n\tint i = {};\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tint i = {};\n\t        ^^\nType mismatch: cannot convert from Object[] to int\n----------\n");
    }
}

