/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;

public class TryStatementTest
extends AbstractRegressionTest {
    static /* synthetic */ Class class$0;

    public TryStatementTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TryStatementTest.buildAllCompliancesTestSuite(TryStatementTest.testClass());
    }

    public void test001() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n  public class X1 {\n    public X1() throws Exception {\n    }\n  }\n  public void method1(){\n    try {\n      new X1() {\n      };\n    } catch(Exception e){\n    }\n  }\n}\n"});
    }

    public void test002() {
        this.runConformTest(new String[]{"p/X.java", "package p;\nimport java.io.*;\nimport java.util.zip.*;\nclass X {\n  void bar() throws ZipException, IOException {}\n  void foo() {\n    try {\n      bar();\n    } catch (ZipException e) {\n    } catch (IOException e) {\n    }\n  }\n}\n"});
    }

    public void test003() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n  public class A1 {\n    public A1() throws Exception {\n    }\n  }\n  public void method1(){\n    try {\n      new A1() {\n      };\n    } catch(Exception e){\n    }\n  }\n}\n"});
    }

    public void test004() {
        this.runConformTest(new String[]{"p/ATC.java", "package p;\npublic class ATC {\n    \n    public class B extends Exception {\n      public B(String msg) { super(msg); }\n    }\n    \n    void foo() throws ATC.B {\n      Object hello$1 = null;\n      try {\n        throw new B(\"Inside foo()\");\n      } catch(B e) {\n        System.out.println(\"Caught B\");\n      }    \n    }       \n}\n"});
    }

    public void test005() {
        this.runConformTest(new String[]{"p/A.java", "package p;\nimport java.io.IOException;\nimport java.util.Vector;\n/**\n * This test0 should run without producing a java.lang.ClassFormatError\n */\npublic class A {\n  public Vector getComponents () {\n    try{\n      throw new IOException();\n    }\n    catch (IOException ioe) {\n    }\n    return null;\n  }\n  public static void main(String[] args) {\n    new A().getComponents();\n  }\n}\n"});
    }

    public void test006() {
        this.runConformTest(new String[]{"p/T.java", "package p;\nimport java.lang.reflect.*;\npublic class T extends InvocationTargetException {\n  public static void main(String[] args) {\n    T ct = new T();\n    ct.getTargetException();\n  }\n  public Throwable getTargetException() {\n    Runnable runnable = new Runnable() {\n      public void run() {\n        System.out.println(\"we got here\");\n        T.super.getTargetException();\n      }\n    };\n    runnable.run();\n    return new Throwable();\n  }\n}\n"});
    }

    public void test007() {
        this.runConformTest(new String[]{"TryFinally.java", "class TryFinally {\t\n\tpublic int readFile(String filename) throws Exception {\t\n\t\tint interfaceID = -1;\t\n\t\tint iNdx = 0;\t\n\t\ttry {\t\n\t\t\ttry {\t\n\t\t\t\treturn interfaceID;\t\n\t\t\t} // end try\t\n\t\t\tfinally {\t\n\t\t\t\tiNdx = 1;\t\n\t\t\t} // end finally\t\n\t\t} // end try\t\n\t\tcatch (Exception ex) {\t\n\t\t\tthrow new Exception(\"general exception \" + ex.getMessage() + \" on processing file \" + filename);\t\n\t\t} // end catch\t\n\t\tfinally {\t\n\t\t} // end finally\t\n\t} // end readFile method\t\n}\t\n"});
    }

    public void test008() {
        this.runConformTest(new String[]{"RedundantException.java", "import java.io.*;\npublic class RedundantException {\n\t/**\n\t     * Runs the class as an application.\n\t     */\n\tpublic static void main(String[] args) {\n\t\tRedundantException re = new RedundantException();\n\t\tre.catchIt();\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n\t/**\n\t     * Defines a method that lists an exception twice.\n\t     * This can be buried in a much longer list.\n\t     */\n\tvoid throwIt() throws IOException, IOException {\n\t\tthrow new IOException();\n\t}\n\t/**\n\t     * Catches the redundantly defined exception.\n\t     */\n\tvoid catchIt() {\n\t\ttry {\n\t\t\tthrowIt(); // compile error here\n\t\t} catch (IOException e) {\n\t\t\tSystem.out.println(\"Caught.\");\n\t\t}\n\t}\n}"}, "Caught.\nSUCCESS");
    }

    public void test009() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\npublic void save() {\n\tint a = 3;\n\ttry {\n\t\tObject warnings = null;\n      \ttry {\n         \tObject contexts = null;\n         \ttry {\n            \tSystem.out.println(warnings);\n\t\t\t \treturn;\n      \t \t} catch (NullPointerException npe) {\n\t\t\t\tSystem.out.println(contexts);\n               return;\n       \t}\n\t\t} catch (Exception e) {\n \t\t\treturn;\n   \t}\n\t} finally {\n     \tint b = 4;\n       System.out.println(\"#save -> \" + b + a);\n    }\n}\npublic static void main(String[] args) {\n\tnew Test().save();\n}\n}"}, "null\n#save -> 43");
    }

    public void test010() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\npublic void save() {\n\tint a = 3;\n\ttry {\n\t\tObject warnings = null;\n      \ttry {\n         \tObject contexts = null;\n         \ttry {\n            \tSystem.out.println(warnings);\n\t\t\t \treturn;\n      \t \t} catch (NullPointerException npe) {\n\t\t\t\tSystem.out.println(contexts);\n               return;\n       \t}\n\t\t} catch (Exception e) {\n \t\t\treturn;\n   \t}\n\t} catch(Exception e){\n\t\tObject dummy1 = null;\n\t\tSystem.out.println(dummy1);\n\t\tObject dummy2 = null;\n\t\tSystem.out.println(dummy2);\n\t\treturn;\n\t} finally {\n     \tint b = 4;\n       System.out.println(\"#save -> \" + b + a);\n    }\n}\npublic static void main(String[] args) {\n\tnew Test().save();\n}\n}"}, "null\n#save -> 43");
    }

    public void test011() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\npublic void save() {\n\tint a = 3;\n\ttry {\n\t\tObject warnings = null;\n      \ttry {\n         \tObject contexts = null;\n         \ttry {\n            \tSystem.out.println(warnings);\n\t\t\t \treturn;\n      \t \t} catch (NullPointerException npe) {\n\t\t\t\tSystem.out.println(contexts);\n               return;\n       \t}\n\t\t} catch (Exception e) {\n \t\t\treturn;\n   \t}\n\t} catch(Exception e){\n\t\tint dummy1 = 11;\n\t\tSystem.out.println(dummy1);\n\t\tint dummy2 = 12;\n\t\tSystem.out.println(dummy2);\n\t\treturn;\n\t} finally {\n     \tint b = 4;\n       System.out.println(\"#save -> \" + b + a);\n    }\n}\npublic static void main(String[] args) {\n\tnew Test().save();\n}\n}"}, "null\n#save -> 43");
    }

    public void test012() {
        this.runConformTest(new String[]{"X.java", "import java.io.*;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tnew X().delete(args);\n\t\t\tSystem.out.println(\"success\");\n\t\t} catch (Exception e) {\n\t\t}\n\t}\n\tvoid bar(int i) {\n\t}\n\tpublic Object delete(String[] resources) throws IOException {\n\t\ttry {\n\t\t\tint totalWork = 3;\n\t\t\tObject result = \"aaa\";\n\t\t\ttry {\n\t\t\t\treturn result;\n\t\t\t} catch (Exception e) {\n\t\t\t\tthrow new IOException();\n\t\t\t} finally {\n\t\t\t\tbar(totalWork);\n\t\t\t}\n\t\t} finally {\n\t\t\tbar(0);\n\t\t}\n\t}\n}\n"}, "success");
    }

    public void test013() {
        this.runConformTest(new String[]{"X.java", "import java.io.*;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tnew X().delete(args);\n\t\t\tSystem.out.println(\"success\");\n\t\t} catch (Exception e) {\n\t\t}\n\t}\n\tvoid bar(int i) {\n\t}\n\tpublic Object delete(String[] resources) throws IOException {\n\t\ttry {\n\t\t\tint totalWork = 3;\n\t\t\tObject result = \"aaa\";\n\t\t\ttry {\n\t\t\t\treturn result;\n\t\t\t} catch (Exception e) {\n\t\t\t\tthrow new IOException();\n\t\t\t} finally {\n\t\t\t\tbar(totalWork);\n\t\t\t}\n\t\t} finally {\n\t\t\tint totalWork = 4;\n\t\t\tbar(totalWork);\n\t\t}\n\t}\n}\n"}, "success");
    }

    public void test014() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\npublic void save() {\n\tint a = 3;\n\ttry {\n\t\tObject warnings = null;\n      \ttry {\n         \tint contexts = 17;\n         \ttry {\n\t\t\t\tObject dummy = null;\n            \tSystem.out.println(warnings);\n            \tSystem.out.println(dummy);\n\t\t\t \treturn;\n      \t \t} catch (NullPointerException npe) {\n\t\t\t\tSystem.out.println(contexts);\n               return;\n       \t}\n\t\t} catch (Exception e) {\n \t\t\treturn;\n   \t} finally { \n\t\t\tint c = 34; \n\t\t\tSystem.out.println(\"#inner-finally ->\" + a + c);\n       }\n\t} finally {\n     \tint b = 4;\n       System.out.println(\"#save -> \" + b + a);\n    }\n}\npublic static void main(String[] args) {\n\tnew Test().save();\n}\n}"}, "null\nnull\n#inner-finally ->334\n#save -> 43");
    }

    public void test015() {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\t\nimport java.io.IOException;\t\npublic class X {\t\n\tpublic static void main(String args[]) {\t\n\t\ttry { \t\n\t\t\tnew Object(){\t\n\t\t\t\t{\t\n\t\t\t\t\tif (true) throw new IOException();\t\n\t\t\t\t\tif (true) throw new Exception();\t\n\t\t\t\t}\t\n\t\t\t};\t\n\t\t\tSystem.out.println(\"FAILED\");\t\n\t\t} catch(Exception e){\t\n\t\t\tSystem.out.println(\"SUCCESS\");\t\n\t\t}\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test016() {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\t\nimport java.io.IOException;\t\npublic class X {\t\n\tpublic static void main(String args[]) {\t\n\t\tclass SomeClass {\t\n\t\t\tSomeClass () throws IOException {\t\n\t\t\t}\t\n\t\t}\t\n\t\ttry { \t\n\t\t\tnew Object(){\t\n\t\t\t\t{\t\n\t\t\t\t\tif (true) throw new IOException();\t\n\t\t\t\t\tif (true) throw new Exception();\t\n\t\t\t\t}\t\n\t\t\t};\t\n\t\t\tSystem.out.println(\"FAILED\");\t\n\t\t} catch(Exception e){\t\n\t\t\tSystem.out.println(\"SUCCESS\");\t\n\t\t}\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test017() {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\t\npublic class X {\t\n\tpublic static void main(String args[]) {\t\n\t\ttry { \t\n\t\t\tnew Object(){\t\n\t\t\t\t{\t\n\t\t\t\t\tfoo();\t\n\t\t\t\t}\t\n\t\t\t};\t\n\t\t\tSystem.out.println(\"FAILED\");\t\n\t\t} catch(Exception e){\t\n\t\t\tSystem.out.println(\"SUCCESS\");\t\n\t\t}\t\n\t}\t\n\tstatic class AEx extends Exception {} \n\tstatic class BEx extends Exception {} \n\tstatic void foo() throws AEx, BEx {\t\n\t\tthrow new AEx();\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test018() {
        this.runConformTest(new String[]{"VerifyEr.java", "public class VerifyEr {\t\n  protected boolean err(boolean b) {\t\n     try {\t\n          System.out.print(\"SUCC\");\t\n     } catch (Throwable t) {\t\n          return b;\t\n     } finally {\t\n          try {\t\n               if (b) {\t\n                    return b;\t\n               }\t\n          } finally {\t\n          \t\tSystem.out.println(\"ESS\");\t\n          }\t\n     }\t\n     return false;\t\n  }\t\n  public static void main(String[] args) {\t\n     new VerifyEr().err(false);\t\n  }\t\n}\t\n"}, "SUCCESS");
    }

    public void test019() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n\tString logger;\t\n  public static void main(String[] args) {\t\n    new X().foo();\t\n\t}\t\n\tpublic void foo() {\t\n\t\ttry {\t\n\t\t\tSystem.out.println(\"SUCCESS\");\t\n\t\t} catch (Exception ce) {\t\n\t\t\tString s = null;\t\n\t\t\ttry {\t\n\t\t\t\treturn;\t\n\t\t\t} catch (Exception ex) {\t\n\t\t\t}\t\n\t\t\ts.hashCode();\t\n\t\t} finally {\t\n\t\t\tif (this.logger == null) {\t\n\t\t\t\tString loggerManager = null;\t\n\t\t\t\tSystem.out.println(loggerManager);\t\n\t\t\t}\t\n\t\t}\t\n\t}\t\n}\t\n"}, "SUCCESS\nnull");
    }

    public void test020() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n\tString logger;\t\n  public static void main(String[] args) {\t\n    new X().foo();\t\n\t}\t\n\tpublic void foo() {\t\n\t\ttry {\t\n\t\t\tSystem.out.println(\"try1\");\t\n\t\t\ttry {\t\n\t\t\t\tSystem.out.println(\"try2\");\t\n\t\t\t} finally {\t\n\t\t\t\tSystem.out.println(\"finally2\");\t\n\t\t\t}\t\n\t\t} catch (Exception ce) {\t\n\t\t\tString s = null;\t\n\t\t\ttry {\t\n\t\t\t\treturn;\t\n\t\t\t} catch (Exception ex) {\t\n\t\t\t}\t\n\t\t\ts.hashCode();\t\n\t\t} finally {\t\n\t\t\tSystem.out.println(\"finally1\");\t\n\t\t\ttry {\t\n\t\t\t\tSystem.out.println(\"try3\");\t\n\t\t\t\tif (this.logger == null) {\t\n\t\t\t\t\tString loggerManager = null;\t\n\t\t\t\t}\t\n\t\t\t} finally {\t\n\t\t\t\tSystem.out.println(\"finally3\");\t\n\t\t\t}\t\n\t\t}\t\n\t\tint i1 = 0;\t\n\t\tint i2 = 0;\t\n\t\tint i3 = 0;\t\n\t\tint i4 = 0;\t\n\t\tint i5 = 0;\t\n\t\tint i6 = 0;\t\n\t\tint i7 = 0;\t\n\t\tint i8 = 0;\t\n\t\tint i9 = 0;\t\n\t}\t\n}\t\n"}, "try1\ntry2\nfinally2\nfinally1\ntry3\nfinally3");
    }

    public void test021() {
        this.runConformTest(new String[]{"pa/A.java", "package pa;\t\npublic abstract class A {\t\n  public static void main(String[] args) {\t\n    System.out.println(\"SUCCESS\");\t\n\t}\t\n\tprotected AIC memberA;\t\n\tprotected class AIC {\t\n\t\tpublic void methodAIC(String parameter) {\t\n\t\t  // ....do something\t\n\t\t}\t\n\t}\t\n}\t\n", "pb/B.java", "package pb;\t\npublic class B extends pa.A {\t\n\tprivate class BIC {\t\n\t\tpublic void methodBIC(String param) {\t\n\t\t\tmemberA.methodAIC(param);\t\n\t\t}\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test022() {
        this.runConformTest(new String[]{"pa/A.java", "package pa;\t\npublic class A {\t\n  public static void main(String[] args) {\t\n\t new A().f();\t\n    System.out.println(\"SUCCESS\");\t\n\t}\t\n\tboolean b = false;\t\n\tprivate Integer f() {\t\n\t\twhile (true) {\t\n\t\t\ttry {\t\n\t\t\t\tint x = 3;\t\n\t\t\t\tsynchronized (this) {\t\n\t\t\t\t\treturn null;\t\n\t\t\t\t}\t\n\t\t\t} finally {\t\n\t\t\t\tif (b)\t\n\t\t\t\t\tsynchronized (this) {\t\n\t\t\t\t\tint y = 3;\t\n\t\t\t\t}\t\n\t\t\t}\t\n\t\t}\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test023() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.hiddenCatchBlock", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tthrow new BX();\n\t\t} catch(BX e) {\n\t\t} catch(AX e) {\n\t\t}\n\t}\n} \nclass AX extends Exception {}\nclass BX extends AX {}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\t} catch(AX e) {\n\t        ^^\nUnreachable catch block for AX. Only more specific exceptions are thrown and handled by previous catch block(s).\n----------\n2. WARNING in X.java (at line 10)\n\tclass AX extends Exception {}\n\t      ^^\nThe serializable class AX does not declare a static final serialVersionUID field of type long\n----------\n3. WARNING in X.java (at line 11)\n\tclass BX extends AX {}\n\t      ^^\nThe serializable class BX does not declare a static final serialVersionUID field of type long\n----------\n", null, true, customOptions);
    }

    public void test024() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\t\npublic class X {\t\n\tpublic void myMethod() {\t\n\t    System.out.println(\"starting\");\t\n\t    try {\t\n\t        if (true) throw new LookupException();\t\n\t    } catch(DataException de) {\t\n\t       \tSystem.out.println(\"DataException occurred\");\t\n\t    } catch(LookupException le) {\t\n\t       \tSystem.out.println(\"LookupException occurred\");\t\n\t    } catch(Throwable t) {\t\n\t       \tSystem.out.println(\"Throwable occurred\");\t\n\t    }\t\n\t    System.out.println(\"SUCCESS\");\t\n\t}\t\n}\t\nclass DataException extends Throwable {\t\n} \t\nclass LookupException extends DataException {\t\n}\t\n"}, "----------\n1. ERROR in p\\X.java (at line 9)\n\t} catch(LookupException le) {\t\n\t        ^^^^^^^^^^^^^^^\nUnreachable catch block for LookupException. It is already handled by the catch block for DataException\n----------\n2. WARNING in p\\X.java (at line 17)\n\tclass DataException extends Throwable {\t\n\t      ^^^^^^^^^^^^^\nThe serializable class DataException does not declare a static final serialVersionUID field of type long\n----------\n3. WARNING in p\\X.java (at line 19)\n\tclass LookupException extends DataException {\t\n\t      ^^^^^^^^^^^^^^^\nThe serializable class LookupException does not declare a static final serialVersionUID field of type long\n----------\n");
    }

    public void test025() {
        this.runConformTest(new String[]{"X.java", "import java.io.*;\npublic class X\n{\n    {\n        String licenseFileName = \"C:/Program Files/Jatt/bin/license.key\";\n        File licenseFile = new File(licenseFileName);\n        try {\n            BufferedReader licenseReader = new BufferedReader(\n                new FileReader(licenseFile));\n            StringBuffer buf = new StringBuffer();\n            String line = null;\n            while ((line = licenseReader.readLine()) != null) {\n                char[] chars = line.toCharArray();\n                for (int i = 0; i < line.length(); i++) {\n                    if (!Character.isSpace(line.charAt(i))) {\n                        buf.append(line.charAt(i));\n                    }\n                }\n            }\n            \n        } catch (FileNotFoundException e) {\n            throw new Error(\"License file not found\", e);\n        } catch (IOException e) {\n            throw new Error(\"License file cannot be read\", e);\n        }\n    }\n  public X()\n  {\n  }\n  \n  public X(X r) \n  {\n  }    \n  public static void main(String[] args) {\n        System.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
    }

    public void test028() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n    public static void main(String[] args) {\n    \ttry {\n\t        new X().start();\n    \t} catch(Exception e) {\n            System.out.println(\"SUCCESS\");\n    \t}\n    }\n    public Object start() {\n        try {\n            return null;\n        } finally {\n            System.out.print(\"ONCE:\");\n            foo();\n        }\n    }\n\n    private void foo() {\n        throw new IllegalStateException(\"Gah!\");\n    }        \n}\n"}, "ONCE:SUCCESS");
    }

    public void test029() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n    public static void main(String[] args) {\n    \ttry {\n\t        new X().start();\n    \t} catch(Exception e) {\n            System.out.println(\"SUCCESS\");\n    \t}\n    }\n    public Object start() {\n        try {\n            return null;\n        } finally {\n            System.out.print(\"ONCE:\");\n            foo();\n            return this;\n        }\n    }\n\n    private void foo() {\n        throw new IllegalStateException(\"Gah!\");\n    }        \n}\n"}, "ONCE:SUCCESS");
    }

    public void test030() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n    public static void main(String[] args) {\n    \ttry {\n\t        new X().start();\n    \t} catch(Exception e) {\n            System.out.println(\"SUCCESS\");\n    \t}\n    }\n    public Object start() {\n        try {\n            Object o = null;\n            o.toString();\n            return null;\n        } catch(Exception e) {\n            System.out.print(\"EXCEPTION:\");\n\t\t\treturn e;        \t\n        } finally {\n            System.out.print(\"ONCE:\");\n            foo();\n        }\n    }\n\n    private void foo() {\n        throw new IllegalStateException(\"Gah!\");\n    }        \n}\n"}, "EXCEPTION:ONCE:SUCCESS");
    }

    public void test031() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "import java.io.IOException;\n\npublic class X {\n\tstatic void foo(Object o) {}\n\t\n    public static void main(String[] args) {\n    \ttry {\n    \t\tfoo(new Object() {\n    \t\t\tpublic void bar() throws IOException {\n    \t\t\t\tbar1();\n    \t\t\t}\n    \t\t});\n    \t} catch(IOException e) {\n    \t\te.printStackTrace();\n    \t}\n    }\n    \n    static void bar1() throws IOException {}\n}"}, "----------\n1. ERROR in X.java (at line 13)\n\t} catch(IOException e) {\n\t        ^^^^^^^^^^^\nUnreachable catch block for IOException. This exception is never thrown from the try statement body\n----------\n", null, true, customOptions);
    }

    public void test032() {
        this.runConformTest(new String[]{"X.java", "public class X\n{\n  static int except_count;\n\n  static boolean test_result = true;\n  \n  static Throwable all_except[] =\n  {\n    new AbstractMethodError(),             //  0\n    new ArithmeticException(),             //  1\n    new ArrayIndexOutOfBoundsException(),  //  2\n    new ArrayStoreException(),             //  3\n    new ClassCastException(),              //  4\n    new ClassCircularityError(),           //  5\n    new ClassFormatError(),                //  6\n    new ClassNotFoundException(),          //  7\n    new CloneNotSupportedException(),      //  8\n    new Error(),                           //  9\n    new Exception(),                       // 10\n    new IllegalAccessError(),              // 11\n    new IllegalAccessException(),          // 12\n    new IllegalArgumentException(),        // 13\n    new IllegalMonitorStateException(),    // 14\n    new IllegalThreadStateException(),     // 15\n    new IncompatibleClassChangeError(),    // 16\n    new IndexOutOfBoundsException(),       // 17\n    new InstantiationError(),              // 18\n    new InstantiationException(),          // 19\n    new InternalError(),                   // 20\n    new InterruptedException(),            // 21\n    new LinkageError(),                    // 22\n    new NegativeArraySizeException(),      // 23\n    new NoClassDefFoundError(),            // 24\n    new NoSuchFieldError(),                // 25\n    new NoSuchMethodError(),               // 26\n    new NoSuchMethodException(),           // 27\n    new NullPointerException(),            // 28\n    new NumberFormatException(),           // 29\n    new OutOfMemoryError(),                // 30\n    new StackOverflowError(),              // 31\n    new RuntimeException(),                // 32\n    new SecurityException(),               // 33\n    new StringIndexOutOfBoundsException(), // 34\n    new ThreadDeath(),                     // 35\n    new UnknownError(),                    // 36\n    new UnsatisfiedLinkError(),            // 37\n    new VerifyError(),                     // 38\n  };\n\n  private static void check_except(int i)\n    throws Throwable\n  {\n    if (except_count != i)\n    {\n      System.out.println(\"Error \"+except_count+\" != \"+i+\";\");\n      test_result=false;\n    }\n    throw all_except[++except_count];\n  }\n\n  public static void main(String[] args) throws Throwable\n  {\n    try {\n      except_count = 0;\n      throw all_except[except_count];\n    } catch (AbstractMethodError e0) {\n      try {\n        check_except(0);\n      } catch (ArithmeticException e1) {\n        try {\n          check_except(1);\n        } catch (ArrayIndexOutOfBoundsException e2) {\n          try {\n            check_except(2);\n          } catch (ArrayStoreException e3) {\n            try {\n              check_except(3);\n            } catch (ClassCastException e4) {\n              try {\n                check_except(4);\n              } catch (ClassCircularityError e5) {\n                try {\n                  check_except(5);\n                } catch (ClassFormatError e6) {\n                  try {\n                    check_except(6);\n                  } catch (ClassNotFoundException e7) {\n                    try {\n                      check_except(7);\n                    } catch (CloneNotSupportedException e8) {\n                      try {\n                        check_except(8);\n                      } catch (Error e9) {\n                        try {\n                          check_except(9);\n                        } catch (Exception e10) {\n                          try {\n                            check_except(10);\n                          } catch (IllegalAccessError e11) {\n                            try {\n                              check_except(11);\n                            } catch (IllegalAccessException e12) {\n                              try {\n                                check_except(12);\n                              } catch (IllegalArgumentException e13) {\n                                try {\n                                  check_except(13);\n                                } catch (IllegalMonitorStateException e14) {\n                                  try {\n                                    check_except(14);\n                                  } catch (IllegalThreadStateException e15) {\n                                    try {\n                                      check_except(15);\n                                    } catch (IncompatibleClassChangeError e16) {\n                                      try {\n                                        check_except(16);\n                                      } catch (IndexOutOfBoundsException e17) {\n                                        try {\n                                          check_except(17);\n                                        } catch (InstantiationError e18) {\n                                          try {\n                                            check_except(18);\n                                          } catch (InstantiationException e19) {\n                                            try {\n                                              check_except(19);\n                                            } catch (InternalError e20) {\n                                              try {\n                                                check_except(20);\n                                              } catch (InterruptedException \ne21) {\n                                                try {\n                                                  check_except(21);\n                                                } catch (LinkageError e22) {\n                                                  try {\n                                                    check_except(22);\n                                                  } catch \n(NegativeArraySizeException e23) {\n                                                    try {\n                                                      check_except(23);\n                                                    } catch \n(NoClassDefFoundError e24) {\n                                                      try {\n                                                        check_except(24);\n                                                      } catch (NoSuchFieldError \ne25) {\n                                                        try {\n                                                          check_except(25);\n                                                        } catch \n(NoSuchMethodError e26) {\n                                                          try {\n                                                            check_except(26);\n                                                          } catch \n(NoSuchMethodException e27) {\n                                                            try {\n                                                              check_except(27);\n                                                            } catch \n(NullPointerException e28) {\n                                                              try {\n                                                                check_except\n(28);\n                                                              } catch \n(NumberFormatException e29) {\n                                                                try {\n                                                                  check_except\n(29);\n                                                                } catch \n(OutOfMemoryError e30) {\n                                                                  try {\n                                                                    check_except\n(30);\n                                                                  } catch \n(StackOverflowError e31) {\n                                                                    try {\n                                                                      \ncheck_except(31);\n                                                                    } catch \n(RuntimeException e32) {\n                                                                      try {\n                                                                        \ncheck_except(32);\n                                                                      } catch \n(SecurityException e33) {\n                                                                        try {\n                                                                          \ncheck_except(33);\n                                                                        } catch \n(StringIndexOutOfBoundsException e34) {\n                                                                          try {\n                                                                            \ncheck_except(34);\n                                                                          } \ncatch (ThreadDeath e35) {\n                                                                            try \n{\n                                                                              \ncheck_except(35);\n                                                                            } \ncatch (UnknownError e36) {\n                                                                              \ntry {\n                                                                                \ncheck_except(36);\n                                                                              } \ncatch (UnsatisfiedLinkError e37) {\n                                                                                \ntry {\n                                                                                \n  check_except(37);\n                                                                                \n} catch (VerifyError e38) {\n                                                                                \n  ++except_count;\n                                                                                \n}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}\n    System.out.print(test_result & (except_count == all_except.length));\n  }\n}"}, "true");
    }

    public void test035() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tnew X().bar();\n\t\t} catch(Exception e){\n\t\t\tSystem.out.println(\"[end]\");\n\t\t}\n\t}\n\tObject bar() {\n\t\ttry {\n\t\t\tSystem.out.print(\"[try]\");\n\t\t\treturn this;\n\t\t} catch(Exception e){\n\t\t\tSystem.out.print(\"[WRONG CATCH]\");\n\t\t} finally {\n\t\t\tSystem.out.print(\"[finally]\");\n\t\t\tfoo();\n\t\t}\n\t\treturn this;\n\t}\n\tObject foo() {\n\t\tthrow new RuntimeException();\n\t}\n}\n"}, "[try][finally][end]");
    }

    public void test036() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tnew X().bar();\n\t\t} catch(Exception e){\n\t\t\tSystem.out.println(\"[end]\");\n\t\t}\n\t}\n\tObject bar() {\n\t\ttry {\n\t\t\tSystem.out.print(\"[try]\");\n\t\t\tthrow new RuntimeException();\n\t\t} catch(Exception e){\n\t\t\tSystem.out.print(\"[catch]\");\n\t\t\treturn this;\n\t\t} finally {\n\t\t\tSystem.out.print(\"[finally]\");\n\t\t\tfoo();\n\t\t}\n\t}\n\tObject foo() {\n\t\tthrow new RuntimeException();\n\t}\n}\n"}, "[try][catch][finally][end]");
    }

    public void test037() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tscenario();\n\t\t} catch(Exception e){\n\t\t\tSystem.out.println(\"[end]\");\n\t\t}\n\t}\n\n\tprivate static void scenario() throws Exception {\n\t\ttry {\n\t\t\tSystem.out.print(\"[try1]\");\n\t\t\ttry {\n\t\t\t\tSystem.out.print(\"[try2]\");\n\t\t\t\treturn;\n\t\t\t} catch(Exception e) {\n\t\t\t\tSystem.out.print(\"[catch2]\");\n\t\t\t} finally {\n\t\t\t\tSystem.out.print(\"[finally2]\");\n\t\t\t\tthrowRuntime();\n\t\t\t}\n\t\t} catch(Exception e) {\n\t\t\tSystem.out.print(\"[catch1]\");\n\t\t\tthrow e;\n\t\t} finally {\n\t\t\tSystem.out.print(\"[finally1]\");\n\t\t}\n\t}\n\n\tprivate static void throwRuntime() {\n\t\tthrow new RuntimeException(\"error\");\n\t}\n}\n"}, "[try1][try2][finally2][catch1][finally1][end]");
    }

    public void test038() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tint hasLoop() {\n\t\tint l, m, n;\n\t\tfor (m = 0; m < 10; m++) {\n\t\t\tn = 2;\n\t\t\ttry {\n\t\t\t\tn = 3;\n\t\t\t\ttry {\n\t\t\t\t\tn = 4;\n\t\t\t\t} catch (ArithmeticException e1) {\n\t\t\t\t\tn = 11;\n\t\t\t\t} finally {\n\t\t\t\t\tfor (l = 0; l < 10; l++) {\n\t\t\t\t\t\tn++;\n\t\t\t\t\t}\n\t\t\t\t\tif (n == 12) {\n\t\t\t\t\t\tn = 13;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t\tn = 15;\n\t\t\t\t}\n\t\t\t} catch (OutOfMemoryError e2) {\n\t\t\t\tn = 18;\n\t\t\t}\n\t\t}\n\t\treturn 0;\n\t}\n\n\tpublic static void main(String args[]) {\n      System.out.println(\"Loaded fine\");\n   }\n}\n"}, "Loaded fine");
    }

    public void test039() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void someMethod() {\n\t\tint count = 0;\n\t\tint code = -1;\n\t\twhile (count < 2 && (code == -1 || code == 2)) {\n\t\t\tcount++;\n\t\t\ttry {\n\t\t\t\t{\n\t\t\t\t\tSystem.out.print(\"[Try:\" + count + \";\" + code+\"]\");\n\t\t\t\t}\n\t\t\t\tcode = 0;\n\n\t\t\t} finally {\n\t\t\t\tSystem.out.print(\"[Finally\" + count + \";\" + code+\"]\");\n\t\t\t}\n\t\t}\n\t\tSystem.out.print(\"[Outering\");\n\n\t\tif (code == 0) {\n\t\t\tSystem.out.print(\"[Return:\" + count + \";\" + code+\"]\");\n\t\t\treturn;\n\t\t}\n\t\tthrow new RuntimeException(null + \"a\");\n\t}\n\n\tpublic static void main(String[] args) throws Exception {\n\t\tfor (int i = 0; i < 1; i++) {\n\t\t\tsomeMethod();\n\t\t\tSystem.out.println();\n\t\t}\n\t}\n}\n"}, "[Try:1;-1][Finally1;0][Outering[Return:1;0]");
    }

    public void test047() {
        if (new CompilerOptions((Map)this.getCompilerOptions()).complianceLevel <= 0x2F0000L) {
            this.runNegativeTest(new String[]{"X.java", "public class X {\n        public static void main(String[] args) {\n                try {\n\t\t\t\t\tif (false) throw null;\n\t\t\t\t\tthrow new Object();\n                } catch(Object o) {\n                }\n        }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tif (false) throw null;\n\t                 ^^^^\nCannot throw null as an exception\n----------\n2. ERROR in X.java (at line 5)\n\tthrow new Object();\n\t      ^^^^^^^^^^^^\nNo exception of type Object can be thrown; an exception type must be a subclass of Throwable\n----------\n3. ERROR in X.java (at line 6)\n\t} catch(Object o) {\n\t        ^^^^^^\nNo exception of type Object can be thrown; an exception type must be a subclass of Throwable\n----------\n");
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n        public static void main(String[] args) {\n                try {\n\t\t\t\t\tif (false) throw null;\n\t\t\t\t\tthrow new Object();\n                } catch(Object o) {\n                }\n        }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tthrow new Object();\n\t      ^^^^^^^^^^^^\nNo exception of type Object can be thrown; an exception type must be a subclass of Throwable\n----------\n2. ERROR in X.java (at line 6)\n\t} catch(Object o) {\n\t        ^^^^^^\nNo exception of type Object can be thrown; an exception type must be a subclass of Throwable\n----------\n");
    }

    public void _test056() {
        this.runNegativeTest(new String[]{"p/BytecodeA.java", "package p;\nclass BytecodeA {\n  \nint foo() { // good\n  boolean b = true;\n  if (b) {\n    if (true)\n      return 0;\n  } else {\n    if (true)\n      return 1;\n  }\n  return 5;\n}\nint foo10() {\n  try {\n    //if (true)\n      return 0;\n  } catch (Exception e) {\n    if (true)\n      return 1;\n  } finally {\n    if (true)\n      return 2;\n  };\n  return 1;\n}   \nint foo11() {\n  synchronized (this) {\n    if (true)\n      return 1;\n  };\n  return 2;\n} \nint foo12() {\n  for (;;)\n    return 1;\n}\nint foo13() {\n  for (;;)\n    if (true)\n      return 1;\n}\nint foo14() {\n  for (int i = 1; i < 10; i++)\n    if (true)\n      return 1;\n  return 2;\n} \nint foo15() {\n  for (int i = 1; i < 10; i++)\n    return 1;\n  return 2;\n}\nint foo16() {\n  final int i;\n  while (true) {\n    i = 1;\n    if (true)\n      break;\n  };\n  return 1;\n}              \nint foo17() {\n  final int i;\n  for (;;) {\n    i = 1;\n    if (true)\n      break;\n  };\n  return 1;\n} \nvoid foo2() {\n  L1 :;  // good\n}\nvoid foo20() {\n  if (true)\n    return;\n} \nvoid foo3() {\n  L : if (true) {\n    for (;;) {\n      continue L; // bad\n    }\n  }\n}   \nvoid foo4() {\n  L : if (true) {\n    try {\n      for (;;) {\n        continue L; // bad\n      }\n    } finally {\n      return;\n    }\n  } \n}\nvoid foo5() {\n  L : for (;;) {\n    continue L; // good\n  }\n}\nvoid foo5bis() {\n  L : K : for (;;) {\n    continue L; // good\n  }\n}\nvoid foo6(){\n  int i;\n  boolean a[] = new boolean[5];\n  a[i=1] = i > 0; // good\n}    \nvoid foo7(){\n  Object x[];\n  x [1] = (x = new Object[5]); // bad\n}    \nvoid foo8() {\n  try {\n  } catch (java.io.IOException e) {\n    foo(); // unreachable\n  }\n}\nvoid foo9() {\n  try {\n  } catch (NullPointerException e) {\n    foo(); // ok\n  }\n}\n    public static void main(String args[]) {\n      BytecodeA a = new BytecodeA();\n      a.foo10();\n    }\n}"}, "----------\n1. WARNING in p\\BytecodeA.java (at line 74)\n\tL1 :;  // good\n\t^^\nThe label L1 is never explicitly referenced\n----------\n2. ERROR in p\\BytecodeA.java (at line 83)\n\tcontinue L; // bad\n\t^^^^^^^^^^\ncontinue cannot be used outside of a loop\n----------\n3. ERROR in p\\BytecodeA.java (at line 91)\n\tcontinue L; // bad\n\t^^^^^^^^^^\ncontinue cannot be used outside of a loop\n----------\n4. WARNING in p\\BytecodeA.java (at line 93)\n\t} finally {\n      return;\n    }\n\t          ^^^^^^^^^^^^^^^^^^^^^\nfinally block does not complete normally\n----------\n5. WARNING in p\\BytecodeA.java (at line 104)\n\tL : K : for (;;) {\n\t    ^\nThe label K is never explicitly referenced\n----------\n6. ERROR in p\\BytecodeA.java (at line 105)\n\tcontinue L; // good\n\t^^^^^^^^^^\ncontinue cannot be used outside of a loop\n----------\n7. ERROR in p\\BytecodeA.java (at line 115)\n\tx [1] = (x = new Object[5]); // bad\n\t^\nThe local variable x may not have been initialized\n----------\n8. ERROR in p\\BytecodeA.java (at line 119)\n\t} catch (java.io.IOException e) {\n\t         ^^^^^^^^^^^^^^^^^^^\nUnreachable catch block for IOException. This exception is never thrown from the try statement body\n----------\n");
    }

    public void test057() {
        String[] sources = new String[]{"p1/Test.java", "package p1; \npublic class Test { \n\tpublic static void main(String[] arguments) { \n\t\ttry {\t\n\t\t\tthrow null; \n\t\t} catch(NullPointerException e){ \t\n\t\t\tSystem.out.println(\"SUCCESS\");\t\n\t\t}\t\n\t} \n} \n"};
        if (this.complianceLevel.equals("1.3")) {
            this.runNegativeTest(sources, "----------\n1. ERROR in p1\\Test.java (at line 5)\n\tthrow null; \n\t      ^^^^\nCannot throw null as an exception\n----------\n");
        } else {
            this.runConformTest(sources, "SUCCESS");
        }
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.compiler.regression.TryStatementTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }
}

