/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.JavadocTest;

public class JavadocBugsTest
extends JavadocTest {
    String docCommentSupport = "enabled";
    String reportInvalidJavadoc = "error";
    String reportInvalidJavadocVisibility = "private";
    String reportMissingJavadocTags = "error";
    String reportMissingJavadocComments = null;
    String reportDeprecation = "error";
    String reportJavadocDeprecation = null;
    static /* synthetic */ Class class$0;

    public JavadocBugsTest(String name) {
        super(name);
    }

    public static Class javadocTestClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.compiler.regression.JavadocBugsTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public static Test suite() {
        return JavadocBugsTest.buildAllCompliancesTestSuite(JavadocBugsTest.javadocTestClass());
    }

    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.doc.comment.support", this.docCommentSupport);
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadoc", this.reportInvalidJavadoc);
        if (!"ignore".equals(this.reportInvalidJavadoc)) {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTagsVisibility", this.reportInvalidJavadocVisibility);
        }
        if (this.reportJavadocDeprecation != null) {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTagsDeprecatedRef", this.reportJavadocDeprecation);
        }
        if (this.reportMissingJavadocComments != null) {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocComments", this.reportMissingJavadocComments);
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocCommentsOverriding", "enabled");
        } else {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocComments", this.reportInvalidJavadoc);
        }
        if (this.reportMissingJavadocTags != null) {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocTags", this.reportMissingJavadocTags);
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocTagsOverriding", "enabled");
        } else {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocTags", this.reportInvalidJavadoc);
        }
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.fieldHiding", "ignore");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.deprecation", this.reportDeprecation);
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.rawTypeReference", "ignore");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedPrivateMember", "ignore");
        return options;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.docCommentSupport = "enabled";
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocVisibility = "private";
        this.reportMissingJavadocTags = "ignore";
        this.reportMissingJavadocComments = "ignore";
        this.reportDeprecation = "error";
    }

    public void testBug45596() {
        this.runConformTest(new String[]{"test/X.java", "package test;\nclass X {\n\tvoid foo(int x, String str) {}\n}\n", "test/Y.java", "package test;\nclass Y {\n  /** */\n  protected X field = new X() {\n    void foo(int x, String str) {}\n  };\n}\n"});
    }

    public void testBug45596a() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid foo(int x, String str) {}\n}\n", "Y1.java", "public class Y1 {\n\t/** */\n\tprotected X field = new X() {\n\t\t/** Invalid javadoc comment in anonymous class */\n\t\tvoid foo(String str) {}\n\t};\n}\n", "Y2.java", "public class Y2 {\n\t/** */\n\tvoid foo() {\n\t\tX x = new X() {\n\t\t\t/** Invalid javadoc comment in anonymous class */\n\t\t\tvoid foo(String str) {}\n\t\t};\n\t\tx.foo(0, \"\");\n\t}\n}\n", "Y3.java", "public class Y3 {\n\tstatic X x;\n\tstatic {\n\t\tx = new X() {\n\t\t\t/** Invalid javadoc comment in anonymous class */\n\t\t\tvoid foo(String str) {}\n\t\t};\n\t}\n}\n"});
    }

    public void testBug45596b() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid foo(int x, String str) {}\n}\n", "Y1.java", "public class Y1 {\n\t/** */\n\tprotected X field = new X() {\n\t\t/**\n\t\t * Valid javadoc comment in anonymous class.\n\t\t * @param str String\n\t\t * @return int\n\t\t */\n\t\tint bar(String str) {\n\t\t\treturn 10;\n\t\t}\n\t};\n}\n", "Y2.java", "public class Y2 {\n\t/** */\n\tvoid foo() {\n\t\tX x = new X() {\n\t\t\t/**\n\t\t\t * Valid javadoc comment in anonymous class.\n\t\t\t * @param str String\n\t\t\t * @return int\n\t\t\t */\n\t\t\tint bar(String str) {\n\t\t\t\treturn 10;\n\t\t\t}\n\t\t};\n\t\tx.foo(0, \"\");\n\t}\n}\n", "Y3.java", "public class Y3 {\n\tstatic X x;\n\tstatic {\n\t\tx = new X() {\n\t\t\t/**\n\t\t\t * Valid javadoc comment in anonymous class.\n\t\t\t * @param str String\n\t\t\t * @return int\n\t\t\t */\n\t\t\tint bar(String str) {\n\t\t\t\treturn 10;\n\t\t\t}\n\t\t};\n\t}\n}\n"});
    }

    public void testBug45592() {
        this.runConformTest(new String[]{"a/Y.java", "package a;\n\n/** */\npublic class Y {\n\tprotected boolean bar(Object obj) {\n\t\treturn obj == null;\n\t}\n}\n", "test/X.java", "package test;\npublic class X {\n\tpublic static Boolean valueOf(boolean bool) {\n\t\tif (bool) {\n\t\t\treturn Boolean.TRUE;\n\t\t} else {\n\t\t\treturn Boolean.FALSE;\n\t\t}\n\t}\n}\n", "test/YY.java", "package test;\n\nimport a.Y;\n\n/** */\npublic class YY extends Y {\n\t/**\n\t * Returns a Boolean.\n\t * @param key\n\t * @return A Boolean telling whether the key is null or not.\n\t * @see #bar(Object)\n\t */\n\tprotected Boolean foo(Object key) {\n\t\treturn X.valueOf(bar(key));\n\t}\n}\n"});
    }

    public void testBug45737() {
        this.runConformTest(new String[]{"Y.java", "class Y {\n\tvoid foo() {\n\t\tX x = new X() {\n\t\t\t/**\n\t\t\t * Valid javadoc comment in anonymous class.\n\t\t\t * @param str String\n\t\t\t * @return int\n\t\t\t */\n\t\t\tint bar(String str) {\n\t\t\t\treturn 10;\n\t\t\t}\n\t\t};\n\t\tx.foo();\n\t}\n}\n", "X.java", "class X {\n\tvoid foo() {}\n}\n"});
    }

    public void testBug45669() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t/**\n\t * Valid javadoc comment with tags mixed order\n\t * @param str first param\n\t * \t\t@see String\n\t * @param dbl second param\n\t * \t\t@see Double\n\t * \t\talso\n\t * \t\t@see \"String ref\"\n\t * @return int\n\t * @throws InterruptedException\n\t * \n\t */\n\tint foo(String str, Double dbl) throws InterruptedException {\n\t\treturn 0;\n\t}\n}\n"});
    }

    public void testBug45669a() {
        this.reportMissingJavadocTags = "error";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/**\n\t * Javadoc comment with tags invalid mixed order\n\t * @param str first param\n\t * \t\t@see String\n\t * @throws InterruptedException\n\t * @param dbl second param\n\t * \t\t@see Double\n\t * \t\talso\n\t * \t\t@see \"String ref\"\n\t * @return int\n\t * \n\t */\n\tpublic int foo(String str, Double dbl) throws InterruptedException {\n\t\treturn 0;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\t* @param dbl second param\n\t   ^^^^^\nJavadoc: Unexpected tag\n----------\n2. ERROR in X.java (at line 14)\n\tpublic int foo(String str, Double dbl) throws InterruptedException {\n\t                                  ^^^\nJavadoc: Missing tag for parameter dbl\n----------\n");
    }

    public void testBug45958() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tint x;\n\tpublic X(int i) {\n\t\tx = i;\n\t}\n\t/**\n\t * @see #X(int)\n\t */\n\tvoid foo() {\n\t}\n}\n"});
    }

    public void testBug45958a() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tint x;\n\tpublic X(int i) {\n\t\tx = i;\n\t}\n\t/**\n\t * @see #X(String)\n\t */\n\tpublic void foo() {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\t* @see #X(String)\n\t        ^^^^^^^^^\nJavadoc: The constructor X(String) is undefined\n----------\n");
    }

    public void testBug45958b() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tint x;\n\tpublic X(int i) {\n\t\tx = i;\n\t}\n\t/**\n\t * @see #X(int)\n\t */\n\tpublic void foo() {\n\t}\n}\n", "XX.java", "public class XX extends X {\n\t/**\n\t * @param i\n\t * @see #X(int)\n\t */\n\tpublic XX(int i) {\n\t\tsuper(i);\n\t\tx++;\n\t}\n}\n"}, "----------\n1. ERROR in XX.java (at line 4)\n\t* @see #X(int)\n\t        ^\nJavadoc: The method X(int) is undefined for the type XX\n----------\n");
    }

    public void testBug45958c() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tint x;\n\tpublic X(int i) {\n\t\tx = i;\n\t}\n\t/**\n\t * @see #X(String)\n\t */\n\tvoid foo() {\n\t}\n\tvoid X(String str) {}\n}\n"});
    }

    public void testBug46901() {
        this.runConformTest(new String[]{"A.java", "public abstract class A {\n\tpublic A() { super(); }\n}\n", "X.java", "/**\n * @see A#A()\n */\npublic class X extends A {\n\tpublic X() { super(); }\n}\n"});
    }

    public void testBug47215() {
        this.runNegativeTest(new String[]{"X.java", "\t/**\n\t * @see X\n\t * @see X#X(int)\n\t * @see X(double)\n\t * @see X   (double)\n\t * @see X[double]\n\t * @see X!=}}\n\t * @see foo()\n\t * @see foo  ()\n\t */\n\tpublic class X {\n\t\tpublic X(int i){}\n\t\tpublic void foo() {}\n\t}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @see X(double)\n\t       ^^^^^^^^^\nJavadoc: Missing #: \"X(double)\"\n----------\n2. ERROR in X.java (at line 6)\n\t* @see X[double]\n\t       ^^^^^^^^^\nJavadoc: Malformed reference (missing end space separator)\n----------\n3. ERROR in X.java (at line 7)\n\t* @see X!=}}\n\t       ^^^^^\nJavadoc: Malformed reference (missing end space separator)\n----------\n4. ERROR in X.java (at line 8)\n\t* @see foo()\n\t       ^^^^^\nJavadoc: Missing #: \"foo()\"\n----------\n5. ERROR in X.java (at line 9)\n\t* @see foo  ()\n\t       ^^^\nJavadoc: foo cannot be resolved to a type\n----------\n");
    }

    public void testBug47341() {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\npublic class X {\n\tvoid foo_package() {}\n\tprotected void foo_protected() {}\n}\n", "p1/Y.java", "package p1;\npublic class Y extends X {\n\t/**\n\t * @see #foo_package()\n\t */\n\tprotected void bar() {\n\t\tfoo_package();\n\t}\n}\n", "p2/Y.java", "package p2;\nimport p1.X;\n\npublic class Y extends X {\n\t/**\n\t * @see X#foo_protected()\n\t */\n\tprotected void bar() {\n\t\tfoo_protected();\n\t}\n}\n"});
    }

    public void testBug47132() {
        this.reportMissingJavadocComments = "error";
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n  /** */\n  public void foo(){\n    new Object(){\n\t\tpublic int x;\n       public void bar(){}\n    };\n  }\n}\n"});
    }

    public void testBug47339() {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X implements Comparable {\n\t/**\n\t * @see java.lang.Comparable#compareTo(java.lang.Object)\n\t */\n\tpublic int compareTo(Object o) {\n\t\treturn 0;\n\t}\n\t/** @see Object#toString() */\n\tpublic String toString(){\n\t\treturn \"\";\n\t}\n}\n"});
    }

    public void testBug47339a() {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X extends RuntimeException {\n\t\n\t/**\n\t * @see RuntimeException#RuntimeException(java.lang.String)\n\t */\n\tpublic X(String message) {\n\t\tsuper(message);\n\t}\n}\n"});
    }

    public void testBug47339b() {
        this.reportMissingJavadocTags = "error";
        this.runNegativeTest(new String[]{"X.java", "/** */\npublic class X implements Comparable {\n\t/** */\n\tpublic int compareTo(Object o) {\n\t\treturn 0;\n\t}\n\t/** */\n\tpublic String toString(){\n\t\treturn \"\";\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tpublic int compareTo(Object o) {\n\t       ^^^\nJavadoc: Missing tag for return type\n----------\n2. ERROR in X.java (at line 4)\n\tpublic int compareTo(Object o) {\n\t                            ^\nJavadoc: Missing tag for parameter o\n----------\n3. ERROR in X.java (at line 8)\n\tpublic String toString(){\n\t       ^^^^^^\nJavadoc: Missing tag for return type\n----------\n");
    }

    public void testBug47339c() {
        this.reportMissingJavadocTags = "error";
        this.runNegativeTest(new String[]{"X.java", "/** */\npublic class X extends RuntimeException {\n\t\n\t/** */\n\tpublic X(String message) {\n\t\tsuper(message);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tpublic X(String message) {\n\t                ^^^^^^^\nJavadoc: Missing tag for parameter message\n----------\n");
    }

    public void testBug48064() {
        this.reportMissingJavadocTags = "error";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic X(String str) {}\n}\n", "Y.java", "public class Y extends X {\n\t/**\n\t * @see X#X(STRING)\n\t */\n\tpublic Y(String str) {super(str);}\n}\n"}, "----------\n1. ERROR in Y.java (at line 3)\n\t* @see X#X(STRING)\n\t           ^^^^^^\nJavadoc: STRING cannot be resolved to a type\n----------\n2. ERROR in Y.java (at line 5)\n\tpublic Y(String str) {super(str);}\n\t                ^^^\nJavadoc: Missing tag for parameter str\n----------\n");
    }

    public void testBug48064a() {
        this.reportMissingJavadocTags = "error";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void foo(String str) {}\n}\n", "Y.java", "public class Y extends X {\n\t/**\n\t * @see X#foo(STRING)\n\t */\n\tpublic void foo(String str) {super.foo(str);}\n}\n"}, "----------\n1. ERROR in Y.java (at line 3)\n\t* @see X#foo(STRING)\n\t             ^^^^^^\nJavadoc: STRING cannot be resolved to a type\n----------\n2. ERROR in Y.java (at line 5)\n\tpublic void foo(String str) {super.foo(str);}\n\t                       ^^^\nJavadoc: Missing tag for parameter str\n----------\n");
    }

    public void testBug48523() {
        this.runConformTest(new String[]{"X.java", "import java.io.IOException;\npublic class X {\n\tpublic void foo() throws IOException {}\n}\n", "Y.java", "import java.io.IOException;\npublic class Y extends X {\n\t/**\n\t * @throws IOException\n\t * @see X#foo()\n\t */\n\tpublic void foo() throws IOException {}\n}\n"});
    }

    public void testBug48711() {
        this.runConformTest(new String[]{"X.java", "import java.io.*;\n\npublic class X {\n\t/**\n\t * @throws IOException\n\t * @throws EOFException\n\t * @throws FileNotFoundException\n\t */\n\tpublic void foo() throws IOException {}\n}\n"});
    }

    public void testBug45782() {
        this.runConformTest(new String[]{"X.java", "public class X implements Comparable {\n\n\t/**\n\t * Overridden method with return value and parameters.\n\t * {@inheritDoc}\n\t */\n\tpublic boolean equals(Object obj) {\n\t\treturn super.equals(obj);\n\t}\n\n\t/**\n\t * Overridden method with return value and thrown exception.\n\t * {@inheritDoc}\n\t */\n\tpublic Object clone() throws CloneNotSupportedException {\n\t\treturn super.clone();\n\t}\n\n\t/**\n\t * Implemented method (Comparable)  with return value and parameters.\n\t * {@inheritDoc}\n\t */\n\tpublic int compareTo(Object o) { return 0; }\n}\n"});
    }

    public void testBug45782a() {
        this.reportMissingJavadocTags = "error";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/**\n\t * Unefficient inheritDoc tag on a method which is neither overridden nor implemented...\n\t * {@inheritDoc}\n\t */\n\tpublic int foo(String str) throws IllegalArgumentException { return 0; }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t* {@inheritDoc}\n\t    ^^^^^^^^^^\nJavadoc: Unexpected tag\n----------\n2. ERROR in X.java (at line 6)\n\tpublic int foo(String str) throws IllegalArgumentException { return 0; }\n\t       ^^^\nJavadoc: Missing tag for return type\n----------\n3. ERROR in X.java (at line 6)\n\tpublic int foo(String str) throws IllegalArgumentException { return 0; }\n\t                      ^^^\nJavadoc: Missing tag for parameter str\n----------\n4. ERROR in X.java (at line 6)\n\tpublic int foo(String str) throws IllegalArgumentException { return 0; }\n\t                                  ^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing tag for declared exception IllegalArgumentException\n----------\n");
    }

    public void testBug49260() {
        this.runConformTest(new String[]{"X.java", "import java.util.Vector;\npublic final class X {\n\tint bar(String str, int var, Vector list, char[] array) throws IllegalAccessException { return 0; }\n\t/**\n\t * Valid method reference on several lines\n\t * @see #bar(String str,\n\t * \t\tint var,\n\t * \t\tVector list,\n\t * \t\tchar[] array)\n\t */\n\tvoid foo() {}\n}\n"});
    }

    public void testBug48385() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Vector;\npublic class X {\n\t/**\n\t * Method outside javaDoc Comment\n\t *  1) {@link String} tag description not empty\n\t *  2) {@link CharOperation Label not empty} tag description not empty\n\t * @param str\n\t * @param var tag description not empty\n\t * @param list third param with embedded tag: {@link Vector}\n\t * @param array fourth param with several embedded tags on several lines:\n\t *  1) {@link String} tag description not empty\n\t *  2) {@linkplain CharOperation Label not empty} tag description not empty\n\t * @throws IllegalAccessException\n\t * @throws NullPointerException tag description not empty\n\t * @return an integer\n\t * @see String\n\t * @see Vector tag description not empty\n\t * @see Object tag description includes embedded tags and several lines:\n\t *  1) {@link String} tag description not empty\n\t *  2) {@link CharOperation Label not empty} tag description not empty\n\t */\n\tint foo(String str, int var, Vector list, char[] array) throws IllegalAccessException { return 0; }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\t*  2) {@link CharOperation Label not empty} tag description not empty\n\t             ^^^^^^^^^^^^^\nJavadoc: CharOperation cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 12)\n\t*  2) {@linkplain CharOperation Label not empty} tag description not empty\n\t                  ^^^^^^^^^^^^^\nJavadoc: CharOperation cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 20)\n\t*  2) {@link CharOperation Label not empty} tag description not empty\n\t             ^^^^^^^^^^^^^\nJavadoc: CharOperation cannot be resolved to a type\n----------\n");
    }

    public void testBug48385And49620() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Vector;\npublic class X {\n\t/**\n\t * Method outside javaDoc Comment\n\t *  1) {@link\n\t * \t\t\t\tString} tag description not empty\n\t *  2) {@link\n\t * \t\t\t\tCharOperation Label not empty} tag description not empty\n\t * @param\n\t * \t\t\t\tstr\n\t * @param\n\t * \t\t\t\tvar tag description not empty\n\t * @param list third param with embedded tag: {@link\n\t * \t\t\t\tVector} but also on several lines: {@link\n\t * \t\t\t\tCharOperation}\n\t * @param array fourth param with several embedded tags on several lines:\n\t *  1) {@link String} tag description not empty\n\t *  2) {@link CharOperation Label not empty} tag description not empty\n\t * @throws\n\t * \t\t\t\t\tIllegalAccessException\n\t * @throws\n\t * \t\t\t\t\tNullPointerException tag description not empty\n\t * @return\n\t * \t\t\t\t\tan integer\n\t * @see\n\t * \t\t\tString\n\t * @see\n\t * \t\tVector\n\t * \t\ttag description not empty\n\t * @see Object tag description includes embedded tags and several lines:\n\t *  1) {@link String} tag description not empty\n\t *  2) {@link CharOperation Label not empty} tag description not empty\n\t */\n\tint foo(String str, int var, Vector list, char[] array) throws IllegalAccessException { return 0; }\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\t* \t\t\t\tCharOperation Label not empty} tag description not empty\n\t  \t\t\t\t^^^^^^^^^^^^^\nJavadoc: CharOperation cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 15)\n\t* \t\t\t\tCharOperation}\n\t  \t\t\t\t^^^^^^^^^^^^^\nJavadoc: CharOperation cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 18)\n\t*  2) {@link CharOperation Label not empty} tag description not empty\n\t             ^^^^^^^^^^^^^\nJavadoc: CharOperation cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 32)\n\t*  2) {@link CharOperation Label not empty} tag description not empty\n\t             ^^^^^^^^^^^^^\nJavadoc: CharOperation cannot be resolved to a type\n----------\n");
    }

    public void testBug48385a() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/**\n\t * Method outside javaDoc Comment\n\t *  1) {@link } Missing reference\n\t *  2) {@link Unknown} Cannot be resolved\n\t *  3) {@link *} Missing reference\n\t *  4) {@link #} Invalid reference\n\t *  5) {@link String } } Valid reference\n\t *  6) {@link String {} Invalid tag\n\t * @return int\n\t */\n\tint foo() {return 0;}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t*  1) {@link } Missing reference\n\t        ^^^^\nJavadoc: Missing reference\n----------\n2. ERROR in X.java (at line 5)\n\t*  2) {@link Unknown} Cannot be resolved\n\t             ^^^^^^^\nJavadoc: Unknown cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 6)\n\t*  3) {@link *} Missing reference\n\t        ^^^^\nJavadoc: Missing reference\n----------\n4. ERROR in X.java (at line 7)\n\t*  4) {@link #} Invalid reference\n\t             ^\nJavadoc: Invalid reference\n----------\n5. ERROR in X.java (at line 9)\n\t*  6) {@link String {} Invalid tag\n\t      ^^^^^^^^^^^^^^^\nJavadoc: Missing closing brace for inline tag\n----------\n");
    }

    public void testBug49491() {
        this.runConformTest(new String[]{"X.java", "public final class X {\n\t/**\n\t * Now valid duplicated throws tag\n\t * @throws IllegalArgumentException First comment\n\t * @throws IllegalArgumentException Second comment\n\t * @throws IllegalArgumentException Last comment\n\t */\n\tvoid foo() throws IllegalArgumentException {}\n}\n"});
    }

    public void testBug49491a() {
        this.runNegativeTest(new String[]{"X.java", "public final class X {\n\t/**\n\t * Duplicated param tags should be still flagged\n\t * @param str First comment\n\t * @param str Second comment\n\t * @param str Last comment\n\t */\n\tvoid foo(String str) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t* @param str Second comment\n\t         ^^^\nJavadoc: Duplicate tag for parameter\n----------\n2. ERROR in X.java (at line 6)\n\t* @param str Last comment\n\t         ^^^\nJavadoc: Duplicate tag for parameter\n----------\n");
    }

    public void testBug48376() {
        this.runConformTest(new String[]{"X.java", "/**\n\t* @see <a href=\"http:/www.ibm.com\">IBM Home Page</a>\n\t* @see <a href=\"http:/www.ibm.com\">\n\t*          IBM Home Page</a>\n\t* @see <a href=\"http:/www.ibm.com\">\n\t*          IBM Home Page\n\t* \t\t\t</a>\n\t* @see <a href=\"http:/www.ibm.com\">\n\t*\n\t*          IBM\n\t*\n\t*          Home Page\n\t*\n\t*\n\t* \t\t\t</a>\n\t* @see Object\n\t*/\npublic class X {\n}\n"});
    }

    public void testBug48376a() {
        this.runNegativeTest(new String[]{"X.java", "/**\n\t* @see <a href=\"http:/www.ibm.com\">IBM Home Page\n\t* @see <a href=\"http:/www.ibm.com\">\n\t*          IBM Home Page\n\t* @see <a href=\"http:/www.ibm.com\">\n\t*          IBM Home Page<\n\t* \t\t\t/a>\n\t* @see <a href=\"http:/www.ibm.com\">\n\t*\n\t*          IBM\n\t*\n\t*          Home Page\n\t*\n\t*\n\t* \t\t\t\n\t* @see Unknown\n\t*/\npublic class X {\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t* @see <a href=\"http:/www.ibm.com\">IBM Home Page\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Malformed link reference\n----------\n2. ERROR in X.java (at line 3)\n\t* @see <a href=\"http:/www.ibm.com\">\n\t*          IBM Home Page\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Malformed link reference\n----------\n3. ERROR in X.java (at line 6)\n\t*          IBM Home Page<\n\t                        ^\nJavadoc: Malformed link reference\n----------\n4. ERROR in X.java (at line 8)\n\t* @see <a href=\"http:/www.ibm.com\">\n\t*\n\t*          IBM\n\t*\n\t*          Home Page\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Malformed link reference\n----------\n5. ERROR in X.java (at line 16)\n\t* @see Unknown\n\t       ^^^^^^^\nJavadoc: Unknown cannot be resolved to a type\n----------\n");
    }

    public void testBug50644() {
        this.reportInvalidJavadoc = "ignore";
        this.runConformTest(new String[]{"p1/X.java", "package p1;\npublic class X {\n\t/**\n\t * Should not be @deprecated\n\t */\n\tpublic void foo() {}\n}\n", "p2/Y.java", "package p2;\nimport p1.X;\npublic class Y {\n\tpublic void foo() {\n\t\tX x = new X();\n\t\tx.foo();\n\t}\n}\n"});
    }

    public void testBug50695() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t/**\n\t * @see java\n\t * @see java.util\n\t */\n\tvoid foo() {}\n}\n"});
    }

    public void testBug50695b() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/**\n\t * @see java.unknown\n\t */\n\tvoid foo() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @see java.unknown\n\t       ^^^^^^^^^^^^\nJavadoc: java.unknown cannot be resolved to a type\n----------\n");
    }

    public void testBug51626() {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\npublic class X {\n\t/**\n\t * @see String\n\t * toto @deprecated\n\t */\n\tpublic void foo() {}\n}\n", "p2/Y.java", "package p2;\nimport p1.*;\npublic class Y {\n\tvoid foo() {\n\t\tX x = new X(); \n\t\tx.foo();\n\t}\n}\n"});
    }

    public void testBug52216() {
        this.runConformTest(new String[]{"X.java", "/**\n * Valid ref with white spaces at the end\n* @see <a href=\"http://www.ietf.org/rfc/rfc2045.txt\">RFC 2045 - Section 6.8</a>\t\t   \n*/\npublic class X {\n}\n"});
    }

    public void testBug52216a() {
        this.runConformTest(new String[]{"X.java", "/**\n* @see \"Valid ref with white spaces at the end\"\t   \n*/\npublic class X {\n}\n"});
    }

    public void testBug52216b() {
        this.runNegativeTest(new String[]{"X.java", "/**\n* @see <a href=\"http://www.ietf.org/rfc/rfc2045.txt\">RFC 2045 - Section 6.8</a>\t\t   \n* @see <a href=\"http://www.ietf.org/rfc/rfc2045.txt\">RFC 2045 - Section 6.8</a>\n* @see <a href=\"http://www.ietf.org/rfc/rfc2045.txt\">RFC 2045 - Section 6.8</a>\t\t\t,\n* @see \"Valid ref with white spaces at the end\"\n* @see \"Valid ref with white spaces at the end\"\t   \n* @see \"Invalid ref\"\t   .\n*/\npublic class X {\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @see <a href=\"http://www.ietf.org/rfc/rfc2045.txt\">RFC 2045 - Section 6.8</a>\t\t\t,\n\t                                                                            ^^^^^^^\nJavadoc: Unexpected text\n----------\n2. ERROR in X.java (at line 7)\n\t* @see \"Invalid ref\"\t   .\n\t                    ^^^^^\nJavadoc: Unexpected text\n----------\n");
    }

    public void testBug51529() {
        this.runConformTest(new String[]{"X.java", "import java.util.Vector;\npublic class X {\n\t/**\n\t * @see Vector\n\t */\n\tvoid foo() {}\n}\n"});
    }

    public void testBug51529a() {
        this.reportInvalidJavadoc = "ignore";
        this.reportMissingJavadocComments = "ignore";
        this.runConformTest(new String[]{"X.java", "import java.util.Vector;\npublic class X {\n\t/**\n\t * @see Vector\n\t */\n\tvoid foo() {}\n}\n"});
    }

    public void testBug51529b() {
        this.docCommentSupport = "disabled";
        this.runNegativeTest(new String[]{"X.java", "import java.util.Vector;\npublic class X {\n\t/**\n\t * @see Vector\n\t */\n\tvoid foo() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\timport java.util.Vector;\n\t       ^^^^^^^^^^^^^^^^\nThe import java.util.Vector is never used\n----------\n");
    }

    public void testBug51911() {
        this.runNegativeTest(new String[]{"X.java", "/**\n * @see #foo\n */\npublic class X {\n\tpublic void foo(int i, float f) {}\n\tpublic void foo(String str) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t* @see #foo\n\t        ^^^\nJavadoc: foo is an ambiguous method reference or is not a field\n----------\n");
    }

    public void testBug51911a() {
        this.runConformTest(new String[]{"X.java", "/**\n * @see #foo\n */\npublic class X {\n\tpublic void foo(String str) {}\n}\n"});
    }

    public void testBug51911b() {
        this.runConformTest(new String[]{"X.java", "/**\n * @see #foo\n */\npublic class X {\n\tpublic int foo;\n\tpublic void foo(String str) {}\n}\n"});
    }

    public void testBug51911c() {
        this.runConformTest(new String[]{"X.java", "/**\n * @see #foo\n */\npublic class X {\n\tpublic int foo;\n\tpublic void foo() {}\n\tpublic void foo(String str) {}\n}\n"});
    }

    public void testBug53279() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/**\n\t * Unterminated inline tags\n\t *  {@link Object\n\t */\n\tvoid foo() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t*  {@link Object\n\t   ^^^^^^^^^^^^^\nJavadoc: Missing closing brace for inline tag\n----------\n");
    }

    public void testBug53279a() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/**\n\t * Unterminated inline tags\n\t *  {@link Object\n\t * @return int\n\t */\n\tint foo() {return 0;}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t*  {@link Object\n\t   ^^^^^^^^^^^^^\nJavadoc: Missing closing brace for inline tag\n----------\n");
    }

    public void testBug53279b() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/**\n\t * Unterminated inline tags\n\t *  {@link        \n\t */\n\tvoid foo() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t*  {@link        \n\t   ^^^^^^^^^^^^^^\nJavadoc: Missing closing brace for inline tag\n----------\n2. ERROR in X.java (at line 4)\n\t*  {@link        \n\t     ^^^^\nJavadoc: Missing reference\n----------\n");
    }

    public void testBug53279c() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/**\n\t * Unterminated inline tags\n\t *  {@link\n\t * @return int\n\t */\n\tint foo() {return 0;}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t*  {@link\n\t   ^^^^^^\nJavadoc: Missing closing brace for inline tag\n----------\n2. ERROR in X.java (at line 4)\n\t*  {@link\n\t     ^^^^\nJavadoc: Missing reference\n----------\n");
    }

    public void testBug53290() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/**\n\t * See as inline tag\n\t *  {@see Object}\n\t *  @see Object\n\t *  @link Object\n\t *  {@link Object}\n\t */\n\tvoid foo() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t*  {@see Object}\n\t     ^^^\nJavadoc: Unexpected tag\n----------\n2. ERROR in X.java (at line 6)\n\t*  @link Object\n\t    ^^^^\nJavadoc: Unexpected tag\n----------\n");
    }

    public void testBug62812() {
        this.runNegativeTest(new String[]{"Test.java", "/**\n * @see Object#clone())\n * @see Object#equals(Object)}\n * @see Object#equals(Object))\n * @see Object#equals(Object)xx\n */\npublic class Test {\n}\n"}, "----------\n1. ERROR in Test.java (at line 2)\n\t* @see Object#clone())\n\t                   ^^^\nJavadoc: Malformed reference (missing end space separator)\n----------\n2. ERROR in Test.java (at line 3)\n\t* @see Object#equals(Object)}\n\t                    ^^^^^^^^^\nJavadoc: Malformed reference (missing end space separator)\n----------\n3. ERROR in Test.java (at line 4)\n\t* @see Object#equals(Object))\n\t                    ^^^^^^^^^\nJavadoc: Malformed reference (missing end space separator)\n----------\n4. ERROR in Test.java (at line 5)\n\t* @see Object#equals(Object)xx\n\t                    ^^^^^^^^^^\nJavadoc: Malformed reference (missing end space separator)\n----------\n");
    }

    public void testBug62812a() {
        this.runNegativeTest(new String[]{"Test.java", "/**\n * {@link Object#clone())}\n * {@link Object#equals(Object)}\n * {@link Object#equals(Object))}\n * {@link Object#equals(Object)xx}\n */\npublic class Test {\n}\n"}, "----------\n1. ERROR in Test.java (at line 2)\n\t* {@link Object#clone())}\n\t                     ^^^^\nJavadoc: Malformed reference (missing end space separator)\n----------\n2. ERROR in Test.java (at line 4)\n\t* {@link Object#equals(Object))}\n\t                      ^^^^^^^^^^\nJavadoc: Malformed reference (missing end space separator)\n----------\n3. ERROR in Test.java (at line 5)\n\t* {@link Object#equals(Object)xx}\n\t                      ^^^^^^^^^^^\nJavadoc: Malformed reference (missing end space separator)\n----------\n");
    }

    public void testBug51606() {
        this.reportMissingJavadocTags = "error";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  /**\n   * @param a aaa\n   * @param b bbb\n   */\n  public void foo(int a, int b) {\n  }\n}\n", "Y.java", "public class Y extends X {\n  /**\n  *  @param a {@inheritDoc}\n   */\n  public void foo(int a, int b) {\n  }\n}\n"}, "----------\n1. ERROR in Y.java (at line 5)\n\tpublic void foo(int a, int b) {\n\t                           ^\nJavadoc: Missing tag for parameter b\n----------\n");
    }

    public void testBug51606a() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  /**\n   * @param a aaa\n   * @param b bbb\n   */\n  public void foo(int a, int b) {\n  }\n}\n", "Y.java", "public class Y extends X {\n  /**\n   * {@inheritDoc}\n  *  @param a aaaaa\n   */\n  public void foo(int a, int b) {\n  }\n}\n"}, "");
    }

    public void testBug51606b() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  /**\n   * @param a aaa\n   * @param b bbb\n   */\n  public void foo(int a, int b) {\n  }\n}\n", "Y.java", "public class Y extends X {\n  /**\n   * Text before inherit tag\n   * {@inheritDoc}\n  *  @param a aaaaa\n   */\n  public void foo(int a, int b) {\n  }\n}\n"});
    }

    public void testBug51606c() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  /**\n   * @param a aaa\n   * @param b bbb\n   */\n  public void foo(int a, int b) {\n  }\n}\n", "Y.java", "public class Y extends X {\n  /**\n   * Text before inherit tag {@inheritDoc}\n  *  @param a aaaaa\n   */\n  public void foo(int a, int b) {\n  }\n}\n"});
    }

    public void testBug65174() {
        this.runConformTest(new String[]{"Test.java", "/**\n * Comment with no error: {@link\n * Object valid} because it's not on first line\n */\npublic class Test {\n\t/** Comment previously with error: {@link\n\t * Object valid} because tag is on comment very first line\n\t */\n\tvoid foo() {}\n}\n"});
    }

    public void testBug65174a() {
        this.runConformTest(new String[]{"Test.java", "/**\n * Comment with no error: {@link    \t\t\n * Object valid} because it's not on first line\n */\npublic class Test {\n\t/** Comment previously with error: {@link   \t\t\n\t * Object valid} because tag is on comment very first line\n\t */\n\tvoid foo() {}\n}\n"});
    }

    public void testBug65174b() {
        this.runConformTest(new String[]{"Test.java", "/**\n * Comment with no error: {@link java.lang.\n * Object valid} because it's not on first line\n */\npublic class Test {\n\t/** Comment previously with error: {@link java.lang.\n\t * Object valid} because tag is on comment very first line\n\t */\n\tvoid foo() {}\n}\n"});
    }

    public void testBug65174c() {
        this.runConformTest(new String[]{"Test.java", "/**\n * Comment with no error: {@link Object\n * valid} because it's not on first line\n */\npublic class Test {\n\t/** Comment previously with no error: {@link Object\n\t * valid} because tag is on comment very first line\n\t */\n\tvoid foo() {}\n}\n"});
    }

    public void testBug65174d() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\n\t/** Comment previously with no error: {@link Object valid} comment on one line */\n\tvoid foo1() {}\n\t/** Comment previously with no error: {@link Object valid}       */\n\tvoid foo2() {}\n\t/** Comment previously with no error: {@link Object valid}*/\n\tvoid foo3() {}\n\t/**                    {@link Object valid} comment on one line */\n\tvoid foo4() {}\n\t/**{@link Object valid} comment on one line */\n\tvoid foo5() {}\n\t/**       {@link Object valid} \t\t\t\t*/\n\tvoid foo6() {}\n\t/**{@link Object valid} \t\t\t\t*/\n\tvoid foo7() {}\n\t/**\t\t\t\t{@link Object valid}*/\n\tvoid foo8() {}\n\t/**{@link Object valid}*/\n\tvoid foo9() {}\n}\n"});
    }

    public void testBug65180() {
        this.runNegativeTest(new String[]{"Test.java", "public class Test {\n\tpublic class Inner {\n\t\t/**\n\t\t * Does something.\n\t\t * \n\t\t * @see #testFunc\n\t\t */\n\t\tpublic void innerFunc() {\n\t\t\ttestFunc();\n\t\t}\n\t}\n\t\n\tpublic void testFunc() {}\n}\n\n"}, "----------\n1. ERROR in Test.java (at line 6)\r\n\t* @see #testFunc\r\n\t        ^^^^^^^^\nJavadoc: testFunc cannot be resolved or is not a field\n----------\n");
    }

    public void testBug65180a() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\n\tpublic class Inner {\n\t\t/**\n\t\t * Does something.\n\t\t * \n\t\t * @see #testFunc()\n\t\t */\n\t\tpublic void innerFunc() {\n\t\t\ttestFunc();\n\t\t}\n\t}\n\t\n\tpublic void testFunc() {}\n}\n\n"});
    }

    public void testBug65180b() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\n\tpublic class Inner {\n\t\t/**\n\t\t * Does something.\n\t\t * \n\t\t * @see Test#testFunc\n\t\t * @see Test#testFunc()\n\t\t */\n\t\tpublic void innerFunc() {\n\t\t\ttestFunc();\n\t\t}\n\t}\n\t\n\tpublic void testFunc() {}\n}\n\n"});
    }

    public void testBug65180c() {
        this.runNegativeTest(new String[]{"Test.java", "public class Test {\n\tpublic class Inner {\n\t\t/**\n\t\t * Does something.\n\t\t * \n\t\t * @see #testFunc\n\t\t */\n\t\tpublic void innerFunc() {\n\t\t\ttestFunc();\n\t\t}\n\t}\n\t\n\tpublic void testFunc() {}\n\tpublic void testFunc(String str) {}\n}\n\n"}, "----------\n1. ERROR in Test.java (at line 6)\n\t* @see #testFunc\n\t        ^^^^^^^^\nJavadoc: testFunc cannot be resolved or is not a field\n----------\n");
    }

    public void testBug65180d() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\n\tint testField;\n\tpublic class Inner {\n\t\t/**\n\t\t * Does something.\n\t\t * \n\t\t * @see #testField\n\t\t * @see #testFunc(int)\n\t\t */\n\t\tpublic void innerFunc() {\n\t\t\ttestFunc(testField);\n\t\t}\n\t}\n\t\n\tpublic void testFunc(int test) {\n\t\ttestField = test; \n\t}\n}\n\n"});
    }

    public void testBug65180e() {
        this.runConformTest(new String[]{"ITest.java", "public interface ITest {\n\t/**\n\t * @see #foo() \n\t */\n\tpublic static int field = 0;\n\t/**\n\t * @see #field\n\t */\n\tpublic void foo();\n}\n"});
    }

    public void testBug65180f() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\n    static class SuperInner {\n    \tpublic int field;\n        public void foo() {}\n     }\n    \n\tpublic static class Inner extends SuperInner {\n\t\t/**\n\t\t * @see #field\n\t\t */\n\t\tpublic static int f;\n\t\t/**\n\t\t * @see #foo()\n\t\t */\n\t\tpublic static void bar() {}\n\t}\n\t\n\tpublic void foo() {}\n}"});
    }

    public void testBug65253() {
        this.reportMissingJavadocTags = "error";
        this.runNegativeTest(new String[]{"Test.java", "/**\n * Comment \n * @@@@see Unknown Should not complain on ref\n */\npublic class Test {\n\t/**\n\t * Comment\n\t * @@@param xxx Should not complain on param\n\t * @@return int\n\t */\n\tint foo() { // should warn on missing tag for return type\n\t\treturn 0;\n\t}\n}\n"}, "----------\n1. ERROR in Test.java (at line 3)\n\t* @@@@see Unknown Should not complain on ref\n\t   ^^^^^^\nJavadoc: Invalid tag\n----------\n2. ERROR in Test.java (at line 8)\n\t* @@@param xxx Should not complain on param\n\t   ^^^^^^^\nJavadoc: Invalid tag\n----------\n3. ERROR in Test.java (at line 9)\n\t* @@return int\n\t   ^^^^^^^\nJavadoc: Invalid tag\n----------\n4. ERROR in Test.java (at line 11)\n\tint foo() { // should warn on missing tag for return type\n\t^^^\nJavadoc: Missing tag for return type\n----------\n");
    }

    public void testBug66551() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\n    int field;\n    /**\n     *  @see #field\n     */\n    void foo(int field) {\n    }\n\n}\n"});
    }

    public void testBug66551a() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\n    static int field;\n    /**\n     *  @see #field\n     */\n    static void foo(int field) {\n    }\n\n}\n"});
    }

    public void testBug66551b() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\n\tint field;\n\t/**\n\t * {@link #field}\n\t */\n\tvoid foo(int field) {\n\t}\n\n}\n"});
    }

    public void testBug66551c() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\n\tstatic int field;\n\t/**\n\t * {@link #field}\n\t */\n\tstatic void foo(int field) {\n\t}\n\n}\n"});
    }

    public void testBug66573() {
        this.runNegativeTest(new String[]{"Test.java", "public class Test {\n    /**\n     * @see Local\n     */\n    void foo() {\n        class Local { \n            // shouldn't be seen from javadoc\n         }\n    }\n}\n"}, "----------\n1. ERROR in Test.java (at line 3)\n\t* @see Local\n\t       ^^^^^\nJavadoc: Local cannot be resolved to a type\n----------\n");
    }

    public void testBug68017conform() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t/**@return valid integer*/\n\tpublic int foo1() {return 0; }\n\t/**\n\t *\t@return #\n\t */\n\tpublic int foo2() {return 0; }\n}\n"});
    }

    public void testBug68017negative() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/**@return*/\n\tpublic int foo1() {return 0; }\n\t/**@return        */\n\tpublic int foo2() {return 0; }\n\t/**@return****/\n\tpublic int foo3() {return 0; }\n\t/**\n\t *\t@return\n\t */\n\tpublic int foo4() {return 0; }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t/**@return*/\n\t    ^^^^^^\nJavadoc: Missing return type description\n----------\n2. ERROR in X.java (at line 4)\n\t/**@return        */\n\t    ^^^^^^\nJavadoc: Missing return type description\n----------\n3. ERROR in X.java (at line 6)\n\t/**@return****/\n\t    ^^^^^^\nJavadoc: Missing return type description\n----------\n4. ERROR in X.java (at line 9)\n\t*\t@return\n\t \t ^^^^^^\nJavadoc: Missing return type description\n----------\n");
    }

    public void testBug68017javadocWarning1() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/**\n\t *\t@return* */\n\tpublic int foo1() {return 0; }\n\t/**@return** **/\n\tpublic int foo2() {return 0; }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t*\t@return* */\n\t \t ^^^^^^\nJavadoc: Missing return type description\n----------\n2. ERROR in X.java (at line 5)\n\t/**@return** **/\n\t    ^^^^^^\nJavadoc: Missing return type description\n----------\n");
    }

    public void testBug68017javadocWarning2() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t/**\n\t *\t@return #\n\t */\n\tpublic int foo1() {return 0; }\n\t/**\n\t *\t@return @\n\t */\n\tpublic int foo2() {return 0; }\n}\n"});
    }

    public void testBug68017javadocWarning3() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/**\n\t *\t@return#\n\t *\t@return#text\n\t */\n\tpublic int foo() {return 0; }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t*\t@return#\n\t \t ^^^^^^^\nJavadoc: Invalid tag\n----------\n2. ERROR in X.java (at line 4)\n\t*\t@return#text\n\t \t ^^^^^^^^^^^\nJavadoc: Invalid tag\n----------\n");
    }

    public void testBug68025conform() {
        this.runConformTest(new String[]{"Y.java", "public class Y {\n\tpublic int field;\n\tpublic void foo() {}\n}\n", "Z.java", "public class Z {\n\t/**\n\t *\t@see Y#field #valid\n\t *\t@see Y#foo #valid\n\t */\n\tpublic void foo1() {}\n\t/**@see Y#field     # valid*/\n\tpublic void foo2() {}\n\t/**@see Y#foo\t\t# valid*/\n\tpublic void foo3() {}\n\t/**@see Y#foo()\n\t *# valid*/\n\tpublic void foo4() {}\n}\n"});
    }

    public void testBug68025negative() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic int field;\n\tpublic void foo() {}\n\t/**\n\t *\t@see #field#invalid\n\t *\t@see #foo#invalid\n\t */\n\tpublic void foo1() {}\n\t/**@see Y#field# invalid*/\n\tpublic void foo2() {}\n\t/**@see Y#foo#\tinvalid*/\n\tpublic void foo3() {}\n\t/**@see Y#foo()#\n\t *valid*/\n\tpublic void foo4() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t*\t@see #field#invalid\n\t \t     ^^^^^^^^^^^^^^\nJavadoc: Malformed reference (missing end space separator)\n----------\n2. ERROR in X.java (at line 6)\n\t*\t@see #foo#invalid\n\t \t     ^^^^^^^^^^^^\nJavadoc: Malformed reference (missing end space separator)\n----------\n3. ERROR in X.java (at line 9)\n\t/**@see Y#field# invalid*/\n\t         ^^^^^^^^^^^^^^^^^\nJavadoc: Malformed reference (missing end space separator)\n----------\n4. ERROR in X.java (at line 11)\n\t/**@see Y#foo#\tinvalid*/\n\t         ^^^^^^^^^^^^^^^\nJavadoc: Malformed reference (missing end space separator)\n----------\n5. ERROR in X.java (at line 13)\n\t/**@see Y#foo()#\n\t             ^^^\nJavadoc: Malformed reference (missing end space separator)\n----------\n");
    }

    public void testBug68726conform1() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t/**\n\t *\t@see Object <a href=\"http://www.eclipse.org\" target=\"_top\">Eclipse</a>\n\t */\n\tvoid foo1() {}\n\t/**@see Object <a href=\"http://www.eclipse.org\" target=\"_top\" target1=\"_top1\" target2=\"_top2\">Eclipse</a>*/\n\tvoid foo2() {}\n}\n"});
    }

    public void testBug68726conform2() {
        this.runConformTest(new String[]{"X.java", "/**\n\t* @see <a href=\"http:/www.ibm.com\" target=\"_top\">IBM Home Page</a>\n\t* @see <a href=\"http:/www.ibm.com\" target=\"_top\">\n\t*          IBM Home Page</a>\n\t* @see <a href=\"http:/www.ibm.com\" target=\"_top\">\n\t*          IBM Home Page\n\t* \t\t\t</a>\n\t* @see <a href=\"http:/www.ibm.com\" target=\"_top\">\n\t*\n\t*          IBM\n\t*\n\t*          Home Page\n\t*\n\t*\n\t* \t\t\t</a>\n\t* @see Object\n\t*/\npublic class X {\n}\n"});
    }

    public void testBug68726negative1() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/**\n\t * Invalid URL link references\n\t *\n\t * @see <a href=\"invalid\" target\n\t * @see <a href=\"invalid\" target=\n\t * @see <a href=\"invalid\" target=\"\n\t * @see <a href=\"invalid\" target=\"_top\n\t * @see <a href=\"invalid\" target=\"_top\"\n\t * @see <a href=\"invalid\" target=\"_top\">\n\t * @see <a href=\"invalid\" target=\"_top\">\n\t * @see <a href=\"invalid\" target=\"_top\">invalid\n\t * @see <a href=\"invalid\" target=\"_top\">invalid<\n\t * @see <a href=\"invalid\" target=\"_top\">invalid</\n\t * @see <a href=\"invalid\" target=\"_top\">invalid</a\n\t * @see <a href=\"invalid\" target=\"_top\">invalid</a> no text allowed after the href\n\t */\n\tvoid foo() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t* @see <a href=\"invalid\" target\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Malformed link reference\n----------\n2. ERROR in X.java (at line 6)\n\t* @see <a href=\"invalid\" target=\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Malformed link reference\n----------\n3. ERROR in X.java (at line 7)\n\t* @see <a href=\"invalid\" target=\"\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Malformed link reference\n----------\n4. ERROR in X.java (at line 8)\n\t* @see <a href=\"invalid\" target=\"_top\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Malformed link reference\n----------\n5. ERROR in X.java (at line 9)\n\t* @see <a href=\"invalid\" target=\"_top\"\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Malformed link reference\n----------\n6. ERROR in X.java (at line 10)\n\t* @see <a href=\"invalid\" target=\"_top\">\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Malformed link reference\n----------\n7. ERROR in X.java (at line 11)\n\t* @see <a href=\"invalid\" target=\"_top\">\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Malformed link reference\n----------\n8. ERROR in X.java (at line 12)\n\t* @see <a href=\"invalid\" target=\"_top\">invalid\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Malformed link reference\n----------\n9. ERROR in X.java (at line 13)\n\t* @see <a href=\"invalid\" target=\"_top\">invalid<\n\t                                              ^\nJavadoc: Malformed link reference\n----------\n10. ERROR in X.java (at line 14)\n\t* @see <a href=\"invalid\" target=\"_top\">invalid</\n\t                                              ^^\nJavadoc: Malformed link reference\n----------\n11. ERROR in X.java (at line 15)\n\t* @see <a href=\"invalid\" target=\"_top\">invalid</a\n\t                                              ^^^\nJavadoc: Malformed link reference\n----------\n12. ERROR in X.java (at line 16)\n\t* @see <a href=\"invalid\" target=\"_top\">invalid</a> no text allowed after the href\n\t                                               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Unexpected text\n----------\n");
    }

    public void testBug68726negative2() {
        this.runNegativeTest(new String[]{"X.java", "/**\n\t* @see <a href=\"http:/www.ibm.com\" target=\"_top\">IBM Home Page\n\t* @see <a href=\"http:/www.ibm.com\" target=\"_top\">\n\t*          IBM Home Page\n\t* @see <a href=\"http:/www.ibm.com\" target=\"_top\">\n\t*          IBM Home Page<\n\t* \t\t\t/a>\n\t* @see <a href=\"http:/www.ibm.com\" target=\"_top\">\n\t*\n\t*          IBM\n\t*\n\t*          Home Page\n\t*\n\t*\n\t* \t\t\t\n\t* @see Unknown\n\t*/\npublic class X {\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t* @see <a href=\"http:/www.ibm.com\" target=\"_top\">IBM Home Page\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Malformed link reference\n----------\n2. ERROR in X.java (at line 3)\n\t* @see <a href=\"http:/www.ibm.com\" target=\"_top\">\n\t*          IBM Home Page\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Malformed link reference\n----------\n3. ERROR in X.java (at line 6)\n\t*          IBM Home Page<\n\t                        ^\nJavadoc: Malformed link reference\n----------\n4. ERROR in X.java (at line 8)\n\t* @see <a href=\"http:/www.ibm.com\" target=\"_top\">\n\t*\n\t*          IBM\n\t*\n\t*          Home Page\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Malformed link reference\n----------\n5. ERROR in X.java (at line 16)\n\t* @see Unknown\n\t       ^^^^^^^\nJavadoc: Unknown cannot be resolved to a type\n----------\n");
    }

    public void testBug69272classValid() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t/**@see Object*/\n\tpublic void foo1() {}\n\t/**@see Object\n\t*/\n\tpublic void foo2() {}\n\t/**@see Object    */\n\tpublic void foo3() {}\n\t/**@see Object****/\n\tpublic void foo4() {}\n\t/**@see Object\t\t****/\n\tpublic void foo5() {}\n}\n"});
    }

    public void testBug69272classInvalid() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/**@see Object* */\n\tpublic void foo1() {}\n\t/**@see Object*** ***/\n\tpublic void foo2() {}\n\t/**@see Object***\n\t */\n\tpublic void foo3() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t/**@see Object* */\n\t        ^^^^^^^\nJavadoc: Malformed reference (missing end space separator)\n----------\n2. ERROR in X.java (at line 4)\n\t/**@see Object*** ***/\n\t        ^^^^^^^^^\nJavadoc: Malformed reference (missing end space separator)\n----------\n3. ERROR in X.java (at line 6)\n\t/**@see Object***\n\t        ^^^^^^^^^\nJavadoc: Malformed reference (missing end space separator)\n----------\n");
    }

    public void testBug69272fieldValid() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tint field;\n\t/**@see #field*/\n\tpublic void foo1() {}\n\t/**@see #field\n\t*/\n\tpublic void foo2() {}\n\t/**@see #field    */\n\tpublic void foo3() {}\n\t/**@see #field****/\n\tpublic void foo4() {}\n\t/**@see #field\t\t********/\n\tpublic void foo5() {}\n}\n"});
    }

    public void testBug69272fieldInvalid() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tint field;\n\t/**@see #field* */\n\tpublic void foo1() {}\n\t/**@see #field*** ***/\n\tpublic void foo2() {}\n\t/**@see #field***\n\t */\n\tpublic void foo3() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t/**@see #field* */\n\t        ^^^^^^^\nJavadoc: Malformed reference (missing end space separator)\n----------\n2. ERROR in X.java (at line 5)\n\t/**@see #field*** ***/\n\t        ^^^^^^^^^\nJavadoc: Malformed reference (missing end space separator)\n----------\n3. ERROR in X.java (at line 7)\n\t/**@see #field***\n\t        ^^^^^^^^^\nJavadoc: Malformed reference (missing end space separator)\n----------\n");
    }

    public void testBug69272methodValid() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t/**@see Object#wait()*/\n\tpublic void foo1() {}\n\t/**@see Object#wait()\n\t*/\n\tpublic void foo2() {}\n\t/**@see Object#wait()    */\n\tpublic void foo3() {}\n\t/**@see Object#wait()****/\n\tpublic void foo4() {}\n\t/**@see Object#wait()\t\t****/\n\tpublic void foo5() {}\n}\n"});
    }

    public void testBug69272methodInvalid() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/**@see Object#wait()* */\n\tpublic void foo1() {}\n\t/**@see Object#wait()*** ***/\n\tpublic void foo2() {}\n\t/**@see Object#wait()***\n\t */\n\tpublic void foo3() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t/**@see Object#wait()* */\n\t                   ^^^\nJavadoc: Malformed reference (missing end space separator)\n----------\n2. ERROR in X.java (at line 4)\n\t/**@see Object#wait()*** ***/\n\t                   ^^^^^\nJavadoc: Malformed reference (missing end space separator)\n----------\n3. ERROR in X.java (at line 6)\n\t/**@see Object#wait()***\n\t                   ^^^^^\nJavadoc: Malformed reference (missing end space separator)\n----------\n");
    }

    public void testBug69275conform() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t/**@see <a href=\"http://www.eclipse.org\">text</a>*/\n\tvoid foo1() {}\n\t/**@see <a href=\"http://www.eclipse.org\">text</a>\n\t*/\n\tvoid foo2() {}\n\t/**@see <a href=\"http://www.eclipse.org\">text</a>\t\t*/\n\tvoid foo3() {}\n\t/**@see <a href=\"http://www.eclipse.org\">text</a>**/\n\tvoid foo4() {}\n\t/**@see <a href=\"http://www.eclipse.org\">text</a>     *****/\n\tvoid foo5() {}\n}\n"});
    }

    public void testBug69275negative() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/**@see <a href=\"http://www.eclipse.org\">text</a>* */\n\tvoid foo1() {}\n\t/**@see <a href=\"http://www.eclipse.org\">text</a>\t** **/\n\tvoid foo2() {}\n\t/**@see <a href=\"http://www.eclipse.org\">text</a>**\n\t*/\n\tvoid foo3() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t/**@see <a href=\"http://www.eclipse.org\">text</a>* */\n\t                                              ^^^^^^^\nJavadoc: Unexpected text\n----------\n2. ERROR in X.java (at line 4)\n\t/**@see <a href=\"http://www.eclipse.org\">text</a>\t** **/\n\t                                              ^^^^^^^^^^\nJavadoc: Unexpected text\n----------\n");
    }

    public void testBug69302conform1() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t/**\n\t *\t@see Object <a href=\"http://www.eclipse.org\">Eclipse</a>\n\t */\n\tvoid foo1() {}\n\t/**\n\t *\t@see Object \"Valid string reference\"\n\t */\n\tvoid foo2() {}\n}\n"});
    }

    public void testBug69302negative1() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/**\n\t *\t@see Unknown <a href=\"http://www.eclipse.org\">Eclipse</a>\n\t */\n\tvoid foo1() {}\n\t/**\n\t *\t@see Unknown \"Valid string reference\"\n\t */\n\tvoid foo2() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t*\t@see Unknown <a href=\"http://www.eclipse.org\">Eclipse</a>\n\t \t     ^^^^^^^\nJavadoc: Unknown cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 7)\n\t*\t@see Unknown \"Valid string reference\"\n\t \t     ^^^^^^^\nJavadoc: Unknown cannot be resolved to a type\n----------\n");
    }

    public void testBug69302negative2() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/**@see Unknown blabla <a href=\"http://www.eclipse.org\">text</a>*/\n\tvoid foo1() {}\n\t/**@see Unknown blabla \"Valid string reference\"*/\n\tvoid foo2() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t/**@see Unknown blabla <a href=\"http://www.eclipse.org\">text</a>*/\n\t        ^^^^^^^\nJavadoc: Unknown cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 4)\n\t/**@see Unknown blabla \"Valid string reference\"*/\n\t        ^^^^^^^\nJavadoc: Unknown cannot be resolved to a type\n----------\n");
    }

    public void testBug70892a() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t/**\n\t * {@value}\n\t */\n\tstatic int field1;\n\t/**\n\t * {@value }\n\t */\n\tstatic int field2;\n\t/**\n\t * {@value #field}\n\t */\n\tstatic int field;\n}\n"});
    }

    public void testBug70892b() {
        String[] testFiles = new String[]{"X.java", "public class X {\n\t/**\n\t * {@value \"invalid\"}\n\t */\n\tfinal static int field1 = 1;\n\t/**\n\t * {@value <a href=\"invalid\">invalid</a>} invalid\n\t */\n\tfinal static int field2 = 2;\n\t/**\n\t * {@value #field}\n\t */\n\tfinal static int field3 = 3;\n\t/**\n\t * {@value #foo}\n\t */\n\tfinal static int field4 = 4;\n\t/**\n\t * {@value #foo()}\n\t */\n\tfinal static int field5 = 5;\n\tvoid foo() {}\n}\n"};
        if (this.complianceLevel.equals("1.3") || this.complianceLevel.equals("1.4")) {
            this.runConformTest(testFiles);
        } else {
            this.runNegativeTest(testFiles, "----------\n1. ERROR in X.java (at line 3)\r\n\t* {@value \"invalid\"}\r\n\t          ^^^^^^^^^\nJavadoc: Only static field reference is allowed for @value tag\n----------\n2. ERROR in X.java (at line 7)\r\n\t* {@value <a href=\"invalid\">invalid</a>} invalid\r\n\t          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Only static field reference is allowed for @value tag\n----------\n3. ERROR in X.java (at line 11)\r\n\t* {@value #field}\r\n\t           ^^^^^\nJavadoc: field cannot be resolved or is not a field\n----------\n4. ERROR in X.java (at line 15)\r\n\t* {@value #foo}\r\n\t           ^^^\nJavadoc: Only static field reference is allowed for @value tag\n----------\n5. ERROR in X.java (at line 19)\r\n\t* {@value #foo()}\r\n\t           ^^^^^\nJavadoc: Only static field reference is allowed for @value tag\n----------\n");
        }
    }

    public void testBug73348conform() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t/**\n\t *\t@return      \n\t *\tint\n\t */\n\tpublic int foo1() {return 0; }\n\t/**\n\t *\t@return      \n\t *\tint\n\t *\t@see Object\n\t */\n\tpublic int foo2() {return 0; }\n}\n"});
    }

    public void testBug73348negative() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/**\n\t *\t@return\n\t *\t@see Object\n\t */\n\tpublic int foo1() {return 0; }\n\t/**\n\t *\t@return      \n\t *\t@see Object\n\t */\n\tpublic int foo2() {return 0; }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t*\t@return\n\t \t ^^^^^^\nJavadoc: Missing return type description\n----------\n2. ERROR in X.java (at line 8)\n\t*\t@return      \n\t \t ^^^^^^\nJavadoc: Missing return type description\n----------\n");
    }

    public void testBug73479() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/**\n\t *\t@see <a href=\"spec.html#section\">Java Spec<a>\n\t */\n\tpublic void foo() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t*\t@see <a href=\"spec.html#section\">Java Spec<a>\n\t \t                                          ^^^\nJavadoc: Malformed link reference\n----------\n");
    }

    public void testBug73995() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t/**\n\t *\t@return {@link Object}     \n\t */\n\tpublic int foo1() {return 0; }\n\t/** @return {@inheritedDoc} */\n\tpublic int foo2() {return 0; }\n\t/**\n\t *\t@return\n\t *\t\t{@unknown_tag}\n\t */\n\tpublic int foo3() {return 0; }\n}\n"});
    }

    public void testBug74369() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\n   public void method() {\n       /**\n        * @see #hsgdfdj\n        */\n        System.out.println(\"println\");\n        class Local {}\n    }\n}"});
    }

    public void testBug74369deprecated() {
        this.runNegativeTest(new String[]{"p/Y.java", "package p;\n\n\npublic class Y {\n   /**\n    * @deprecated\n    */\n   public void bar() {}\n}\n", "X.java", "import p.Y;\n\npublic class X {\n\tObject obj = new Object() {\n\t\tpublic boolean equals(Object o) {\n\t\t\t/**\n\t\t\t * @deprecated\n\t\t\t */\n\t        System.out.println(\"println\");\n\t        class Local {\n\t        \tvoid bar() {\n\t\t\t\t\tnew Y().bar();\n\t        \t}\n\t        }\n\t\t\treturn super.equals(o);\n\t\t}\n\t};\n}"}, "----------\n1. ERROR in X.java (at line 12)\n\tnew Y().bar();\n\t^^^^^^^^^^^^^\nThe method bar() from the type Y is deprecated\n----------\n");
    }

    public void testBug76324() {
        this.runConformTest(new String[]{"X.java", "\n/**\n * Subclasses perform GUI-related work in a dedicated thread. For instructions\n * on using this class, see\n * {@link <a  href=\"http://java.sun.com/docs/books/tutorial/uiswing/misc/threads.html\"> Swing tutorial </a>}\n * \n * @see <a\n *      href=\"http://gee.cs.oswego.edu/dl/classes/EDU/oswego/cs/dl/util/concurrent/intro.html\">\n *      EDU.oswego.cs.dl.util.concurrent </a>\n * @see <a\n *      href=\"http://java.sun.com/j2se/1.5.0/docs/api/java/util/concurrent/package-summary.html\">\n *      JDK 5.0 </a>\n * @author {@link <a href=\"http://gee.cs.oswego.edu/dl\">Doug Lea</a>}\n * @author {@link <a href=\"http://home.pacbell.net/jfai\">J?rgen Failenschmid</a>}\n  *\n  * It is assumed that you have read the introductory document\n  * {@link <a HREF=\"../../../../../internat/overview.htm\">\n  * Internationalization</a>}\n  * and are familiar with \n */\npublic class X {\n\n}\n"});
    }

    public void testBug76324url() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/**\n\t * Invalid inline URL link references \n\t *\n\t * {@link <}\n\t * {@link <a}\n\t * {@link <a hre}\n\t * {@link <a href}\n\t * {@link <a href=}\n\t * {@link <a href=\"}\n\t * {@link <a href=\"invalid}\n\t * {@link <a href=\"invalid\"}\n\t * {@link <a href=\"invalid\">}\n\t * {@link <a href=\"invalid\">invalid}\n\t * {@link <a href=\"invalid\">invalid<}\n\t * {@link <a href=\"invalid\">invalid</}\n\t * {@link <a href=\"invalid\">invalid</a}\n\t * {@link <a href=\"invalid\">invalid</a> no text allowed after}\n\t */\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t* {@link <}\n\t         ^^\nJavadoc: Malformed link reference\n----------\n2. ERROR in X.java (at line 6)\n\t* {@link <a}\n\t         ^^^\nJavadoc: Malformed link reference\n----------\n3. ERROR in X.java (at line 7)\n\t* {@link <a hre}\n\t         ^^^^^^^\nJavadoc: Malformed link reference\n----------\n4. ERROR in X.java (at line 8)\n\t* {@link <a href}\n\t         ^^^^^^^^\nJavadoc: Malformed link reference\n----------\n5. ERROR in X.java (at line 9)\n\t* {@link <a href=}\n\t         ^^^^^^^^^\nJavadoc: Malformed link reference\n----------\n6. ERROR in X.java (at line 10)\n\t* {@link <a href=\"}\n\t         ^^^^^^^^^^\nJavadoc: Malformed link reference\n----------\n7. ERROR in X.java (at line 11)\n\t* {@link <a href=\"invalid}\n\t         ^^^^^^^^^^^^^^^^^\nJavadoc: Malformed link reference\n----------\n8. ERROR in X.java (at line 12)\n\t* {@link <a href=\"invalid\"}\n\t         ^^^^^^^^^^^^^^^^^^\nJavadoc: Malformed link reference\n----------\n9. ERROR in X.java (at line 13)\n\t* {@link <a href=\"invalid\">}\n\t         ^^^^^^^^^^^^^^^^^^^\nJavadoc: Malformed link reference\n----------\n10. ERROR in X.java (at line 14)\n\t* {@link <a href=\"invalid\">invalid}\n\t         ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Malformed link reference\n----------\n11. ERROR in X.java (at line 15)\n\t* {@link <a href=\"invalid\">invalid<}\n\t                                  ^^\nJavadoc: Malformed link reference\n----------\n12. ERROR in X.java (at line 16)\n\t* {@link <a href=\"invalid\">invalid</}\n\t                                  ^^^\nJavadoc: Malformed link reference\n----------\n13. ERROR in X.java (at line 17)\n\t* {@link <a href=\"invalid\">invalid</a}\n\t                                  ^^^^\nJavadoc: Malformed link reference\n----------\n14. ERROR in X.java (at line 18)\n\t* {@link <a href=\"invalid\">invalid</a> no text allowed after}\n\t                                   ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Unexpected text\n----------\n");
    }

    public void testBug76324string() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/**\n\t * Inline string references \n\t *\n\t * {@link \"}\n\t * {@link \"unterminated string}\n\t * {@link \"invalid string\"\"}\n\t * {@link \"valid string\"}\n\t * {@link \"invalid\" no text allowed after the string}\n\t */\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t* {@link \"}\n\t         ^^\nJavadoc: Invalid reference\n----------\n2. ERROR in X.java (at line 6)\n\t* {@link \"unterminated string}\n\t         ^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid reference\n----------\n3. ERROR in X.java (at line 7)\n\t* {@link \"invalid string\"\"}\n\t                         ^^\nJavadoc: Unexpected text\n----------\n4. ERROR in X.java (at line 9)\n\t* {@link \"invalid\" no text allowed after the string}\n\t                  ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Unexpected text\n----------\n");
    }

    public void testBug77510enabled() {
        this.runNegativeTest(new String[]{"A.java", "public class A {\n\t/** \\u0009 @deprecated */\n\tstatic int i0009;\n\t/** \\u000a @deprecated */\n\tstatic int i000a;\n\t/** \\u000b @deprecated */\n\tstatic int i000b;\n\t/** \\u000c @deprecated */\n\tstatic int i000c;\n\t/** \\u001c @deprecated */\n\tstatic int i001c;\n\t/** \\u001d @deprecated */\n\tstatic int i001d;\n\t/** \\u001e @deprecated */\n\tstatic int i001e;\n\t/** \\u001f @deprecated */\n\tstatic int i001f;\n\t/** \\u2007 @deprecated */\n\tstatic int i2007;\n\t/** \\u202f @deprecated */\n\tstatic int i202f;\n}\n", "X.java", "public class X {\n\tint i0 = A.i0009;\n\tint i1 = A.i000a;\n\tint i2 = A.i000b;\n\tint i3 = A.i000c;\n\tint i4 = A.i001c;\n\tint i5 = A.i001d;\n\tint i6 = A.i001e;\n\tint i7 = A.i001f;\n\tint i8 = A.i2007;\n\tint i9 = A.i202f;\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tint i0 = A.i0009;\n\t           ^^^^^\nThe field A.i0009 is deprecated\n----------\n2. ERROR in X.java (at line 3)\n\tint i1 = A.i000a;\n\t           ^^^^^\nThe field A.i000a is deprecated\n----------\n3. ERROR in X.java (at line 5)\n\tint i3 = A.i000c;\n\t           ^^^^^\nThe field A.i000c is deprecated\n----------\n");
    }

    public void testBug77510disabled() {
        this.docCommentSupport = "ignore";
        this.runNegativeTest(new String[]{"A.java", "public class A {\n\t/** \\u0009 @deprecated */\n\tstatic int i0009;\n\t/** \\u000a @deprecated */\n\tstatic int i000a;\n\t/** \\u000b @deprecated */\n\tstatic int i000b;\n\t/** \\u000c @deprecated */\n\tstatic int i000c;\n\t/** \\u001c @deprecated */\n\tstatic int i001c;\n\t/** \\u001d @deprecated */\n\tstatic int i001d;\n\t/** \\u001e @deprecated */\n\tstatic int i001e;\n\t/** \\u001f @deprecated */\n\tstatic int i001f;\n\t/** \\u2007 @deprecated */\n\tstatic int i2007;\n\t/** \\u202f @deprecated */\n\tstatic int i202f;\n}\n", "X.java", "public class X {\n\tint i0 = A.i0009;\n\tint i1 = A.i000a;\n\tint i2 = A.i000b;\n\tint i3 = A.i000c;\n\tint i4 = A.i001c;\n\tint i5 = A.i001d;\n\tint i6 = A.i001e;\n\tint i7 = A.i001f;\n\tint i8 = A.i2007;\n\tint i9 = A.i202f;\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tint i0 = A.i0009;\n\t           ^^^^^\nThe field A.i0009 is deprecated\n----------\n2. ERROR in X.java (at line 3)\n\tint i1 = A.i000a;\n\t           ^^^^^\nThe field A.i000a is deprecated\n----------\n3. ERROR in X.java (at line 5)\n\tint i3 = A.i000c;\n\t           ^^^^^\nThe field A.i000c is deprecated\n----------\n");
    }

    public void testBug77260() {
        this.runConformTest(new String[]{"X.java", "/** @deprecated */\npublic class X {\n\tpublic int x;\n\tpublic void foo() {}\n}\n", "Y.java", "/**\n * @see X\n * @deprecated\n */\npublic class Y {\n\t/** @see X#x */\n\tpublic int x;\n\t/** @see X#foo() */\n\tpublic void foo() {}\n}\n", "Z.java", "public class Z {\n\t/** \n\t * @see X#x\n\t * @deprecated\n\t */\n\tpublic int x;\n\t/**\n\t * @see X#foo()\n\t * @deprecated\n\t */\n\tpublic void foo() {}\n}\n"});
    }

    public void testBug77260nested() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.deprecationInDeprecatedCode", "enabled");
        this.runNegativeTest(new String[]{"X.java", "/** @deprecated */\npublic class X {\n\tpublic int x;\n\tpublic void foo() {}\n}\n", "Y.java", "/**\n * @see X\n * @deprecated\n */\npublic class Y {\n\t/** @see X#x */\n\tpublic int x;\n\t/** @see X#foo() */\n\tpublic void foo() {}\n}\n", "Z.java", "public class Z {\n\t/** \n\t * @see X#x\n\t * @deprecated\n\t */\n\tpublic int x;\n\t/**\n\t * @see X#foo()\n\t * @deprecated\n\t */\n\tpublic void foo() {}\n}\n"}, "----------\n1. ERROR in Y.java (at line 2)\n\t* @see X\n\t       ^\nJavadoc: The type X is deprecated\n----------\n2. ERROR in Y.java (at line 6)\n\t/** @see X#x */\n\t         ^\nJavadoc: The type X is deprecated\n----------\n3. ERROR in Y.java (at line 6)\n\t/** @see X#x */\n\t           ^\nJavadoc: The field X.x is deprecated\n----------\n4. ERROR in Y.java (at line 8)\n\t/** @see X#foo() */\n\t         ^\nJavadoc: The type X is deprecated\n----------\n5. ERROR in Y.java (at line 8)\n\t/** @see X#foo() */\n\t           ^^^^^\nJavadoc: The method foo() from the type X is deprecated\n----------\n----------\n1. ERROR in Z.java (at line 3)\n\t* @see X#x\n\t       ^\nJavadoc: The type X is deprecated\n----------\n2. ERROR in Z.java (at line 3)\n\t* @see X#x\n\t         ^\nJavadoc: The field X.x is deprecated\n----------\n3. ERROR in Z.java (at line 8)\n\t* @see X#foo()\n\t       ^\nJavadoc: The type X is deprecated\n----------\n4. ERROR in Z.java (at line 8)\n\t* @see X#foo()\n\t         ^^^^^\nJavadoc: The method foo() from the type X is deprecated\n----------\n", null, true, options);
    }

    public void testBug77260nested_disabled() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.deprecationInDeprecatedCode", "enabled");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTagsDeprecatedRef", "disabled");
        this.runConformTest(new String[]{"X.java", "/** @deprecated */\npublic class X {\n\tpublic int x;\n\tpublic void foo() {}\n}\n", "Y.java", "/**\n * @see X\n * @deprecated\n */\npublic class Y {\n\t/** @see X#x */\n\tpublic int x;\n\t/** @see X#foo() */\n\tpublic void foo() {}\n}\n", "Z.java", "public class Z {\n\t/** \n\t * @see X#x\n\t * @deprecated\n\t */\n\tpublic int x;\n\t/**\n\t * @see X#foo()\n\t * @deprecated\n\t */\n\tpublic void foo() {}\n}\n"}, "", null, true, null, options, null);
    }

    public void testBug77602() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  /**\n   * @see\n   * @see UnknownClass\n   */\n  protected void foo() {\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @see\n\t   ^^^\nJavadoc: Missing reference\n----------\n2. ERROR in X.java (at line 4)\n\t* @see UnknownClass\n\t       ^^^^^^^^^^^^\nJavadoc: UnknownClass cannot be resolved to a type\n----------\n");
    }

    public void testBug77602_Public() {
        this.reportInvalidJavadocVisibility = "public";
        this.runConformTest(new String[]{"X.java", "public class X {\n  /**\n   * @see\n   * @see UnknownClass\n   */\n  protected void foo() {\n  }\n}\n"});
    }

    public void testBug78091() {
        this.reportMissingJavadocTags = "error";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/**\n\t * Valid type parameter reference\n\t * @param xxx.yyy invalid\n\t * @param obj(x) invalid\n\t */\n\tpublic void foo(int xxx, Object obj) {}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @param xxx.yyy invalid\n\t         ^^^^^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 5)\n\t* @param obj(x) invalid\n\t         ^^^^^^\nJavadoc: Invalid param tag name\n----------\n3. ERROR in X.java (at line 7)\n\tpublic void foo(int xxx, Object obj) {}\n\t                    ^^^\nJavadoc: Missing tag for parameter xxx\n----------\n4. ERROR in X.java (at line 7)\n\tpublic void foo(int xxx, Object obj) {}\n\t                                ^^^\nJavadoc: Missing tag for parameter obj\n----------\n");
    }

    public void testBug80910() {
        this.runNegativeTest(new String[]{"Test.java", "public class Test {\n\tint field;\n\n\t/**\n\t * @param key's toto\n\t * @see #field\n\t */\n\tpublic void foo(int x) {\n\t}\n}\n"}, "----------\n1. ERROR in Test.java (at line 5)\n\t* @param key's toto\n\t         ^^^^^\nJavadoc: Invalid param tag name\n----------\n");
    }

    public void testBug82088() {
        this.runNegativeTest(new String[]{"Test.java", "public class Test {\n\tint field;\n\n\t/**\n\t * @param key's toto\n\t * @see #field\n\t */\n\tpublic void foo(int x) {\n\t}\n}\n"}, "----------\n1. ERROR in Test.java (at line 5)\n\t* @param key's toto\n\t         ^^^^^\nJavadoc: Invalid param tag name\n----------\n");
    }

    public void testBug83285a() {
        this.runConformTest(new String[]{"p/A.java", "package p;\nclass A { }\nclass C {\n    /**\n     * Link {@link #C(String)} was also wrongly warned...\n     */\n    private String fGerman;\n    public C(String german) {\n        fGerman = german;\n    }\n}"});
    }

    public void testBug83285b() {
        this.runConformTest(new String[]{"p/A.java", "package p;\nclass A {\n\tA(char c) {}\n}\nclass B {\n\tB(Exception ex) {}\n\tvoid foo() {} \n\tclass C { \n\t    /**\n\t     * Link {@link #B(Exception)} OK\n\t     * Link {@link #B.C(String)} OK\n\t     * Link {@link #foo()} OK\n\t     * Link {@link #bar()} OK\n\t     */\n\t    public C(String str) {}\n\t\tvoid bar() {}\n\t}\n}"});
    }

    public void testBug83285c() {
        this.runNegativeTest(new String[]{"p/A.java", "package p;\nclass A {\n\tA(char c) {}\n}\nclass B {\n\tB(Exception ex) {}\n\tvoid foo() {}\n\tclass C { \n\t    /**\n\t     * Link {@link #A(char)} KO\n\t     * Link {@link #B(char)}  KO\n\t     * Link {@link #C(char)} KO\n\t     * Link {@link #foo(int)} KO\n\t     * Link {@link #bar(int)} KO\n\t     */\n\t    public C(String str) {}\n\t\tvoid bar() {}\n\t}\n}"}, "----------\n1. ERROR in p\\A.java (at line 10)\n\t* Link {@link #A(char)} KO\n\t               ^\nJavadoc: The method A(char) is undefined for the type B.C\n----------\n2. ERROR in p\\A.java (at line 11)\n\t* Link {@link #B(char)}  KO\n\t               ^\nJavadoc: The method B(char) is undefined for the type B.C\n----------\n3. ERROR in p\\A.java (at line 12)\n\t* Link {@link #C(char)} KO\n\t               ^^^^^^^\nJavadoc: The constructor B.C(char) is undefined\n----------\n4. ERROR in p\\A.java (at line 13)\n\t* Link {@link #foo(int)} KO\n\t               ^^^\nJavadoc: The method foo(int) is undefined for the type B.C\n----------\n5. ERROR in p\\A.java (at line 14)\n\t* Link {@link #bar(int)} KO\n\t               ^^^\nJavadoc: The method bar() in the type B.C is not applicable for the arguments (int)\n----------\n");
    }

    public void testBug87404() {
        this.runConformTest(new String[]{"p/A.java", "package p;\nclass A {\n\tA(char c) {}\n\tclass B {\n\t\tB(Exception ex) {}\n\t}\n\tvoid foo() {}\n    /**\n     * Link {@link #A(char)} OK \n     * Link {@link #A(String)} OK\n     * Link {@link #foo()} OK\n     * Link {@link #bar()} OK\n     */\n    public A(String str) {}\n\tvoid bar() {}\n}"});
    }

    public void testBug90302() {
        this.reportMissingJavadocTags = "error";
        this.runNegativeTest(new String[]{"X.java", "/**\n * @see #foo(String)\n */\npublic class X {\n\t/**\n\t * Static method\n\t * @param str\n\t * @return int\n\t * @throws NumberFormatException\n\t */\n\tstatic int foo(String str) throws NumberFormatException{\n\t\treturn Integer.parseInt(str);\n\t}\n}\n", "Y.java", "/**\n * @see #foo(String)\n */\npublic class Y extends X { \n\t/**\n\t * Static method: does not override super\n\t * {@inheritDoc}\n\t */\n\tstatic int foo(String str) throws NumberFormatException{\n\t\treturn Integer.parseInt(str);\n\t}\n}\n"}, "----------\n1. ERROR in Y.java (at line 7)\n\t* {@inheritDoc}\n\t    ^^^^^^^^^^\nJavadoc: Unexpected tag\n----------\n2. ERROR in Y.java (at line 9)\n\tstatic int foo(String str) throws NumberFormatException{\n\t       ^^^\nJavadoc: Missing tag for return type\n----------\n3. ERROR in Y.java (at line 9)\n\tstatic int foo(String str) throws NumberFormatException{\n\t                      ^^^\nJavadoc: Missing tag for parameter str\n----------\n4. ERROR in Y.java (at line 9)\n\tstatic int foo(String str) throws NumberFormatException{\n\t                                  ^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing tag for declared exception NumberFormatException\n----------\n");
    }

    public void testBug90302b() {
        this.reportMissingJavadocTags = "error";
        this.runNegativeTest(new String[]{"X.java", "/** */\npublic class X {\n}\n", "Y.java", "/**\n * @see #foo(String)\n */\npublic class Y extends X { \n\t/**\n\t * Simple method: does not override super\n\t * {@inheritDoc}\n\t */\n\tstatic int foo(String str) throws NumberFormatException{\n\t\treturn Integer.parseInt(str);\n\t}\n}\n"}, "----------\n1. ERROR in Y.java (at line 7)\n\t* {@inheritDoc}\n\t    ^^^^^^^^^^\nJavadoc: Unexpected tag\n----------\n2. ERROR in Y.java (at line 9)\n\tstatic int foo(String str) throws NumberFormatException{\n\t       ^^^\nJavadoc: Missing tag for return type\n----------\n3. ERROR in Y.java (at line 9)\n\tstatic int foo(String str) throws NumberFormatException{\n\t                      ^^^\nJavadoc: Missing tag for parameter str\n----------\n4. ERROR in Y.java (at line 9)\n\tstatic int foo(String str) throws NumberFormatException{\n\t                                  ^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing tag for declared exception NumberFormatException\n----------\n");
    }

    public void testBug103304a() {
        this.runNegativeTest(new String[]{"boden/IAFAState.java", "package boden;\npublic interface IAFAState {\n    public class ValidationException extends Exception {\n        public ValidationException(String variableName, IAFAState subformula) {\n            super(\"Variable '\"+variableName+\"' may be unbound in '\"+subformula+\"'\");\n        }\n        public void method() {}\n    }\n    /**\n     * Validates a formula for consistent bindings. Bindings are consistent, when at each point in time,\n     * the set of povided variables can be guaranteed to be a superset of the set of required variables.\n     * @throws ValidationException Thrown if a variable is unbound. \n     * @see ValidationException#IAFAState.ValidationException(String, IAFAState)\n     * @see IAFAState.ValidationException#method()\n     * @see ValidationException\n     * {@link ValidationException}\n     */\n    public void validate() throws ValidationException;\n}\n", "boden/TestValid.java", "package boden;\nimport boden.IAFAState.ValidationException;\n/**\n * @see ValidationException\n * @see IAFAState.ValidationException\n */\npublic class TestValid {\n\t/**  \n\t * @see ValidationException#IAFAState.ValidationException(String, IAFAState)\n\t */\n\tIAFAState.ValidationException valid1;\n\t/**\n\t * @see IAFAState.ValidationException#IAFAState.ValidationException(String, IAFAState)\n\t */\n\tIAFAState.ValidationException valid2;\n}\n"}, "----------\n1. ERROR in boden\\TestValid.java (at line 4)\n\t* @see ValidationException\n\t       ^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid member type qualification\n----------\n2. ERROR in boden\\TestValid.java (at line 9)\n\t* @see ValidationException#IAFAState.ValidationException(String, IAFAState)\n\t       ^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid member type qualification\n----------\n");
    }

    public void testBug103304b() {
        this.runNegativeTest(new String[]{"boden/IAFAState.java", "package boden;\npublic interface IAFAState {\n    public class ValidationException extends Exception {\n        public ValidationException(String variableName, IAFAState subformula) {\n            super(\"Variable '\"+variableName+\"' may be unbound in '\"+subformula+\"'\");\n        }\n        public void method() {}\n    }\n}\n", "boden/TestInvalid1.java", "package boden;\nimport boden.IAFAState.ValidationException;\npublic class TestInvalid1 {\n\t/** \n\t * @see ValidationException#ValidationException(String, IAFAState)\n\t */ \n\tIAFAState.ValidationException invalid;\n}\n", "boden/TestInvalid2.java", "package boden;\npublic class TestInvalid2 {\n\t/**\n\t * @see IAFAState.ValidationException#ValidationException(String, IAFAState)\n\t */\n\tIAFAState.ValidationException invalid;\n}\n", "boden/TestInvalid3.java", "package boden;\nimport boden.IAFAState.ValidationException;\npublic class TestInvalid3 {\n\t/**\n\t * @see IAFAState.ValidationException#IAFA.State.ValidationException(String, IAFAState)\n\t */\n\tIAFAState.ValidationException invalid;\n}\n", "boden/TestInvalid4.java", "package boden;\nimport boden.IAFAState.ValidationException;\npublic class TestInvalid4 {\n\t/**\n\t * @see IAFAState.ValidationException#IAFAState .ValidationException(String, IAFAState)\n\t */\n\tIAFAState.ValidationException invalid;\n}\n"}, "----------\n1. ERROR in boden\\TestInvalid1.java (at line 5)\n\t* @see ValidationException#ValidationException(String, IAFAState)\n\t       ^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid member type qualification\n----------\n----------\n1. ERROR in boden\\TestInvalid3.java (at line 5)\n\t* @see IAFAState.ValidationException#IAFA.State.ValidationException(String, IAFAState)\n\t                                     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid member type qualification\n----------\n----------\n1. ERROR in boden\\TestInvalid4.java (at line 5)\n\t* @see IAFAState.ValidationException#IAFAState .ValidationException(String, IAFAState)\n\t                                     ^^^^^^^^^\nJavadoc: IAFAState cannot be resolved or is not a field\n----------\n");
    }

    public void testBug103304c() {
        this.runConformTest(new String[]{"test/Test.java", "package test;\npublic interface Test {\n\tpublic class Level0 {\n\t\tpublic Level0() {}\n\t}\n\tpublic interface Member {\n\t\tpublic class Level1 {\n\t\t\tpublic Level1() {}\n\t\t}\n\t}\n}\n", "test/C.java", "package test;\npublic class C {\n\t/**\n\t * @see Test.Level0#Test.Level0()\n\t */\n\tTest.Level0 valid = new Test.Level0();\n\t/**\n\t * @see Test.Level0#Level0()\n\t */\n\tTest.Level0 invalid = new Test.Level0();\n}\n"});
    }

    public void testBug103304d() {
        this.runNegativeTest(new String[]{"test/Test.java", "package test;\npublic interface Test {\n\tpublic class Level0 {\n\t\tpublic Level0() {}\n\t}\n\tpublic interface Member {\n\t\tpublic class Level1 {\n\t\t\tpublic Level1() {}\n\t\t}\n\t}\n}\n", "test/C2.java", "package test;\npublic class C2 {\n\t/**\n\t * @see Test.Member.Level1#Test.Member.Level1()\n\t */\n\tTest.Member.Level1 valid = new Test.Member.Level1();\n\t/**\n\t * @see Test.Member.Level1#Level1()\n\t */\n\tTest.Member.Level1 invalid = new Test.Member.Level1();\n\t/**\n\t * @see Test.Member.Level1#Test.Level1()\n\t */\n\tTest.Member.Level1 wrong = new Test.Member.Level1();\n}\n"}, "----------\n1. ERROR in test\\C2.java (at line 12)\n\t* @see Test.Member.Level1#Test.Level1()\n\t                          ^^^^^^^^^^^^^\nJavadoc: Invalid member type qualification\n----------\n");
    }

    public void testBug103304e() {
        this.runConformTest(new String[]{"implicit/Valid.java", "package implicit;\npublic interface Valid {\n\tpublic class Level0 {\n\t\t/**\n\t\t * @see #Valid.Level0() Valid\n\t\t */\n\t\tpublic Level0() {}\n\t\t/**\n\t\t * @see #Valid.Level0(String) Valid\n\t\t */\n\t\tpublic Level0(String str) {}\n\t}\n\tpublic interface Member {\n\t\tpublic class Level1 {\n\t\t\t/**\n\t\t\t * @see #Valid.Member.Level1() Valid\n\t\t\t */\n\t\t\tpublic Level1() {}\n\t\t\t/**\n\t\t\t * @see #Valid.Member.Level1(int) Valid\n\t\t\t */\n\t\t\tpublic Level1(int x) {}\n\t\t}\n\t}\n}\n"});
    }

    public void testBug103304f() {
        this.runNegativeTest(new String[]{"implicit/Invalid.java", "package implicit;\npublic interface Invalid {\n\tpublic class Level0 {\n\t\t/**\n\t\t * @see #Level0() Invalid\n\t\t */\n\t\tpublic Level0() {}\n\t\t/**\n\t\t * @see #Level0(String) Invalid\n\t\t */\n\t\tpublic Level0(String str) {}\n\t}\n\tpublic interface Member {\n\t\tpublic class Level1 {\n\t\t\t/**\n\t\t\t * @see #Level1() Invalid\n\t\t\t * @see #Member.Level1() Invalid\n\t\t\t * @see #Invalid.Level1() Invalid\n\t\t\t */\n\t\t\tpublic Level1() {}\n\t\t\t/**\n\t\t\t * @see #Level1(int) Invalid\n\t\t\t * @see #Invalid.Level1(int) Invalid\n\t\t\t * @see #Member.Level1(int) Invalid\n\t\t\t */\n\t\t\tpublic Level1(int x) {}\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in implicit\\Invalid.java (at line 17)\n\t* @see #Member.Level1() Invalid\n\t        ^^^^^^^^^^^^^^^\nJavadoc: Invalid member type qualification\n----------\n2. ERROR in implicit\\Invalid.java (at line 18)\n\t* @see #Invalid.Level1() Invalid\n\t        ^^^^^^^^^^^^^^^^\nJavadoc: Invalid member type qualification\n----------\n3. ERROR in implicit\\Invalid.java (at line 23)\n\t* @see #Invalid.Level1(int) Invalid\n\t        ^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid member type qualification\n----------\n4. ERROR in implicit\\Invalid.java (at line 24)\n\t* @see #Member.Level1(int) Invalid\n\t        ^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid member type qualification\n----------\n");
    }

    public void testBug116464() {
        this.reportMissingJavadocTags = "error";
        this.runConformTest(new String[]{"X.java", "public class X {\n\t/**\n\t * @\\u0070\\u0061\\u0072\\u0061\\u006d str xxx\n\t */\n\tvoid foo(String str) {}\n}\n"});
    }

    public void testBug125903() {
        this.reportMissingJavadocTags = "error";
        this.runNegativeTest(new String[]{"X.java", "/**\n * {@ link java.lang.String}\n * @ since 2.1\n */\npublic class X {\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t* {@ link java.lang.String}\n\t   ^^\nJavadoc: Invalid tag\n----------\n2. ERROR in X.java (at line 3)\n\t* @ since 2.1\n\t  ^^\nJavadoc: Invalid tag\n----------\n");
    }

    public void testBug128954() {
        this.reportInvalidJavadoc = "warning";
        this.reportDeprecation = "warning";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/**\n\t * @see p.A#bar()\n\t */\n\tvoid foo() {\n\t\tZork z;\n\t}\n}\n", "p/A.java", "package p;\npublic class A {\n\t/** @deprecated */\n\tpublic void bar() {\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\t* @see p.A#bar()\n\t           ^^^^^\n[@cat:javadoc] Javadoc: The method bar() from the type A is deprecated\n----------\n2. ERROR in X.java (at line 6)\n\tZork z;\n\t^^^^\n[@cat:type] Zork cannot be resolved to a type\n----------\n", null, true, null, false, true, true);
    }

    public void testBug128954a() {
        this.reportInvalidJavadoc = "warning";
        this.reportDeprecation = "warning";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\n\t/**\n\t * @see p.A#bar()\n\t */\n\tvoid foo() {\n\t\tZork z;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\t* @see p.A#bar()\n\t       ^^^\n[@cat:javadoc] Javadoc: p cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 7)\n\tZork z;\n\t^^^^\n[@cat:type] Zork cannot be resolved to a type\n----------\n", null, true, null, false, true, true);
    }

    public void testBug129241a() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/**\n\t * @see p.A#bar\n\t */\n\tvoid foo() {}\n}\n", "p/A.java", "package p;\n/** @deprecated */\npublic class A {\n\tvoid bar() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @see p.A#bar\n\t       ^^^\nJavadoc: The type A is deprecated\n----------\n");
    }

    public void testBug129241b() {
        this.reportDeprecation = "ignore";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/**\n\t * @see p.A#bar\n\t */\n\tvoid foo() {}\n}\n", "p/A.java", "package p;\n/** @deprecated */\npublic class A {\n\tvoid bar() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @see p.A#bar\n\t       ^^^\nJavadoc: The type A is deprecated\n----------\n");
    }

    public void testBug129241c() {
        this.reportJavadocDeprecation = "disabled";
        this.runConformTest(new String[]{"X.java", "public class X {\n\t/**\n\t * @see p.A#bar\n\t */\n\tvoid foo() {}\n}\n", "p/A.java", "package p;\n/** @deprecated */\npublic class A {\n\tvoid bar() {}\n}\n"});
    }

    public void testBug129241d() {
        this.reportInvalidJavadoc = "ignore";
        this.runConformTest(new String[]{"X.java", "public class X {\n\t/**\n\t * @see p.A#bar\n\t */\n\tvoid foo() {}\n}\n", "p/A.java", "package p;\n/** @deprecated */\npublic class A {\n\tvoid bar() {}\n}\n"});
    }

    public void testBug132813() {
        this.runNegativeTest(new String[]{"Test.java", "public class X { \n\t/**\t */ \n\tpublic Test() {}\n\t/**\t */\n\tpublic test() {}\n}\n"}, "----------\n1. ERROR in Test.java (at line 1)\n\tpublic class X { \n\t             ^\nThe public type X must be defined in its own file\n----------\n2. ERROR in Test.java (at line 3)\n\tpublic Test() {}\n\t       ^^^^^^\nReturn type for the method is missing\n----------\n3. ERROR in Test.java (at line 5)\n\tpublic test() {}\n\t       ^^^^^^\nReturn type for the method is missing\n----------\n");
    }

    public void testBug149013_Private01() {
        this.reportMissingJavadocTags = "ignore";
        this.runConformTest(new String[]{"test1/X.java", "package test1;\npublic class X {\n\tclass Inner {\n\t\tclass Level2 {\n\t\t\tclass Level3 {}\n\t\t}\n\t}\n}\n", "test1/Test.java", "package test1;\n/**\n * @see X.Inner\n * @see X.Inner.Level2\n * @see X.Inner.Level2.Level3\n */\npublic class Test {}\n", "test1/X.java"});
    }

    public void testBug149013_Public01() {
        this.reportMissingJavadocTags = "disabled";
        this.reportInvalidJavadocVisibility = "public";
        this.runNegativeTest(new String[]{"test1/X.java", "package test1;\npublic class X {\n\tclass Inner {\n\t\tclass Level2 {\n\t\t\tclass Level3 {}\n\t\t}\n\t}\n}\n", "test1/Test.java", "package test1;\n/**\n * @see X.Inner\n * @see X.Inner.Level2\n * @see X.Inner.Level2.Level3\n */\npublic class Test {\n}\n"}, "----------\n1. ERROR in test1\\Test.java (at line 3)\n\t* @see X.Inner\n\t       ^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n2. ERROR in test1\\Test.java (at line 4)\n\t* @see X.Inner.Level2\n\t       ^^^^^^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n3. ERROR in test1\\Test.java (at line 5)\n\t* @see X.Inner.Level2.Level3\n\t       ^^^^^^^^^^^^^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n");
    }

    public void testBug149013_Private02() {
        this.reportMissingJavadocTags = "ignore";
        this.runNegativeTest(new String[]{"test1/X.java", "package test1;\npublic class X {\n\tclass Inner {\n\t\tclass Level2 {\n\t\t\tclass Level3 {}\n\t\t}\n\t}\n}\n", "test2/Test.java", "package test2;\nimport test1.X;\n/**\n * @see X.Inner\n * @see X.Inner.Level2\n * @see X.Inner.Level2.Level3\n */\npublic class Test {}\n"}, "----------\n1. ERROR in test2\\Test.java (at line 4)\r\n\t* @see X.Inner\r\n\t       ^^^^^^^\nJavadoc: The type X.Inner is not visible\n----------\n2. ERROR in test2\\Test.java (at line 5)\r\n\t* @see X.Inner.Level2\r\n\t       ^^^^^^^^^^^^^^\nJavadoc: The type X.Inner is not visible\n----------\n3. ERROR in test2\\Test.java (at line 6)\r\n\t* @see X.Inner.Level2.Level3\r\n\t       ^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type X.Inner is not visible\n----------\n");
    }

    public void testBug149013_Public02() {
        this.reportMissingJavadocTags = "disabled";
        this.reportInvalidJavadocVisibility = "public";
        this.runNegativeTest(new String[]{"test1/X.java", "package test1;\npublic class X {\n\tclass Inner {\n\t\tclass Level2 {\n\t\t\tclass Level3 {}\n\t\t}\n\t}\n}\n", "test2/Test.java", "package test2;\nimport test1.X;\n/**\n * @see X.Inner\n * @see X.Inner.Level2\n * @see X.Inner.Level2.Level3\n */\npublic class Test {}\n"}, "----------\n1. ERROR in test2\\Test.java (at line 4)\r\n\t* @see X.Inner\r\n\t       ^^^^^^^\nJavadoc: The type X.Inner is not visible\n----------\n2. ERROR in test2\\Test.java (at line 5)\r\n\t* @see X.Inner.Level2\r\n\t       ^^^^^^^^^^^^^^\nJavadoc: The type X.Inner is not visible\n----------\n3. ERROR in test2\\Test.java (at line 6)\r\n\t* @see X.Inner.Level2.Level3\r\n\t       ^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type X.Inner is not visible\n----------\n");
    }

    public void testBug149013_Private03() {
        this.reportMissingJavadocTags = "ignore";
        this.runNegativeTest(new String[]{"test1/X.java", "package test1;\npublic class X {\n\tclass Inner {\n\t\tclass Level2 {\n\t\t\tclass Level3 {}\n\t\t}\n\t}\n}\n", "test3/Test.java", "package test3;\n/**\n * @see test1.X.Inner\n * @see test1.X.Inner.Level2\n * @see test1.X.Inner.Level2.Level3\n */\npublic class Test {}\n"}, "----------\n1. ERROR in test3\\Test.java (at line 3)\r\n\t* @see test1.X.Inner\r\n\t       ^^^^^^^^^^^^^\nJavadoc: The type test1.X.Inner is not visible\n----------\n2. ERROR in test3\\Test.java (at line 4)\r\n\t* @see test1.X.Inner.Level2\r\n\t       ^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test1.X.Inner is not visible\n----------\n3. ERROR in test3\\Test.java (at line 5)\r\n\t* @see test1.X.Inner.Level2.Level3\r\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test1.X.Inner is not visible\n----------\n");
    }

    public void testBug149013_Public03() {
        this.reportMissingJavadocTags = "disabled";
        this.reportInvalidJavadocVisibility = "public";
        this.runNegativeTest(new String[]{"test1/X.java", "package test1;\npublic class X {\n\tclass Inner {\n\t\tclass Level2 {\n\t\t\tclass Level3 {}\n\t\t}\n\t}\n}\n", "test3/Test.java", "package test3;\n/**\n * @see test1.X.Inner\n * @see test1.X.Inner.Level2\n * @see test1.X.Inner.Level2.Level3\n */\npublic class Test {}\n"}, "----------\n1. ERROR in test3\\Test.java (at line 3)\r\n\t* @see test1.X.Inner\r\n\t       ^^^^^^^^^^^^^\nJavadoc: The type test1.X.Inner is not visible\n----------\n2. ERROR in test3\\Test.java (at line 4)\r\n\t* @see test1.X.Inner.Level2\r\n\t       ^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test1.X.Inner is not visible\n----------\n3. ERROR in test3\\Test.java (at line 5)\r\n\t* @see test1.X.Inner.Level2.Level3\r\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test1.X.Inner is not visible\n----------\n");
    }

    public void testBug153399a() {
        String[] testFiles = new String[]{"X.java", "public class X { \n\t/**\n\t * {@value #MY_VALUE}\n\t */\n\tpublic final static int MY_VALUE = 0; \n\t/**\n\t * {@value #MY_VALUE}\n\t */\n\tpublic void foo() {}\n\t/**\n\t * {@value #MY_VALUE}\n\t */\n\tclass Sub {} \n}\n"};
        if (this.complianceLevel.equals("1.3") || this.complianceLevel.equals("1.4")) {
            this.runNegativeTest(testFiles, "----------\n1. ERROR in X.java (at line 7)\n\t* {@value #MY_VALUE}\n\t    ^^^^^\nJavadoc: Unexpected tag\n----------\n2. ERROR in X.java (at line 11)\n\t* {@value #MY_VALUE}\n\t    ^^^^^\nJavadoc: Unexpected tag\n----------\n");
        } else {
            this.runConformTest(testFiles);
        }
    }

    public void testBug153399b() {
        String[] testFiles = new String[]{"X.java", "public class X { \n\t/**\n\t * {@value}\n\t */\n\tpublic final static int MY_VALUE = 0; \n\t/**\n\t * {@value}\n\t */\n\tpublic void foo() {}\n\t/**\n\t * {@value}\n\t */\n\tclass Sub {} \n}\n"};
        if (this.complianceLevel.equals("1.3") || this.complianceLevel.equals("1.4")) {
            this.runNegativeTest(testFiles, "----------\n1. ERROR in X.java (at line 7)\n\t* {@value}\n\t    ^^^^^\nJavadoc: Unexpected tag\n----------\n2. ERROR in X.java (at line 11)\n\t* {@value}\n\t    ^^^^^\nJavadoc: Unexpected tag\n----------\n");
        } else {
            this.runConformTest(testFiles);
        }
    }

    public void testBug153399c() {
        String[] testFiles = new String[]{"p1/X.java", "package p1;\npublic class X {\n\t/**\n\t * @return a\n\t */\n\tboolean get() {\n\t\treturn false;\n\t}\n}\n"};
        this.runConformTest(testFiles);
    }

    public void testBug153399d() {
        String[] testFiles = new String[]{"X.java", "public class X { \n\t/**\n\t * {@value #MY_VALUE}\n\t * {@value}\n\t * {@value Invalid}\n\t */\n\tpublic final static int MY_VALUE = 0; \n}\n"};
        if (this.complianceLevel.equals("1.3") || this.complianceLevel.equals("1.4")) {
            this.runNegativeTest(testFiles, "----------\n1. ERROR in X.java (at line 3)\n\t* {@value #MY_VALUE}\n\t    ^^^^^\nJavadoc: Unexpected tag\n----------\n2. ERROR in X.java (at line 4)\n\t* {@value}\n\t    ^^^^^\nJavadoc: Unexpected tag\n----------\n");
        } else {
            this.runNegativeTest(testFiles, "----------\n1. ERROR in X.java (at line 5)\n\t* {@value Invalid}\n\t          ^^^^^^^^\nJavadoc: Invalid reference\n----------\n");
        }
    }

    public void testBug153399e() {
        String[] testFiles = new String[]{"X.java", "public class X { \n\t/**\n\t * {@value Invalid}\n\t * {@value #MY_VALUE}\n\t */\n\tpublic final static int MY_VALUE = 0; \n}\n"};
        if (this.complianceLevel.equals("1.3") || this.complianceLevel.equals("1.4")) {
            this.runNegativeTest(testFiles, "----------\n1. ERROR in X.java (at line 3)\n\t* {@value Invalid}\n\t    ^^^^^\nJavadoc: Unexpected tag\n----------\n");
        } else {
            this.runNegativeTest(testFiles, "----------\n1. ERROR in X.java (at line 3)\n\t* {@value Invalid}\n\t          ^^^^^^^^\nJavadoc: Invalid reference\n----------\n");
        }
    }

    public void testBug160015() {
        this.runNegativeTest(new String[]{"Test.java", "/**\n * @see #method(Long) Warning!\n */\npublic class Test {\n\tpublic void method(long l) {}\n\t/**\n\t * @see #method(Long) Warning!\n\t */\n\tvoid bar() {}\n}\n"}, "----------\n1. ERROR in Test.java (at line 2)\n\t* @see #method(Long) Warning!\n\t        ^^^^^^\nJavadoc: The method method(long) in the type Test is not applicable for the arguments (Long)\n----------\n2. ERROR in Test.java (at line 7)\n\t* @see #method(Long) Warning!\n\t        ^^^^^^\nJavadoc: The method method(long) in the type Test is not applicable for the arguments (Long)\n----------\n");
    }

    public void testBug163659() {
        this.runNegativeTest(new String[]{"Test.java", "/**\n * @see #foo(MyInterface)\n * @see #foo(MySubInterface)\n */\npublic class Test {\n\tpublic void foo(MyInterface mi) {\n\t}\n}\ninterface MyInterface {}\ninterface MySubInterface extends MyInterface {} \n"}, "----------\n1. ERROR in Test.java (at line 3)\n\t* @see #foo(MySubInterface)\n\t        ^^^\nJavadoc: The method foo(MyInterface) in the type Test is not applicable for the arguments (MySubInterface)\n----------\n");
    }

    public void testBug165794() {
        String[] testFiles = new String[]{"X.java", "/**\n * No reasonable hint for resolving the {@link #getMax(A)}.\n */\npublic class X {\n    /**\n     * Extends Number method.\n     * @see #getMax(A ipZ)\n     */\n    public <T extends Y> T getMax(final A<T> ipY) {\n        return ipY.t();\n    }\n    \n    /**\n     * Extends Exception method.\n     * @see #getMax(A ipY)\n     */\n    public <T extends Z> T getMax(final A<T> ipZ) {\n        return ipZ.t();\n    }\n}\nclass A<T> {\n\tT t() { return null; }\n}\nclass Y {}\nclass Z {}"};
        if (this.complianceLevel.equals("1.3") || this.complianceLevel.equals("1.4")) {
            return;
        }
        this.runConformTest(testFiles);
    }

    public void testBug166365() {
        String[] testFiles = new String[]{"X.java", "public class X {\n    /**\n     * @return\n     */\n    private String getSomePrivate() {\n        return \"SomePrivate\";\n    }\n    /**\n     * @return\n     */\n    protected String getSomeProtected() {\n        return \"SomeProtected\";\n    }\n    /**\n     * @return\n     */\n    String getSomeDefault() {\n        return \"SomeDefault\";\n    }\n    /**\n     * @return\n     */\n    public String getSomePublic() {\n        return \"SomePublic\";\n    }\n}\n"};
        this.reportInvalidJavadocVisibility = "public";
        this.runNegativeTest(testFiles, "----------\n1. ERROR in X.java (at line 21)\n\t* @return\n\t   ^^^^^^\nJavadoc: Missing return type description\n----------\n");
    }

    public void testBug166436() {
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic static final String PUBLIC_CONST = \"public\";\n\tprotected static final String PROTECTED_CONST = \"protected\";\n\tstatic final String DEFAULT_CONST = \"default\"; \n\tprivate static final String PRIVATE_CONST = \"private\"; \n\t/**\n\t * Values:\n\t * <ul>\n\t * \t<li>{@value #PUBLIC_CONST}</li>\n\t * \t<li>{@value #PROTECTED_CONST}</li>\n\t * \t<li>{@value #DEFAULT_CONST}</li>\n\t * \t<li>{@value #PRIVATE_CONST}</li>\n\t * </ul>\n\t */\n\tpublic X() {\n\t}\n}\n"};
        this.reportInvalidJavadocVisibility = "public";
        if (this.complianceLevel.equals("1.3") || this.complianceLevel.equals("1.4")) {
            this.runNegativeTest(testFiles, "----------\n1. ERROR in X.java (at line 9)\n\t* \t<li>{@value #PUBLIC_CONST}</li>\n\t  \t      ^^^^^\nJavadoc: Unexpected tag\n----------\n2. ERROR in X.java (at line 10)\n\t* \t<li>{@value #PROTECTED_CONST}</li>\n\t  \t      ^^^^^\nJavadoc: Unexpected tag\n----------\n3. ERROR in X.java (at line 11)\n\t* \t<li>{@value #DEFAULT_CONST}</li>\n\t  \t      ^^^^^\nJavadoc: Unexpected tag\n----------\n4. ERROR in X.java (at line 12)\n\t* \t<li>{@value #PRIVATE_CONST}</li>\n\t  \t      ^^^^^\nJavadoc: Unexpected tag\n----------\n");
        } else {
            this.runNegativeTest(testFiles, "----------\n1. ERROR in X.java (at line 10)\n\t* \t<li>{@value #PROTECTED_CONST}</li>\n\t  \t            ^^^^^^^^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'protected' reference\n----------\n2. ERROR in X.java (at line 11)\n\t* \t<li>{@value #DEFAULT_CONST}</li>\n\t  \t            ^^^^^^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n3. ERROR in X.java (at line 12)\n\t* \t<li>{@value #PRIVATE_CONST}</li>\n\t  \t            ^^^^^^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'private' reference\n----------\n");
        }
    }
}

