/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractComparableTest;

public class EnumTest
extends AbstractComparableTest {
    String reportMissingJavadocComments = null;
    static /* synthetic */ Class class$0;

    public EnumTest(String name) {
        super(name);
    }

    public static Test suite() {
        return EnumTest.buildComparableTestSuite(EnumTest.testClass());
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.compiler.regression.EnumTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.doc.comment.support", "enabled");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadoc", "error");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTags", "enabled");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTagsVisibility", "private");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocTags", "error");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocTagsVisibility", "private");
        if (this.reportMissingJavadocComments != null) {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocComments", this.reportMissingJavadocComments);
        }
        return options;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.reportMissingJavadocComments = null;
    }

    public void test000() {
        this.runConformTest(new String[]{"e/X.java", "package e;\nimport e.T;\nimport static e.T.*;\n\npublic class X {\n    public static void main(String[] args) {\n    \tSystem.out.print(\"JDTCore team:\");\n    \tT oldest = null;\n    \tint maxAge = Integer.MIN_VALUE;\n    \tfor (T t : T.values()) {\n            if (t == YODA) continue;// skip YODA\n            t.setRole(t.isManager());\n\t\t\t if (t.age() > maxAge) {\n               oldest = t;\n               maxAge = t.age();\n            }\n            System.out.print(\" \"+ t + ':'+t.age()+':'+location(t)+':'+t.role);\n        }\n        System.out.println(\" WINNER is:\" + T.valueOf(oldest.name()));\n    }\n\n   private enum Location { SNZ, OTT }\n\n    private static Location location(T t) {\n        switch(t) {\n          case PHILIPPE:  \n          case DAVID:\n          case JEROME:\n          case FREDERIC:\n          \treturn Location.SNZ;\n          case OLIVIER:\n          case KENT:\n            return Location.OTT;\n          default:\n            throw new AssertionError(\"Unknown team member: \" + t);\n        }\n    }\n}\n", "e/T.java", "package e;\npublic enum T {\n\tPHILIPPE(37) {\n\t\tpublic boolean isManager() {\n\t\t\treturn true;\n\t\t}\n\t},\n\tDAVID(27),\n\tJEROME(33),\n\tOLIVIER(35),\n\tKENT(40),\n\tYODA(41),\n\tFREDERIC;\n\tfinal static int OLD = 41;\n\n   enum Role { M, D }\n\n   int age;\n\tRole role;\n\n\tT() { this(OLD); }\n\tT(int age) {\n\t\tthis.age = age;\n\t}\n\tpublic int age() { return this.age; }\n\tpublic boolean isManager() { return false; }\n\tvoid setRole(boolean mgr) {\n\t\tthis.role = mgr ? Role.M : Role.D;\n\t}\n}\n"}, "JDTCore team: PHILIPPE:37:SNZ:M DAVID:27:SNZ:D JEROME:33:SNZ:D OLIVIER:35:OTT:D KENT:40:OTT:D FREDERIC:41:SNZ:D WINNER is:FREDERIC");
    }

    public void test001() {
        this.runNegativeTest(new String[]{"X.java", "public enum X { \n\tBLEU, \n\tBLANC, \n\tROUGE;\n\tstatic {\n\t\tBLEU = null;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tBLEU = null;\n\t^^^^\nThe final field X.BLEU cannot be assigned\n----------\n");
    }

    public void test002() {
        this.runNegativeTest(new String[]{"X.java", "public enum X { \n\t\n\tBLEU, \n\tBLANC, \n\tROUGE,\n\tBLEU;\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tBLEU, \n\t^^^^\nDuplicate field X.BLEU\n----------\n2. ERROR in X.java (at line 6)\n\tBLEU;\n\t^^^^\nDuplicate field X.BLEU\n----------\n");
    }

    public void test003() {
        this.runNegativeTest(new String[]{"X.java", "public enum X { \n\t\n\tpublic BLEU, \n\ttransient BLANC, \n\tROUGE\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tpublic BLEU, \n\t       ^^^^\nIllegal modifier for the enum constant BLEU; no modifier is allowed\n----------\n2. ERROR in X.java (at line 4)\n\ttransient BLANC, \n\t          ^^^^^\nIllegal modifier for the enum constant BLANC; no modifier is allowed\n----------\n");
    }

    public void test004() {
        this.runConformTest(new String[]{"X.java", "public enum X { \n\t\n\tBLEU,\n\tBLANC,\n\tROUGE;\n\t\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(BLEU);\n\t}\n\t\n}\n"}, "BLEU");
    }

    public void test005() {
        this.runNegativeTest(new String[]{"X.java", "public enum X { \n\t;\n\tprotected Object clone() { return this; }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tprotected Object clone() { return this; }\n\t                 ^^^^^^^\nCannot override the final method from Enum<X>\n----------\n2. WARNING in X.java (at line 3)\n\tprotected Object clone() { return this; }\n\t                 ^^^^^^^\nThe method clone() of type X should be tagged with @Override since it actually overrides a superclass method\n----------\n");
    }

    public void test006() {
        this.runConformTest(new String[]{"X.java", "public enum X { \n\t\n\tBLEU,\n\tBLANC,\n\tROUGE;\n\t\n\tpublic static void main(String[] args) {\n\t\tfor(X x: X.values()) {\n\t\t\tSystem.out.print(x);\n\t\t}\n\t}\n\t\n}\n"}, "BLEUBLANCROUGE");
    }

    public void test007() {
        this.runConformTest(new String[]{"X.java", "public enum X { \n\t\n\tBLEU,\n\tBLANC,\n\tROUGE;\n\t\n   int $VALUES;\n\tpublic static void main(String[] args) {\n\t\tfor(X x: X.values()) {\n\t\t\tSystem.out.print(x);\n\t\t}\n\t}\n\t\n}\n"}, "BLEUBLANCROUGE");
    }

    public void test008() {
        this.runNegativeTest(new String[]{"X.java", "public enum X { \n\t\n\tBLEU,\n\tBLANC,\n\tROUGE;\n\t\n   void dup() {} \n   void values() {} \n   void dup() {} \n   void values() {} \n   Missing dup() {} \n\tpublic static void main(String[] args) {\n\t\tfor(X x: X.values()) {\n\t\t\tSystem.out.print(x);\n\t\t}\n\t}\n\t\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tvoid dup() {} \n\t     ^^^^^\nDuplicate method dup() in type X\n----------\n2. ERROR in X.java (at line 8)\n\tvoid values() {} \n\t     ^^^^^^^^\nThe enum X already defines the method values() implicitly\n----------\n3. ERROR in X.java (at line 9)\n\tvoid dup() {} \n\t     ^^^^^\nDuplicate method dup() in type X\n----------\n4. ERROR in X.java (at line 10)\n\tvoid values() {} \n\t     ^^^^^^^^\nThe enum X already defines the method values() implicitly\n----------\n5. ERROR in X.java (at line 11)\n\tMissing dup() {} \n\t^^^^^^^\nMissing cannot be resolved to a type\n----------\n6. ERROR in X.java (at line 11)\n\tMissing dup() {} \n\t        ^^^^^\nDuplicate method dup() in type X\n----------\n");
    }

    public void test009() {
        this.runConformTest(new String[]{"X.java", "public enum X {\n\t\n\tBLEU,\n\tBLANC,\n\tROUGE;\n\t\n\t//void values() {}\n\t\n\tpublic static void main(String[] args) {\n\t\tX x = BLEU;\n\t\tswitch(x) {\n\t\t\tcase BLEU :\n\t\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t\t\tbreak;\n\t\t\tcase BLANC :\n\t\t\tcase ROUGE :\n\t\t\t\tSystem.out.println(\"FAILED\");\n\t\t\t\tbreak;\n\t\t}\n\t}\n\t\n}"}, "SUCCESS");
    }

    public void test010() {
        this.runNegativeTest(new String[]{"X.java", "public enum X {\n\t\n\tBLEU,\n\tBLANC,\n\tROUGE;\n\t\n\t//void values() {}\n\t\n\tpublic static void main(String[] args) {\n\t\tX x = BLEU;\n\t\tswitch(x) {\n\t\t\tcase BLEU :\n\t\t\t\tbreak;\n\t\t\tcase BLEU :\n\t\t\tcase BLANC :\n\t\t\tcase ROUGE :\n\t\t\t\tSystem.out.println(\"FAILED\");\n\t\t\t\tbreak;\n\t\t}\n\t}\n\t\n}"}, "----------\n1. ERROR in X.java (at line 12)\n\tcase BLEU :\n\t^^^^^^^^^\nDuplicate case\n----------\n2. ERROR in X.java (at line 14)\n\tcase BLEU :\n\t^^^^^^^^^\nDuplicate case\n----------\n");
    }

    public void test011() {
        this.runNegativeTest(new String[]{"X.java", "public enum X { \n\t\n\tBLEU,\n\tBLANC,\n\tROUGE;\n\t\n   void values() {} \n   void values() {} \n\tpublic static void main(String[] args) {\n\t\tfor(X x: X.values()) {\n\t\t\tSystem.out.print(x);\n\t\t}\n\t}\n\t\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tvoid values() {} \n\t     ^^^^^^^^\nThe enum X already defines the method values() implicitly\n----------\n2. ERROR in X.java (at line 8)\n\tvoid values() {} \n\t     ^^^^^^^^\nThe enum X already defines the method values() implicitly\n----------\n");
    }

    public void test012() {
        this.runNegativeTest(new String[]{"X.java", "public enum X implements Runnable { \n\t\n\tBLEU,\n\tBLANC,\n\tROUGE;\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic enum X implements Runnable { \n\t            ^\nThe type X must implement the inherited abstract method Runnable.run()\n----------\n");
    }

    public void test013() {
        this.runNegativeTest(new String[]{"X.java", "public enum X { \n\t\n\tBLEU(10),\n\tBLANC(20),\n\tROUGE(30);\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tBLEU(10),\n\t^^^^\nThe constructor X(int) is undefined\n----------\n2. ERROR in X.java (at line 4)\n\tBLANC(20),\n\t^^^^^\nThe constructor X(int) is undefined\n----------\n3. ERROR in X.java (at line 5)\n\tROUGE(30);\n\t^^^^^\nThe constructor X(int) is undefined\n----------\n");
    }

    public void test014() {
        this.runConformTest(new String[]{"X.java", "public enum X { \n\t\n\tBLEU(10),\n\tBLANC(20),\n\tROUGE(30);\n\n\tint val;\n\tX(int val) {\n\t\tthis.val = val;\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tfor(X x: values()) {\n\t\t\tSystem.out.print(x.val);\n\t\t}\n\t}\n}\n"}, "102030");
    }

    public void test015() {
        this.runNegativeTest(new String[]{"X.java", "public enum X { \n\t\n\tBLEU(10),\n\tBLANC(),\n\tROUGE(30);\n\n\tint val;\n\tX(int val) {\n\t\tthis.val = val;\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tfor(X x: values()) {\n\t\t\tSystem.out.print(x.val);\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tBLANC(),\n\t^^^^^\nThe constructor X() is undefined\n----------\n");
    }

    public void test016() {
        this.runConformTest(new String[]{"X.java", "public enum X {\n\t\n\tBLEU(10) {\n\t\tString foo() { // inner\n\t\t\treturn super.foo() + this.val;\n\t\t}\n\t},\n\tBLANC(20),\n\tROUGE(30);\n\n\tint val;\n\tX(int val) {\n\t\tthis.val = val;\n\t}\n\tString foo() {  // outer\n\t\treturn this.name();\n\t}\n\tpublic static void main(String[] args) {\n\t\tfor(X x: values()) {\n\t\t\tSystem.out.print(x.foo());\n\t\t}\n\t}\n}\n"}, "BLEU10BLANCROUGE");
    }

    public void test017() {
        this.runConformTest(new String[]{"X.java", "public enum X {\n\t\n\tBLEU()\n}\n"}, "");
    }

    public void test018() {
        this.runNegativeTest(new String[]{"X.java", "public enum X {\n\tBLEU()\n}\n\nclass XX extends X implements X {\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tclass XX extends X implements X {\n\t                 ^\nThe type X cannot be the superclass of XX; a superclass must be a class\n----------\n2. ERROR in X.java (at line 5)\n\tclass XX extends X implements X {\n\t                              ^\nThe type X cannot be a superinterface of XX; a superinterface must be an interface\n----------\n");
    }

    public void test019() {
        this.runConformTest(new String[]{"MonthEnum.java", "public enum MonthEnum {\n    JANUARY   (30),\n    FEBRUARY  (28),\n    MARCH     (31),\n    APRIL     (30),\n    MAY       (31),\n    JUNE      (30),\n    JULY      (31),\n    AUGUST    (31),\n    SEPTEMBER (31),\n    OCTOBER   (31),\n    NOVEMBER  (30),\n    DECEMBER  (31);\n    \n    private final int days;\n    \n    MonthEnum(int days) {\n        this.days = days;\n    }\n    \n    public int getDays() {\n    \tboolean leapYear = true;\n    \tswitch(this) {\n    \t\tcase FEBRUARY: if(leapYear) return days+1;\n    \t}\n    \treturn days;\n    }\n    \n    public static void main(String[] args) {\n    \tSystem.out.println(JANUARY.getDays());\n    }\n    \n}\n"}, "30");
    }

    public void test020() {
        this.runConformTest(new String[]{"Foo.java", "public class Foo{\n    public enum Rank {FIRST,SECOND,THIRD}\n    public void setRank(Rank rank){}\n}\n"}, "");
    }

    public void test021() {
        this.runNegativeTest(new String[]{"Foo.java", "public class Foo {\n    public static enum Rank {FIRST,SECOND,THIRD;\n            void bar() { foo(); } \n    }\n    public void setRank(Rank rank){}\n    void foo() {}\n}\n"}, "----------\n1. ERROR in Foo.java (at line 3)\n\tvoid bar() { foo(); } \n\t             ^^^\nCannot make a static reference to the non-static method foo() from the type Foo\n----------\n");
    }

    public void test022() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\n\tenum MX { BLEU, BLANC, ROUGE }\n\t\n\tvoid foo(MX e) {\n\t\tswitch(e) {\n\t\t\tcase MX.BLEU : break;\n\t\t\tcase MX.BLANC : break;\n\t\t\tcase MX.ROUGE : break;\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tcase MX.BLEU : break;\n\t        ^^^^\nThe enum constant X.MX.BLEU reference cannot be qualified in a case label\n----------\n2. ERROR in X.java (at line 8)\n\tcase MX.BLANC : break;\n\t        ^^^^^\nThe enum constant X.MX.BLANC reference cannot be qualified in a case label\n----------\n3. ERROR in X.java (at line 9)\n\tcase MX.ROUGE : break;\n\t        ^^^^^\nThe enum constant X.MX.ROUGE reference cannot be qualified in a case label\n----------\n");
    }

    public void test023() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic enum RuleType{ SUCCESS, FAILURE }\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(RuleType.valueOf(RuleType.SUCCESS.name()));\n\t}\n}"}, "SUCCESS");
    }

    public void test024() {
        this.runNegativeTest(new String[]{"X.java", "public final enum X {\n\tFOO() {}\n}\n\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic final enum X {\n\t                  ^\nIllegal modifier for the enum X; only public is permitted\n----------\n");
    }

    public void test025() {
        this.runConformTest(new String[]{"X.java", "public enum X {\n\tSUC, CESS;\n\tpublic static void main(String[] args) {\n\t\tfor (X x : values()) {\n\t\t\tSystem.out.print(x.name());\n\t\t}\n\t}\n}"}, "SUCCESS");
    }

    public void test026() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tenum Couleur { BLEU, BLANC, ROUGE }\n}\n\nclass Y {\n\tvoid foo(Couleur c) {\n\t\tswitch (c) {\n\t\t\tcase BLEU :\n\t\t\t\tbreak;\n\t\t\tcase BLANC :\n\t\t\t\tbreak;\n\t\t\tcase ROUGE :\n\t\t\t\tbreak;\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tvoid foo(Couleur c) {\n\t         ^^^^^^^\nCouleur cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 8)\n\tcase BLEU :\n\t     ^^^^\nBLEU cannot be resolved\n----------\n3. ERROR in X.java (at line 10)\n\tcase BLANC :\n\t     ^^^^^\nBLANC cannot be resolved\n----------\n4. ERROR in X.java (at line 12)\n\tcase ROUGE :\n\t     ^^^^^\nROUGE cannot be resolved\n----------\n");
    }

    public void test027() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tenum Couleur { BLEU, BLANC, ROUGE }\n\tclass Y {\n\t\tvoid foo(Couleur c) {\n\t\t\tswitch (c) {\n\t\t\t\tcase BLEU :\n\t\t\t\t\tbreak;\n\t\t\t\tcase BLANC :\n\t\t\t\t\tbreak;\n\t\t\t\tcase ROUGE :\n\t\t\t\t\tbreak;\n\t\t\t}\n\t\t}\t\n\t}\n}\n"}, "");
    }

    public void test028() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tenum Couleur { \n\t\tBLEU, BLANC, ROUGE;\n\t\tstatic int C = 0;\n\t\tstatic void FOO() {}\n\t}\n\tclass Y {\n\t\tvoid foo(Couleur c) {\n\t\t\tswitch (c) {\n\t\t\t\tcase BLEU :\n\t\t\t\t\tbreak;\n\t\t\t\tcase BLANC :\n\t\t\t\t\tbreak;\n\t\t\t\tcase ROUGE :\n\t\t\t\t\tbreak;\n\t\t\t}\n\t\t\tFOO();\n\t\t\tC++;\n\t\t}\t\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 17)\n\tFOO();\n\t^^^\nThe method FOO() is undefined for the type X.Y\n----------\n2. ERROR in X.java (at line 18)\n\tC++;\n\t^\nC cannot be resolved\n----------\n");
    }

    public void test029() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tenum Couleur { \n\t\tBLEU, BLANC, ROUGE; // take precedence over toplevel BLEU type\n\t}\n\tclass Y {\n\t\tvoid foo(Couleur c) {\n\t\t\tswitch (c) {\n\t\t\t\tcase BLEU :\n\t\t\t\t\tbreak;\n\t\t\t\tcase BLANC :\n\t\t\t\t\tbreak;\n\t\t\t\tcase ROUGE :\n\t\t\t\t\tbreak;\n\t\t\t}\n\t\t}\t\n\t}\n}\n\nclass BLEU {}\n"}, "");
    }

    public void test030() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tenum Couleur { \n\t\tBLEU, BLANC, ROUGE; // take precedence over sibling constant from Color\n\t}\n\tenum Color { \n\t\tBLEU, BLANC, ROUGE;\n\t}\n\tclass Y {\n\t\tvoid foo(Couleur c) {\n\t\t\tswitch (c) {\n\t\t\t\tcase BLEU :\n\t\t\t\t\tbreak;\n\t\t\t\tcase BLANC :\n\t\t\t\t\tbreak;\n\t\t\t\tcase ROUGE :\n\t\t\t\t\tbreak;\n\t\t\t}\n\t\t}\t\n\t}\n}\n\nclass BLEU {}\n"}, "");
    }

    public void test031() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tenum Couleur { \n\t\tBLEU, BLANC, ROUGE; // take precedence over toplevel BLEU type\n\t}\n\tclass Y implements IX, JX {\n\t\tvoid foo(Couleur c) {\n\t\t\tswitch (c) {\n\t\t\t\tcase BLEU :\n\t\t\t\t\tbreak;\n\t\t\t\tcase BLANC :\n\t\t\t\t\tbreak;\n\t\t\t\tcase ROUGE :\n\t\t\t\t\tbreak;\n\t\t\t}\n\t\t}\t\n\t}\n}\n\ninterface IX {\n\tint BLEU = 1;\n}\ninterface JX {\n\tint BLEU = 2;\n}\nclass BLEU {}\n\n"}, "");
    }

    public void test032() {
        this.runNegativeTest(new String[]{"X.java", "public class X extends Enum {\n}"}, "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X extends Enum {\n\t                       ^^^^\nEnum is a raw type. References to generic type Enum<E> should be parameterized\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X extends Enum {\n\t                       ^^^^\nThe type X may not subclass Enum explicitly\n----------\n");
    }

    public void test033() {
        this.runConformTest(new String[]{"E.java", "\t/**\n\t * Valid javadoc\n\t * @author ffr\n\t */\npublic enum E {\n\t/** Valid javadoc */\n\tTEST,\n\t/** Valid javadoc */\n\tVALID;\n\t/** Valid javadoc */\n\tpublic void foo() {}\n}\n"});
    }

    public void test034() {
        this.runNegativeTest(new String[]{"E.java", "\t/**\n\t * Invalid javadoc\n\t * @exception NullPointerException Invalid tag\n\t * @throws NullPointerException Invalid tag\n\t * @return Invalid tag\n\t * @param x Invalid tag\n\t */\npublic enum E { TEST, VALID }\n"}, "----------\n1. ERROR in E.java (at line 3)\n\t* @exception NullPointerException Invalid tag\n\t   ^^^^^^^^^\nJavadoc: Unexpected tag\n----------\n2. ERROR in E.java (at line 4)\n\t* @throws NullPointerException Invalid tag\n\t   ^^^^^^\nJavadoc: Unexpected tag\n----------\n3. ERROR in E.java (at line 5)\n\t* @return Invalid tag\n\t   ^^^^^^\nJavadoc: Unexpected tag\n----------\n4. ERROR in E.java (at line 6)\n\t* @param x Invalid tag\n\t   ^^^^^\nJavadoc: Unexpected tag\n----------\n");
    }

    public void test035() {
        this.runConformTest(new String[]{"E.java", "\t/**\n\t * @see \"Valid normal string\"\n\t * @see <a href=\"http://java.sun.com/j2se/1.4.2/docs/tooldocs/windows/javadoc.html\">Valid URL link reference</a>\n\t * @see Object\n\t * @see #TEST\n\t * @see E\n\t * @see E#TEST\n\t */\npublic enum E { TEST, VALID }\n"});
    }

    public void test036() {
        this.runNegativeTest(new String[]{"E.java", "\t/**\n\t * @see \"invalid\" no text allowed after the string\n\t * @see <a href=\"invalid\">invalid</a> no text allowed after the href\n\t * @see\n\t * @see #VALIDE\n\t */\npublic enum E { TEST, VALID }\n"}, "----------\n1. ERROR in E.java (at line 2)\n\t* @see \"invalid\" no text allowed after the string\n\t                ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Unexpected text\n----------\n2. ERROR in E.java (at line 3)\n\t* @see <a href=\"invalid\">invalid</a> no text allowed after the href\n\t                                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Unexpected text\n----------\n3. ERROR in E.java (at line 4)\n\t* @see\n\t   ^^^\nJavadoc: Missing reference\n----------\n4. ERROR in E.java (at line 5)\n\t* @see #VALIDE\n\t        ^^^^^^\nJavadoc: VALIDE cannot be resolved or is not a field\n----------\n");
    }

    public void test037() {
        this.runConformTest(new String[]{"E.java", "\t/**\n\t * Value test: {@value #TEST}\n\t * or: {@value E#TEST}\n\t */\npublic enum E { TEST, VALID }\n"});
    }

    public void test038() {
        this.reportMissingJavadocComments = "error";
        this.runNegativeTest(new String[]{"E.java", "public enum E { TEST, VALID;\n\tpublic void foo() {}\n}"}, "----------\n1. ERROR in E.java (at line 1)\n\tpublic enum E { TEST, VALID;\n\t            ^\nJavadoc: Missing comment for public declaration\n----------\n2. ERROR in E.java (at line 1)\n\tpublic enum E { TEST, VALID;\n\t                ^^^^\nJavadoc: Missing comment for public declaration\n----------\n3. ERROR in E.java (at line 1)\n\tpublic enum E { TEST, VALID;\n\t                      ^^^^^\nJavadoc: Missing comment for public declaration\n----------\n4. ERROR in E.java (at line 2)\n\tpublic void foo() {}\n\t            ^^^^^\nJavadoc: Missing comment for public declaration\n----------\n");
    }

    public void test039() {
        this.runNegativeTest(new String[]{"E.java", "public enum E {\n\t/**\n\t * @exception NullPointerException Invalid tag\n\t * @throws NullPointerException Invalid tag\n\t * @return Invalid tag\n\t * @param x Invalid tag\n\t */\n\tTEST,\n\tVALID;\n}\n"}, "----------\n1. ERROR in E.java (at line 3)\n\t* @exception NullPointerException Invalid tag\n\t   ^^^^^^^^^\nJavadoc: Unexpected tag\n----------\n2. ERROR in E.java (at line 4)\n\t* @throws NullPointerException Invalid tag\n\t   ^^^^^^\nJavadoc: Unexpected tag\n----------\n3. ERROR in E.java (at line 5)\n\t* @return Invalid tag\n\t   ^^^^^^\nJavadoc: Unexpected tag\n----------\n4. ERROR in E.java (at line 6)\n\t* @param x Invalid tag\n\t   ^^^^^\nJavadoc: Unexpected tag\n----------\n");
    }

    public void test040() {
        this.runConformTest(new String[]{"E.java", "public enum E {\n\t/**\n\t * @see E\n\t * @see #VALID\n\t */\n\tTEST,\n\t/**\n\t * @see E#TEST\n\t * @see E\n\t */\n\tVALID;\n\t/**\n\t * @param x the object\n\t * @return String\n\t * @see Object\n\t */\n\tpublic String val(Object x) { return x.toString(); }\n}\n"});
    }

    public void test041() {
        this.runNegativeTest(new String[]{"E.java", "public enum E {\n\t/**\n\t * @see e\n\t * @see #VALIDE\n\t */\n\tTEST,\n\t/**\n\t * @see E#test\n\t * @see EUX\n\t */\n\tVALID;\n\t/**\n\t * @param obj the object\n\t * @return\n\t * @see Objet\n\t */\n\tpublic String val(Object x) { return x.toString(); }\n}\n"}, "----------\n1. ERROR in E.java (at line 3)\n\t* @see e\n\t       ^\nJavadoc: e cannot be resolved to a type\n----------\n2. ERROR in E.java (at line 4)\n\t* @see #VALIDE\n\t        ^^^^^^\nJavadoc: VALIDE cannot be resolved or is not a field\n----------\n3. ERROR in E.java (at line 8)\n\t* @see E#test\n\t         ^^^^\nJavadoc: test cannot be resolved or is not a field\n----------\n4. ERROR in E.java (at line 9)\n\t* @see EUX\n\t       ^^^\nJavadoc: EUX cannot be resolved to a type\n----------\n5. ERROR in E.java (at line 13)\n\t* @param obj the object\n\t         ^^^\nJavadoc: Parameter obj is not declared\n----------\n6. ERROR in E.java (at line 14)\n\t* @return\n\t   ^^^^^^\nJavadoc: Missing return type description\n----------\n7. ERROR in E.java (at line 15)\n\t* @see Objet\n\t       ^^^^^\nJavadoc: Objet cannot be resolved to a type\n----------\n8. ERROR in E.java (at line 17)\n\tpublic String val(Object x) { return x.toString(); }\n\t                         ^\nJavadoc: Missing tag for parameter x\n----------\n");
    }

    public void test042() {
        this.runConformTest(new String[]{"E.java", "public enum E {\n\t/**\n\t * Test value: {@value #TEST}\n\t */\n\tTEST,\n\t/**\n\t * Valid value: {@value E#VALID}\n\t */\n\tVALID;\n\t/**\n\t * Test value: {@value #TEST}\n\t * Valid value: {@value E#VALID}\n\t * @param x the object\n\t * @return String\n\t */\n\tpublic String val(Object x) { return x.toString(); }\n}\n"});
    }

    public void test043() {
        this.runConformTest(new String[]{"test/E.java", "package test;\npublic enum E { TEST, VALID }\n", "test/X.java", "import static test.E.TEST;\n\t/**\n\t * @see test.E\n\t * @see test.E#VALID\n\t * @see #TEST\n\t */\npublic class X {}\n"});
    }

    public void test044() {
        this.runConformTest(new String[]{"test/E.java", "package test;\npublic enum E { TEST, VALID }\n", "test/X.java", "import static test.E.TEST;\n\t/**\n\t * Valid value = {@value test.E#VALID}\n\t * Test value = {@value #TEST}\n\t */\npublic class X {}\n"});
    }

    public void test045() {
        this.runConformTest(new String[]{"X.java", "public enum X\n{\n  FIRST,\n  SECOND,\n  THIRD;\n\n  static {\n    for (X t : values()) {\n      System.out.print(t.name());\n    }\n  }\n\n  X() {\n  }\n\n  public static void main(String[] args) {\n  }\n}"}, "FIRSTSECONDTHIRD");
    }

    public void test046() {
        this.runConformTest(new String[]{"X.java", "public enum X {\n  a(1);\n  X(int i) {\n  }\n}"}, "");
    }

    public void test047() {
        this.runNegativeTest(new String[]{"X.java", "public enum X {\n\t;\n\tX() {\n\t\tsuper();\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tsuper();\n\t^^^^^^^^\nCannot invoke super constructor from enum constructor X()\n----------\n");
    }

    public void test048() {
        this.runConformTest(new String[]{"StopLight.java", "public enum StopLight{\n    RED{\n        public StopLight next(){ return GREEN; }\n    },\n    GREEN{\n        public StopLight next(){ return YELLOW; }\n    },\n    YELLOW{\n        public StopLight next(){ return RED; }\n    };\n\n   public abstract StopLight next();\n}"}, "");
    }

    public void test049() {
        this.runNegativeTest(new String[]{"X.java", "public abstract enum X {}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic abstract enum X {}\n\t                     ^\nIllegal modifier for the enum X; only public is permitted\n----------\n");
    }

    public void test050() {
        this.runConformTest(new String[]{"X.java", "public enum X {}"}, "");
    }

    public void test051() {
        this.runConformTest(new String[]{"X.java", "public enum X {\n\tBLEU (0) {\n\t}\n\t;\n\tX() {\n\t\tthis(0);\n\t}\n\tX(int i) {\n\t}\n}\n"}, "");
    }

    public void test052() {
        this.runNegativeTest(new String[]{"X.java", "public enum X {\n\tA\n\t;\n\t\n\tpublic abstract void foo();\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tpublic abstract void foo();\n\t                     ^^^^^\nThe enum X can only define the abstract method foo() if it also defines enum constants with corresponding implementations\n----------\n");
    }

    public void test053() {
        this.runConformTest(new String[]{"X.java", "public enum X {\n\tA () { public void foo() {} }\n\t;\n\t\n\tpublic abstract void foo();\n}\n"}, "");
    }

    public void test054() {
        this.runNegativeTest(new String[]{"X.java", "public enum X {\n\tA() {}\n\t;\n\t\n\tpublic abstract void foo();\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tA() {}\n\t    ^\nThe type new X(){} must implement the inherited abstract method X.foo()\n----------\n");
    }

    public void test055() {
        this.runNegativeTest(new String[]{"X.java", "public enum X {\n\t;\n\t\n\tpublic abstract void foo();\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tpublic abstract void foo();\n\t                     ^^^^^\nThe enum X can only define the abstract method foo() if it also defines enum constants with corresponding implementations\n----------\n");
    }

    public void test056() {
        this.runConformTest(new String[]{"X.java", "public enum X {\n    PLUS {\n        double eval(double x, double y) { return x + y; }\n    };\n\n    // Perform the arithmetic X represented by this constant\n    abstract double eval(double x, double y);\n}"}, "");
    }

    public void test057() {
        this.runConformTest(new String[]{"Enum2.java", "public class Enum2 {\n    enum Color { RED, GREEN };\n    public static void main(String[] args) {\n        Color c= Color.GREEN;\n        switch (c) {\n        case RED:\n            System.out.println(Color.RED);\n            break;\n        case GREEN:\n            System.out.println(c);\n            break;\n        }\n    }\n}\n"}, "GREEN");
    }

    public void test058() {
        this.runNegativeTest(new String[]{"X.java", "enum X { a }\nclass A {\n\tpublic static void main(String[] args) {\n\t\ttest(X.a, 9);\n\t\ttest2(X.a, 3);\n\t}\n\tstatic void test(X x, int a) {\n\t\tif (x == a) a++; // incomparable types: X and int\n\t\tswitch(x) {\n\t\t\tcase a : System.out.println(a); // prints '9'\n\t\t}\n\t}\n\tstatic void test2(X x, final int aa) {\n\t\tswitch(x) {\n\t\t\tcase aa : // unqualified enum constant error\n\t\t\t\tSystem.out.println(a); // cannot find a\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tif (x == a) a++; // incomparable types: X and int\n\t    ^^^^^^\nIncompatible operand types X and int\n----------\n2. ERROR in X.java (at line 15)\n\tcase aa : // unqualified enum constant error\n\t     ^^\naa cannot be resolved or is not a field\n----------\n3. ERROR in X.java (at line 16)\n\tSystem.out.println(a); // cannot find a\n\t                   ^\na cannot be resolved\n----------\n");
    }

    public void test059() {
        this.runConformTest(new String[]{"X.java", "public enum X {\n\tMONDAY {\n\t\tpublic void foo() {\n\t\t}\n\t};\n\tprivate X() {\n\t}\n\tpublic static void main(String[] args) {\n\t  System.out.println(\"SUCCESS\");\n\t}\n}\n"}, "SUCCESS");
    }

    public void test060() {
        this.runNegativeTest(new String[]{"com/flarion/test/a/MyEnum.java", "package com.flarion.test.a;\npublic enum MyEnum {\n\n    First, Second;\n    \n}\n", "com/flarion/test/b/MyClass.java", "package com.flarion.test.b;\nimport com.flarion.test.a.MyEnum;\nimport static com.flarion.test.a.MyEnum.First;\nimport static com.flarion.test.a.MyEnum.Second;\npublic class MyClass {\n\n    public void myMethod() {\n        MyEnum e = MyEnum.First;\n        switch (e) {\n        case First:\n            break;\n        case Second:\n            break;\n        }\n        throw new Exception();\n    }\n}\n"}, "----------\n1. WARNING in com\\flarion\\test\\b\\MyClass.java (at line 3)\n\timport static com.flarion.test.a.MyEnum.First;\n\t              ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe import com.flarion.test.a.MyEnum.First is never used\n----------\n2. WARNING in com\\flarion\\test\\b\\MyClass.java (at line 4)\n\timport static com.flarion.test.a.MyEnum.Second;\n\t              ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe import com.flarion.test.a.MyEnum.Second is never used\n----------\n3. ERROR in com\\flarion\\test\\b\\MyClass.java (at line 15)\n\tthrow new Exception();\n\t^^^^^^^^^^^^^^^^^^^^^^\nUnhandled exception type Exception\n----------\n");
    }

    public void test061() {
        this.runNegativeTest(new String[]{"X.java", "public enum X {\n\tA, B, C;\n\tpublic static final X D = null;\n}\n\nclass A {\n\tprivate void foo(X x) {\n\t\tswitch (x) {\n\t\t\tcase D:\n\t\t}\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 8)\n\tswitch (x) {\n\t        ^\nThe enum constant X.A has no corresponding case label\n----------\n2. WARNING in X.java (at line 8)\n\tswitch (x) {\n\t        ^\nThe enum constant X.B has no corresponding case label\n----------\n3. WARNING in X.java (at line 8)\n\tswitch (x) {\n\t        ^\nThe enum constant X.C has no corresponding case label\n----------\n4. ERROR in X.java (at line 9)\n\tcase D:\n\t     ^\nThe field X.D cannot be referenced from an enum case label; only enum constants can be used in enum switch\n----------\n");
    }

    public void test062() {
        this.runNegativeTest(new String[]{"X.java", "public enum X {\n\tA, B, C;\n\tpublic static final X D = null;\n}\n\nclass A {\n\tprivate void foo(X x) {\n\t\tswitch (x) {\n\t\t\tcase X.D:\n\t\t}\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 8)\n\tswitch (x) {\n\t        ^\nThe enum constant X.A has no corresponding case label\n----------\n2. WARNING in X.java (at line 8)\n\tswitch (x) {\n\t        ^\nThe enum constant X.B has no corresponding case label\n----------\n3. WARNING in X.java (at line 8)\n\tswitch (x) {\n\t        ^\nThe enum constant X.C has no corresponding case label\n----------\n4. ERROR in X.java (at line 9)\n\tcase X.D:\n\t       ^\nThe field X.D cannot be referenced from an enum case label; only enum constants can be used in enum switch\n----------\n");
    }

    public void test063() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n  enum Option { ALPHA, BRAVO  };\n  void method1(Option item) {\n    switch (item) {\n    case ALPHA:      break;\n    case BRAVO:      break;\n    }\n  }\n}\n"}, "");
    }

    public void test064() {
        this.runConformTest(new String[]{"X.java", "public enum X implements B {\n\n\tC1 {\n\t\tpublic void test() {};\n\t},\n\tC2 {\n\t\tpublic void test() {};\n\t}\n}\n\ninterface B {\n\tpublic void test();\n\t\n}\n"}, "");
    }

    public void test065() {
        this.runNegativeTest(new String[]{"X.java", "public enum X {\n  A;\n  private void foo() {\n    X e= new X() {\n    };\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tX e= new X() {\n\t         ^\nCannot instantiate the type X\n----------\n");
    }

    public void test066() {
        this.runConformTest(new String[]{"X.java", "public enum X {\n    SUCCESS (0) {};\n    private X(int i) {}\n    public static void main(String[] args) {\n       for (X x : values()) {\n           System.out.print(x);\n       }\n    }\n}"}, "SUCCESS");
    }

    public void test067() {
        this.runNegativeTest(new String[]{"X.java", "public enum X {\n    ONE, TWO, THREE;\n    abstract int getSquare();\n    abstract int getSquare();\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tabstract int getSquare();\n\t             ^^^^^^^^^^^\nDuplicate method getSquare() in type X\n----------\n2. ERROR in X.java (at line 4)\n\tabstract int getSquare();\n\t             ^^^^^^^^^^^\nDuplicate method getSquare() in type X\n----------\n");
    }

    public void test068() {
        this.runNegativeTest(new String[]{"X.java", "public enum X {\n    A(1, 3), B(1, 3), C(1, 3) { }\n   \t;\n    public X(int i, int j) { }\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tpublic X(int i, int j) { }\n\t       ^^^^^^^^^^^^^^^\nIllegal modifier for the enum constructor; only private is permitted.\n----------\n");
    }

    public void test069() {
        this.runNegativeTest(new String[]{"X.java", "public enum X {\n    A(1, 3), B(1, 3), C(1, 3) { }\n   \t;\n    protected X(int i, int j) { }\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tprotected X(int i, int j) { }\n\t          ^^^^^^^^^^^^^^^\nIllegal modifier for the enum constructor; only private is permitted.\n----------\n");
    }

    public void test070() {
        this.runConformTest(new String[]{"X.java", "public enum X {\n    PLUS {\n        double eval(double x, double y) { return x + y; }\n    };\n\n    // Perform the arithmetic X represented by this constant\n    abstract double eval(double x, double y);\n}"}, "");
    }

    public void test071() {
        this.runConformTest(new String[]{"X1.java", "public enum X1 implements I {\n\t;\n}\ninterface I {}\n"}, "");
        this.runConformTest(new String[]{"X1a.java", "public enum X1a implements I {\n\tA;\n}\ninterface I {}\n"}, "");
        this.runConformTest(new String[]{"X1b.java", "public enum X1b implements I {\n\tA() { void random() {} };\n}\ninterface I {}\n"}, "");
    }

    public void test072() {
        this.runConformTest(new String[]{"X2.java", "public enum X2 implements I {\n\t;\n\tpublic void test() {}\n}\ninterface I { void test(); }\n"}, "");
        this.runConformTest(new String[]{"X2a.java", "public enum X2a implements I {\n\tA;\n\tpublic void test() {}\n}\ninterface I { void test(); }\n"}, "");
        this.runConformTest(new String[]{"X2b.java", "public enum X2b implements I {\n\tA() { public void test() {} };\n\tpublic void test() {}\n}\ninterface I { void test(); }\n"}, "");
        this.runConformTest(new String[]{"X2c.java", "public enum X2c implements I {\n\tA() { void random() {} };\n\tpublic void test() {}\n}\ninterface I { void test(); }\n"}, "");
    }

    public void test073() {
        this.runNegativeTest(new String[]{"X3.java", "public enum X3 implements I {\n\t;\n\tpublic abstract void test();\n}\ninterface I { void test(); }\n"}, "----------\n1. ERROR in X3.java (at line 3)\n\tpublic abstract void test();\n\t                     ^^^^^^\nThe enum X3 can only define the abstract method test() if it also defines enum constants with corresponding implementations\n----------\n");
        this.runNegativeTest(new String[]{"X3a.java", "public enum X3a implements I {\n\tA;\n\tpublic abstract void test();\n}\ninterface I { void test(); }\n"}, "----------\n1. ERROR in X3a.java (at line 3)\n\tpublic abstract void test();\n\t                     ^^^^^^\nThe enum X3a can only define the abstract method test() if it also defines enum constants with corresponding implementations\n----------\n");
        this.runConformTest(new String[]{"X3b.java", "public enum X3b implements I {\n\tA() { public void test() {} };\n\tpublic abstract void test();\n}\ninterface I { void test(); }\n"}, "");
        this.runNegativeTest(new String[]{"X3c.java", "public enum X3c implements I {\n\tA() { void random() {} };\n\tpublic abstract void test();\n}\ninterface I { void test(); }\n"}, "----------\n1. ERROR in X3c.java (at line 2)\n\tA() { void random() {} };\n\t    ^\nThe type new X3c(){} must implement the inherited abstract method X3c.test()\n----------\n");
    }

    public void test074() {
        this.runNegativeTest(new String[]{"X4.java", "public enum X4 {\n\t;\n\tpublic abstract void test();\n}\n"}, "----------\n1. ERROR in X4.java (at line 3)\n\tpublic abstract void test();\n\t                     ^^^^^^\nThe enum X4 can only define the abstract method test() if it also defines enum constants with corresponding implementations\n----------\n");
        this.runNegativeTest(new String[]{"X4a.java", "public enum X4a {\n\tA;\n\tpublic abstract void test();\n}\n"}, "----------\n1. ERROR in X4a.java (at line 3)\n\tpublic abstract void test();\n\t                     ^^^^^^\nThe enum X4a can only define the abstract method test() if it also defines enum constants with corresponding implementations\n----------\n");
        this.runConformTest(new String[]{"X4b.java", "public enum X4b {\n\tA() { public void test() {} };\n\tpublic abstract void test();\n}\n"}, "");
        this.runNegativeTest(new String[]{"X4c.java", "public enum X4c {\n\tA() { void random() {} };\n\tpublic abstract void test();\n}\n"}, "----------\n1. ERROR in X4c.java (at line 2)\n\tA() { void random() {} };\n\t    ^\nThe type new X4c(){} must implement the inherited abstract method X4c.test()\n----------\n");
    }

    public void test075() {
        this.runNegativeTest(new String[]{"X5.java", "public enum X5 implements I {\n\t;\n}\ninterface I { void test(); }\n"}, "----------\n1. ERROR in X5.java (at line 1)\n\tpublic enum X5 implements I {\n\t            ^^\nThe type X5 must implement the inherited abstract method I.test()\n----------\n");
        this.runNegativeTest(new String[]{"X5a.java", "public enum X5a implements I {\n\tA;\n}\ninterface I { void test(); }\n"}, "----------\n1. ERROR in X5a.java (at line 1)\n\tpublic enum X5a implements I {\n\t            ^^^\nThe type X5a must implement the inherited abstract method I.test()\n----------\n");
        this.runConformTest(new String[]{"X5b.java", "public enum X5b implements I {\n\tA() { public void test() {} };\n\t;\n}\ninterface I { void test(); }\n"}, "");
        this.runNegativeTest(new String[]{"X5c.java", "public enum X5c implements I {\n\tA() { void random() {} };\n\t;\n\tprivate X5c() {}\n}\ninterface I { void test(); }\n"}, "----------\n1. ERROR in X5c.java (at line 2)\n\tA() { void random() {} };\n\t    ^\nThe type new X5c(){} must implement the inherited abstract method I.test()\n----------\n");
    }

    public void test076() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) { ((I) E.A).foo(); }\n}\ninterface I { I foo(); }\nenum E implements I {\n\tA;\n\tpublic E foo() {\n\t\tSystem.out.println(\"SUCCESS\");\n\t\treturn null;\n\t}\n}\n"}, "SUCCESS");
    }

    public void test077() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t\n\tpublic static void main(String[] args) {\n\t\tE.A.bar();\n\t}\n}\nenum E {\n\tA {\n\t\tvoid bar() {\n\t\t\tnew M();\n\t\t}\n\t};\n\tabstract void bar();\n\t\n\tclass M {\n\t\tM() {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\n\t}\n}\n"}, "SUCCESS");
    }

    public void test078() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t\n\tpublic static void main(String[] args) {\n\t\tE.A.bar();\n\t}\n}\nenum E {\n\tA {\n\t\tvoid bar() {\n\t\t\tnew X(){\n\t\t\t\tvoid baz() {\n\t\t\t\t\tnew M();\n\t\t\t\t}\n\t\t\t}.baz();\n\t\t}\n\t};\n\tabstract void bar();\n\t\n\tclass M {\n\t\tM() {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\n\t}\n}\n"}, "SUCCESS");
    }

    public void test079() {
        this.runNegativeTest(new String[]{"X.java", "public enum X {\n\tA, B;\n\tprivate strictfp X() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tprivate strictfp X() {}\n\t                 ^^^\nIllegal modifier for the method X.X()\n----------\n");
        this.runConformTest(new String[]{"X.java", "public strictfp enum X {\n\tA, B;\n\tprivate X() {}\n}\n"}, "");
    }

    public void test080() {
        this.runConformTest(new String[]{"X.java", "interface TestInterface {\n\tint test();\n}\n\npublic enum X implements TestInterface {\n\tTEST {\n\t\tpublic int test() {\n\t\t\treturn 42;\n\t\t}\n\t},\n\tENUM {\n\t\tpublic int test() {\n\t\t\treturn 37;\n\t\t}\n\t};\n} \n"}, "");
    }

    public void test081() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo() {\n\t\tenum E {}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tenum E {}\n\t     ^\nThe member enum E cannot be local\n----------\n");
    }

    public void test082() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tclass Y {\n\t\tenum E {}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tenum E {}\n\t     ^\nThe member enum E must be defined inside a static member type\n----------\n");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic class Y {\n\t\tenum E {}\n\t}\n}"}, "");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo() {\n\t\tclass Local {\n\t\t\tenum E {}\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tenum E {}\n\t     ^\nThe member enum E cannot be local\n----------\n");
    }

    public void test083() {
        this.runNegativeTest(new String[]{"X.java", "public enum X {\n\tINPUT {\n\t\t@Override\n\t\tpublic X getReverse() {\n\t\t\treturn OUTPUT;\n\t\t}\n\t},\n\tOUTPUT {\n\t\t@Override\n\t\tpublic X getReverse() {\n\t\t\treturn INPUT;\n\t\t}\n\t},\n\tINOUT {\n\t\t@Override\n\t\tpublic X getReverse() {\n\t\t\treturn INOUT;\n\t\t}\n\t};\n\tX(){}\n  Zork z;\n\tpublic abstract X getReverse();\n}\n"}, "----------\n1. ERROR in X.java (at line 21)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test084() {
        this.runConformTest(new String[]{"X.java", "public enum X {\n\tINPUT {\n\t\t@Override\n\t\tpublic X getReverse() {\n\t\t\treturn OUTPUT;\n\t\t}\n\t},\n\tOUTPUT {\n\t\t@Override\n\t\tpublic X getReverse() {\n\t\t\treturn INPUT;\n\t\t}\n\t},\n\tINOUT {\n\t\t@Override\n\t\tpublic X getReverse() {\n\t\t\treturn INOUT;\n\t\t}\n\t};\n\tX(){}\n\tpublic abstract X getReverse();\n}\n"}, "");
    }

    public void test085() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tenum Test1 {\n\t\ttest11, test12\n\t};\n\tenum Test2 {\n\t\ttest21, test22\n\t};\n\n\tvoid foo1(Test1 t1, Test2 t2) {\n\t\tboolean b = t1 == t2;\n\t}\n\tvoid foo2(Test1 t1, Object t2) {\n\t\tboolean b = t1 == t2;\n\t}\n\tvoid foo3(Test1 t1, Enum t2) {\n\t\tboolean b = t1 == t2;\n\t}\n\tpublic static void main(String[] args) {\n\t\tboolean booleanTest = (Test1.test11 == Test2.test22);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tboolean b = t1 == t2;\n\t            ^^^^^^^^\nIncompatible operand types X.Test1 and X.Test2\n----------\n2. WARNING in X.java (at line 15)\n\tvoid foo3(Test1 t1, Enum t2) {\n\t                    ^^^^\nEnum is a raw type. References to generic type Enum<E> should be parameterized\n----------\n3. ERROR in X.java (at line 19)\n\tboolean booleanTest = (Test1.test11 == Test2.test22);\n\t                      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nIncompatible operand types X.Test1 and X.Test2\n----------\n");
    }

    public void test086() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tenum Test1 {\n\t\tV;\n\t\tstatic int foo = 0;\n\t}\n}\n"}, "");
    }

    public void test087() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tenum Test1 {\n\t\tV;\n\t\tinterface Foo {}\n\t}\n}\n"}, "");
    }

    public void test088() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tenum Test1 {\n\t\tV;\n\t}\n\tObject foo() {\n\t\treturn this;\n\t}\n\n\tstatic class Sub extends X {\n\t\t@Override\n\t\tTest1 foo() {\n\t\t\treturn Test1.V;\n\t\t}\n\t}\n}\n"}, "");
    }

    public void test089() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n\tenum Test1 {\n\t\tV;\n\t\tprotected final Test1 clone() { return V; }\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tprotected final Test1 clone() { return V; }\n\t                      ^^^^^^^\nCannot override the final method from Enum<X.Test1>\n----------\n2. WARNING in X.java (at line 5)\n\tprotected final Test1 clone() { return V; }\n\t                      ^^^^^^^\nThe method clone() of type X.Test1 should be tagged with @Override since it actually overrides a superclass method\n----------\n");
    }

    public void test090() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n\tenum Test1 {\n\t\tV;\n\t\tpublic Test1 foo() { return V; }\n\t}\n\tZork z;\n}\n", "java/lang/Object.java", "package java.lang;\npublic class Object {\n\tpublic Object foo() { return this; }\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tpublic Test1 foo() { return V; }\n\t             ^^^^^\nThe method foo() of type X.Test1 should be tagged with @Override since it actually overrides a superclass method\n----------\n2. ERROR in X.java (at line 7)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test091() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tenum Test1 {\n\t\tV;\n\t\tvoid foo() {}\n\t}\n\tclass Member<E extends Test1> {\n\t\tvoid bar(E e) {\n\t\t\te.foo();\n\t\t}\n\t}\n}\n"}, "");
    }

    public void test092() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n\tenum Test1 {\n\t\tV;\n\t\tvoid foo() {}\n\t}\n\tclass Member<E extends Object & Test1> {\n\t\tvoid bar(E e) {\n\t\t\te.foo();\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tclass Member<E extends Object & Test1> {\n\t                                ^^^^^\nThe type X.Test1 is not an interface; it cannot be specified as a bounded parameter\n----------\n2. ERROR in X.java (at line 9)\n\te.foo();\n\t  ^^^\nThe method foo() is undefined for the type E\n----------\n");
    }

    public void test093() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tenum Test1 {\n\t\tV;\n\t\tvoid foo() {}\n\t}\n\tclass Member<E extends Test1> {\n\t\tE e;\n\t\tvoid bar(Member<? extends Test1> me) {\n\t\t}\n\t}\n}\n"}, "");
    }

    public void test094() {
        this.runConformTest(new String[]{"X.java", "public enum X {\n}\n"}, "");
    }

    public void test095() {
        this.runNegativeTest(new String[]{"X.java", "public enum X implements I, J { \n\tROUGE;\n}\ninterface I { void foo(); }\ninterface J { void foo(); }\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic enum X implements I, J { \n\t            ^\nThe type X must implement the inherited abstract method I.foo()\n----------\n");
        this.runNegativeTest(new String[]{"X.java", "public enum X implements I, J { \n\tROUGE;\n\tpublic void foo() {}\n}\ninterface I { void foo(int i); }\ninterface J { void foo(); }\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic enum X implements I, J { \n\t            ^\nThe type X must implement the inherited abstract method I.foo(int)\n----------\n");
    }

    public void test096() {
        this.runConformTest(new String[]{"X.java", "public enum X implements I { \n\tROUGE;\n\tpublic void foo(A a) {}\n}\ninterface I { void foo(A<String> a); }\nclass A<T> {}\n"}, "");
        this.runConformTest(new String[]{"X.java", "public enum X implements I { \n\tROUGE { public void foo(A a) {} }\n\t;\n}\ninterface I { void foo(A<String> a); }\nclass A<T> {}\n"}, "");
        this.runNegativeTest(new String[]{"X.java", "public enum X implements I { \n\tROUGE;\n\tpublic void foo(A<String> a) {}\n}\ninterface I { void foo(A a); }\nclass A<T> {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic enum X implements I { \n\t            ^\nThe type X must implement the inherited abstract method I.foo(A)\n----------\n2. ERROR in X.java (at line 3)\n\tpublic void foo(A<String> a) {}\n\t            ^^^^^^^^^^^^^^^^\nName clash: The method foo(A<String>) of type X has the same erasure as foo(A) of type I but does not override it\n----------\n3. WARNING in X.java (at line 5)\n\tinterface I { void foo(A a); }\n\t                       ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n");
    }

    public void test097() {
        this.runNegativeTest(new String[]{"E.java", "public class E {\n\tenum Numbers { ONE, TWO, THREE }\n\tstatic final String BLANK = \"    \";\n\tvoid foo(Colors color) {\n\t\tswitch (color) {\n\t\t\tcase BLUE:\n\t\t\tcase RED:\n\t\t\t\tbreak;\n\t\t} \n\t}\n}\n/**\n * Enumeration of some basic colors.\n */\nenum Colors {\n\tBLACK,\n\tWHITE,\n\tRED  \n}\n"}, "----------\n1. ERROR in E.java (at line 6)\n\tcase BLUE:\n\t     ^^^^\nBLUE cannot be resolved or is not a field\n----------\n");
    }

    public void test098() {
        this.runNegativeTest(new String[]{"E.java", "public class E {\n\tenum Numbers { ONE, TWO, THREE }\n\tstatic final String BLANK = \"    \";\n\tvoid foo(Colors color) {\n\t\tswitch (color) {\n\t\t} \n\t}\n}\n/**\n * Enumeration of some basic colors.\n */\nenum Colors {\n\tBLACK,\n\tWHITE,\n\tRED;  \n  Zork z;\n}\n"}, "----------\n1. WARNING in E.java (at line 5)\n\tswitch (color) {\n\t        ^^^^^\nThe enum constant Colors.BLACK has no corresponding case label\n----------\n2. WARNING in E.java (at line 5)\n\tswitch (color) {\n\t        ^^^^^\nThe enum constant Colors.RED has no corresponding case label\n----------\n3. WARNING in E.java (at line 5)\n\tswitch (color) {\n\t        ^^^^^\nThe enum constant Colors.WHITE has no corresponding case label\n----------\n4. ERROR in E.java (at line 16)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test099() {
        this.runNegativeTest(new String[]{"X.java", "class A<T> {\n\tenum E {\n\t\tv1, v2;\n\t}\n}\n\npublic class X extends A<Integer> {\n\tvoid a(A.E e) {\n\t\tb(e); // no unchecked warning\n\t}\n\n\tvoid b(E e) {\n\t\tA<Integer>.E e1 = e;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\tA<Integer>.E e1 = e;\n\t^^^^^^^^^^^^\nThe member type A<Integer>.E cannot be qualified with a parameterized type, since it is static. Remove arguments from qualifying type A<Integer>\n----------\n");
    }

    public void test100() {
        this.runNegativeTest(new String[]{"X.java", "public enum X {\n\n\tanEnumValue {\n\t\tprivate final X thisOne = anEnumValue;\n\n\t\t@Override String getMessage() {\n\t\t\treturn \"Here is what thisOne gets assigned: \" + thisOne;\n\t\t}\n\t};\n\n\tabstract String getMessage();\n\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(anEnumValue.getMessage());\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tprivate final X thisOne = anEnumValue;\n\t                          ^^^^^^^^^^^\nCannot refer to the static enum field X.anEnumValue within an initializer\n----------\n");
    }

    public void test101() {
        this.runNegativeTest(new String[]{"X.java", "interface Foo {\n  public boolean bar();\n}\nenum BugDemo {\n  CONSTANT(new Foo() {\n    public boolean bar() {\n      Zork z;\n      return true;\n    }\n  });\n  BugDemo(Foo foo) {\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test102() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\npublic class X <T> {\n\tenum SomeEnum {\n\t\tA, B;\n\t\tstatic SomeEnum foo() {\n\t\t\treturn null;\n\t\t}\n\t}\n\tEnum<SomeEnum> e = SomeEnum.A;\n\t\t\n\tSet<SomeEnum> set1 = EnumSet.of(SomeEnum.A);\n\tSet<SomeEnum> set2 = EnumSet.of(SomeEnum.foo());\n\t\n\tFoo<Bar> foo = null;\n}\nclass Foo <U extends Foo<U>> {\n}\nclass Bar extends Foo {\n}\n"}, "----------\n1. ERROR in X.java (at line 15)\n\tFoo<Bar> foo = null;\n\t    ^^^\nBound mismatch: The type Bar is not a valid substitute for the bounded parameter <U extends Foo<U>> of the type Foo<U>\n----------\n2. WARNING in X.java (at line 19)\n\tclass Bar extends Foo {\n\t                  ^^^\nFoo is a raw type. References to generic type Foo<U> should be parameterized\n----------\n");
    }

    public void test103() {
        this.runNegativeTest(new String[]{"BadEnum.java", "public class BadEnum {\n  public interface EnumInterface<T extends Object> {\n    public T getMethod();\n  }\n  public enum EnumClass implements EnumInterface<String> {\n    ENUM1 { public String getMethod() { return \"ENUM1\";} },\n    ENUM2 { public String getMethod() { return \"ENUM2\";} };\n  }\n}\n}\n"}, "----------\n1. ERROR in BadEnum.java (at line 10)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n");
    }

    public void test104() {
        this.runConformTest(new String[]{"p/Placeholder.java", "package p;\n\npublic class Placeholder {\n    public static void main(String... argv) {\n        ClassWithBadEnum.EnumClass constant = ClassWithBadEnum.EnumClass.ENUM1;\n        ClassWithBadEnum.main(argv);\n\t}\n}    \n\n", "p/ClassWithBadEnum.java", "package p;\n\npublic class ClassWithBadEnum {\n\tpublic interface EnumInterface<T extends Object> {\n\t    public T getMethod();\n\t}\n\n\tpublic enum EnumClass implements EnumInterface<String> {\n\t\tENUM1 { public String getMethod() { return \"ENUM1\";} },\n\t\tENUM2 { public String getMethod() { return \"ENUM2\";} };\n\t}\n\tprivate EnumClass enumVar; \n\tpublic EnumClass getEnumVar() {\n\t\treturn enumVar;\n\t}\n\tpublic void setEnumVar(EnumClass enumVar) {\n\t\tthis.enumVar = enumVar;\n\t}\n\n\tpublic static void main(String... argv) {\n\t\tint a = 1;\n\t\tClassWithBadEnum badEnum = new ClassWithBadEnum();\n\t\tbadEnum.setEnumVar(ClassWithBadEnum.EnumClass.ENUM1);\n\t\t// Should fail if bug manifests itself because there will be two getInternalValue() methods\n\t\t// one returning an Object instead of a String\n\t\tString s3 = badEnum.getEnumVar().getMethod();\n\t\tSystem.out.println(s3);\n\t}\n}  \n"}, "ENUM1");
    }

    public void test105() {
        this.runConformTest(new String[]{"pack/X.java", "package pack;\nimport static pack.Color.*;\npublic class X {\n    public static void main(String[] args) {\n        Color c = BLACK;\n        switch(c) {\n        case BLACK:\n            System.out.print(\"Black\");\n            break;\n        case WHITE:\n            System.out.print(\"White\");\n            break;\n        }\n    }\n}", "pack/Color.java", "package pack;\nenum Color {WHITE, BLACK}"}, "Black");
        this.runConformTest(new String[]{"pack/Color.java", "package pack;\nenum Color {BLACK, WHITE}"}, "", null, false, null);
        this.executeClass("pack/X.java", "Black", null, false, null, null, null);
    }

    public void test106() {
        this.runConformTest(new String[]{"pack/X.java", "package pack;\nimport static pack.Color.*;\npublic class X {\n    public static void main(String[] args) {\n        Color c = BLACK;\n        switch(c) {\n        }\n\t\t System.out.print(\"SUCCESS\");\n    }\n}", "pack/Color.java", "package pack;\nenum Color {WHITE, BLACK}"}, "SUCCESS");
        this.runConformTest(new String[]{"pack/Color.java", "package pack;\nenum Color {BLACK, WHITE}"}, "", null, false, null);
        this.executeClass("pack/X.java", "SUCCESS", null, false, null, null, null);
    }

    public void test107() {
        this.runConformTest(new String[]{"pack/X.java", "package pack;\nimport static pack.Color.*;\npublic class X {\n    public static void main(String[] args) {\n        Color c = BLACK;\n        switch(c) {\n        case BLACK:\n            System.out.print(\"Black\");\n            break;\n        case WHITE:\n            System.out.print(\"White\");\n            break;\n        }\n        switch(c) {\n        case BLACK:\n            System.out.print(\"Black\");\n            break;\n        case WHITE:\n            System.out.print(\"White\");\n            break;\n        }\n    }\n}", "pack/Color.java", "package pack;\nenum Color {WHITE, BLACK}"}, "BlackBlack");
        this.runConformTest(new String[]{"pack/Color.java", "package pack;\nenum Color { BLACK }"}, "", null, false, null);
        this.executeClass("pack/X.java", "BlackBlack", null, false, null, null, null);
    }

    public void test108() {
        this.runConformTest(new String[]{"pack/X.java", "package pack;\nimport static pack.Color.*;\npublic class X {\n    public static void main(String[] args) {\n        Color c = BLACK;\n        switch(c) {\n        case BLACK:\n            System.out.print(\"Black\");\n            break;\n        case WHITE:\n            System.out.print(\"White\");\n            break;\n        default:\n            System.out.print(\"Error\");\n            break;\n        }\n    }\n}", "pack/Color.java", "package pack;\nenum Color {WHITE, BLACK}"}, "Black");
        this.runConformTest(new String[]{"pack/Color.java", "package pack;\nenum Color {RED, GREEN, YELLOW, BLACK, WHITE}"}, "", null, false, null);
        this.executeClass("pack/X.java", "Black", null, false, null, null, null);
    }

    public void test109() {
        this.runConformTest(new String[]{"pack/X.java", "package pack;\nimport static pack.Color.*;\npublic class X {\n    public static void main(String[] args) {\n\t\tColor c = null;\n\t\t try {\n        \tc = BLACK;\n\t\t} catch(NoSuchFieldError e) {\n\t\t\tSystem.out.print(\"SUCCESS\");\n\t\t\treturn;\n\t\t}\n      \tswitch(c) {\n       \tcase BLACK:\n          \tSystem.out.print(\"Black\");\n          \tbreak;\n       \tcase WHITE:\n          \tSystem.out.print(\"White\");\n          \tbreak;\n      \t}\n    }\n}", "pack/Color.java", "package pack;\nenum Color {WHITE, BLACK}"}, "Black");
        this.runConformTest(new String[]{"pack/Color.java", "package pack;\nenum Color {RED, GREEN, YELLOW, WHITE}"}, "", null, false, null);
        this.executeClass("pack/X.java", "SUCCESS", null, false, null, null, null);
    }

    public void test110() {
        this.runConformTest(new String[]{"pack/X.java", "package pack;\nimport static pack.Color.*;\npublic class X {\n\tpublic int[] $SWITCH_TABLE$pack$Color;\n\tpublic int[] $SWITCH_TABLE$pack$Color() { return null; }\n   public static void main(String[] args) {\n        Color c = BLACK;\n        switch(c) {\n        case BLACK:\n            System.out.print(\"Black\");\n            break;\n        case WHITE:\n            System.out.print(\"White\");\n            break;\n        }\n    }\n}", "pack/Color.java", "package pack;\nenum Color {WHITE, BLACK}"}, "Black");
        this.runConformTest(new String[]{"pack/Color.java", "package pack;\nenum Color {BLACK, WHITE}"}, "", null, false, null);
        this.executeClass("pack/X.java", "Black", null, false, null, null, null);
    }

    public void test111() {
        this.runConformTest(new String[]{"pack/X.java", "package pack;\nimport static pack.Color.*;\npublic class X {\n\tpublic int[] $SWITCH_TABLE$pack$Color;\n\tpublic int[] $SWITCH_TABLE$pack$Color() { return null; }\n   public static void main(String[] args) {\n        Color c = BLACK;\n        switch(c) {\n        case BLACK:\n            System.out.print(\"Black\");\n            break;\n        case WHITE:\n            System.out.print(\"White\");\n            break;\n        }\n\t\t foo();\n    }\n   public static void foo() {\n        Color c = BLACK;\n        switch(c) {\n        case BLACK:\n            System.out.print(\"Black\");\n            break;\n        case WHITE:\n            System.out.print(\"White\");\n            break;\n        }\n    }\n}", "pack/Color.java", "package pack;\nenum Color {WHITE, BLACK}"}, "BlackBlack");
        this.runConformTest(new String[]{"pack/Color.java", "package pack;\nenum Color {BLACK, WHITE}"}, "", null, false, null);
        this.executeClass("pack/X.java", "BlackBlack", null, false, null, null, null);
    }

    public void test112() {
        this.runConformTest(new String[]{"com/annot/Foo.java", "package com.annot;\n\nimport static com.annot.TestType.*;\n\npublic class Foo {\n\t@Test(type=PERFORMANCE)\n\tpublic void testBar() throws Exception {\n\t\tTest annotation = this.getClass().getMethod(\"testBar\").getAnnotation(Test.class);\n\t\tswitch (annotation.type()) {\n\t\t\tcase PERFORMANCE:\n\t\t\t\tSystem.out.println(PERFORMANCE);\n\t\t\t\tbreak;\n\t\t\tcase CORRECTNESS:\n\t\t\t\tSystem.out.println(CORRECTNESS);\n\t\t\t\tbreak;\n\t\t}\t\t\n\t}\n}", "com/annot/Test.java", "package com.annot;\n\nimport static com.annot.TestType.CORRECTNESS;\nimport static java.lang.annotation.ElementType.METHOD;\n\nimport java.lang.annotation.Target;\n\n@Target(METHOD)\npublic @interface Test {\n\tTestType type() default CORRECTNESS;\n}", "com/annot/TestType.java", "package com.annot;\n\npublic enum TestType {\n\tCORRECTNESS,\n\tPERFORMANCE\n}"}, "");
    }

    public void test113() {
        this.runNegativeTest(new String[]{"X.java", "enum BugDemo {\n\tFOO() {\n\t\tstatic int bar;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tstatic int bar;\n\t           ^^^\nThe field new BugDemo(){}.bar is never read locally\n----------\n2. ERROR in X.java (at line 3)\n\tstatic int bar;\n\t           ^^^\nThe field bar cannot be declared static; static fields can only be declared in static or top level types\n----------\n");
    }

    public void test114() {
        this.runConformTest(new String[]{"EnumTest.java", "import java.lang.reflect.*;\nimport java.lang.annotation.*;\n@ExpectedModifiers(Modifier.FINAL)\npublic enum EnumTest {\n\tX(255);\n\tEnumTest(int r) {}\n\tpublic static void main(String argv[]) throws Exception {\n\t\ttest(\"EnumTest\");\n\t\ttest(\"EnumTest$EnumA\");\n\t\ttest(\"EnumTest$EnumB\");\n\t\ttest(\"EnumTest$EnumB2\");\n\t\ttest(\"EnumTest$EnumB3\");\n\t\ttest(\"EnumTest$EnumC3\");\n\t\ttest(\"EnumTest$EnumD\");\n\t}\n\tstatic void test(String className) throws Exception {\n\t\tClass c = Class.forName(className);\n\t\tExpectedModifiers em = (ExpectedModifiers) c.getAnnotation(ExpectedModifiers.class);\n\t\tif (em != null) {\n\t\t\tint classModifiers = c.getModifiers();\n\t\t\tint expected = em.value();\n\t\t\tif (expected != (classModifiers & (Modifier.ABSTRACT|Modifier.FINAL|Modifier.STATIC))) {\n\t\t\t\tif ((expected & Modifier.ABSTRACT) != (classModifiers & Modifier.ABSTRACT))\n\t\t\t\t\tSystem.out.println(\"FAILED ABSTRACT: \" + className);\n\t\t\t\tif ((expected & Modifier.FINAL) != (classModifiers & Modifier.FINAL))\n\t\t\t\t\tSystem.out.println(\"FAILED FINAL: \" + className);\n\t\t\t\tif ((expected & Modifier.STATIC) != (classModifiers & Modifier.STATIC))\n\t\t\t\t\tSystem.out.println(\"FAILED STATIC: \" + className);\n\t\t\t}\n\t\t}\n\t}\n\t@ExpectedModifiers(Modifier.FINAL|Modifier.STATIC)\n\tenum EnumA {\n\t\tA;\n\t}\n\t@ExpectedModifiers(Modifier.STATIC)\n\tenum EnumB {\n\t\tB {\n\t\t\tint value() { return 1; }\n\t\t};\n\t\tint value(){ return 0; }\n\t}\n\t@ExpectedModifiers(Modifier.STATIC)\n\tenum EnumB2 {\n\t\tB2 {};\n\t\tint value(){ return 0; }\n\t}\n\t@ExpectedModifiers(Modifier.FINAL|Modifier.STATIC)\n\tenum EnumB3 {\n\t\tB3;\n\t\tint value(){ return 0; }\n\t}\n\t@ExpectedModifiers(Modifier.STATIC)\n\tenum EnumC implements I {\n\t\tC {\n\t\t\tint value() { return 1; }\n\t\t};\n\t\tint value(){ return 0; }\n\t\tpublic void foo(){}\n\t}\n\t@ExpectedModifiers(Modifier.STATIC)\n\tenum EnumC2 implements I {\n\t\tC2 {};\n\t\tint value(){ return 0; }\n\t\tpublic void foo(){}\n\t}\n\t@ExpectedModifiers(Modifier.FINAL|Modifier.STATIC)\n\tenum EnumC3 implements I {\n\t\tC3;\n\t\tint value(){ return 0; }\n\t\tpublic void foo(){}\n\t}\n\t@ExpectedModifiers(Modifier.ABSTRACT|Modifier.STATIC)\n\tenum EnumD {\n\t\tD {\n\t\t\tint value() { return 1; }\n\t\t};\n\t\tabstract int value();\n\t}\n}\ninterface I {\n\tvoid foo();\n}\n@Retention(RetentionPolicy.RUNTIME)\n@interface ExpectedModifiers {\n\tint value();\n}"}, "");
    }

    public void test115() {
        this.runNegativeTest(new String[]{"X.java", "public enum X {\n\tVALUE;\n\n\tstatic int ASD;\n\tfinal static int CST = 0;\n\t\n\tprivate X() {\n\t\tVALUE = null;\n\t\tASD = 5;\n\t\tX.VALUE = null;\n\t\tX.ASD = 5;\n\t\t\n\t\tSystem.out.println(CST);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tVALUE = null;\n\t^^^^^\nCannot refer to the static enum field X.VALUE within an initializer\n----------\n2. ERROR in X.java (at line 8)\n\tVALUE = null;\n\t^^^^^\nThe final field X.VALUE cannot be assigned\n----------\n3. ERROR in X.java (at line 9)\n\tASD = 5;\n\t^^^\nCannot refer to the static enum field X.ASD within an initializer\n----------\n4. ERROR in X.java (at line 10)\n\tX.VALUE = null;\n\t  ^^^^^\nThe final field X.VALUE cannot be assigned\n----------\n");
    }

    public void test116() {
        this.runNegativeTest(new String[]{"X.java", "public enum X { \n\tBLEU, \n\tBLANC, \n\tROUGE;\n\t{\n\t\tBLEU = null;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tBLEU = null;\n\t^^^^\nCannot refer to the static enum field X.BLEU within an initializer\n----------\n2. ERROR in X.java (at line 6)\n\tBLEU = null;\n\t^^^^\nThe final field X.BLEU cannot be assigned\n----------\n");
    }

    public void test117() {
        this.runNegativeTest(new String[]{"X.java", "public enum X { \n\tBLEU, \n\tBLANC, \n\tROUGE;\n\t{\n\t\tX x = BLEU.BLANC; // ko\n\t\tX x2 = BLEU; // ko\n\t}\n\tstatic {\n\t\tX x = BLEU.BLANC; // ok\n\t\tX x2 = BLEU; // ok\n\t}\t\n\tX dummy = BLEU; // ko\n\tstatic X DUMMY = BLANC; // ok\n\tX() {\n\t\tX x = BLEU.BLANC; // ko\n\t\tX x2 = BLEU; // ko\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tX x = BLEU.BLANC; // ko\n\t      ^^^^\nCannot refer to the static enum field X.BLEU within an initializer\n----------\n2. WARNING in X.java (at line 6)\n\tX x = BLEU.BLANC; // ko\n\t           ^^^^^\nThe static field X.BLANC should be accessed in a static way\n----------\n3. ERROR in X.java (at line 7)\n\tX x2 = BLEU; // ko\n\t       ^^^^\nCannot refer to the static enum field X.BLEU within an initializer\n----------\n4. WARNING in X.java (at line 10)\n\tX x = BLEU.BLANC; // ok\n\t           ^^^^^\nThe static field X.BLANC should be accessed in a static way\n----------\n5. ERROR in X.java (at line 13)\n\tX dummy = BLEU; // ko\n\t          ^^^^\nCannot refer to the static enum field X.BLEU within an initializer\n----------\n6. ERROR in X.java (at line 16)\n\tX x = BLEU.BLANC; // ko\n\t      ^^^^\nCannot refer to the static enum field X.BLEU within an initializer\n----------\n7. WARNING in X.java (at line 16)\n\tX x = BLEU.BLANC; // ko\n\t           ^^^^^\nThe static field X.BLANC should be accessed in a static way\n----------\n8. ERROR in X.java (at line 17)\n\tX x2 = BLEU; // ko\n\t       ^^^^\nCannot refer to the static enum field X.BLEU within an initializer\n----------\n");
    }

    public void test118() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\n\npublic enum X {\n\t\t one,\n\t\t two;\n\t\t \n\t\t static ArrayList someList;\n\t\t \n\t\t private X() {\n\t\t \t\t if (someList == null) {\n\t\t \t\t \t\t someList = new ArrayList();\n\t\t \t\t }\n\t\t }\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tstatic ArrayList someList;\n\t       ^^^^^^^^^\nArrayList is a raw type. References to generic type ArrayList<E> should be parameterized\n----------\n2. ERROR in X.java (at line 10)\n\tif (someList == null) {\n\t    ^^^^^^^^\nCannot refer to the static enum field X.someList within an initializer\n----------\n3. ERROR in X.java (at line 11)\n\tsomeList = new ArrayList();\n\t^^^^^^^^\nCannot refer to the static enum field X.someList within an initializer\n----------\n4. WARNING in X.java (at line 11)\n\tsomeList = new ArrayList();\n\t               ^^^^^^^^^\nArrayList is a raw type. References to generic type ArrayList<E> should be parameterized\n----------\n");
    }

    public void test119() {
        this.runConformTest(new String[]{"X.java", "public enum X {\n\tBLEU, BLANC, ROUGE;\n\tfinal static int CST = 0;\n    enum Member {\n    \t;\n        Object obj1 = CST;\n        Object obj2 = BLEU;\n    }\n}\n"}, "");
    }

    public void test120() {
        this.runNegativeTest(new String[]{"X.java", "public enum X {\n\n\tA() {\n\t\tfinal X a = A;\n\t\tfinal X a2 = B.A;\n\t\t@Override void foo() {\n\t\t\tSystem.out.println(String.valueOf(a));\n\t\t\tSystem.out.println(String.valueOf(a2));\n\t\t}\n\t},\n\tB() {\n\t\t@Override void foo(){}\n\t};\n\tabstract void foo();\n\n\tpublic static void main(String[] args) {\n\t\tA.foo();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tfinal X a = A;\n\t            ^\nCannot refer to the static enum field X.A within an initializer\n----------\n2. ERROR in X.java (at line 5)\n\tfinal X a2 = B.A;\n\t             ^\nCannot refer to the static enum field X.B within an initializer\n----------\n3. WARNING in X.java (at line 5)\n\tfinal X a2 = B.A;\n\t               ^\nThe static field X.A should be accessed in a static way\n----------\n");
    }

    public void test121() {
        this.runNegativeTest(new String[]{"X.java", "public enum X {\n\n\tUNKNOWN();\n\n\tprivate static String error;\n\n\t{\n\t\terror = \"error\";\n\t}\n\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tprivate static String error;\n\t                      ^^^^^\nThe field X.error is never read locally\n----------\n2. ERROR in X.java (at line 8)\n\terror = \"error\";\n\t^^^^^\nCannot refer to the static enum field X.error within an initializer\n----------\n");
    }

    public void test122() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic enum State {\n\t\tNORMAL\n\t}\n\tpublic void foo() {\n\t\tState state = State.NORMAL;\n\t\tswitch (state) {\n\t\tcase (NORMAL) :\n\t\t\tSystem.out.println(State.NORMAL);\n\t\t\tbreak;\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tcase (NORMAL) :\n\t     ^^^^^^^^\nEnum constants cannot be surrounded by parenthesis\n----------\n");
    }

    public void test123() {
        this.runNegativeTest(new String[]{"Foo.java", "enum Foo {\n A(0);\n Foo(int x) {\n    t[0]=x;\n }\n private static final int[] t = new int[12];\n}"}, "----------\n1. ERROR in Foo.java (at line 4)\n\tt[0]=x;\n\t^\nCannot refer to the static enum field Foo.t within an initializer\n----------\n");
    }

    public void test124() {
        this.runNegativeTest(new String[]{"X.java", " public enum X {\n  max {\n   { \n     val=3;  \n   }         \n   @Override public String toString() {\n     return Integer.toString(val);\n   }\n  }; \n  {\n    val=2;\n  }\n  private int val; \n  public static void main(String[] args) {\n    System.out.println(max); // 3\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tval=3;  \n\t^^^\nCannot make a static reference to the non-static field val\n----------\n2. ERROR in X.java (at line 7)\n\treturn Integer.toString(val);\n\t                        ^^^\nCannot make a static reference to the non-static field val\n----------\n");
    }

    public void test125() {
        this.runNegativeTest(new String[]{"X.java", "\npublic class X {\n\tinterface I {\n\t\tint values();\n\t\tenum E implements I {\n\t\t\tA, B, C;\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tenum E implements I {\n\t     ^\nThis static method cannot hide the instance method from X.I\n----------\n");
    }

    public void test126() {
        this.runConformTest(new String[]{"X.java", "  public class X {\n    enum NoValues {}\n    public static void main(String[] args) {\n      System.out.println(\"[\"+NoValues.values().length+\"]\");\n    }\n  }\n"}, "[0]");
    }

    public void test127() {
        this.runConformTest(new String[]{"X.java", "public enum X {\n\tVALUE {\n\t\tvoid foo() {\n\t\t};\n\t};\n\tabstract void foo();\n    public static void main(String[] args) {\n      System.out.println(\"[\"+X.values().length+\"]\");\n    }\n}"}, "[1]");
    }

    public void test129() {
        this.runConformTest(new String[]{"X.java", "public enum X {\n        A, B, C;\n}\n"}, "");
    }

    public void test130() {
        this.runConformTest(new String[]{"X.java", "public class X {\n   public static void main(String[] args) {\n      for(Action a : Action.values()) {\n         switch(a) {\n         case ONE:\n            System.out.print(\"1\");\n            break;\n         case TWO:\n            System.out.print(\"2\");\n            break;\n         default:\n            System.out.print(\"default\");\n         }\n      }\n   }\n}", "Action.java", "enum Action { ONE, TWO }"}, "12");
        this.runConformTest(new String[]{"Action.java", "enum Action {ONE, TWO, THREE}"}, "", null, false, null);
        this.executeClass("X.java", "12default", null, false, null, null, null);
    }

    public void test131() {
        this.runConformTest(new String[]{"X.java", "public enum X {\n\t//A,B\n\t;\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tSystem.out.println(X.valueOf(null));\n\t\t} catch (NullPointerException e) {\n\t\t\tSystem.out.println(\"NullPointerException\");\n\t\t} catch (IllegalArgumentException e) {\n\t\t\tSystem.out.println(\"IllegalArgumentException\");\n\t\t}\n\t}\n}\n"}, "NullPointerException");
    }

    public void test132() {
        this.runConformTest(new String[]{"X.java", "public enum X {\n\tA,B\n\t;\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tSystem.out.println(X.valueOf(null));\n\t\t} catch (NullPointerException e) {\n\t\t\tSystem.out.println(\"NullPointerException\");\n\t\t} catch (IllegalArgumentException e) {\n\t\t\tSystem.out.println(\"IllegalArgumentException\");\n\t\t}\n\t}\n}\n"}, "NullPointerException");
    }

    public void test133() {
        this.runConformTest(new String[]{"X.java", "public enum X {\n\tA, B, C;\n\tpublic static void main(String[] args) {}\n}\n"}, "");
    }

    public void test134() {
        this.runNegativeTest(new String[]{"X.java", "public enum X {\n    INITIAL ,\n    OPENED {\n        {\n            System.out.printf(\"After the %s constructor\\n\",INITIAL);\n        }\n    }\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tSystem.out.printf(\"After the %s constructor\\n\",INITIAL);\n\t                                               ^^^^^^^\nCannot refer to the static enum field X.INITIAL within an initializer\n----------\n");
    }

    public void test135() {
        this.runNegativeTest(new String[]{"E.java", "public enum E {\n    A,\n    B\n}", "X.java", "public class X {\n    boolean foo(E e) {\n        boolean b;\n        switch (e) {\n          case A:\n              b = true;\n              break;\n          case B:\n              b = false;\n              break;\n        }\n        return b;\n    }\n}"}, "----------\n1. ERROR in X.java (at line 12)\n\treturn b;\n\t       ^\nThe local variable b may not have been initialized\n----------\n");
    }

    public void test136() {
        this.runConformTest(new String[]{"X.java", "import p.BeanName;\npublic class X {\n\tObject o = BeanName.CreateStepApiOperation;\n}", "p/BeanName.java", "package p;\npublic enum BeanName {\n\n    //~ Enum constants ---------------------------------------------------------\n\n    AbortAllJobsOperation,\n    AbortJobApiOperation,\n    AbortStepOperation,\n    AclVoter,\n    AcquireNamedLockApiOperation,\n    AuthenticationManager,\n    BeginStepOperation,\n    CloneApiOperation,\n    CommanderDao,\n    CommanderServer,\n    ConfigureQuartzOperation,\n    CreateAclEntryApiOperation,\n    CreateActualParameterApiOperation,\n    CreateFormalParameterApiOperation,\n    CreateProcedureApiOperation,\n    CreateProjectApiOperation,\n    CreateResourceApiOperation,\n    CreateScheduleApiOperation,\n    CreateStepApiOperation,\n    DeleteAclEntryApiOperation,\n    DeleteActualParameterApiOperation,\n    DeleteFormalParameterApiOperation,\n    DeleteJobApiOperation,\n    DeleteProcedureApiOperation,\n    DeleteProjectApiOperation,\n    DeletePropertyApiOperation,\n    DeleteResourceApiOperation,\n    DeleteScheduleApiOperation,\n    DeleteStepApiOperation,\n    DispatchApiRequestOperation,\n    DumpStatisticsApiOperation,\n    ExpandJobStepAction,\n    ExportApiOperation,\n    FinishStepOperation,\n    GetAccessApiOperation,\n    GetAclEntryApiOperation,\n    GetActualParameterApiOperation,\n    GetActualParametersApiOperation,\n    GetFormalParameterApiOperation,\n    GetFormalParametersApiOperation,\n    GetJobDetailsApiOperation,\n    GetJobInfoApiOperation,\n    GetJobStatusApiOperation,\n    GetJobStepDetailsApiOperation,\n    GetJobStepStatusApiOperation,\n    GetJobsApiOperation,\n    GetProcedureApiOperation,\n    GetProceduresApiOperation,\n    GetProjectApiOperation,\n    GetProjectsApiOperation,\n    GetPropertiesApiOperation,\n    GetPropertyApiOperation,\n    GetResourceApiOperation,\n    GetResourcesApiOperation,\n    GetResourcesInPoolApiOperation,\n    GetScheduleApiOperation,\n    GetSchedulesApiOperation,\n    GetStepApiOperation,\n    GetStepsApiOperation,\n    GetVersionsApiOperation,\n    GraphWorkflowApiOperation,\n    HibernateFlushListener,\n    ImportApiOperation,\n    IncrementPropertyApiOperation,\n    InvokeCommandOperation,\n    InvokePostProcessorOperation,\n    LoginApiOperation,\n    LogManager,\n    LogMessageApiOperation,\n    ModifyAclEntryApiOperation,\n    ModifyActualParameterApiOperation,\n    ModifyFormalParameterApiOperation,\n    ModifyProcedureApiOperation,\n    ModifyProjectApiOperation,\n    ModifyPropertyApiOperation,\n    ModifyResourceApiOperation,\n    ModifyScheduleApiOperation,\n    ModifyStepApiOperation,\n    MoveStepApiOperation,\n    PauseSchedulerApiOperation,\n    QuartzQueue,\n    QuartzScheduler,\n    ReleaseNamedLockApiOperation,\n    ResourceInvoker,\n    RunProcedureApiOperation,\n    RunQueryApiOperation,\n    SaxReader,\n    ScheduleStepsOperation,\n    SessionCache,\n    SetJobNameApiOperation,\n    SetPropertyApiOperation,\n    SetStepStatusAction,\n    StartWorkflowOperation,\n    StateRefreshOperation,\n    StepCompletionPrecondition,\n    StepOutcomePrecondition,\n    StepScheduler,\n    TemplateOperation,\n    TimeoutWatchdog,\n    UpdateConfigurationOperation,\n    Workspace,\n    XmlRequestHandler;\n\n    //~ Static fields/initializers ---------------------------------------------\n\n    public static final int MAX_BEAN_NAME_LENGTH = 33;\n\n    //~ Methods ----------------------------------------------------------------\n\n    /**\n     * Get this bean name as a property name, i.e. uncapitalized.\n     *\n     * @return String\n     */\n    public String getPropertyName()\n    {\n        return null;\n    }\n}\n"}, "");
    }

    public void test137() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n    interface Interface {\n        public int value();\n    }\n\n    public enum MyEnum implements Interface {\n        ;\n\n        MyEnum(int value) { this.value = value; }        \n        public int value() { return this.value; }\n\n        private int value;\n    }\n\n    public static void main(String[] args) {\n        System.out.println(MyEnum.values().length);\n    }\n}"}, "0");
    }

    public void test138() {
        this.runNegativeTest(new String[]{"X.java", "public enum X {\n\tPLUS {\n\t\tdouble eval(double x, double y) {\n\t\t\treturn x + y;\n\t\t}\n\t},\n\tMINUS {\n\t\t@Override\n\t\tabstract double eval(double x, double y);\n\t};\n\n\tabstract double eval(double x, double y);\n}\n\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tdouble eval(double x, double y) {\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^\nThe method eval(double, double) of type new X(){} should be tagged with @Override since it actually overrides a superclass method\n----------\n2. ERROR in X.java (at line 9)\n\tabstract double eval(double x, double y);\n\t                ^^^^^^^^^^^^^^^^^^^^^^^^\nThe abstract method eval in type new X(){} can only be defined by an abstract class\n----------\n");
    }

    public void test139() {
        this.runNegativeTest(new String[]{"X.java", "public enum X {\n\tPLUS {\n\t\tdouble eval(double x, double y) {\n\t\t\treturn x + y;\n\t\t}\n\t},\n\tMINUS {\n\t\tabstract double eval2(double x, double y);\n\t};\n\n\tabstract double eval(double x, double y);\n}\n\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tdouble eval(double x, double y) {\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^\nThe method eval(double, double) of type new X(){} should be tagged with @Override since it actually overrides a superclass method\n----------\n2. ERROR in X.java (at line 7)\n\tMINUS {\n\t      ^\nThe type new X(){} must implement the inherited abstract method X.eval(double, double)\n----------\n3. ERROR in X.java (at line 8)\n\tabstract double eval2(double x, double y);\n\t                ^^^^^^^^^^^^^^^^^^^^^^^^^\nThe abstract method eval2 in type new X(){} can only be defined by an abstract class\n----------\n");
    }

    public void test140() {
        this.runConformTest(new String[]{"X.java", "public enum X {\n\tPLUS {/*ANONYMOUS*/}, MINUS;\n\tvoid bar(X x) {\n\t\tRunnable r = (Runnable)x;\n\t}\n}"}, "");
    }

    public void test141() {
        this.runNegativeTest(new String[]{"X.java", "public enum X {\n\tPLUS, MINUS;\n\tvoid bar(X x) {\n\t\tRunnable r = (Runnable)x;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tRunnable r = (Runnable)x;\n\t             ^^^^^^^^^^^\nCannot cast from X to Runnable\n----------\n");
    }

    public void test142() {
        this.runConformTest(new String[]{"X.java", "enum Week {\n\tMonday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tnew X().foo();\n\t\tnew X().bar();\t\t\n\t}\n\tvoid foo() {\n\t\tfor (Week w : Week.values())\n\t\t\tSystem.out.print(w + \" \");\n\t}\n\tvoid bar() {\n\t\tfor (Week w : java.util.EnumSet.range(Week.Monday, Week.Friday)) {\n\t\t\tSystem.out.print(w + \" \");\n\t\t}\n\t}\n}\n"}, "Monday Tuesday Wednesday Thursday Friday Saturday Sunday Monday Tuesday Wednesday Thursday Friday");
    }

    public void test143() {
        this.runNegativeTest(new String[]{"X.java", "public enum X {\n  A {\n    @Override\n    public String toString() {\n      return a();\n    }\n    public abstract String a();\n  }\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tpublic abstract String a();\n\t                       ^^^\nThe abstract method a in type new X(){} can only be defined by an abstract class\n----------\n");
    }
}

