/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.parser;

import java.util.Locale;
import java.util.Map;
import org.eclipse.wst.jsdt.core.tests.compiler.parser.TestSourceElementRequestor;
import org.eclipse.wst.jsdt.core.tests.util.AbstractCompilerTest;
import org.eclipse.wst.jsdt.core.tests.util.Util;
import org.eclipse.wst.jsdt.internal.codeassist.complete.CompletionParser;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.wst.jsdt.internal.compiler.IProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.wst.jsdt.internal.compiler.SourceElementParser;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;

public class AnnotationDietRecoveryTest
extends AbstractCompilerTest {
    public static boolean optimizeStringLiterals = false;
    public static long sourceLevel = 0x2F0000L;

    public AnnotationDietRecoveryTest(String testName) {
        super(testName);
    }

    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
        options.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
        options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
        return options;
    }

    public void checkParse(char[] source, String expectedDietUnitToString, String expectedDietPlusBodyUnitToString, String expectedFullUnitToString, String expectedCompletionDietUnitToString, String testName) {
        CompilationResult compilationResult;
        CompilationUnit sourceUnit;
        Parser parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        CompilationUnitDeclaration computedUnit = parser.dietParse((ICompilationUnit)(sourceUnit = new CompilationUnit(source, testName, null)), compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0));
        String computedUnitToString = computedUnit.toString();
        if (!expectedDietUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        AnnotationDietRecoveryTest.assertEquals("Invalid unit diet structure" + testName, expectedDietUnitToString, computedUnitToString);
        parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.dietParse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedDietUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        AnnotationDietRecoveryTest.assertEquals("Invalid unit diet structure" + testName, expectedDietUnitToString, computedUnitToString);
        if (computedUnit.types != null) {
            int i = computedUnit.types.length;
            while (--i >= 0) {
                computedUnit.types[i].parseMethod(parser, computedUnit);
            }
        }
        if (!expectedDietPlusBodyUnitToString.equals(computedUnitToString = computedUnit.toString())) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        AnnotationDietRecoveryTest.assertEquals("Invalid unit diet+body structure" + testName, expectedDietPlusBodyUnitToString, computedUnitToString);
        parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.parse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedFullUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        AnnotationDietRecoveryTest.assertEquals("Invalid unit full structure" + testName, expectedFullUnitToString, computedUnitToString);
        parser = new SourceElementParser((ISourceElementRequestor)new TestSourceElementRequestor(), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault()), new CompilerOptions(this.getCompilerOptions()), false, true);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.dietParse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedDietUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        AnnotationDietRecoveryTest.assertEquals("Invalid source element diet structure" + testName, expectedDietUnitToString, computedUnitToString);
        parser = new SourceElementParser((ISourceElementRequestor)new TestSourceElementRequestor(), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault()), new CompilerOptions(this.getCompilerOptions()), false, true);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.parse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedFullUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        AnnotationDietRecoveryTest.assertEquals("Invalid source element full structure" + testName, expectedFullUnitToString, computedUnitToString);
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        CompletionParser parser2 = new CompletionParser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), options, (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())));
        CompilationUnit sourceUnit2 = new CompilationUnit(source, testName, null);
        CompilationResult compilationResult2 = new CompilationResult((ICompilationUnit)sourceUnit2, 0, 0, 0);
        CompilationUnitDeclaration computedUnit2 = parser2.dietParse((ICompilationUnit)sourceUnit2, compilationResult2, Integer.MAX_VALUE);
        String computedUnitToString2 = computedUnit2.toString();
        if (!expectedCompletionDietUnitToString.equals(computedUnitToString2)) {
            System.out.println(Util.displayString(computedUnitToString2));
        }
        AnnotationDietRecoveryTest.assertEquals("Invalid completion diet structure" + testName, expectedCompletionDietUnitToString, computedUnitToString2);
    }

    public void test0001() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic @interface X\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietPlusBodyUnitToString = expectedDietUnitToString = "package a;\npublic @interface X {\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0002() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic @interface X <T> {\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietPlusBodyUnitToString = expectedDietUnitToString = "package a;\npublic @interface X {\n  {\n  }\n  <clinit>() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0003() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic @interface X {\t\t\t\t\t\t\t\n  String foo()\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietPlusBodyUnitToString = expectedDietUnitToString = "package a;\npublic @interface X {\n  String foo() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0004() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic @interface X {\t\t\t\t\t\t\n  String foo() default \"blabla\"\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietPlusBodyUnitToString = expectedDietUnitToString = "package a;\npublic @interface X {\n  String foo() default \"blabla\" {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0005() {
        String s = "@Documented\t\t\t\n@Rentention(RententionPolicy.RUNTIME)\t\t\t\t\n@Target(ElementType.TYPE)\t\t\t\t\t\t\t\n@interface MyAnn { \t\t\t\t\t\t\t\t\t\n  String value() default \"Default Message\"\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\t\t\n\tpublic @MyAnn void something() { }\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "@Documented @Rentention(RententionPolicy.RUNTIME) @Target(ElementType.TYPE) @interface MyAnn {\n  String value() default \"Default Message\" {\n  }\n}\npublic class X {\n  public X() {\n  }\n  public @MyAnn void something() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "@Documented @Rentention(RententionPolicy.RUNTIME) @Target(ElementType.TYPE) @interface MyAnn {\n  String value() default \"Default Message\" {\n  }\n}\npublic class X {\n  public X() {\n    super();\n  }\n  public @MyAnn void something() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0006() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic @interface X {\t\t\t\t\t\t\n  String foo() {}\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietPlusBodyUnitToString = expectedDietUnitToString = "package a;\npublic @interface X {\n  String foo() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0007() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic @interface X {\t\t\t\t\t\t\n  String foo(\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietPlusBodyUnitToString = expectedDietUnitToString = "package a;\npublic @interface X {\n  String foo() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0008() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t        \t\t\n  void foo(int var1, @Annot(at1=zzz, at2) int var2 {\t\n  }\t\t\t\t\t\t\t        \t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo(int var1) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo(int var1) {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0009() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t        \t\t\n  @SuppressWarnings(\"unchecked\");\n  List<Test> l;\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X {\n  List<Test> l;\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  List<Test> l;\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0010() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\n  String foo() {\t\t\t\t\t\t\t\n       @interface Y {\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X {\n  @interface Y {\n  }\n  public X() {\n  }\n  String foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  @interface Y {\n  }\n  public X() {\n    super();\n  }\n  String foo() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }
}

