/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.preferences.ui;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.wst.html.ui.internal.HTMLUIMessages;
import org.eclipse.wst.html.ui.internal.HTMLUIPlugin;
import org.eclipse.wst.sse.ui.internal.preferences.ui.AbstractPreferencePage;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;

public class HTMLTypingPreferencePage
extends AbstractPreferencePage {
    private Button fCloseComment;
    private Button fCloseEndTag;
    private Button fRemoveEndTag;
    private Button fCloseElement;

    protected Control createContents(Composite parent) {
        Composite composite = super.createComposite(parent, 1);
        this.createStartTagGroup(composite);
        this.createEndTagGroup(composite);
        this.createAutoComplete(composite);
        this.createAutoRemove(composite);
        this.setSize(composite);
        this.loadPreferences();
        return composite;
    }

    private void createStartTagGroup(Composite parent) {
        Group group = this.createGroup(parent, 2);
        group.setText(XMLUIMessages.XMLTyping_Start_Tag);
        this.fCloseElement = this.createCheckBox((Composite)group, XMLUIMessages.XMLTyping_Complete_Elements);
        ((GridData)this.fCloseElement.getLayoutData()).horizontalSpan = 2;
    }

    private void createEndTagGroup(Composite parent) {
        Group group = this.createGroup(parent, 2);
        group.setText(XMLUIMessages.XMLTyping_End_Tag);
        this.fCloseEndTag = this.createCheckBox((Composite)group, XMLUIMessages.XMLTyping_Complete_End_Tags);
        ((GridData)this.fCloseEndTag.getLayoutData()).horizontalSpan = 2;
    }

    private void createAutoComplete(Composite parent) {
        Group group = this.createGroup(parent, 2);
        group.setText(HTMLUIMessages.HTMLTyping_Auto_Complete);
        this.fCloseComment = this.createCheckBox((Composite)group, HTMLUIMessages.HTMLTyping_Complete_Comments);
        ((GridData)this.fCloseComment.getLayoutData()).horizontalSpan = 2;
    }

    private void createAutoRemove(Composite parent) {
        Group group = this.createGroup(parent, 2);
        group.setText(HTMLUIMessages.HTMLTyping_Auto_Remove);
        this.fRemoveEndTag = this.createCheckBox((Composite)group, HTMLUIMessages.HTMLTyping_Remove_End_Tags);
        ((GridData)this.fRemoveEndTag.getLayoutData()).horizontalSpan = 2;
    }

    public boolean performOk() {
        boolean result = super.performOk();
        HTMLUIPlugin.getDefault().savePluginPreferences();
        return result;
    }

    protected void initializeValues() {
        this.initCheckbox(this.fCloseComment, "completeComments");
        this.initCheckbox(this.fCloseEndTag, "completeEndTags");
        this.initCheckbox(this.fCloseElement, "completeElements");
        this.initCheckbox(this.fRemoveEndTag, "removeEndTags");
    }

    protected void performDefaults() {
        this.defaultCheckbox(this.fCloseComment, "completeComments");
        this.defaultCheckbox(this.fCloseEndTag, "completeEndTags");
        this.defaultCheckbox(this.fCloseElement, "completeElements");
        this.defaultCheckbox(this.fRemoveEndTag, "removeEndTags");
    }

    private void initCheckbox(Button box, String key) {
        if (box != null && key != null) {
            box.setSelection(this.getPreferenceStore().getBoolean(key));
        }
    }

    private void defaultCheckbox(Button box, String key) {
        if (box != null && key != null) {
            box.setSelection(this.getPreferenceStore().getDefaultBoolean(key));
        }
    }

    protected void storeValues() {
        this.getPreferenceStore().setValue("completeComments", this.fCloseComment != null ? this.fCloseComment.getSelection() : false);
        this.getPreferenceStore().setValue("completeEndTags", this.fCloseEndTag != null ? this.fCloseEndTag.getSelection() : false);
        this.getPreferenceStore().setValue("completeElements", this.fCloseElement != null ? this.fCloseElement.getSelection() : false);
        this.getPreferenceStore().setValue("removeEndTags", this.fRemoveEndTag != null ? this.fRemoveEndTag.getSelection() : false);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return HTMLUIPlugin.getDefault().getPreferenceStore();
    }
}

