/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.preferences.ui;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.html.ui.internal.HTMLUIMessages;
import org.eclipse.wst.html.ui.internal.HTMLUIPlugin;
import org.eclipse.wst.html.ui.internal.preferences.HTMLUIPreferenceNames;
import org.eclipse.wst.sse.ui.internal.preferences.ui.AbstractPreferencePage;

public class HTMLSourcePreferencePage
extends AbstractPreferencePage {
    private Button fTagNameUpper = null;
    private Button fTagNameLower = null;
    private Button fAttrNameUpper = null;
    private Button fAttrNameLower = null;
    private final int MIN_INDENTATION_SIZE = 0;
    private final int MAX_INDENTATION_SIZE = 16;
    private Button fAutoPropose;
    private Label fAutoProposeLabel;
    private Text fAutoProposeText;
    private Button fClearAllBlankLines;
    private Text fLineWidthText;
    private Button fSplitMultiAttrs;
    private Button fAlignEndBracket;
    private Button fIndentUsingTabs;
    private Button fIndentUsingSpaces;
    private Spinner fIndentationSize;

    private void createContentsForContentAssistGroup(Composite parent) {
        Group contentAssistGroup = this.createGroup(parent, 2);
        contentAssistGroup.setText(HTMLUIMessages.Content_assist_UI_);
        this.fAutoPropose = this.createCheckBox((Composite)contentAssistGroup, HTMLUIMessages.Automatically_make_suggest_UI_);
        ((GridData)this.fAutoPropose.getLayoutData()).horizontalSpan = 2;
        this.fAutoPropose.addSelectionListener((SelectionListener)this);
        this.fAutoProposeLabel = this.createLabel((Composite)contentAssistGroup, HTMLUIMessages.Prompt_when_these_characte_UI_);
        this.fAutoProposeText = this.createTextField((Composite)contentAssistGroup);
        this.createContentsForPreferredCaseGroup(parent, 2);
    }

    private Composite createContentsForPreferredCaseGroup(Composite parent, int columnSpan) {
        Group caseGroup = this.createGroup(parent, columnSpan);
        caseGroup.setText(HTMLUIMessages.Preferred_markup_case_UI_);
        Group tagNameGroup = this.createGroup((Composite)caseGroup, 1);
        tagNameGroup.setText(HTMLUIMessages.Tag_names__UI_);
        this.fTagNameUpper = this.createRadioButton((Composite)tagNameGroup, HTMLUIMessages.Tag_names_Upper_case_UI_);
        this.fTagNameLower = this.createRadioButton((Composite)tagNameGroup, HTMLUIMessages.Tag_names_Lower_case_UI_);
        Group attrNameGroup = this.createGroup((Composite)caseGroup, 1);
        attrNameGroup.setText(HTMLUIMessages.Attribute_names__UI_);
        this.fAttrNameUpper = this.createRadioButton((Composite)attrNameGroup, HTMLUIMessages.Attribute_names_Upper_case_UI_);
        this.fAttrNameLower = this.createRadioButton((Composite)attrNameGroup, HTMLUIMessages.Attribute_names_Lower_case_UI_);
        return parent;
    }

    private void createContentsForFormattingGroup(Composite parent) {
        Group formattingGroup = this.createGroup(parent, 2);
        formattingGroup.setText(HTMLUIMessages.Formatting_UI_);
        this.createLabel((Composite)formattingGroup, HTMLUIMessages.Line_width__UI_);
        this.fLineWidthText = new Text((Composite)formattingGroup, 2052);
        GridData gData = new GridData(33);
        gData.widthHint = 25;
        this.fLineWidthText.setLayoutData((Object)gData);
        this.fLineWidthText.addModifyListener((ModifyListener)this);
        this.fSplitMultiAttrs = this.createCheckBox((Composite)formattingGroup, HTMLUIMessages.Split_multiple_attributes);
        ((GridData)this.fSplitMultiAttrs.getLayoutData()).horizontalSpan = 2;
        this.fAlignEndBracket = this.createCheckBox((Composite)formattingGroup, HTMLUIMessages.Align_final_bracket);
        ((GridData)this.fAlignEndBracket.getLayoutData()).horizontalSpan = 2;
        this.fClearAllBlankLines = this.createCheckBox((Composite)formattingGroup, HTMLUIMessages.Clear_all_blank_lines_UI_);
        ((GridData)this.fClearAllBlankLines.getLayoutData()).horizontalSpan = 2;
        Composite indentComposite = this.createComposite((Composite)formattingGroup, 1);
        ((GridData)indentComposite.getLayoutData()).horizontalSpan = 2;
        ((GridLayout)indentComposite.getLayout()).marginWidth = 0;
        ((GridLayout)indentComposite.getLayout()).marginHeight = 0;
        this.fIndentUsingTabs = this.createRadioButton(indentComposite, HTMLUIMessages.Indent_using_tabs);
        ((GridData)this.fIndentUsingTabs.getLayoutData()).horizontalSpan = 1;
        this.fIndentUsingSpaces = this.createRadioButton(indentComposite, HTMLUIMessages.Indent_using_spaces);
        ((GridData)this.fIndentUsingSpaces.getLayoutData()).horizontalSpan = 1;
        this.createLabel((Composite)formattingGroup, HTMLUIMessages.Indentation_size);
        this.fIndentationSize = new Spinner((Composite)formattingGroup, 2056);
        GridData gd = new GridData(32);
        this.fIndentationSize.setLayoutData((Object)gd);
        this.fIndentationSize.setToolTipText(HTMLUIMessages.Indentation_size_tip);
        this.fIndentationSize.setMinimum(0);
        this.fIndentationSize.setMaximum(16);
        this.fIndentationSize.setIncrement(1);
        this.fIndentationSize.setPageIncrement(4);
        this.fIndentationSize.addModifyListener((ModifyListener)this);
    }

    protected void performDefaults() {
        this.fTagNameUpper.setSelection(this.getModelPreferences().getDefaultInt("tagNameCase") == 2);
        this.fTagNameLower.setSelection(this.getModelPreferences().getDefaultInt("tagNameCase") == 1);
        this.fAttrNameUpper.setSelection(this.getModelPreferences().getDefaultInt("attrNameCase") == 2);
        this.fAttrNameLower.setSelection(this.getModelPreferences().getDefaultInt("attrNameCase") == 1);
        this.performDefaultsForFormattingGroup();
        this.performDefaultsForContentAssistGroup();
        this.validateValues();
        this.enableValues();
        super.performDefaults();
    }

    private void performDefaultsForContentAssistGroup() {
        this.fAutoPropose.setSelection(this.getPreferenceStore().getDefaultBoolean(HTMLUIPreferenceNames.AUTO_PROPOSE));
        this.fAutoProposeText.setText(this.getPreferenceStore().getDefaultString(HTMLUIPreferenceNames.AUTO_PROPOSE_CODE));
    }

    private void performDefaultsForFormattingGroup() {
        this.fLineWidthText.setText(this.getModelPreferences().getDefaultString("lineWidth"));
        this.fSplitMultiAttrs.setSelection(this.getModelPreferences().getDefaultBoolean("splitMultiAttrs"));
        this.fAlignEndBracket.setSelection(this.getModelPreferences().getDefaultBoolean("alignEndBracket"));
        this.fClearAllBlankLines.setSelection(this.getModelPreferences().getDefaultBoolean("clearAllBlankLines"));
        if ("tab".equals(this.getModelPreferences().getDefaultString("indentationChar"))) {
            this.fIndentUsingTabs.setSelection(true);
            this.fIndentUsingSpaces.setSelection(false);
        } else {
            this.fIndentUsingSpaces.setSelection(true);
            this.fIndentUsingTabs.setSelection(false);
        }
        this.fIndentationSize.setSelection(this.getModelPreferences().getDefaultInt("indentationSize"));
    }

    protected void initializeValues() {
        this.fTagNameUpper.setSelection(this.getModelPreferences().getInt("tagNameCase") == 2);
        this.fTagNameLower.setSelection(this.getModelPreferences().getInt("tagNameCase") == 1);
        this.fAttrNameUpper.setSelection(this.getModelPreferences().getInt("attrNameCase") == 2);
        this.fAttrNameLower.setSelection(this.getModelPreferences().getInt("attrNameCase") == 1);
        this.initializeValuesForFormattingGroup();
        this.initializeValuesForContentAssistGroup();
    }

    private void initializeValuesForContentAssistGroup() {
        this.fAutoPropose.setSelection(this.getPreferenceStore().getBoolean(HTMLUIPreferenceNames.AUTO_PROPOSE));
        this.fAutoProposeText.setText(this.getPreferenceStore().getString(HTMLUIPreferenceNames.AUTO_PROPOSE_CODE));
    }

    private void initializeValuesForFormattingGroup() {
        this.fLineWidthText.setText(this.getModelPreferences().getString("lineWidth"));
        this.fSplitMultiAttrs.setSelection(this.getModelPreferences().getBoolean("splitMultiAttrs"));
        this.fAlignEndBracket.setSelection(this.getModelPreferences().getBoolean("alignEndBracket"));
        this.fClearAllBlankLines.setSelection(this.getModelPreferences().getBoolean("clearAllBlankLines"));
        if ("tab".equals(this.getModelPreferences().getString("indentationChar"))) {
            this.fIndentUsingTabs.setSelection(true);
            this.fIndentUsingSpaces.setSelection(false);
        } else {
            this.fIndentUsingSpaces.setSelection(true);
            this.fIndentUsingTabs.setSelection(false);
        }
        this.fIndentationSize.setSelection(this.getModelPreferences().getInt("indentationSize"));
    }

    protected void storeValues() {
        if (this.fTagNameUpper.getSelection()) {
            this.getModelPreferences().setValue("tagNameCase", 2);
        } else {
            this.getModelPreferences().setValue("tagNameCase", 1);
        }
        if (this.fAttrNameUpper.getSelection()) {
            this.getModelPreferences().setValue("attrNameCase", 2);
        } else {
            this.getModelPreferences().setValue("attrNameCase", 1);
        }
        this.storeValuesForFormattingGroup();
        this.storeValuesForContentAssistGroup();
    }

    private void storeValuesForContentAssistGroup() {
        this.getPreferenceStore().setValue(HTMLUIPreferenceNames.AUTO_PROPOSE, this.fAutoPropose.getSelection());
        this.getPreferenceStore().setValue(HTMLUIPreferenceNames.AUTO_PROPOSE_CODE, this.fAutoProposeText.getText());
    }

    private void storeValuesForFormattingGroup() {
        this.getModelPreferences().setValue("lineWidth", this.fLineWidthText.getText());
        this.getModelPreferences().setValue("splitMultiAttrs", this.fSplitMultiAttrs.getSelection());
        this.getModelPreferences().setValue("alignEndBracket", this.fAlignEndBracket.getSelection());
        this.getModelPreferences().setValue("clearAllBlankLines", this.fClearAllBlankLines.getSelection());
        if (this.fIndentUsingTabs.getSelection()) {
            this.getModelPreferences().setValue("indentationChar", "tab");
        } else {
            this.getModelPreferences().setValue("indentationChar", "space");
        }
        this.getModelPreferences().setValue("indentationSize", this.fIndentationSize.getSelection());
    }

    public boolean performOk() {
        boolean result = super.performOk();
        this.doSavePreferenceStore();
        return result;
    }

    protected Preferences getModelPreferences() {
        return HTMLCorePlugin.getDefault().getPluginPreferences();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return HTMLUIPlugin.getDefault().getPreferenceStore();
    }

    private void doSavePreferenceStore() {
        HTMLUIPlugin.getDefault().savePluginPreferences();
        HTMLCorePlugin.getDefault().savePluginPreferences();
    }

    protected Control createContents(Composite parent) {
        Composite composite = super.createComposite(parent, 1);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.wst.html.ui.webx0031");
        new PreferenceLinkArea(composite, 66, "org.eclipse.wst.sse.ui.preferences.editor", HTMLUIMessages._UI_STRUCTURED_TEXT_EDITOR_PREFS_LINK, (IWorkbenchPreferenceContainer)this.getContainer(), null).getControl().setLayoutData((Object)GridDataFactory.fillDefaults().hint(150, -1).create());
        new Label(composite, 0).setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.createContentsForFormattingGroup(composite);
        this.createContentsForContentAssistGroup(composite);
        this.setSize(composite);
        this.loadPreferences();
        return composite;
    }

    protected void enableValues() {
        if (this.fAutoPropose != null) {
            if (this.fAutoPropose.getSelection()) {
                this.fAutoProposeLabel.setEnabled(true);
                this.fAutoProposeText.setEnabled(true);
            } else {
                this.fAutoProposeLabel.setEnabled(false);
                this.fAutoProposeText.setEnabled(false);
            }
        }
    }

    protected void validateValues() {
        boolean isError = false;
        String widthText = null;
        if (this.fLineWidthText != null) {
            try {
                widthText = this.fLineWidthText.getText();
                int formattingLineWidth = Integer.parseInt(widthText);
                if (formattingLineWidth < 0 || formattingLineWidth > 999) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setInvalidInputMessage(widthText);
                this.setValid(false);
                isError = true;
            }
        }
        int indentSize = 0;
        if (this.fIndentationSize != null) {
            try {
                indentSize = this.fIndentationSize.getSelection();
                if (indentSize < 0 || indentSize > 16) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setInvalidInputMessage(Integer.toString(indentSize));
                this.setValid(false);
                isError = true;
            }
        }
        if (!isError) {
            this.setErrorMessage(null);
            this.setValid(true);
        }
    }
}

