/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.ui.common;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.ws.internal.ui.WSUIPluginMessages;
import org.eclipse.jst.ws.internal.ui.common.IFilter;
import org.eclipse.jst.ws.internal.ui.plugin.WebServiceUIPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class DialogResourceBrowser
extends Dialog {
    private final String INFOPOP_RESOURCE_TREE = "org.eclipse.jst.ws.ui.DRES0001";
    private IResource root_;
    private IFilter[] filters_;
    private boolean multipleSelectionEnabled_;
    private IResource[] selection_;
    private Tree resourceTree_;
    private TreeViewer fileViewer_;
    private HashMap visitedContainers_;
    private boolean foldersSelectable_;

    public DialogResourceBrowser(Shell shell, IResource root, IFilter filter) {
        this(shell, root, new IFilter[]{filter}, false);
    }

    public DialogResourceBrowser(Shell shell, IResource root, IFilter[] filters) {
        this(shell, root, filters, false);
    }

    public DialogResourceBrowser(Shell shell, IResource root, IFilter[] filters, boolean foldersSelectable) {
        super(shell);
        IResource moduleRoot = root;
        if (root instanceof IProject) {
            IProject p = (IProject)moduleRoot;
            moduleRoot = p;
        }
        this.root_ = moduleRoot == null ? ResourcesPlugin.getWorkspace().getRoot() : moduleRoot;
        this.filters_ = filters == null ? new IFilter[]{} : filters;
        this.visitedContainers_ = new HashMap();
        this.multipleSelectionEnabled_ = false;
        this.foldersSelectable_ = foldersSelectable;
        this.setShellStyle(67696);
    }

    public void setMultipleSelectionEnabled(boolean multipleSelectionEnabled) {
        this.multipleSelectionEnabled_ = multipleSelectionEnabled;
    }

    public IResource[] getSelection() {
        return this.selection_;
    }

    public IResource getFirstSelection() {
        if (this.selection_ != null && this.selection_.length > 0) {
            return this.selection_[0];
        }
        return null;
    }

    protected void cancelPressed() {
        this.selection_ = null;
        this.setReturnCode(1);
        super.cancelPressed();
    }

    protected void okPressed() {
        ISelection selection = this.fileViewer_.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            this.selection_ = new IResource[structuredSelection.size()];
            int i = 0;
            Iterator it = structuredSelection.iterator();
            while (it.hasNext()) {
                Object object = it.next();
                if (!(object instanceof IResource)) continue;
                this.selection_[i++] = (IResource)object;
            }
        }
        this.setReturnCode(0);
        super.okPressed();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(WSUIPluginMessages.DIALOG_TITLE_RESOURCE_BROWSER);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        gd.heightHint = 300;
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)gd);
        this.resourceTree_ = this.multipleSelectionEnabled_ ? new Tree(composite, 2818) : new Tree(composite, 2820);
        gd = new GridData(1808);
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        this.resourceTree_.setLayoutData((Object)gd);
        this.resourceTree_.setToolTipText(WSUIPluginMessages.TOOLTIP_RESOURCE_TREE);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.resourceTree_, "org.eclipse.jst.ws.ui.DRES0001");
        this.fileViewer_ = new TreeViewer(this.resourceTree_);
        this.fileViewer_.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.fileViewer_.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), WebServiceUIPlugin.getInstance().getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.fileViewer_.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentObject, Object object) {
                if (object instanceof IResource) {
                    return DialogResourceBrowser.this.isValidResource((IResource)object);
                }
                return false;
            }
        });
        if (!this.foldersSelectable_) {
            this.fileViewer_.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    DialogResourceBrowser.this.handleSelectionChanged();
                }
            });
        }
        this.fileViewer_.setInput((Object)this.root_);
        return composite;
    }

    private void handleSelectionChanged() {
        ISelection selection = this.fileViewer_.getSelection();
        boolean validSelection = true;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection strucSelection = (IStructuredSelection)selection;
            Iterator iter = strucSelection.iterator();
            while (iter.hasNext()) {
                Object object = iter.next();
                validSelection = object instanceof IFile ? this.acceptsFile((IResource)((IFile)object)) : false;
                if (validSelection) {
                    continue;
                }
                break;
            }
        } else {
            validSelection = false;
        }
        Button okButton = this.getButton(0);
        okButton.setEnabled(validSelection);
    }

    private boolean acceptsFile(IResource file) {
        boolean result = false;
        int i = 0;
        while (i < this.filters_.length) {
            if (this.filters_[i].accepts(file)) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    private boolean isValidResource(IResource resource) {
        boolean result = false;
        if (resource instanceof IFile) {
            result = this.acceptsFile(resource);
        } else if (resource instanceof IContainer) {
            Boolean validContainer = (Boolean)this.visitedContainers_.get(resource);
            if (validContainer == null) {
                try {
                    IContainer container = (IContainer)resource;
                    IResource[] members = container.members();
                    this.visitedContainers_.put(container, Boolean.FALSE);
                    int index = 0;
                    while (index < members.length) {
                        if (this.isValidResource(members[index])) {
                            this.visitedContainers_.put(container, Boolean.TRUE);
                            result = true;
                            break;
                        }
                        ++index;
                    }
                }
                catch (CoreException coreException) {}
            } else {
                result = validContainer;
            }
        }
        return result;
    }
}

