/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatRuntimeWorkingCopy;
import org.eclipse.jst.server.tomcat.ui.internal.Messages;
import org.eclipse.jst.server.tomcat.ui.internal.SWTUtil;
import org.eclipse.jst.server.tomcat.ui.internal.TomcatUIPlugin;
import org.eclipse.jst.server.tomcat.ui.internal.Trace;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.core.internal.IInstallableRuntime;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.ui.internal.wizard.TaskWizard;
import org.eclipse.wst.server.ui.internal.wizard.fragment.LicenseWizardFragment;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class TomcatRuntimeComposite
extends Composite {
    protected IRuntimeWorkingCopy runtimeWC;
    protected ITomcatRuntimeWorkingCopy runtime;
    protected IWizardHandle wizard;
    protected Text installDir;
    protected Text name;
    protected Combo combo;
    protected List installedJREs;
    protected String[] jreNames;
    protected IInstallableRuntime ir;
    protected Label installLabel;
    protected Button install;
    static /* synthetic */ Class class$0;

    protected TomcatRuntimeComposite(Composite parent, IWizardHandle wizard) {
        super(parent, 0);
        this.wizard = wizard;
        wizard.setTitle(Messages.wizardTitle);
        wizard.setDescription(Messages.wizardDescription);
        wizard.setImageDescriptor(TomcatUIPlugin.getImageDescriptor("wizTomcat"));
        this.createControl();
    }

    protected void setRuntime(IRuntimeWorkingCopy newRuntime) {
        if (newRuntime == null) {
            this.runtimeWC = null;
            this.runtime = null;
        } else {
            this.runtimeWC = newRuntime;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jst.server.tomcat.core.internal.ITomcatRuntimeWorkingCopy");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.runtime = (ITomcatRuntimeWorkingCopy)newRuntime.loadAdapter((Class)clazz, null);
        }
        if (this.runtimeWC == null) {
            this.ir = null;
            this.install.setEnabled(false);
            this.installLabel.setText("");
        } else {
            this.ir = ServerPlugin.findInstallableRuntime((String)this.runtimeWC.getRuntimeType().getId());
            if (this.ir != null) {
                this.install.setEnabled(true);
                this.installLabel.setText(this.ir.getName());
            }
        }
        this.init();
        this.validate();
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this, "org.eclipse.jst.server.tomcat.ui.twnr0000");
        Label label = new Label((Composite)this, 0);
        label.setText(Messages.runtimeName);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.name = new Text((Composite)this, 2048);
        data = new GridData(768);
        this.name.setLayoutData((Object)data);
        this.name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TomcatRuntimeComposite.this.runtimeWC.setName(TomcatRuntimeComposite.this.name.getText());
                TomcatRuntimeComposite.this.validate();
            }
        });
        label = new Label((Composite)this, 0);
        label.setText(Messages.installDir);
        data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.installDir = new Text((Composite)this, 2048);
        data = new GridData(768);
        this.installDir.setLayoutData((Object)data);
        this.installDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TomcatRuntimeComposite.this.runtimeWC.setLocation((IPath)new Path(TomcatRuntimeComposite.this.installDir.getText()));
                TomcatRuntimeComposite.this.validate();
            }
        });
        Button browse = SWTUtil.createButton(this, Messages.browse);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                DirectoryDialog dialog = new DirectoryDialog(TomcatRuntimeComposite.this.getShell());
                dialog.setMessage(Messages.selectInstallDir);
                dialog.setFilterPath(TomcatRuntimeComposite.this.installDir.getText());
                String selectedDirectory = dialog.open();
                if (selectedDirectory != null) {
                    TomcatRuntimeComposite.this.installDir.setText(selectedDirectory);
                }
            }
        });
        this.installLabel = new Label((Composite)this, 131072);
        data = new GridData(768);
        data.horizontalIndent = 10;
        this.installLabel.setLayoutData((Object)data);
        this.install = SWTUtil.createButton(this, Messages.install);
        this.install.setEnabled(false);
        this.install.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                String license = null;
                try {
                    license = TomcatRuntimeComposite.this.ir.getLicense((IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    Trace.trace((byte)2, "Error getting license", e);
                }
                TaskModel taskModel = new TaskModel();
                taskModel.putObject("license", (Object)license);
                TaskWizard wizard2 = new TaskWizard(Messages.installDialogTitle, new WizardFragment(this){
                    final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    protected void createChildFragments(List list) {
                        list.add(new LicenseWizardFragment());
                    }
                }, taskModel);
                WizardDialog dialog2 = new WizardDialog(TomcatRuntimeComposite.this.getShell(), (IWizard)wizard2);
                if (dialog2.open() == 1) {
                    return;
                }
                DirectoryDialog dialog = new DirectoryDialog(TomcatRuntimeComposite.this.getShell());
                dialog.setMessage(Messages.selectInstallDir);
                dialog.setFilterPath(TomcatRuntimeComposite.this.installDir.getText());
                String selectedDirectory = dialog.open();
                if (selectedDirectory != null) {
                    TomcatRuntimeComposite.this.ir.install((IPath)new Path(selectedDirectory));
                    TomcatRuntimeComposite.this.installDir.setText(selectedDirectory);
                }
            }
        });
        this.updateJREs();
        label = new Label((Composite)this, 0);
        label.setText(Messages.installedJRE);
        data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.combo = new Combo((Composite)this, 12);
        this.combo.setItems(this.jreNames);
        data = new GridData(256);
        this.combo.setLayoutData((Object)data);
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int sel = TomcatRuntimeComposite.this.combo.getSelectionIndex();
                IVMInstall vmInstall = null;
                if (sel > 0) {
                    vmInstall = (IVMInstall)TomcatRuntimeComposite.this.installedJREs.get(sel - 1);
                }
                TomcatRuntimeComposite.this.runtime.setVMInstall(vmInstall);
                TomcatRuntimeComposite.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button button = SWTUtil.createButton(this, Messages.installedJREs);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String currentVM = TomcatRuntimeComposite.this.combo.getText();
                if (TomcatRuntimeComposite.this.showPreferencePage()) {
                    TomcatRuntimeComposite.this.updateJREs();
                    TomcatRuntimeComposite.this.combo.setItems(TomcatRuntimeComposite.this.jreNames);
                    TomcatRuntimeComposite.this.combo.setText(currentVM);
                    if (TomcatRuntimeComposite.this.combo.getSelectionIndex() == -1) {
                        TomcatRuntimeComposite.this.combo.select(0);
                    }
                    TomcatRuntimeComposite.this.validate();
                }
            }
        });
        this.init();
        this.validate();
        Dialog.applyDialogFont((Control)this);
        this.name.forceFocus();
    }

    protected void updateJREs() {
        this.installedJREs = new ArrayList();
        IVMInstallType[] vmInstallTypes = JavaRuntime.getVMInstallTypes();
        int size = vmInstallTypes.length;
        int i = 0;
        while (i < size) {
            IVMInstall[] vmInstalls = vmInstallTypes[i].getVMInstalls();
            int size2 = vmInstalls.length;
            int j = 0;
            while (j < size2) {
                this.installedJREs.add(vmInstalls[j]);
                ++j;
            }
            ++i;
        }
        size = this.installedJREs.size();
        this.jreNames = new String[size + 1];
        this.jreNames[0] = Messages.runtimeDefaultJRE;
        i = 0;
        while (i < size) {
            IVMInstall vmInstall = (IVMInstall)this.installedJREs.get(i);
            this.jreNames[i + 1] = vmInstall.getName();
            ++i;
        }
    }

    protected boolean showPreferencePage() {
        String id = "org.eclipse.jdt.debug.ui.preferences.VMPreferencePage";
        PreferenceManager manager = PlatformUI.getWorkbench().getPreferenceManager();
        IPreferenceNode node = manager.find("org.eclipse.jdt.ui.preferences.JavaBasePreferencePage").findSubNode(id);
        PreferenceManager manager2 = new PreferenceManager();
        manager2.addToRoot(node);
        PreferenceDialog dialog = new PreferenceDialog(this.getShell(), manager2);
        dialog.create();
        return dialog.open() == 0;
    }

    protected void init() {
        if (this.name == null || this.runtime == null) {
            return;
        }
        if (this.runtimeWC.getName() != null) {
            this.name.setText(this.runtimeWC.getName());
        } else {
            this.name.setText("");
        }
        if (this.runtimeWC.getLocation() != null) {
            this.installDir.setText(this.runtimeWC.getLocation().toOSString());
        } else {
            this.installDir.setText("");
        }
        if (this.runtime.isUsingDefaultJRE()) {
            this.combo.select(0);
        } else {
            boolean found = false;
            int size = this.installedJREs.size();
            int i = 0;
            while (i < size) {
                IVMInstall vmInstall = (IVMInstall)this.installedJREs.get(i);
                if (vmInstall.equals(this.runtime.getVMInstall())) {
                    this.combo.select(i + 1);
                    found = true;
                }
                ++i;
            }
            if (!found) {
                this.combo.select(0);
            }
        }
    }

    protected void validate() {
        if (this.runtime == null) {
            this.wizard.setMessage("", 3);
            return;
        }
        IStatus status = this.runtimeWC.validate(null);
        if (status == null || status.isOK()) {
            this.wizard.setMessage(null, 0);
        } else if (status.getSeverity() == 2) {
            this.wizard.setMessage(status.getMessage(), 2);
        } else {
            this.wizard.setMessage(status.getMessage(), 3);
        }
        this.wizard.update();
    }
}

