/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.layout.table;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.layout.CSSBlockFlowLayout;
import org.eclipse.jst.pagedesigner.css2.layout.CSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.ICSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.ICSSPainter;
import org.eclipse.jst.pagedesigner.css2.layout.table.TableCaptionInfo;
import org.eclipse.jst.pagedesigner.css2.layout.table.TableCellInfo;
import org.eclipse.jst.pagedesigner.css2.layout.table.TableInfo;
import org.eclipse.jst.pagedesigner.css2.layout.table.TableRowGroupInfo;
import org.eclipse.jst.pagedesigner.css2.layout.table.TableRowInfo;
import org.eclipse.jst.pagedesigner.css2.style.ITagEditInfo;

public class CSSTableLayout2
extends CSSBlockFlowLayout
implements ICSSPainter {
    static Logger _log = PDPlugin.getLogger(CSSTableLayout2.class);
    int _hspacing;
    int _vspacing;
    int[] _columnWidths;
    int[] _rowHeights;
    Dimension _captionSize;
    TableInfo _tableInfo;
    private int _internalTableWidth;
    private int _internalTableHeight;
    private int _rowx;
    private int _rowwidth;

    public CSSTableLayout2(CSSFigure flowfigure) {
        super(flowfigure);
    }

    protected void preLayout() {
        Dimension d;
        int cellWidth;
        int rowspan;
        ICSSFigure figure;
        TableCellInfo cellinfo;
        int maxMin;
        int tableWidth;
        super.preLayout();
        ICSSStyle style = this.getCSSStyle();
        this._vspacing = 3;
        this._hspacing = 3;
        if (style != null) {
            Object borderspacing = style.getStyleProperty("border-spacing");
            if (borderspacing instanceof int[]) {
                int[] intvalues = (int[])borderspacing;
                this._hspacing = intvalues[0];
                this._vspacing = intvalues[1];
            } else {
                ITagEditInfo info = (ITagEditInfo)style.getAdapter(ITagEditInfo.class);
                if (info != null && info.needTableDecorator()) {
                    if (this._hspacing < 5) {
                        this._hspacing = 5;
                    }
                    if (this._vspacing < 5) {
                        this._vspacing = 5;
                    }
                }
            }
        }
        this._tableInfo = new TableInfo(this.getCSSFigure());
        this._tableInfo.constructTable();
        int contentWidth = this._blockBox.getContentWidth();
        int availableWidth = this._blockBox.getRecommendedContentWidth();
        int contentHeight = this._blockBox.getContentHeight();
        this._tableInfo.calculateWidth(contentWidth, availableWidth);
        this._tableInfo.calculateHeight(contentHeight);
        int columnCount = this._tableInfo.getColumnCount();
        int[] columnMinWidths = new int[columnCount];
        int[] columnMaxWidths = new int[columnCount];
        List cells = this._tableInfo.getCells();
        int i = 0;
        int size = cells.size();
        while (i < size) {
            TableCellInfo cellinfo2 = (TableCellInfo)cells.get(i);
            if (cellinfo2.getColSpan() == 1) {
                int column = cellinfo2.getColumnIndex();
                Dimension mincw = cellinfo2.getMinCWDimension();
                Dimension maxcw = cellinfo2.getMaxCWDimension();
                if (maxcw.width < mincw.width) {
                    maxcw.width = mincw.width;
                }
                if (mincw.width > columnMinWidths[column]) {
                    columnMinWidths[column] = mincw.width;
                }
                if (maxcw.width > columnMaxWidths[column]) {
                    columnMaxWidths[column] = maxcw.width;
                }
            }
            ++i;
        }
        int captionWidth = 0;
        if (this._tableInfo.getCaption() != null) {
            captionWidth = this._tableInfo.getCaption().getDimension().width;
        }
        int i2 = 0;
        int size2 = cells.size();
        while (i2 < size2) {
            TableCellInfo cellinfo3 = (TableCellInfo)cells.get(i2);
            int colspan = cellinfo3.getColSpan();
            if (colspan > 1) {
                int column = cellinfo3.getColumnIndex();
                Dimension mincw = cellinfo3.getMinCWDimension();
                Dimension maxcw = cellinfo3.getMaxCWDimension();
                this.adjustWidth(column, colspan, mincw.width, columnMinWidths);
                this.adjustWidth(column, colspan, maxcw.width, columnMaxWidths);
            }
            ++i2;
        }
        int sigmaMinWidth = 0;
        int sigmaMaxWidth = 0;
        int i3 = 0;
        while (i3 < columnMinWidths.length) {
            sigmaMinWidth += columnMinWidths[i3];
            if (columnMaxWidths[i3] == Integer.MAX_VALUE) {
                sigmaMaxWidth = Integer.MAX_VALUE;
            } else if (sigmaMaxWidth != Integer.MAX_VALUE && (sigmaMaxWidth += columnMaxWidths[i3]) < 0) {
                sigmaMaxWidth = Integer.MAX_VALUE;
            }
            ++i3;
        }
        int spacingall = (columnMinWidths.length + 1) * this._hspacing;
        sigmaMinWidth += spacingall;
        if (sigmaMaxWidth != Integer.MAX_VALUE && (sigmaMaxWidth += spacingall) < 0) {
            sigmaMaxWidth = Integer.MAX_VALUE;
        }
        if ((tableWidth = this._tableInfo.getTableWidth()) > 0) {
            maxMin = Math.max(captionWidth, sigmaMinWidth);
            if (maxMin >= tableWidth) {
                tableWidth = maxMin;
            }
            this.distribute(tableWidth - sigmaMinWidth, columnMinWidths, columnMaxWidths);
        } else {
            maxMin = Math.max(captionWidth, sigmaMaxWidth);
            tableWidth = maxMin <= availableWidth ? maxMin : availableWidth;
            this.distribute(tableWidth - sigmaMinWidth, columnMinWidths, columnMaxWidths);
        }
        this._columnWidths = columnMinWidths;
        this._rowHeights = new int[this._tableInfo.getRowCount()];
        List rows = this._tableInfo.getRows();
        int i4 = 0;
        int size3 = rows.size();
        while (i4 < size3 && i4 < this._rowHeights.length) {
            TableRowInfo rowInfo = (TableRowInfo)rows.get(i4);
            if (rowInfo.getSpecifiedRowHeight() > 0) {
                this._rowHeights[i4] = rowInfo.getSpecifiedRowHeight();
            }
            ++i4;
        }
        cells = this._tableInfo.getCells();
        i4 = 0;
        size3 = cells.size();
        while (i4 < size3) {
            cellinfo = (TableCellInfo)cells.get(i4);
            figure = cellinfo.getFigure();
            rowspan = cellinfo.getRowSpan();
            if (rowspan == 1) {
                cellWidth = this.getCellWidth(cellinfo, this._columnWidths);
                d = figure.getPreferredSize(cellWidth, cellinfo.getHeight());
                if (d.height > this._rowHeights[cellinfo.getRowIndex()]) {
                    this._rowHeights[cellinfo.getRowIndex()] = d.height;
                }
            }
            ++i4;
        }
        cells = this._tableInfo.getCells();
        i4 = 0;
        size3 = cells.size();
        while (i4 < size3) {
            cellinfo = (TableCellInfo)cells.get(i4);
            figure = cellinfo.getFigure();
            rowspan = cellinfo.getRowSpan();
            if (rowspan > 1) {
                cellWidth = this.getCellWidth(cellinfo, this._columnWidths);
                d = figure.getPreferredSize(cellWidth, cellinfo.getHeight());
                if (d.height > this.getCellHeight(cellinfo, this._rowHeights)) {
                    this.adjustHeight(cellinfo.getRowIndex(), rowspan, d.height, this._rowHeights);
                }
            }
            ++i4;
        }
        int sigmaHeight = (this._tableInfo.getRowCount() + 1) * this._vspacing;
        int i5 = 0;
        while (i5 < this._rowHeights.length) {
            sigmaHeight += this._rowHeights[i5];
            ++i5;
        }
        if (sigmaHeight < contentHeight) {
            this.distributeHeights(contentHeight - sigmaHeight, this._rowHeights);
        }
        Insets insets = style == null ? new Insets() : style.getBorderInsets().getAdded(style.getPaddingInsets());
        this._internalTableWidth = (this._tableInfo.getColumnCount() + 1) * this._hspacing;
        int i6 = 0;
        while (i6 < this._columnWidths.length) {
            this._internalTableWidth += this._columnWidths[i6];
            ++i6;
        }
        int minWidth = this.getLengthValue(style, "min-width");
        this._internalTableWidth = this._internalTableWidth > minWidth ? this._internalTableWidth : minWidth;
        this._blockBox.setWidth(this._internalTableWidth + insets.getWidth());
        this._internalTableHeight = (this._tableInfo.getRowCount() + 1) * this._vspacing;
        int i7 = 0;
        while (i7 < this._rowHeights.length) {
            this._internalTableHeight += this._rowHeights[i7];
            ++i7;
        }
        int minHeight = this.getLengthValue(style, "min-height");
        this._internalTableHeight = this._internalTableHeight > minHeight ? this._internalTableHeight : minHeight;
        int captionHeight = 0;
        if (this._tableInfo.getCaption() != null) {
            this._captionSize = this._tableInfo.getCaption().getFigure().getPreferredSize(this._internalTableWidth, -1);
            captionHeight = this._captionSize.height;
        } else {
            this._captionSize = null;
        }
        this._internalTableHeight += captionHeight;
        this._blockBox.setHeight(this._internalTableHeight + insets.getHeight());
        this._rowwidth = this._internalTableWidth - 2 * this._hspacing;
        this._rowx = this._hspacing;
    }

    protected void endBlock() {
        this._blockBox.setWidth(this._internalTableWidth + this._blockBox.getBorderPaddingWidth());
        this._blockBox.setHeight(this._internalTableHeight + this._blockBox.getBorderPaddingHeight());
        super.endBlock();
    }

    private void distribute(int toDistribute, int[] columnMinWidths, int[] columnMaxWidths) {
        if (toDistribute <= 0) {
            return;
        }
        if (columnMinWidths.length == 0) {
            return;
        }
        int[] delta = new int[columnMinWidths.length];
        int sigmaDelta = 0;
        int i = 0;
        while (i < columnMinWidths.length && toDistribute > 0) {
            if (this._tableInfo.getWidthSpecified()[i]) {
                delta[i] = 0;
            } else {
                delta[i] = columnMaxWidths[i] - columnMinWidths[i];
                if (delta[i] <= 0) {
                    delta[i] = 0;
                }
                sigmaDelta += delta[i];
            }
            ++i;
        }
        if (sigmaDelta == 0) {
            this.averageDeltaToCell(columnMinWidths, toDistribute);
        } else {
            int left = toDistribute;
            int i2 = 0;
            while (i2 < columnMinWidths.length - 1) {
                if (delta[i2] > 0) {
                    int add = delta[i2] * toDistribute / sigmaDelta;
                    left -= add;
                    int n = i2;
                    columnMinWidths[n] = columnMinWidths[n] + add;
                }
                ++i2;
            }
            int n = columnMinWidths.length - 1;
            columnMinWidths[n] = columnMinWidths[n] + left;
        }
    }

    private void averageDeltaToCell(int[] columnMinWidths, int toDistribute) {
        if (toDistribute <= 0) {
            return;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 0;
        while (i < columnMinWidths.length) {
            if (!this._tableInfo.getWidthSpecified()[i]) {
                list.add(new Integer(i));
            }
            ++i;
        }
        if (list.size() == 0) {
            i = 0;
            while (i < columnMinWidths.length) {
                list.add(new Integer(i));
                ++i;
            }
        }
        int padding = toDistribute / list.size();
        int left = toDistribute % list.size();
        int i2 = 0;
        int n = list.size();
        while (i2 < n) {
            int n2 = (Integer)list.get(i2);
            columnMinWidths[n2] = columnMinWidths[n2] + padding;
            ++i2;
        }
        if (left > 0) {
            i2 = 0;
            while (i2 < left) {
                int n3 = (Integer)list.get(i2);
                columnMinWidths[n3] = columnMinWidths[n3] + 1;
                ++i2;
            }
        }
    }

    private void distributeHeights(int toDistribute, int[] heights) {
        if (heights.length == 0) {
            return;
        }
        int eachDelta = toDistribute / heights.length;
        int i = 0;
        while (i < heights.length - 1) {
            int n = i++;
            heights[n] = heights[n] + eachDelta;
        }
        int n = heights.length - 1;
        heights[n] = heights[n] + (toDistribute - (heights.length - 1) * eachDelta);
    }

    public int getCellHeight(TableCellInfo cellinfo, int[] heights) {
        int rowIndex = cellinfo.getRowIndex();
        int rowspan = cellinfo.getRowSpan();
        int h = 0;
        int i = 0;
        while (i < rowspan) {
            h += heights[rowIndex + i];
            ++i;
        }
        return h += (rowspan - 1) * this._vspacing;
    }

    public int getCellWidth(TableCellInfo cellinfo, int[] widths) {
        int columnIndex = cellinfo.getColumnIndex();
        int colspan = cellinfo.getColSpan();
        int w = 0;
        int i = 0;
        while (i < colspan) {
            w += widths[columnIndex + i];
            ++i;
        }
        return w += (colspan - 1) * this._hspacing;
    }

    private void adjustWidth(int column, int colspan, int width, int[] columnWidths) {
        CSSTableLayout2.adjustSpan(column, colspan, width, columnWidths, this._hspacing);
    }

    private void adjustHeight(int rowIndex, int rowspan, int height, int[] heights) {
        CSSTableLayout2.adjustSpan(rowIndex, rowspan, height, heights, this._vspacing);
    }

    private static void adjustSpan(int column, int colspan, int width, int[] columnWidths, int spacing) {
        int spanwidth = 0;
        int i = 0;
        while (i < colspan) {
            spanwidth += columnWidths[column + i];
            ++i;
        }
        if ((spanwidth += (colspan - 1) * spacing) >= width) {
            return;
        }
        int delta = width - spanwidth;
        int deltaeach = delta / colspan;
        int i2 = 0;
        while (i2 < colspan - 1) {
            int n = column + i2;
            columnWidths[n] = columnWidths[n] + deltaeach;
            ++i2;
        }
        int n = column + colspan - 1;
        columnWidths[n] = columnWidths[n] + (delta - (colspan - 1) * deltaeach);
    }

    public int[] getRowHeights() {
        return this._rowHeights;
    }

    public int[] getColumnWidths() {
        return this._columnWidths;
    }

    public int getVSpacing() {
        return this._vspacing;
    }

    public int getHSpacing() {
        return this._hspacing;
    }

    public TableRowInfo getRowInfo(CSSFigure figure) {
        return this._tableInfo.findRowInfo(figure);
    }

    public TableCaptionInfo getCaptionInfo() {
        return this._tableInfo.getCaption();
    }

    public TableRowGroupInfo getGroupInfo(CSSFigure figure) {
        return this._tableInfo.findGroupInfo(figure);
    }

    public int getRowX() {
        return this._rowx;
    }

    public int getRowWidth() {
        return this._rowwidth;
    }

    public boolean shouldExpand() {
        return false;
    }

    public Dimension getCaptionSize() {
        return this._captionSize;
    }

    public void paintFigure(Graphics g) {
        ITagEditInfo info;
        ICSSStyle style = this.getCSSStyle();
        if (style != null && (info = (ITagEditInfo)style.getAdapter(ITagEditInfo.class)) != null && info.needTableDecorator()) {
            List cells = this._tableInfo.getCells();
            int i = 0;
            int size = cells.size();
            while (i < size) {
                TableCellInfo cellInfo = (TableCellInfo)cells.get(i);
                ICSSFigure cellfigure = cellInfo.getFigure();
                Rectangle rect = cellfigure.getBounds().getCopy();
                rect = rect.expand(1, 1);
                g.setLineStyle(1);
                g.setLineWidth(1);
                g.setForegroundColor(ColorConstants.lightGray);
                g.drawRectangle(rect);
                ++i;
            }
        }
    }
}

