/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.view.model.jsp.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jst.jsf.common.internal.policy.OrderedListProvider;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.DefaultJSPTagResolver;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.JSPTagResolvingStrategy;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.TagIntrospectingStrategy;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.persistence.PersistedDataTagStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TLDRegistryPreferences {
    private static final Map<String, JSPTagResolvingStrategy.StrategyDescriptor> ALL_KNOWN_STRATEGIES;
    private final IPreferenceStore _prefStore;
    private final CopyOnWriteArrayList<PropertyListener> _listeners;
    private final AtomicBoolean _isDisposed = new AtomicBoolean(false);
    private static final String KEY_STRATEGY_ID_ORDER = "org.eclipse.jst.jsf.designtime.jsp.registry.StrategyIDOrder";
    private static final List<OrderedListProvider.OrderableObject> DEFAULT_STRATEGY_ORDER;
    private List<OrderedListProvider.OrderableObject> _ids;
    private List<OrderedListProvider.OrderableObject> _originalIds;
    private IPropertyChangeListener _propertyListener;

    static {
        ArrayList<OrderedListProvider.OrderableObject> list = new ArrayList<OrderedListProvider.OrderableObject>();
        list.add(new OrderedListProvider.OrderableObject((Object)new StrategyIdentifier(PersistedDataTagStrategy.createDescriptor()), true));
        list.add(new OrderedListProvider.OrderableObject((Object)new StrategyIdentifier(DefaultJSPTagResolver.createDescriptor()), true));
        list.add(new OrderedListProvider.OrderableObject((Object)new StrategyIdentifier(TagIntrospectingStrategy.createDescriptor()), true));
        DEFAULT_STRATEGY_ORDER = Collections.unmodifiableList(list);
        HashMap<String, JSPTagResolvingStrategy.StrategyDescriptor> knownDescriptors = new HashMap<String, JSPTagResolvingStrategy.StrategyDescriptor>();
        for (OrderedListProvider.OrderableObject object : DEFAULT_STRATEGY_ORDER) {
            StrategyIdentifier strategyId = (StrategyIdentifier)object.getObject();
            knownDescriptors.put(strategyId.getId(), strategyId._descriptor);
        }
        ALL_KNOWN_STRATEGIES = Collections.unmodifiableMap(knownDescriptors);
    }

    public TLDRegistryPreferences(IPreferenceStore prefStore) {
        this._prefStore = prefStore;
        this._ids = new ArrayList<OrderedListProvider.OrderableObject>();
        this._listeners = new CopyOnWriteArrayList();
    }

    public void dispose() {
        if (this._isDisposed.compareAndSet(false, true) && this._propertyListener != null) {
            this._prefStore.removePropertyChangeListener(this._propertyListener);
        }
    }

    void addListener(PropertyListener propListener) {
        if (!this.assertNotDisposed()) {
            return;
        }
        if (this._propertyListener == null) {
            this._propertyListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (TLDRegistryPreferences.KEY_STRATEGY_ID_ORDER.equals(event.getProperty())) {
                        TLDRegistryPreferences.this.fireStrategyOrderChanged();
                    }
                }
            };
            this._prefStore.addPropertyChangeListener(this._propertyListener);
        }
        this._listeners.addIfAbsent(propListener);
    }

    void removeListener(PropertyListener propListener) {
        if (!this.assertNotDisposed()) {
            return;
        }
        this._listeners.remove(propListener);
        if (this._listeners.isEmpty()) {
            this._prefStore.removePropertyChangeListener(this._propertyListener);
            this._propertyListener = null;
        }
    }

    private void fireStrategyOrderChanged() {
        if (!this.assertNotDisposed()) {
            return;
        }
        for (PropertyListener listener : this._listeners) {
            listener.strategyOrderChanged();
        }
    }

    private boolean assertNotDisposed() {
        if (this._isDisposed.get()) {
            JSFCorePlugin.log(new Exception("Stack trace only"), "TLDRegistryPreferences is disposed");
            return false;
        }
        return true;
    }

    public void load() {
        this.load(this._prefStore);
    }

    public OrderedListProvider getOrderedListProvider() {
        return new MyOrderedListProvider();
    }

    public List<OrderedListProvider.OrderableObject> getStrategyIdOrdering() {
        return this._ids;
    }

    public void setStrategyIdOrdering(List<OrderedListProvider.OrderableObject> ids) {
        this._ids = ids;
    }

    public List<String> getEnabledIds() {
        ArrayList<String> strategies = new ArrayList<String>();
        for (OrderedListProvider.OrderableObject id : this._ids) {
            if (!id.isEnabled()) continue;
            StrategyIdentifier strategyId = (StrategyIdentifier)id.getObject();
            strategies.add(strategyId.getId());
        }
        return strategies;
    }

    private void load(IPreferenceStore prefStore) {
        List<OrderedListProvider.OrderableObject> ids;
        if (!prefStore.contains(KEY_STRATEGY_ID_ORDER)) {
            prefStore.setDefault(KEY_STRATEGY_ID_ORDER, this.serialize(DEFAULT_STRATEGY_ORDER));
        }
        if ((ids = this.deserialize(prefStore.getString(KEY_STRATEGY_ID_ORDER))) == null) {
            ids = this.deserialize(this.serialize(DEFAULT_STRATEGY_ORDER));
        }
        this._ids = ids;
        ArrayList<OrderedListProvider.OrderableObject> originalList = new ArrayList<OrderedListProvider.OrderableObject>();
        for (OrderedListProvider.OrderableObject id : this._ids) {
            OrderedListProvider.OrderableObject copy = id.clone();
            originalList.add(copy);
        }
        this._originalIds = Collections.unmodifiableList(originalList);
    }

    private String serialize(List<OrderedListProvider.OrderableObject> ids) {
        StringBuffer buffer = new StringBuffer();
        for (OrderedListProvider.OrderableObject id : ids) {
            StrategyIdentifier strategyId = (StrategyIdentifier)id.getObject();
            buffer.append("dummyValue");
            buffer.append(",");
            buffer.append(strategyId.getId());
            buffer.append(",");
            buffer.append(id.isEnabled());
            buffer.append(",");
        }
        return buffer.toString();
    }

    private List<OrderedListProvider.OrderableObject> deserialize(String serializedList) {
        ArrayList<OrderedListProvider.OrderableObject> list = new ArrayList<OrderedListProvider.OrderableObject>();
        String[] ids = serializedList.split(",");
        if (ids.length % 3 != 0) {
            return null;
        }
        int i = 0;
        while (i < ids.length) {
            JSPTagResolvingStrategy.StrategyDescriptor desc;
            String id = ids[i + 1];
            String enabled = ids[i + 2];
            if ("org.eclipse.jst.jsf.THISISTEMPORARY".equals(id)) {
                id = "org.eclipse.jst.jsf.metadata.DefaultJSPTagResolver";
            }
            if ((desc = ALL_KNOWN_STRATEGIES.get(id)) == null) {
                JSFCorePlugin.log(new Exception("Stack trace only"), "Error: unknown strategy id: " + id);
            } else {
                StrategyIdentifier strategyIdentifier = new StrategyIdentifier(desc);
                list.add(new OrderedListProvider.OrderableObject((Object)strategyIdentifier, Boolean.valueOf(enabled).booleanValue()));
            }
            i += 3;
        }
        return list;
    }

    public void commit(IPreferenceStore prefStore) {
        prefStore.setValue(KEY_STRATEGY_ID_ORDER, this.serialize(this.getStrategyIdOrdering()));
        this.load();
    }

    public void setDefaults() {
        this.setStrategyIdOrdering(new ArrayList<OrderedListProvider.OrderableObject>(DEFAULT_STRATEGY_ORDER));
    }

    public boolean isDirty() {
        return !this._ids.equals(this._originalIds);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyOrderedListProvider
    extends OrderedListProvider {
        private MyOrderedListProvider() {
        }

        protected List<OrderedListProvider.OrderableObject> createAndPopulateOrderedObjects() {
            return TLDRegistryPreferences.this._ids;
        }
    }

    static abstract class PropertyListener {
        PropertyListener() {
        }

        public abstract void strategyOrderChanged();
    }

    public static class StrategyIdentifier {
        private final JSPTagResolvingStrategy.StrategyDescriptor _descriptor;

        StrategyIdentifier(JSPTagResolvingStrategy.StrategyDescriptor descriptor) {
            this._descriptor = descriptor;
        }

        public String getId() {
            return this._descriptor.getId();
        }

        public boolean equals(Object obj) {
            if (obj instanceof StrategyIdentifier) {
                return this.getId().equals(((StrategyIdentifier)obj).getId());
            }
            return false;
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public String getDisplayName() {
            return this._descriptor.getDisplayName();
        }
    }
}

