/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal.pde;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.internal.pde.AbstractRegistryReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSimpleClassExtensionRegistryReader<T>
extends AbstractRegistryReader<T> {
    private final String _attributeName;
    private final String _configElementName;
    private final Comparator<SortableExecutableExtension<T>> _comparator;

    protected AbstractSimpleClassExtensionRegistryReader(String extPtNamespace, String extPtId, String configElementName, String attributeName, Comparator<SortableExecutableExtension<T>> listComparator) {
        super(extPtNamespace, extPtId);
        this._configElementName = configElementName;
        this._attributeName = attributeName;
        this._comparator = listComparator;
    }

    @Override
    protected final void initialize() {
        ArrayList result = new ArrayList();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(this.getExtPtNamespace(), this.getExtPtId());
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension iExtension = extensions[i];
            IConfigurationElement[] tagConverter = iExtension.getConfigurationElements();
            int j = 0;
            while (j < tagConverter.length) {
                IConfigurationElement element = tagConverter[j];
                if (element.getName().equals(this._configElementName)) {
                    element.getAttribute(this._attributeName);
                    try {
                        Object obj = element.createExecutableExtension(this._attributeName);
                        result.add(new SortableExecutableExtension(this._comparator, element.getContributor().getName(), obj));
                    }
                    catch (ClassCastException ce) {
                        this.handleLoadFailure(new CoreException((IStatus)new Status(4, "org.eclipse.jst.jsf.common", "Extension class is not the expected type", (Throwable)ce)));
                    }
                    catch (CoreException e) {
                        this.handleLoadFailure(e);
                    }
                }
                ++j;
            }
            ++i;
        }
        if (result.size() > 0) {
            if (this._comparator != null) {
                Collections.sort(result, this._comparator);
            }
        } else {
            JSFCommonPlugin.log(2, String.format("No extensions found for: %s.%s", this.getExtPtNamespace(), this.getExtPtId()));
        }
        ArrayList finalExtensions = new ArrayList();
        for (SortableExecutableExtension sortableExecutableExtension : result) {
            finalExtensions.add(sortableExecutableExtension.getExtensionObject());
        }
        this.internalSetExtensions(finalExtensions);
    }

    protected abstract void handleLoadFailure(CoreException var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class CanonicalComparatorWithPrefixExceptions<T>
    implements Comparator<SortableExecutableExtension<T>> {
        protected CanonicalComparatorWithPrefixExceptions() {
        }

        @Override
        public int compare(SortableExecutableExtension<T> o1, SortableExecutableExtension<T> o2) {
            int result = this.prefixSort(o1, o2);
            if (result == 0) {
                result = o1.getContributorId().compareTo(o2.getContributorId());
            }
            return result;
        }

        protected abstract int prefixSort(SortableExecutableExtension<T> var1, SortableExecutableExtension<T> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class SortableExecutableExtension<T>
    implements Comparable<SortableExecutableExtension> {
        private final Comparator _comparator;
        private final String _contributorId;
        private final T _extensionObject;

        private SortableExecutableExtension(Comparator comparator, String contributorId, T extensionObject) {
            this._comparator = comparator == null ? new Comparator<T>(){

                @Override
                public int compare(T o1, T o2) {
                    return 0;
                }
            } : comparator;
            this._contributorId = contributorId;
            this._extensionObject = extensionObject;
        }

        @Override
        public int compareTo(SortableExecutableExtension o) {
            return this._comparator.compare(this, o);
        }

        public boolean equals(Object obj) {
            return this._comparator.compare(this, obj) == 0;
        }

        public int hashCode() {
            return this._contributorId.hashCode() ^ this._extensionObject.hashCode();
        }

        public String getContributorId() {
            return this._contributorId;
        }

        public T getExtensionObject() {
            return this._extensionObject;
        }
    }
}

