/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.utility.internal.Transformer;
import org.eclipse.jpt.utility.internal.iterators.ReadOnlyListIterator;
import org.eclipse.jpt.utility.internal.model.value.CollectionListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListValueModelWrapper;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationListValueModelAdapter<E1, E2>
extends ListValueModelWrapper<E1>
implements ListValueModel<E2> {
    protected Transformer<E1, E2> transformer;
    protected final List<E2> transformedList;

    public TransformationListValueModelAdapter(ListValueModel<? extends E1> listHolder, Transformer<E1, E2> transformer) {
        super(listHolder);
        this.transformer = transformer;
        this.transformedList = new ArrayList<E2>();
    }

    public TransformationListValueModelAdapter(ListValueModel<? extends E1> listHolder) {
        this(listHolder, Transformer.Null.instance());
    }

    public TransformationListValueModelAdapter(CollectionValueModel<? extends E1> collectionHolder, Transformer<E1, E2> transformer) {
        this(new CollectionListValueModelAdapter<E1>(collectionHolder), transformer);
    }

    public TransformationListValueModelAdapter(CollectionValueModel<? extends E1> collectionHolder) {
        this((ListValueModel<? extends E1>)new CollectionListValueModelAdapter<E1>(collectionHolder));
    }

    @Override
    public Iterator<E2> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E2> listIterator() {
        return new ReadOnlyListIterator<E2>(this.transformedList);
    }

    @Override
    public E2 get(int index) {
        return this.transformedList.get(index);
    }

    @Override
    public int size() {
        return this.transformedList.size();
    }

    @Override
    public Object[] toArray() {
        return this.transformedList.toArray();
    }

    @Override
    protected void engageModel() {
        super.engageModel();
        this.transformedList.addAll(this.transformItems(this.listHolder));
    }

    @Override
    protected void disengageModel() {
        super.disengageModel();
        this.transformedList.clear();
    }

    protected List<E2> transformItems(ListChangeEvent event) {
        return this.transformItems(this.items(event), event.itemsSize());
    }

    protected List<E2> transformItems(ListValueModel<? extends E1> lvm) {
        return this.transformItems(lvm.listIterator(), lvm.size());
    }

    protected List<E2> transformReplacedItems(ListChangeEvent event) {
        return this.transformItems(this.replacedItems(event), event.itemsSize());
    }

    protected List<E2> transformItems(ListIterator<? extends E1> items, int size) {
        ArrayList<E2> result = new ArrayList<E2>(size);
        while (items.hasNext()) {
            result.add(this.transformItem(items.next()));
        }
        return result;
    }

    protected E2 transformItem(E1 item) {
        return this.transformer.transform(item);
    }

    public void setTransformer(Transformer<E1, E2> transformer) {
        this.transformer = transformer;
        this.rebuildTransformedList();
    }

    protected void rebuildTransformedList() {
        this.transformedList.clear();
        this.transformedList.addAll(this.transformItems(this.listHolder));
        this.fireListChanged("list values");
    }

    @Override
    protected void itemsAdded(ListChangeEvent event) {
        this.addItemsToList(event.getIndex(), this.transformItems(event), this.transformedList, "list values");
    }

    @Override
    protected void itemsRemoved(ListChangeEvent event) {
        this.removeItemsFromList(event.getIndex(), event.itemsSize(), this.transformedList, "list values");
    }

    @Override
    protected void itemsReplaced(ListChangeEvent event) {
        this.setItemsInList(event.getIndex(), this.transformItems(event), this.transformedList, "list values");
    }

    @Override
    protected void itemsMoved(ListChangeEvent event) {
        this.moveItemsInList(event.getTargetIndex(), event.getSourceIndex(), event.getMoveLength(), this.transformedList, "list values");
    }

    @Override
    protected void listCleared(ListChangeEvent event) {
        this.clearList(this.transformedList, "list values");
    }

    @Override
    protected void listChanged(ListChangeEvent event) {
        this.rebuildTransformedList();
    }
}

