/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.utility.internal.model.SingleAspectChangeSupport;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyValueModelWrapper<T>
extends AbstractModel {
    protected final PropertyValueModel<? extends T> valueHolder;
    protected final PropertyChangeListener valueChangeListener;

    protected PropertyValueModelWrapper(PropertyValueModel<? extends T> valueHolder) {
        if (valueHolder == null) {
            throw new NullPointerException();
        }
        this.valueHolder = valueHolder;
        this.valueChangeListener = this.buildValueChangeListener();
    }

    @Override
    protected ChangeSupport buildChangeSupport() {
        return new SingleAspectChangeSupport(this, PropertyChangeListener.class, "value");
    }

    protected PropertyChangeListener buildValueChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                PropertyValueModelWrapper.this.valueChanged(event);
            }

            public String toString() {
                return "value change listener";
            }
        };
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.hasNoPropertyChangeListeners("value")) {
            this.engageValueHolder();
        }
        super.addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (propertyName == "value" && this.hasNoPropertyChangeListeners("value")) {
            this.engageValueHolder();
        }
        super.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        if (this.hasNoPropertyChangeListeners("value")) {
            this.disengageValueHolder();
        }
    }

    @Override
    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        super.removePropertyChangeListener(propertyName, listener);
        if (propertyName == "value" && this.hasNoPropertyChangeListeners("value")) {
            this.disengageValueHolder();
        }
    }

    protected void engageValueHolder() {
        this.valueHolder.addPropertyChangeListener("value", this.valueChangeListener);
    }

    protected void disengageValueHolder() {
        this.valueHolder.removePropertyChangeListener("value", this.valueChangeListener);
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.valueHolder);
    }

    protected abstract void valueChanged(PropertyChangeEvent var1);
}

