/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.iterators;

import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayListIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementListIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeListIterator<E>
implements ListIterator<E> {
    private final ListIterator<? extends ListIterator<E>> iterators;
    private ListIterator<E> nextIterator;
    private int nextIndex;
    private boolean nextReturned;
    private ListIterator<E> lastIteratorToReturnElement;

    public CompositeListIterator(List<? extends List<E>> lists) {
        this(new TransformationListIterator<List<E>, ListIterator<E>>(lists.listIterator()){

            @Override
            protected ListIterator<E> transform(List<E> list) {
                return list.listIterator();
            }
        });
    }

    public CompositeListIterator(ListIterator<? extends ListIterator<E>> iterators) {
        this.iterators = iterators;
        this.nextIndex = 0;
        this.nextReturned = false;
    }

    public CompositeListIterator(E object, List<E> list) {
        this(object, list.listIterator());
    }

    public CompositeListIterator(E object, ListIterator<E> iterator) {
        this(new ListIterator[]{new SingleElementListIterator<E>(object), iterator});
    }

    public CompositeListIterator(List<E> list, E object) {
        this(list.listIterator(), object);
    }

    public CompositeListIterator(ListIterator<E> iterator, E object) {
        this(new ListIterator[]{iterator, new SingleElementListIterator<E>(object)});
    }

    public CompositeListIterator(List<E> ... lists) {
        this(Arrays.asList(lists));
    }

    public CompositeListIterator(ListIterator<E> ... iterators) {
        this((ListIterator<ListIterator<E>>)new ArrayListIterator<ListIterator<E>>(iterators));
    }

    @Override
    public void add(E o) {
        this.checkNextIterator();
        this.nextIterator.add(o);
        ++this.nextIndex;
    }

    @Override
    public boolean hasNext() {
        try {
            this.loadNextIterator();
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        return this.nextIterator.hasNext();
    }

    @Override
    public boolean hasPrevious() {
        try {
            this.loadPreviousIterator();
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        return this.nextIterator.hasPrevious();
    }

    @Override
    public E next() {
        this.loadNextIterator();
        E result = this.nextIterator.next();
        this.lastIteratorToReturnElement = this.nextIterator;
        ++this.nextIndex;
        this.nextReturned = true;
        return result;
    }

    @Override
    public int nextIndex() {
        return this.nextIndex;
    }

    @Override
    public E previous() {
        this.loadPreviousIterator();
        E result = this.nextIterator.previous();
        this.lastIteratorToReturnElement = this.nextIterator;
        --this.nextIndex;
        this.nextReturned = false;
        return result;
    }

    @Override
    public int previousIndex() {
        return this.nextIndex - 1;
    }

    @Override
    public void remove() {
        if (this.lastIteratorToReturnElement == null) {
            throw new IllegalStateException();
        }
        this.lastIteratorToReturnElement.remove();
        if (this.nextReturned) {
            --this.nextIndex;
        }
    }

    @Override
    public void set(E e) {
        if (this.lastIteratorToReturnElement == null) {
            throw new IllegalStateException();
        }
        this.lastIteratorToReturnElement.set(e);
    }

    private void loadNextIterator() {
        this.checkNextIterator();
        while (!this.nextIterator.hasNext() && this.iterators.hasNext()) {
            this.nextIterator = this.iterators.next();
        }
    }

    private void loadPreviousIterator() {
        this.checkNextIterator();
        while (!this.nextIterator.hasPrevious() && this.iterators.hasPrevious()) {
            this.nextIterator = this.iterators.previous();
        }
    }

    private void checkNextIterator() {
        if (this.nextIterator == null) {
            this.nextIterator = this.iterators.next();
        }
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.iterators);
    }
}

