/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.model.value;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.utility.internal.model.value.SimpleListValueModel;
import org.eclipse.jpt.utility.tests.internal.TestTools;
import org.eclipse.jpt.utility.tests.internal.model.value.CoordinatedList;

public class CompositeListValueModelTests
extends TestCase {
    private SimpleListValueModel<String> lvm0;
    private SimpleListValueModel<String> lvm1;
    private SimpleListValueModel<String> lvm2;
    private SimpleListValueModel<String> lvm3;
    private SimpleListValueModel<SimpleListValueModel<String>> uberLVM;
    private CompositeListValueModel<SimpleListValueModel<String>, String> compositeLVM;

    public CompositeListValueModelTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.lvm0 = new SimpleListValueModel();
        this.lvm0.add((Object)"aaa");
        this.lvm0.add((Object)"bbb");
        this.lvm0.add((Object)"ccc");
        this.lvm1 = new SimpleListValueModel();
        this.lvm1.add((Object)"ddd");
        this.lvm1.add((Object)"eee");
        this.lvm2 = new SimpleListValueModel();
        this.lvm2.add((Object)"fff");
        this.lvm3 = new SimpleListValueModel();
        this.lvm3.add((Object)"ggg");
        this.lvm3.add((Object)"hhh");
        this.lvm3.add((Object)"iii");
        this.lvm3.add((Object)"jjj");
        this.lvm3.add((Object)"kkk");
        this.uberLVM = new SimpleListValueModel();
        this.uberLVM.add(this.lvm0);
        this.uberLVM.add(this.lvm1);
        this.uberLVM.add(this.lvm2);
        this.uberLVM.add(this.lvm3);
        this.compositeLVM = new CompositeListValueModel(this.uberLVM);
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testGetInt() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        CompositeListValueModelTests.assertEquals((String)"aaa", (String)((String)this.compositeLVM.get(0)));
        CompositeListValueModelTests.assertEquals((String)"aaa", (String)((String)coordList.get(0)));
        CompositeListValueModelTests.assertEquals((String)"bbb", (String)((String)this.compositeLVM.get(1)));
        CompositeListValueModelTests.assertEquals((String)"bbb", (String)((String)coordList.get(1)));
        CompositeListValueModelTests.assertEquals((String)"ccc", (String)((String)this.compositeLVM.get(2)));
        CompositeListValueModelTests.assertEquals((String)"ccc", (String)((String)coordList.get(2)));
        CompositeListValueModelTests.assertEquals((String)"ddd", (String)((String)this.compositeLVM.get(3)));
        CompositeListValueModelTests.assertEquals((String)"ddd", (String)((String)coordList.get(3)));
        CompositeListValueModelTests.assertEquals((String)"eee", (String)((String)this.compositeLVM.get(4)));
        CompositeListValueModelTests.assertEquals((String)"eee", (String)((String)coordList.get(4)));
        CompositeListValueModelTests.assertEquals((String)"fff", (String)((String)this.compositeLVM.get(5)));
        CompositeListValueModelTests.assertEquals((String)"fff", (String)((String)coordList.get(5)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(6)));
    }

    public void testIterator() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        CompositeListValueModelTests.assertEquals((String)"aaa", (String)((String)this.compositeLVM.iterator().next()));
        CompositeListValueModelTests.assertEquals((String)"aaa", (String)((String)coordList.iterator().next()));
        Iterator stream1 = coordList.iterator();
        Iterator stream2 = this.compositeLVM.iterator();
        while (stream2.hasNext()) {
            CompositeListValueModelTests.assertEquals((String)((String)stream1.next()), (String)((String)stream2.next()));
        }
        CompositeListValueModelTests.assertFalse((boolean)stream1.hasNext());
    }

    public void testSize() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        CompositeListValueModelTests.assertEquals((int)11, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)11, (int)coordList.size());
    }

    public void testToArray() {
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
    }

    public void testHasListeners() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        CompositeListValueModelTests.assertTrue((boolean)this.compositeLVM.hasAnyListChangeListeners("list values"));
        CompositeListValueModelTests.assertTrue((boolean)this.lvm0.hasAnyListChangeListeners("list values"));
        this.compositeLVM.removeListChangeListener("list values", coordList);
        CompositeListValueModelTests.assertFalse((boolean)this.compositeLVM.hasAnyListChangeListeners("list values"));
        CompositeListValueModelTests.assertFalse((boolean)this.lvm0.hasAnyListChangeListeners("list values"));
        this.compositeLVM.addListChangeListener("list values", coordList);
        CompositeListValueModelTests.assertTrue((boolean)this.compositeLVM.hasAnyListChangeListeners("list values"));
        CompositeListValueModelTests.assertTrue((boolean)this.lvm0.hasAnyListChangeListeners("list values"));
    }

    public void testAddSource_Begin() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        SimpleListValueModel lvm = new SimpleListValueModel();
        lvm.add((Object)"xxx");
        lvm.add((Object)"yyy");
        lvm.add((Object)"zzz");
        this.uberLVM.add(0, (Object)lvm);
        Object[] expected = new Object[]{"xxx", "yyy", "zzz", "aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(9)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(9)));
    }

    public void testAddSource_Middle() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        SimpleListValueModel lvm = new SimpleListValueModel();
        lvm.add((Object)"xxx");
        lvm.add((Object)"yyy");
        lvm.add((Object)"zzz");
        this.uberLVM.add(2, (Object)lvm);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "xxx", "yyy", "zzz", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(9)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(9)));
    }

    public void testAddSource_End() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        SimpleListValueModel lvm = new SimpleListValueModel();
        lvm.add((Object)"xxx");
        lvm.add((Object)"yyy");
        lvm.add((Object)"zzz");
        this.uberLVM.add((Object)lvm);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk", "xxx", "yyy", "zzz"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(6)));
    }

    public void testAddSources() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        SimpleListValueModel lvmA = new SimpleListValueModel();
        lvmA.add((Object)"xxx");
        lvmA.add((Object)"yyy");
        lvmA.add((Object)"zzz");
        SimpleListValueModel lvmB = new SimpleListValueModel();
        lvmB.add((Object)"ppp");
        lvmB.add((Object)"qqq");
        lvmB.add((Object)"rrr");
        ArrayList<SimpleListValueModel> c = new ArrayList<SimpleListValueModel>();
        c.add(lvmA);
        c.add(lvmB);
        this.uberLVM.addAll(2, c);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "xxx", "yyy", "zzz", "ppp", "qqq", "rrr", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(12)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(12)));
    }

    public void testRemoveSource_Begin() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.uberLVM.remove(0);
        Object[] expected = new Object[]{"ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(3)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(3)));
    }

    public void testRemoveSource_Middle() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.uberLVM.remove(2);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(5)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(5)));
    }

    public void testRemoveSource_End() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.uberLVM.remove(3);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"fff", (String)((String)this.compositeLVM.get(5)));
        CompositeListValueModelTests.assertEquals((String)"fff", (String)((String)coordList.get(5)));
    }

    public void testRemoveSources() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.uberLVM.remove(2, 2);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"eee", (String)((String)this.compositeLVM.get(4)));
        CompositeListValueModelTests.assertEquals((String)"eee", (String)((String)coordList.get(4)));
    }

    public void testReplaceSources() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        SimpleListValueModel lvmA = new SimpleListValueModel();
        lvmA.add((Object)"xxx");
        lvmA.add((Object)"yyy");
        lvmA.add((Object)"zzz");
        SimpleListValueModel lvmB = new SimpleListValueModel();
        lvmB.add((Object)"ppp");
        lvmB.add((Object)"qqq");
        lvmB.add((Object)"rrr");
        ArrayList<SimpleListValueModel> list = new ArrayList<SimpleListValueModel>();
        list.add(lvmA);
        list.add(lvmB);
        this.uberLVM.set(2, list);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "xxx", "yyy", "zzz", "ppp", "qqq", "rrr"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"qqq", (String)((String)this.compositeLVM.get(9)));
        CompositeListValueModelTests.assertEquals((String)"qqq", (String)((String)coordList.get(9)));
    }

    public void testMoveSources_Begin() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.uberLVM.move(0, 2, 2);
        Object[] expected = new Object[]{"fff", "ggg", "hhh", "iii", "jjj", "kkk", "aaa", "bbb", "ccc", "ddd", "eee"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(1)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(1)));
    }

    public void testMoveSources_Middle() {
        SimpleListValueModel lvm4 = new SimpleListValueModel();
        lvm4.add((Object)"lll");
        lvm4.add((Object)"mmm");
        this.uberLVM.add((Object)lvm4);
        SimpleListValueModel lvm5 = new SimpleListValueModel();
        lvm5.add((Object)"nnn");
        lvm5.add((Object)"ooo");
        lvm5.add((Object)"ppp");
        lvm5.add((Object)"qqq");
        this.uberLVM.add((Object)lvm5);
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.uberLVM.move(1, 3, 2);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ggg", "hhh", "iii", "jjj", "kkk", "lll", "mmm", "ddd", "eee", "fff", "nnn", "ooo", "ppp", "qqq"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(3)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(3)));
    }

    public void testMoveSources_End() {
        SimpleListValueModel lvm4 = new SimpleListValueModel();
        lvm4.add((Object)"lll");
        lvm4.add((Object)"mmm");
        this.uberLVM.add((Object)lvm4);
        SimpleListValueModel lvm5 = new SimpleListValueModel();
        lvm5.add((Object)"nnn");
        lvm5.add((Object)"ooo");
        lvm5.add((Object)"ppp");
        lvm5.add((Object)"qqq");
        this.uberLVM.add((Object)lvm5);
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.uberLVM.move(3, 0, 3);
        Object[] expected = new Object[]{"ggg", "hhh", "iii", "jjj", "kkk", "lll", "mmm", "nnn", "ooo", "ppp", "qqq", "aaa", "bbb", "ccc", "ddd", "eee", "fff"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(0)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(0)));
    }

    public void testMoveSource() {
        SimpleListValueModel lvm4 = new SimpleListValueModel();
        lvm4.add((Object)"lll");
        lvm4.add((Object)"mmm");
        this.uberLVM.add((Object)lvm4);
        SimpleListValueModel lvm5 = new SimpleListValueModel();
        lvm5.add((Object)"nnn");
        lvm5.add((Object)"ooo");
        lvm5.add((Object)"ppp");
        lvm5.add((Object)"qqq");
        this.uberLVM.add((Object)lvm5);
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.uberLVM.move(3, 1);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "fff", "ggg", "hhh", "iii", "jjj", "kkk", "ddd", "eee", "lll", "mmm", "nnn", "ooo", "ppp", "qqq"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ooo", (String)((String)this.compositeLVM.get(14)));
        CompositeListValueModelTests.assertEquals((String)"ooo", (String)((String)coordList.get(14)));
    }

    public void testClearSources() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.uberLVM.clear();
        Object[] expected = new Object[]{};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
    }

    public void testChangeSources() {
        ArrayList<SimpleListValueModel> newList = new ArrayList<SimpleListValueModel>();
        SimpleListValueModel lvm4 = new SimpleListValueModel();
        lvm4.add((Object)"lll");
        lvm4.add((Object)"mmm");
        newList.add(lvm4);
        SimpleListValueModel lvm5 = new SimpleListValueModel();
        lvm5.add((Object)"nnn");
        lvm5.add((Object)"ooo");
        lvm5.add((Object)"ppp");
        lvm5.add((Object)"qqq");
        newList.add(lvm5);
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.uberLVM.setList(newList);
        Object[] expected = new Object[]{"lll", "mmm", "nnn", "ooo", "ppp", "qqq"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ooo", (String)((String)this.compositeLVM.get(3)));
        CompositeListValueModelTests.assertEquals((String)"ooo", (String)((String)coordList.get(3)));
    }

    public void testAddItem_Begin() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm0.add(0, (Object)"xxx");
        Object[] expected = new Object[]{"xxx", "aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(7)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(7)));
    }

    public void testAddItem_Middle() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm2.add(1, (Object)"xxx");
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "xxx", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(7)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(7)));
    }

    public void testAddItem_End() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm3.add(5, (Object)"xxx");
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk", "xxx"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(6)));
    }

    public void testAddItems_Begin() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm0.addAll(0, Arrays.asList("xxx", "yyy", "zzz"));
        Object[] expected = new Object[]{"xxx", "yyy", "zzz", "aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(9)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(9)));
    }

    public void testAddItems_Middle() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm2.addAll(1, Arrays.asList("xxx", "yyy", "zzz"));
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "xxx", "yyy", "zzz", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(9)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(9)));
    }

    public void testAddItems_End() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm3.addAll(5, Arrays.asList("xxx", "yyy", "zzz"));
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk", "xxx", "yyy", "zzz"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(6)));
    }

    public void testRemoveItem_Begin() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm0.remove(0);
        Object[] expected = new Object[]{"bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(5)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(5)));
    }

    public void testRemoveItem_Middle() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm2.remove(0);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(5)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(5)));
    }

    public void testRemoveItem_End() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm3.remove(4);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(6)));
    }

    public void testRemoveItems_Begin() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm0.remove(0, 3);
        Object[] expected = new Object[]{"ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(3)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(3)));
    }

    public void testRemoveItems_Middle() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm3.remove(1, 3);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"kkk", (String)((String)this.compositeLVM.get(7)));
        CompositeListValueModelTests.assertEquals((String)"kkk", (String)((String)coordList.get(7)));
    }

    public void testRemoveItems_End() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm3.remove(3, 2);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(6)));
    }

    public void testReplaceItem_Begin() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm0.set(0, (Object)"xxx");
        Object[] expected = new Object[]{"xxx", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(6)));
    }

    public void testReplaceItem_Middle() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm2.set(0, (Object)"xxx");
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "xxx", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(6)));
    }

    public void testReplaceItem_End() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm3.set(4, (Object)"xxx");
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "xxx"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(6)));
    }

    public void testReplaceItems_Begin() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm0.set(0, Arrays.asList("xxx", "yyy", "zzz"));
        Object[] expected = new Object[]{"xxx", "yyy", "zzz", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(6)));
    }

    public void testReplaceItems_Middle() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm3.set(1, Arrays.asList("xxx", "yyy", "zzz"));
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "xxx", "yyy", "zzz", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"kkk", (String)((String)this.compositeLVM.get(10)));
        CompositeListValueModelTests.assertEquals((String)"kkk", (String)((String)coordList.get(10)));
    }

    public void testReplaceItems_End() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm3.set(3, Arrays.asList("xxx", "yyy"));
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii", "xxx", "yyy"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(6)));
    }

    public void testMoveItem_Begin() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm0.move(2, 0);
        Object[] expected = new Object[]{"bbb", "ccc", "aaa", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(6)));
    }

    public void testMoveItem_Middle() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm1.move(0, 1);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "eee", "ddd", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(6)));
    }

    public void testMoveItem_End() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm3.move(0, 4);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "kkk", "ggg", "hhh", "iii", "jjj"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(7)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(7)));
    }

    public void testMoveItems_Begin() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm0.move(1, 0, 2);
        Object[] expected = new Object[]{"ccc", "aaa", "bbb", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(6)));
    }

    public void testMoveItems_Middle() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm1.add((Object)"eee.1");
        this.lvm1.add((Object)"eee.2");
        this.lvm1.add((Object)"eee.3");
        this.lvm1.move(1, 2, 3);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee.1", "eee.2", "eee.3", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(9)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(9)));
    }

    public void testMoveItems_End() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm3.move(0, 2, 3);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "iii", "jjj", "kkk", "ggg", "hhh"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(9)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(9)));
    }

    public void testClearItems_Begin() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm0.clear();
        Object[] expected = new Object[]{"ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(3)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(3)));
    }

    public void testClearItems_Middle() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm1.clear();
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(4)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(4)));
    }

    public void testClearItems_End() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm3.clear();
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"fff", (String)((String)this.compositeLVM.get(5)));
        CompositeListValueModelTests.assertEquals((String)"fff", (String)((String)coordList.get(5)));
    }

    public void testChangeItems_Begin() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm0.setList(Arrays.asList("xxx", "yyy", "zzz"));
        Object[] expected = new Object[]{"xxx", "yyy", "zzz", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(6)));
    }

    public void testChangeItems_Middle() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm1.setList(Arrays.asList("xxx", "yyy", "zzz"));
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "xxx", "yyy", "zzz", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(7)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(7)));
    }

    public void testChangeItems_End() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm3.setList(Arrays.asList("xxx", "yyy", "zzz"));
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "xxx", "yyy", "zzz"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"fff", (String)((String)this.compositeLVM.get(5)));
        CompositeListValueModelTests.assertEquals((String)"fff", (String)((String)coordList.get(5)));
    }
}

